<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">

        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
            <h4 class="text-2xl font-semibold text-white">Manage User Cards</h4>

            
            <form action="<?php echo e(route('admin.cards')); ?>" method="GET" class="flex flex-col sm:flex-row gap-3 w-full sm:w-auto">
                <select name="status" class="bg-gray-800 text-sm text-white border border-gray-600 rounded-lg px-3 py-2 focus:ring-indigo-500 focus:border-indigo-500">
                    <option value="all">All Statuses</option>
                    <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                    <option value="frozen" <?php echo e(request('status') == 'frozen' ? 'selected' : ''); ?>>Frozen</option>
                    <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                </select>

                <div class="relative">
                    <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Search user or last 4 digits..."
                           class="bg-gray-800 text-sm text-white border border-gray-600 rounded-lg pl-10 pr-4 py-2 w-full sm:w-64 focus:ring-indigo-500 focus:border-indigo-500">
                    <svg class="w-4 h-4 text-gray-400 absolute left-3 top-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                </div>

                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white text-sm font-bold px-4 py-2 rounded-lg transition-colors">
                    Filter
                </button>
            </form>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-800">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Cardholder</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Card Number</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Balance</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Expiry</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-400 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    <?php $__empty_1 = true; $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-700 transition-colors">
                        
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="h-8 w-8 rounded-full bg-indigo-500/20 flex items-center justify-center text-indigo-400 font-bold text-xs mr-3">
                                    <?php echo e(substr($card->user->firstname ?? 'U', 0, 1)); ?>

                                </div>
                                <div>
                                    <div class="text-sm font-medium text-white"><?php echo e($card->user->firstname ?? 'N/A'); ?> <?php echo e($card->user->lastname ?? ''); ?></div>
                                    <div class="text-xs text-gray-400"><?php echo e($card->user->email ?? 'N/A'); ?></div>
                                </div>
                            </div>
                        </td>

                        
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="font-mono text-sm text-gray-300">**** **** **** <?php echo e(substr($card->card_number, -4)); ?></span>
                            <span class="ml-2 text-xs bg-gray-600 text-gray-300 px-1.5 py-0.5 rounded"><?php echo e($card->cvv); ?></span>
                        </td>

                        
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm font-bold text-white">$<?php echo e(number_format($card->balance, 2)); ?></span>
                        </td>

                        
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-400">
                            <?php echo e($card->expiry_month); ?>/<?php echo e(substr($card->expiry_year, 2)); ?>

                        </td>

                        
                        <td class="px-6 py-4 whitespace-nowrap">
                            <?php
                                $statusClasses = [
                                    'active' => 'bg-green-100 text-green-800',
                                    'inactive' => 'bg-gray-100 text-gray-800',
                                    'frozen' => 'bg-red-100 text-red-800',
                                    'pending' => 'bg-yellow-100 text-yellow-800',
                                ];
                                $class = $statusClasses[$card->status] ?? 'bg-gray-100 text-gray-800';
                            ?>
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($class); ?>">
                                <?php echo e(ucfirst($card->status)); ?>

                            </span>
                        </td>

                        
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                            <div class="flex items-center justify-end gap-2">
                                <?php if($card->status === 'active'): ?>
                                    <form action="<?php echo e(route('admin.cards.status', $card->id)); ?>" method="POST" onsubmit="return confirm('Freeze this card? The user will not be able to use it.');">
                                        <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                                        <input type="hidden" name="status" value="frozen">
                                        <button type="submit" class="text-red-400 hover:text-red-300 text-xs border border-red-500/30 px-2 py-1 rounded hover:bg-red-500/10 transition">
                                            Freeze
                                        </button>
                                    </form>
                                <?php elseif($card->status === 'frozen'): ?>
                                    <form action="<?php echo e(route('admin.cards.status', $card->id)); ?>" method="POST" onsubmit="return confirm('Unfreeze this card?');">
                                        <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                                        <input type="hidden" name="status" value="active">
                                        <button type="submit" class="text-green-400 hover:text-green-300 text-xs border border-green-500/30 px-2 py-1 rounded hover:bg-green-500/10 transition">
                                            Unfreeze
                                        </button>
                                    </form>
                                <?php endif; ?>

                                
                                
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="px-6 py-10 text-center text-gray-500">
                            No cards found matching your filters.
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            <?php echo e($cards->appends(request()->query())->links()); ?>

        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\exodus-clone-laravel\resources\views/admin/card/index.blade.php ENDPATH**/ ?>