<!DOCTYPE html>
<html>
<head>
    <title>Welcome to <?php echo e(config('app.name')); ?></title>
    <style>
        /* Basic styling for the email */
        body {
            font-family: Arial, sans-serif;
            font-size: 16px;
            line-height: 1.5;
            color: #333;
            background-color: #f5f5f5;
            margin: 0;
            padding: 20px;
        }

        h2 {
            color: #333;
            font-size: 24px;
            margin-bottom: 10px;
        }

        p {
            margin-bottom: 10px;
        }

        a {
            color: #007bff;
            text-decoration: none;
        }

        /* Email header */
        .header {
            background-color: #007bff;
            color: #fff;
            padding: 20px;
            text-align: center;
        }

        .header h1 {
            margin: 0;
        }

        /* Email footer */
        .footer {
            background-color: #f0f0f0;
            padding: 20px;
            text-align: center;
        }

        .footer a {
            color: #333;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Welcome to <?php echo e(config('app.name')); ?>!</h1>
    </div>

    <h2>Hi <?php echo e($user->firstname); ?> <?php echo e($user->lastname); ?>,</h2>

    <p>We're thrilled to have you join our community of investors and traders.</p>

    <p>With <?php echo e(config('app.name')); ?>, you can now:</p>
    <ul>
        <li>Invest in the lucrative oil sector</li>
        <li>Trade a wide range of commodities</li>
        <li>Access real-time market data and analysis</li>
        <li>Benefit from our expert insights and guidance</li>
    </ul>

    <p>To get started, simply:</p>
    <ol>
        <li>**Complete your profile:** Provide additional information to enhance your experience.</li>
        <li>**Fund your account:** Deposit funds to start investing and trading.</li>
    </ol>

    <p>We're committed to providing you with a seamless and rewarding trading experience. If you have any questions or need assistance, please don't hesitate to contact our support team.</p>

    <p>Happy investing!</p>

    <div class="footer">
        <p>Best regards,</p>
        <p><?php echo e(config('app.name')); ?> Team</p>
        <p><a href="[Platform Website]"><?php echo e(config('app.name')); ?></a></p>
        <p><a href="[Support Email]">Support Email</a></p>
    </div>
</body>
</html>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\exodus-clone-laravel\resources\views/emails/registration_success.blade.php ENDPATH**/ ?>