<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-5 gap-1 h-full md:max-h-[90vh]">

        
        <div id="stock-list-panel" class="col-span-full md:col-span-1 bg-[#131319] rounded-lg shadow-md pt-0 p-4 flex flex-col max-h-[90vh] md:h-screen">
            <div class="sticky top-0 bg-[#131319] pb-4 z-10">
                <h2 class="text-xl font-bold text-white">Stocks</h2>
                <p class="text-gray-400 text-sm mb-2 pb-4">Select Stock to begin trading</p>
                <input type="text" id="search-input" class="w-full rounded-lg p-2 text-gray-800" placeholder="Search by code or name">
                <div class="mt-2 mb-4">
                    <label for="market-filter" class="block text-sm font-medium text-gray-400">Filter by Market</label>
                    <select id="market-filter" class="w-full rounded-lg p-2 text-gray-800 mt-1">
                        <option value="all">All Markets</option>
                        <option value="usd">NYSE</option>
                        <option value="gbx">LSE</option>
                    </select>
                </div>
            </div>
            <div id="stock-list" class="flex-1 overflow-y-auto custom-scrollbar border border-gray-700 h-screen">
                <?php $__currentLoopData = $stocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="stock-item p-2 py-4 border-b border-gray-700 cursor-pointer transition-colors duration-200 hover:bg-gray-700"
                    data-stock-id="<?php echo e($stock->id); ?>"
                    data-stock-code="<?php echo e($stock->code); ?>"
                    data-tradingview-code="<?php echo e($stock->tradingview_code); ?>"
                    data-market="<?php echo e($stock->market); ?>">
                        <div class="flex items-center justify-between">
                            <span class="text-base font-medium text-white"><?php echo e($stock->code); ?></span>
                            <span class="text-sm font-semibold text-white">
                                $<?php echo e(number_format($stock->value, 2)); ?><span class="uppercase"></span>
                            </span>
                        </div>
                        <div class="flex items-center justify-between mt-1">
                            <span class="text-sm font-semibold text-gray-400">
                                <?php echo e(Str::limit($stock->name, 17, '...')); ?>

                            </span>
                            <span class="shares-count text-sm font-semibold <?php if($stock->wallet && $stock->wallet->claimed > 0): ?> text-green-400 <?php else: ?> text-gray-400 <?php endif; ?>">
                                <?php echo e($stock->wallet->claimed ?? 0); ?> Shares
                            </span>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        
        <div id="chart-panel" class="col-span-full md:col-span-2 lg:col-span-3 bg-[#131319] rounded-lg shadow-md p-4 overflow-y-auto custom-scrollbar min-h-[70vh] hidden md:block">
            <button id="back-to-list-btn" class="mb-4 text-white md:hidden p-2 bg-gray-700 rounded-lg hover:bg-gray-600 transition-colors">
                <svg class="w-6 h-6 inline-block mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
                Back to Stocks
            </button>
            <h2 id="chart-title" class="text-xl font-bold mb-4 text-white">General Market Overview</h2>
            <div class="h-[200px]">
                <div id="tradingview-chart-container" class="h-[400px] w-full bg-[#000000] rounded-lg"></div>
            </div>
            <div id="stock-details" class="mt-6 hidden">
                <h3 class="text-2xl font-bold text-white mb-4">Stock Data</h3>
                <div class="grid grid-cols-2 sm:grid-cols-3 gap-4">
                    <div class="bg-gray-700 p-4 rounded-lg">
                        <p class="text-gray-400 text-sm">Open</p>
                        <p id="details-open" class="text-white text-lg font-semibold">-</p>
                    </div>
                    <div class="bg-gray-700 p-4 rounded-lg">
                        <p class="text-gray-400 text-sm">Previous Close</p>
                        <p id="details-close" class="text-white text-lg font-semibold">-</p>
                    </div>
                    <div class="bg-gray-700 p-4 rounded-lg">
                        <p class="text-gray-400 text-sm">High</p>
                        <p id="details-high" class="text-white text-lg font-semibold">-</p>
                    </div>
                    <div class="bg-gray-700 p-4 rounded-lg">
                        <p class="text-gray-400 text-sm">Low</p>
                        <p id="details-low" class="text-white text-lg font-semibold">-</p>
                    </div>
                    <div class="bg-gray-700 p-4 rounded-lg">
                        <p class="text-gray-400 text-sm">52 Wk High</p>
                        <p id="details-52wh" class="text-white text-lg font-semibold">-</p>
                    </div>
                    <div class="bg-gray-700 p-4 rounded-lg">
                        <p class="text-gray-400 text-sm">52 Wk Low</p>
                        <p id="details-52wl" class="text-white text-lg font-semibold">-</p>
                    </div>
                </div>
            </div>
        </div>

        
        <div id="trading-panel" class="col-span-full md:col-span-1 bg-[#131319] rounded-lg shadow-md p-4 overflow-y-auto custom-scrollbar min-h-[70vh] hidden md:block">
            <h2 class="text-xl font-bold mb-4 text-white">Trade</h2>
            <div id="trading-component" class="hidden">
                <?php echo $__env->make('components.trading-component', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container mt-5 w-full">
                    <div class="tradingview-widget-container__widget"></div>
                    <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/markets/" rel="noopener nofollow" target="_blank"><span class="blue-text">World markets</span></a><span class="trademark"> by TradingView</span></div>
                    <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-market-overview.js" async>
                        {
                        "colorTheme": "dark",
                        "dateRange": "12M",
                        "locale": "en",
                        "largeChartUrl": "",
                        "isTransparent": false,
                        "showFloatingTooltip": false,
                        "plotLineColorGrowing": "rgba(41, 98, 255, 1)",
                        "plotLineColorFalling": "rgba(41, 98, 255, 1)",
                        "gridLineColor": "rgba(240, 243, 250, 0)",
                        "scaleFontColor": "#DBDBDB",
                        "belowLineFillColorGrowing": "rgba(41, 98, 255, 0.12)",
                        "belowLineFillColorFalling": "rgba(41, 98, 255, 0.12)",
                        "belowLineFillColorGrowingBottom": "rgba(41, 98, 255, 0)",
                        "belowLineFillColorFallingBottom": "rgba(41, 98, 255, 0)",
                        "symbolActiveColor": "rgba(41, 98, 255, 0.12)",
                        "tabs": [
                                {
                            "title": "Crypto",
                            "symbols": [
                                {
                                "s": "BINANCE:BTCUSDT",
                                "d": "",
                                "base-currency-logoid": "crypto/XTVCBTC",
                                "currency-logoid": "crypto/XTVCUSDT"
                                },
                                {
                                "s": "BINANCE:ETHUSDT",
                                "d": "",
                                "base-currency-logoid": "crypto/XTVCETH",
                                "currency-logoid": "crypto/XTVCUSDT"
                                },
                                {
                                "s": "BINANCE:XRPUSDT",
                                "d": "",
                                "base-currency-logoid": "crypto/XTVCXRP",
                                "currency-logoid": "crypto/XTVCUSDT"
                                },
                                {
                                "s": "COINBASE:SOLUSD",
                                "d": "",
                                "base-currency-logoid": "crypto/XTVCSOL",
                                "currency-logoid": "country/US"
                                },
                                {
                                "s": "BITSTAMP:XRPUSD",
                                "d": "",
                                "base-currency-logoid": "crypto/XTVCXRP",
                                "currency-logoid": "country/US"
                                },
                                {
                                "s": "BINANCE:LTCUSDT",
                                "d": "",
                                "base-currency-logoid": "crypto/XTVCLTC",
                                "currency-logoid": "crypto/XTVCUSDT"
                                },
                                {
                                "s": "TRADENATION:SOLANA",
                                "d": "",
                                "base-currency-logoid": "crypto/XTVCSOL",
                                "currency-logoid": "country/US"
                                }
                            ]
                            },
                            {
                            "title": "Indices",
                            "symbols": [
                                {
                                "s": "FOREXCOM:SPXUSD",
                                "d": "btc"
                                },
                                {
                                "s": "FOREXCOM:NSXUSD",
                                "d": "US 100 Cash CFD"
                                },
                                {
                                "s": "FOREXCOM:DJI",
                                "d": "Dow Jones Industrial Average Index"
                                },
                                {
                                "s": "INDEX:NKY",
                                "d": "Japan 225"
                                },
                                {
                                "s": "INDEX:DEU40",
                                "d": "DAX Index"
                                },
                                {
                                "s": "FOREXCOM:UKXGBP",
                                "d": "FTSE 100 Index"
                                },
                                {
                                "s": "BITSTAMP:BTCUSD",
                                "d": "",
                                "base-currency-logoid": "crypto/XTVCBTC",
                                "currency-logoid": "country/US"
                                },
                                {
                                "s": "CRYPTOCAP:XRP",
                                "d": "",
                                "logoid": "crypto/XTVCXRP",
                                "currency-logoid": "country/US"
                                },
                                {
                                "s": "CRYPTOCAP:SOL",
                                "d": "",
                                "logoid": "crypto/XTVCSOL",
                                "currency-logoid": "country/US"
                                },
                                {
                                "s": "BINANCE:BNBUSD",
                                "d": "",
                                "base-currency-logoid": "crypto/XTVCBNB",
                                "currency-logoid": "country/US"
                                }
                            ],
                            "originalTitle": "Indices"
                            },
                            {
                            "title": "Futures",
                            "symbols": [
                                {
                                "s": "BMFBOVESPA:ISP1!",
                                "d": "S&P 500"
                                },
                                {
                                "s": "BMFBOVESPA:EUR1!",
                                "d": "Euro"
                                },
                                {
                                "s": "CMCMARKETS:GOLD",
                                "d": "Gold"
                                },
                                {
                                "s": "PYTH:WTI3!",
                                "d": "WTI Crude Oil"
                                },
                                {
                                "s": "BMFBOVESPA:CCM1!",
                                "d": "Corn"
                                }
                            ],
                            "originalTitle": "Futures"
                            },
                            {
                            "title": "Bonds",
                            "symbols": [
                                {
                                "s": "EUREX:FGBL1!",
                                "d": "Euro Bund"
                                },
                                {
                                "s": "EUREX:FBTP1!",
                                "d": "Euro BTP"
                                },
                                {
                                "s": "EUREX:FGBM1!",
                                "d": "Euro BOBL"
                                }
                            ],
                            "originalTitle": "Bonds"
                            },
                            {
                            "title": "Forex",
                            "symbols": [
                                {
                                "s": "FX:EURUSD",
                                "d": "EUR to USD"
                                },
                                {
                                "s": "FX:GBPUSD",
                                "d": "GBP to USD"
                                },
                                {
                                "s": "FX:USDJPY",
                                "d": "USD to JPY"
                                },
                                {
                                "s": "FX:USDCHF",
                                "d": "USD to CHF"
                                },
                                {
                                "s": "FX:AUDUSD",
                                "d": "AUD to USD"
                                },
                                {
                                "s": "FX:USDCAD",
                                "d": "USD to CAD"
                                }
                            ],
                            "originalTitle": "Forex"
                            }
                        ],
                        "support_host": "https://www.tradingview.com",
                        "backgroundColor": "#0f0f0f",
                        "width": "400",
                        "height": "550",
                        "showSymbolLogo": true,
                        "showChart": true
                        }
                    </script>
                </div>
                <!-- TradingView Widget END -->
                <div class="container-full hidden" id="connect-banks">
                    <div class="">
                        <h3 class="text-center font-bold mb-3">Connect to Banks</h3>
                        <div class="grid grid-cols-2 gap-1">
                            <div class="col ">
                                <div class="flex flex-col gap-1 items-center text-center bg-white p-1 rounded-lg overflow-hidden text-black">
                                    <img src="<?php echo e(asset('images/banks/hsbc.png')); ?>" class="card-img-top object-fit-contain" style="xmax-height: 150px;" alt="HSBC">
                                    <div class="card-body d-flex flex-column justify-content-between align-items-center">
                                        <h5 class="card-title text-center">HSBC</h5>
                                        <button class="text-white px-2 py-1 rounded-full text-xs bg-red-600 connect-button" data-bank="hsbc">Connect</button>
                                        <button class="text-white px-2 py-1 rounded-full text-xs bg-gray-400 disconnect-button hidden" data-bank="hsbc">Disconnect</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col">
                                <div class="flex flex-col gap-1 items-center text-center bg-white p-1 rounded-lg overflow-hidden text-black">
                                    <img src="<?php echo e(asset('images/banks/jpmorgan.png')); ?>" class="card-img-top object-fit-contain" style="xmax-height: 150px;" alt="JPMorgan">
                                    <div class="card-body d-flex flex-column justify-content-between align-items-center">
                                        <h5 class="card-title text-center">JPMorgan</h5>
                                        <button class="text-white px-2 py-1 rounded-full text-xs bg-red-600 connect-button" data-bank="jpmorgan">Connect</button>
                                        <button class="text-white px-2 py-1 rounded-full text-xs bg-gray-400 disconnect-button hidden" data-bank="jpmorgan">Disconnect</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col">
                                <div class="flex flex-col gap-1 items-center text-center bg-white p-1 rounded-lg overflow-hidden text-black">
                                    <img src="<?php echo e(asset('images/banks/halifax.png')); ?>" class="card-img-top object-fit-contain" style="xmax-height: 150px;" alt="Halifax">
                                    <div class="card-body d-flex flex-column justify-content-between align-items-center">
                                        <h5 class="card-title text-center">Halifax</h5>
                                        <button class="text-white px-2 py-1 rounded-full text-xs bg-red-600 connect-button" data-bank="halifax">Connect</button>
                                        <button class="text-white px-2 py-1 rounded-full text-xs bg-gray-400 disconnect-button hidden" data-bank="halifax">Disconnect</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col">
                                <div class="flex flex-col gap-1 items-center text-center bg-white p-1 rounded-lg overflow-hidden text-black">
                                    <img src="<?php echo e(asset('images/banks/td-ameritrade.png')); ?>" class="card-img-top object-fit-contain" style="xmax-height: 150px;" alt="td-ameritrade">
                                    <div class="card-body d-flex flex-column justify-content-between align-items-center">
                                        <h5 class="card-title text-center">TD Ameritrade</h5>
                                        <button class="text-white px-2 py-1 rounded-full text-xs bg-red-600 connect-button" data-bank="td-ameritrade">Connect</button>
                                        <button class="text-white px-2 py-1 rounded-full text-xs bg-gray-400 disconnect-button hidden" data-bank="td-ameritrade">Disconnect</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col">
                                <div class="flex flex-col gap-1 items-center text-center bg-white p-1 rounded-lg overflow-hidden text-black">
                                    <img src="<?php echo e(asset('images/banks/barclays.png')); ?>" class="card-img-top object-fit-contain" style="xmax-height: 150px;" alt="barclays">
                                    <div class="card-body d-flex flex-column justify-content-between align-items-center">
                                        <h5 class="card-title text-center">Barclays</h5>
                                        <button class="text-white px-2 py-1 rounded-full text-xs bg-red-600 connect-button" data-bank="barclays">Connect</button>
                                        <button class="text-white px-2 py-1 rounded-full text-xs bg-gray-400 disconnect-button hidden" data-bank="barclays">Disconnect</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col">
                                <div class="flex flex-col gap-1 items-center text-center bg-white p-1 rounded-lg overflow-hidden text-black">
                                    <img src="<?php echo e(asset('images/banks/merrill.png')); ?>" class="card-img-top object-fit-contain" style="xmax-height: 150px;" alt="merril">
                                    <div class="card-body d-flex flex-column justify-content-between align-items-center">
                                        <h5 class="card-title text-center">Merrill</h5>
                                        <button class="text-white px-2 py-1 rounded-full text-xs bg-red-600 connect-button" data-bank="merril">Connect</button>
                                        <button class="text-white px-2 py-1 rounded-full text-xs bg-gray-400 disconnect-button hidden" data-bank="merril">Disconnect</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <script>
                        let connectedBank = 'hsbc';
                        document.addEventListener('DOMContentLoaded', function() {
                            const connectButtons = document.querySelectorAll('.connect-button');
                            const disconnectButtons = document.querySelectorAll('.disconnect-button');

                            connectButtons.forEach(button => {
                                button.addEventListener('click', function() {
                                    const bankName = this.getAttribute('data-bank');

                                    if (connectedBank) {
                                        console.log(`Already connected to ${connectedBank}. Disconnect first to connect to ${bankName}.`);
                                        return;
                                    }

                                    this.textContent = 'Connecting...';
                                    this.classList.remove('bg-red-600', 'hover:bg-red-700', 'text-white');
                                    this.classList.add('btn-warning');
                                    this.disabled = true;

                                    setTimeout(() => {
                                        this.textContent = 'Connected';
                                        this.classList.remove('btn-warning');
                                        this.classList.add('btn-success');
                                        this.style.backgroundColor = '#28a745';
                                        this.style.borderColor = '#28a745';
                                        this.disabled = true;
                                        connectedBank = bankName;
                                        console.log(`Connected to ${connectedBank}`);

                                        // Show disconnect button for the connected bank
                                        const disconnectButton = this.nextElementSibling;
                                        disconnectButton.classList.remove('hidden');

                                        // Disable all other connect buttons
                                        connectButtons.forEach(otherButton => {
                                            if (otherButton !== this) {
                                                otherButton.disabled = true;
                                            }
                                        });
                                    }, 2000);
                                });
                            });

                            disconnectButtons.forEach(button => {
                                button.addEventListener('click', function() {
                                    const bankName = this.getAttribute('data-bank');

                                    // Reset the connected bank
                                    connectedBank = null;
                                    console.log(`Disconnected from ${bankName}`);

                                    // Hide the disconnect button
                                    this.classList.add('hidden');

                                    // Enable all connect buttons and reset their appearance
                                    connectButtons.forEach(connectButton => {
                                        connectButton.disabled = false;
                                        connectButton.textContent = 'Connect';
                                        connectButton.classList.remove('btn-success');
                                        connectButton.classList.remove('btn-warning');
                                        connectButton.classList.add('bg-red-600', 'hover:bg-red-700', 'text-white');
                                        connectButton.style.backgroundColor = '';
                                        connectButton.style.borderColor = '';
                                    });
                                });
                            });

                            function getConnectedBank() {
                                return connectedBank;
                            }
                        });
                    </script>

                    <style>
                        .object-fit-contain {
                            object-fit: contain;
                        }
                    </style>

                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            const connectButtons = document.querySelectorAll('.connect-button');

                            connectButtons.forEach(button => {
                                button.addEventListener('click', function() {
                                    const bankName = this.getAttribute('data-bank');
                                    this.textContent = 'Connecting...';
                                    this.disabled = true;

                                    // Simulate a connection process (replace with your actual logic)
                                    setTimeout(() => {
                                        this.textContent = 'Connected';
                                        this.classList.remove('btn-primary');
                                        this.classList.add('btn-success');
                                        this.disabled = true; // Keep it disabled after connecting
                                        console.log(`Connected to ${bankName}`);
                                        // You might want to trigger an actual API call or update the UI further here
                                    }, 2000); // Simulate a 2-second connection time
                                });
                            });
                        });
                    </script>
                </div>
            </div>
            <div id="select-stock-prompt" class="p-6 text-center text-gray-400">
                <p>Select a stock from the left to begin trading.</p>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script src="https://s3.tradingview.com/tv.js"></script>
    <script>
        // Global state variables
        let currentOrderSide = 'buy';
        let currentUnit = 'shares';
        let currentOrderType = 'limit';
        let currentTIF = 'day';
        let selectedStock = null;
        let userWallet = {
            usd_balance: <?php echo e(auth()->user()->wallet->balance ?? 0); ?>,
            // gbx_balance: <?php echo e(auth()->user()->wallet->gbx_balance ?? 0); ?>

        };
        const usdFormatter = new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
        });

        // Global element references. They will be assigned values in DOMContentLoaded.
        let sharesQuantityInput, fiatQuantityInput, estimatedTotalSpan, askValueSpan, bidValueSpan, limitPriceInput, stopPriceInput;
        let trading_box_content, buyTab, sellTab, unitSharesBtn, unitFiatBtn, limitBtn, marketBtn, stopBtn, submitOrderBtn;
        let limitFields, marketFields, stopFields, tifDayBtn, tifGtcBtn, marketTifDayBtn, marketTifGtcBtn, stopTifDayBtn, stopTifGtcBtn;
        let submitText, submitSpinner, messagePopup, popupTitle, popupMessage, closePopupBtn, okPopupBtn;

        // Core Functions - Defined in a higher scope to be accessible everywhere
        function getCurrentPrice() {
            const askPrice = parseFloat(document.getElementById('data_ask').value) || 0;
            const bidPrice = parseFloat(document.getElementById('data_bid').value) || 0;

            if (currentOrderType === 'limit') {
                const limitPrice = parseFloat(document.getElementById('limit-price').value);
                if (limitPrice && limitPrice > 0) return limitPrice;
            } else if (currentOrderType === 'stop') {
                const stopPrice = parseFloat(document.getElementById('stop-price').value);
                if (stopPrice && stopPrice > 0) return stopPrice;
            }

            return currentOrderSide === 'buy' ? askPrice : bidPrice;
        }

        function calculateQuantities() {
            if (!sharesQuantityInput || !fiatQuantityInput || !selectedStock) return;

            const price = getCurrentPrice();
            if (!price || price <= 0) {
                sharesQuantityInput.value = '';
                fiatQuantityInput.value = '';
                updateEstimatedTotal();
                return;
            }

            const activeInput = currentUnit === 'shares' ? sharesQuantityInput : fiatQuantityInput;
            const inactiveInput = currentUnit === 'shares' ? fiatQuantityInput : sharesQuantityInput;

            const currentValue = parseFloat(activeInput.value) || 0;

            if (currentUnit === 'shares') {
                const fiatValue = currentValue * price;
                inactiveInput.value = fiatValue.toFixed(2);
            } else { // 'fiat'
                const sharesValue = price > 0 ? (currentValue / price) : 0;
                inactiveInput.value = sharesValue.toFixed(2);
            }

            updateEstimatedTotal();
        }

        function updateEstimatedTotal() {
            const quantityInput = currentUnit === 'shares' ? sharesQuantityInput : fiatQuantityInput;
            const quantity = parseFloat(quantityInput.value) || 0;
            const price = getCurrentPrice();

            let total = 0;
            if (currentUnit === 'shares') {
                total = quantity * price;
            } else {
                total = quantity;
            }

            // estimatedTotalSpan.textContent = `$${total.toFixed(2)}`;
        }

        function showMessage(type, title, message) {
            popupTitle.textContent = title;
            popupMessage.textContent = message;
            if (type === 'success') {
                popupTitle.classList.remove('text-red-500');
                popupTitle.classList.add('text-green-500');
            } else {
                popupTitle.classList.remove('text-green-500');
                popupTitle.classList.add('text-red-500');
            }
            messagePopup.classList.remove('hidden');
            messagePopup.classList.add('flex');
        }

        function hideMessage() {
            messagePopup.classList.remove('flex');
            messagePopup.classList.add('hidden');
        }

        async function fetchAndUpdateUI() {
            try {
                const response = await fetch('/api/user/data');
                const data = await response.json();
                userWallet = data.wallet;

                // document.getElementById('gbxBalance_head_app').textContent = userWallet.gbx_balance;
                // document.getElementById('usdBalance_head_app').textContent = userWallet.usd_balance;

                const stockItems = document.querySelectorAll('.stock-item');
                stockItems.forEach(item => {
                    const stockId = item.dataset.stockId;
                    const stockData = data.stocks.find(s => s.id == stockId);
                    if (stockData) {
                        const sharesSpan = item.querySelector('span.shares-count');
                        sharesSpan.textContent = `${stockData.claimed ?? 0} Shares`;
                        if ((stockData.claimed ?? 0) > 0) {
                            // console.log(stockData.claimed , userWallet,sharesSpan, 'teeeeeeeeeeeeeeeeeeeeeeeee');
                            sharesSpan.classList.add('text-green-400');
                            sharesSpan.classList.remove('text-gray-400');
                        } else {
                            sharesSpan.classList.remove('text-green-400');
                            sharesSpan.classList.add('text-gray-400');
                        }
                    }
                });

                if (selectedStock) {
                    const acctCur = selectedStock.market.toUpperCase();
                    let acctBal = userWallet.balance;
                    // const acctBal = selectedStock.market === 'usd' ? userWallet.usd_balance : userWallet.gbx_balance;
                    // console.log('acctBal', usdFormatter.format(parseFloat(acctBal)), acctBal);
                    document.getElementById('available-funds').textContent = `${usdFormatter.format(parseFloat(acctBal))}`;

                    const stockInWallet = data.stocks.find(s => s.id == selectedStock.id);
                    document.getElementById('available-shares').textContent = `${stockInWallet ? (stockInWallet.claimed ?? 0) : 0}`;
                }
            } catch (error) {
                console.error('Failed to fetch user data:', error);
            }
        }

        function updateOrderSideTabs() {
            if (currentOrderSide === 'buy') {
                buyTab.classList.add('bg-blue-600', 'text-white');
                buyTab.classList.remove('bg-gray-700', 'text-gray-400');
                sellTab.classList.add('bg-gray-700', 'text-gray-400');
                sellTab.classList.remove('bg-red-600', 'text-white');
                submitText.textContent = 'Submit Buy Order';
                submitOrderBtn.classList.remove('bg-red-600', 'hover:bg-red-700');
                submitOrderBtn.classList.add('bg-blue-600', 'hover:bg-blue-700');
                trading_box_content.classList.add('border-blue-600');
                trading_box_content.classList.remove('border-red-600');

                unitSharesBtn.classList.remove('hidden');
                unitFiatBtn.classList.remove('hidden');

                if (currentUnit === 'fiat') {
                    fiatQuantityInput.classList.remove('hidden');
                    sharesQuantityInput.classList.add('hidden');
                } else {
                    fiatQuantityInput.classList.add('hidden');
                    sharesQuantityInput.classList.remove('hidden');
                }
            } else { // 'sell'
                sellTab.classList.add('bg-red-600', 'text-white');
                sellTab.classList.remove('bg-gray-700', 'text-gray-400');
                buyTab.classList.add('bg-gray-700', 'text-gray-400');
                buyTab.classList.remove('bg-blue-600', 'text-white');
                submitText.textContent = 'Submit Sell Order';
                submitOrderBtn.classList.remove('bg-blue-600', 'hover:bg-blue-700');
                submitOrderBtn.classList.add('bg-red-600', 'hover:bg-red-700');
                trading_box_content.classList.add('border-red-600');
                trading_box_content.classList.remove('border-blue-600');

                // On sell, only shares are available, so switch to shares and hide fiat button
                unitFiatBtn.classList.add('hidden');
                sharesQuantityInput.classList.remove('hidden');
                fiatQuantityInput.classList.add('hidden');
                if(currentUnit === 'fiat') {
                    currentUnit = 'shares';
                    updateUnitButtons();
                }
            }
            calculateQuantities();
        }

        function updateUnitButtons() {
            if (currentUnit === 'shares') {
                sharesQuantityInput.classList.remove('hidden');
                fiatQuantityInput.classList.add('hidden');
                unitSharesBtn.classList.add('bg-gray-500', 'text-white');
                unitSharesBtn.classList.remove('text-gray-400');
                unitFiatBtn.classList.add('text-gray-400');
                unitFiatBtn.classList.remove('bg-gray-500', 'text-white');
            } else { // 'fiat'
                fiatQuantityInput.classList.remove('hidden');
                sharesQuantityInput.classList.add('hidden');
                unitFiatBtn.classList.add('bg-gray-500', 'text-white');
                unitFiatBtn.classList.remove('text-gray-400');
                unitSharesBtn.classList.add('text-gray-400');
                unitSharesBtn.classList.remove('bg-gray-500', 'text-white');
            }
        }

        function updateOrderTypeButtons() {
            const orderTypeButtons = [limitBtn, marketBtn, stopBtn];
            orderTypeButtons.forEach(btn => {
                btn.classList.add('text-gray-400');
                btn.classList.remove('bg-gray-500', 'text-white');
            });

            let activeBtn;
            switch (currentOrderType) {
                case 'limit': activeBtn = limitBtn; break;
                case 'market': activeBtn = marketBtn; break;
                case 'stop': activeBtn = stopBtn; break;
            }

            if (activeBtn) {
                activeBtn.classList.add('bg-gray-500', 'text-white');
                activeBtn.classList.remove('text-gray-400');
            }
        }

        function updateOrderFields() {
            limitFields.classList.add('hidden');
            marketFields.classList.add('hidden');
            stopFields.classList.add('hidden');

            switch (currentOrderType) {
                case 'limit': limitFields.classList.remove('hidden'); break;
                case 'market': marketFields.classList.remove('hidden'); break;
                case 'stop': stopFields.classList.remove('hidden'); break;
            }
        }

        function updateAllTIFButtons() {
            const tifButtons = {
                limit: { day: tifDayBtn, gtc: tifGtcBtn },
                market: { day: marketTifDayBtn, gtc: marketTifGtcBtn },
                stop: { day: stopTifDayBtn, gtc: stopTifGtcBtn }
            };

            Object.values(tifButtons).forEach(btns => {
                if (currentTIF === 'day') {
                    btns.day.classList.add('bg-gray-500', 'text-white');
                    btns.day.classList.remove('text-gray-400');
                    btns.gtc.classList.add('text-gray-400');
                    btns.gtc.classList.remove('bg-gray-500', 'text-white');
                } else {
                    btns.gtc.classList.add('bg-gray-500', 'text-white');
                    btns.gtc.classList.remove('text-gray-400');
                    btns.day.classList.add('text-gray-400');
                    btns.day.classList.remove('bg-gray-500', 'text-white');
                }
            });
        }

        document.addEventListener('DOMContentLoaded', function() {
            // Assigning global element references
            sharesQuantityInput = document.getElementById('shares-quantity-input');
            fiatQuantityInput = document.getElementById('fiat-quantity-input');
            estimatedTotalSpan = document.getElementById('estimated-total');
            askValueSpan = document.getElementById('ask-value');
            bidValueSpan = document.getElementById('bid-value');
            limitPriceInput = document.getElementById('limit-price');
            stopPriceInput = document.getElementById('stop-price');
            trading_box_content = document.getElementById('trading_box_content');
            buyTab = document.getElementById('buy-tab');
            sellTab = document.getElementById('sell-tab');
            unitSharesBtn = document.getElementById('unit-shares');
            unitFiatBtn = document.getElementById('unit-fiat');
            limitBtn = document.getElementById('limit-btn');
            marketBtn = document.getElementById('market-btn');
            stopBtn = document.getElementById('stop-btn');
            submitOrderBtn = document.getElementById('submit-order');
            submitText = document.getElementById('submit-text');
            submitSpinner = document.getElementById('submit-spinner');
            limitFields = document.getElementById('limit-fields');
            marketFields = document.getElementById('market-fields');
            stopFields = document.getElementById('stop-fields');
            tifDayBtn = document.getElementById('tif-day');
            tifGtcBtn = document.getElementById('tif-gtc');
            marketTifDayBtn = document.getElementById('market-tif-day');
            marketTifGtcBtn = document.getElementById('market-tif-gtc');
            stopTifDayBtn = document.getElementById('stop-tif-day');
            stopTifGtcBtn = document.getElementById('stop-tif-gtc');
            messagePopup = document.getElementById('message-popup');
            popupTitle = document.getElementById('popup-title');
            popupMessage = document.getElementById('popup-message');
            closePopupBtn = document.getElementById('close-popup');
            okPopupBtn = document.getElementById('ok-popup');

            const stockItems = document.querySelectorAll('.stock-item');
            const tradingViewContainer = document.getElementById('tradingview-chart-container');
            const tradingComponent = document.getElementById('trading-component');
            const selectStockPrompt = document.getElementById('select-stock-prompt');
            const chartTitle = document.getElementById('chart-title');
            const stockDetailsSection = document.getElementById('stock-details');
            const searchInput = document.getElementById('search-input');
            const marketFilter = document.getElementById('market-filter');
            const closeTradingBoxBtn = document.getElementById('close-trading-box');

            // NEW: Mobile UI specific elements
            const stockListPanel = document.getElementById('stock-list-panel');
            const chartPanel = document.getElementById('chart-panel');
            const tradingPanel = document.getElementById('trading-panel');
            const backToListBtn = document.getElementById('back-to-list-btn');

            let currentWidget = new TradingView.widget({
                "container_id": "tradingview-chart-container",
                "width": "100%",
                "height": "100%",
                "autosize": true,
                "symbol": "NASDAQ:NDAQ",
                "interval": "D",
                "timezone": "Etc/UTC",
                "theme": "dark",
                "style": "1",
                "locale": "en",
                "toolbar_bg": "#f1f3f6",
                "enable_publishing": false,
                "allow_symbol_change": true,
                "backgroundColor": "#131319"
            });

            stockItems.forEach(item => {
                item.addEventListener('click', function() {
                    stockItems.forEach(i => i.classList.remove('bg-gray-700'));
                    this.classList.add('bg-gray-700');

                    const stockCode = this.dataset.stockCode;
                    const tradingviewCode = this.dataset.tradingviewCode;

                    if (currentWidget) { currentWidget.remove(); }
                    currentWidget = new TradingView.widget({
                        "container_id": "tradingview-chart-container",
                        "width": "100%",
                        "height": "70%",
                        "autosize": true,
                        "symbol": tradingviewCode,
                        "interval": "D",
                        "timezone": "Etc/UTC",
                        "theme": "dark",
                        "style": "1",
                        "locale": "en",
                        "toolbar_bg": "#f1f3f6",
                        "enable_publishing": false,
                        "allow_symbol_change": true,
                        "backgroundColor": "#131319"
                    });

                    chartTitle.textContent = `${stockCode} Details & Chart`;
                    tradingComponent.classList.remove('hidden');
                    selectStockPrompt.classList.add('hidden');
                    stockDetailsSection.classList.remove('hidden');

                    // NEW: Mobile UI Logic
                    if (window.innerWidth < 768) {
                        stockListPanel.classList.add('hidden');
                        chartPanel.classList.remove('hidden');
                        tradingPanel.classList.remove('hidden');
                    }

                    fetch(`/api/stocks/${stockCode}`)
                        .then(response => response.json())
                        .then(data => {
                            // let acctCur = data.market.toUpperCase();
                            let mrktName = data.market === 'usd' ? 'NYSE' : 'LSE';
                            let acctCur = 'USD';
                            // let acctBal = data.market === "usd" ? userWallet.usd_balance : userWallet.gbx_balance;
                            let acctBal = userWallet.usd_balance;
                            let avg_price = ((parseFloat(data.ask_value) + parseFloat(data.bid_value))/2).toFixed(2);

                            document.getElementById('details-open').textContent = `${usdFormatter.format(data.ask_value)}`;
                            document.getElementById('details-close').textContent = `${usdFormatter.format(data.bid_value)}`;
                            document.getElementById('ask-value').textContent = `${usdFormatter.format(data.ask_value)}`;
                            document.getElementById('bid-value').textContent = `${usdFormatter.format(data.bid_value)}`;

                            document.getElementById('data_ask').value = data.ask_value;
                            document.getElementById('data_bid').value = data.bid_value;
                            document.getElementById('data_stock_id').value = data.id;
                            document.getElementById('data_market').value = data.market === 'usd' ? 'NYSE' : 'LSE';

                            document.getElementById('details-high').textContent = `${usdFormatter.format(data.year_range_max)}`;
                            document.getElementById('details-low').textContent = `${usdFormatter.format(data.year_range_min)}`;
                            document.getElementById('details-52wh').textContent = `${usdFormatter.format(data.year_range_max)}`;
                            document.getElementById('details-52wl').textContent = `${usdFormatter.format(data.year_range_min)}`;
                            document.getElementById('unit-fiat').textContent = `${acctCur}`;

                            document.getElementById('account-name').textContent = `${mrktName}`;
                            document.getElementById('available-funds').textContent = `${usdFormatter.format(parseFloat(acctBal))}`;
                            document.getElementById('avg-price').textContent = `${usdFormatter.format(avg_price)}`;
                            document.getElementById('available-shares').textContent = `${data.claimed}`;

                            selectedStock = data;
                            calculateQuantities();
                        })
                        .catch(error => console.error('Error fetching stock details:', error));
                });
            });

            // NEW: Event listener for the "Back to Stocks" button on mobile
            backToListBtn.addEventListener('click', function() {
                stockListPanel.classList.remove('hidden');
                chartPanel.classList.add('hidden');
                tradingPanel.classList.add('hidden');
            });

            searchInput.addEventListener('input', function() {
                const searchTerm = this.value.toLowerCase();
                const selectedMarket = marketFilter.value;
                stockItems.forEach(item => {
                    const stockCode = item.dataset.stockCode.toLowerCase();
                    const stockName = item.querySelector('span:nth-child(2)').textContent.toLowerCase();
                    const stockMarket = item.dataset.market;
                    const marketMatch = (selectedMarket === 'all' || stockMarket === selectedMarket);
                    const searchMatch = stockCode.includes(searchTerm) || stockName.includes(searchTerm);

                    if (searchMatch && marketMatch) {
                        item.style.display = 'block';
                    } else {
                        item.style.display = 'none';
                    }
                });
            });

            marketFilter.addEventListener('change', function() {
                const selectedMarket = this.value;
                const searchTerm = searchInput.value.toLowerCase();
                stockItems.forEach(item => {
                    const stockCode = item.dataset.stockCode.toLowerCase();
                    const stockName = item.querySelector('span:nth-child(2)').textContent.toLowerCase();
                    const stockMarket = item.dataset.market;
                    const marketMatch = (selectedMarket === 'all' || stockMarket === selectedMarket);
                    const searchMatch = stockCode.includes(searchTerm) || stockName.includes(searchTerm);

                    if (searchMatch && marketMatch) {
                        item.style.display = 'block';
                    } else {
                        item.style.display = 'none';
                    }
                });
            });

            closeTradingBoxBtn.addEventListener('click', function() {
                tradingComponent.classList.add('hidden');
                selectStockPrompt.classList.remove('hidden');
            });

            // Event Listeners for the trading component
            buyTab.addEventListener('click', () => { currentOrderSide = 'buy'; updateOrderSideTabs(); });
            sellTab.addEventListener('click', () => { currentOrderSide = 'sell'; updateOrderSideTabs(); });
            unitSharesBtn.addEventListener('click', () => { currentUnit = 'shares'; updateUnitButtons(); calculateQuantities(); });
            unitFiatBtn.addEventListener('click', () => { currentUnit = 'fiat'; updateUnitButtons(); calculateQuantities(); });

            limitBtn.addEventListener('click', () => { currentOrderType = 'limit'; updateOrderTypeButtons(); updateOrderFields(); calculateQuantities(); });
            marketBtn.addEventListener('click', () => { currentOrderType = 'market'; updateOrderTypeButtons(); updateOrderFields(); calculateQuantities(); });
            stopBtn.addEventListener('click', () => { currentOrderType = 'stop'; updateOrderTypeButtons(); updateOrderFields(); calculateQuantities(); });

            [tifDayBtn, marketTifDayBtn, stopTifDayBtn].forEach(btn => {
                btn.addEventListener('click', () => { currentTIF = 'day'; updateAllTIFButtons(); });
            });
            [tifGtcBtn, marketTifGtcBtn, stopTifGtcBtn].forEach(btn => {
                btn.addEventListener('click', () => { currentTIF = 'gtc'; updateAllTIFButtons(); });
            });

            sharesQuantityInput.addEventListener('input', calculateQuantities);
            fiatQuantityInput.addEventListener('input', calculateQuantities);

            limitPriceInput.addEventListener('input', calculateQuantities);
            stopPriceInput.addEventListener('input', calculateQuantities);

            submitOrderBtn.addEventListener('click', async () => {
                const stockId = document.getElementById('data_stock_id').value;
                if (!stockId) { showMessage('error', 'Error', 'Please select a stock first.'); return; }

                const sharesQuantity = parseFloat(sharesQuantityInput.value);
                const fiatQuantity = parseFloat(fiatQuantityInput.value);

                if (!sharesQuantity && !fiatQuantity || (currentUnit === 'shares' && sharesQuantity <= 0) || (currentUnit === 'fiat' && fiatQuantity <= 0)) {
                    showMessage('error', 'Error', 'Please enter a valid quantity.');
                    return;
                }

                if (!connectedBank) {
                    showMessage('error', 'Connect to a bank', 'You need to connect to a bank before you can trade.');
                    const connectBankSection = document.getElementById('connect-banks');
                    // If the element exists, scroll to it smoothly
                    if (connectBankSection) {
                        connectBankSection.scrollIntoView({ behavior: 'smooth' });
                    }
                    return;
                }

                // Validate limit or stop price if needed
                let orderPrice;
                if (currentOrderType === 'limit') {
                    orderPrice = parseFloat(document.getElementById('limit-price').value);
                    if (!orderPrice || orderPrice <= 0) {
                        showMessage('error', 'Error', 'Please enter a valid limit price.');
                        return;
                    }
                } else if (currentOrderType === 'stop') {
                    orderPrice = parseFloat(document.getElementById('stop-price').value);
                    if (!orderPrice || orderPrice <= 0) {
                        showMessage('error', 'Error', 'Please enter a valid stop price.');
                        return;
                    }
                }

                submitText.classList.add('hidden');
                submitSpinner.classList.remove('hidden');
                submitOrderBtn.disabled = true;

                const orderData = {
                    stock_id: stockId,
                    trade_action: currentOrderSide,
                    order_type: currentOrderType,
                    time_in_force: currentTIF,
                    fill_outside_rth: document.getElementById('fill-outside-rth').checked,
                    shares_quantity: sharesQuantity,
                    fiat_amount: fiatQuantity
                };

                // Conditionally add limit or stop price
                if (currentOrderType === 'limit') {
                    orderData.limit_price = orderPrice;
                } else if (currentOrderType === 'stop') {
                    orderData.stop_price = orderPrice;
                }

                try {
                    const response = await fetch('/api/trade', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content') },
                        body: JSON.stringify(orderData)
                    });
                    const data = await response.json();

                    if (data.success) {
                        showMessage('success', 'Success!', data.message);
                        sharesQuantityInput.value = '';
                        fiatQuantityInput.value = '';
                        updateEstimatedTotal();
                        await fetchAndUpdateUI();
                    } else {
                        showMessage('error', 'Error', data.message || 'An error occurred while processing your order.');
                    }
                } catch (error) {
                    console.error('Error:', error);
                    showMessage('error', 'Error', 'An unexpected error occurred. Please try again.');
                } finally {
                    submitText.classList.remove('hidden');
                    submitSpinner.classList.add('hidden');
                    submitOrderBtn.disabled = false;
                }
            });

            closePopupBtn.addEventListener('click', hideMessage);
            okPopupBtn.addEventListener('click', hideMessage);

            updateOrderSideTabs();
            updateUnitButtons();
            updateOrderTypeButtons();
            updateOrderFields();
            updateAllTIFButtons();
            updateEstimatedTotal();
        });
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\liquid-brokers-crypto-investment-app-v3.1\resources\views/dashboard.blade.php ENDPATH**/ ?>