<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="max-w-[1600px] mx-auto space-y-8">

        
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
            <div>
                <h1 class="text-2xl font-bold text-slate-900 flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full bg-indigo-50 flex items-center justify-center text-indigo-600">
                        <i data-lucide="shield-check" class="w-5 h-5"></i>
                    </div>
                    Identity Verification
                </h1>
                <p class="text-sm text-slate-500 mt-1 ml-13">Complete your KYC to unlock full account features.</p>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

            
            <div class="lg:col-span-2 space-y-8">

                
                <div class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden">
                    <div class="p-8">
                        <h3 class="text-lg font-bold text-slate-900 mb-6">Current Status</h3>

                        <div class="flex items-center gap-6">
                            <?php
                                $status = $user->kyc_status ?? 'unverified'; // Adjust based on your DB
                            ?>

                            <?php if($status === 'completed' || $status === 'verified'): ?>
                                <div class="w-16 h-16 rounded-full bg-emerald-100 flex items-center justify-center text-emerald-600">
                                    <i data-lucide="check-circle-2" class="w-8 h-8"></i>
                                </div>
                                <div>
                                    <h4 class="text-xl font-bold text-emerald-700">Verified</h4>
                                    <p class="text-slate-500 text-sm mt-1">Your identity has been verified. You have full access.</p>
                                </div>
                            <?php elseif($status === 'pending'): ?>
                                <div class="w-16 h-16 rounded-full bg-amber-100 flex items-center justify-center text-amber-600">
                                    <i data-lucide="clock" class="w-8 h-8"></i>
                                </div>
                                <div>
                                    <h4 class="text-xl font-bold text-amber-700">Pending Review</h4>
                                    <p class="text-slate-500 text-sm mt-1">We are currently reviewing your documents. This usually takes 24 hours.</p>
                                </div>
                            <?php else: ?>
                                <div class="w-16 h-16 rounded-full bg-slate-100 flex items-center justify-center text-slate-500">
                                    <i data-lucide="user-x" class="w-8 h-8"></i>
                                </div>
                                <div>
                                    <h4 class="text-xl font-bold text-slate-700">Unverified</h4>
                                    <p class="text-slate-500 text-sm mt-1">Please upload your documents below to verify your identity.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    
                    <?php if($status !== 'verified'): ?>
                    <div class="bg-slate-50 px-8 py-4 border-t border-gray-100 flex justify-between items-center text-sm">
                        <div class="flex items-center gap-2 text-indigo-600 font-bold">
                            <span class="w-6 h-6 rounded-full bg-indigo-600 text-white flex items-center justify-center text-xs">1</span>
                            Upload
                        </div>
                        <div class="h-px bg-gray-200 w-16"></div>
                        <div class="flex items-center gap-2 <?php echo e($status === 'pending' ? 'text-indigo-600 font-bold' : 'text-slate-400'); ?>">
                            <span class="w-6 h-6 rounded-full <?php echo e($status === 'pending' ? 'bg-indigo-600 text-white' : 'bg-gray-200 text-gray-500'); ?> flex items-center justify-center text-xs">2</span>
                            Review
                        </div>
                        <div class="h-px bg-gray-200 w-16"></div>
                        <div class="flex items-center gap-2 text-slate-400">
                            <span class="w-6 h-6 rounded-full bg-gray-200 text-gray-500 flex items-center justify-center text-xs">3</span>
                            Approved
                        </div>
                    </div>
                    <?php endif; ?>
                </div>

                
                <?php if($status !== 'verified' && $status !== 'pending'): ?>
                <div class="bg-white rounded-2xl border border-gray-100 shadow-sm p-8">
                    <h3 class="text-lg font-bold text-slate-900 mb-6">Submit Documents</h3>

                    <?php if($status === 'rejected'): ?>
                        <div class="bg-red-50 border border-red-200 rounded-xl p-4 mb-6">
                            <div class="flex items-start gap-3">
                                <i data-lucide="alert-circle" class="w-5 h-5 text-red-600 mt-0.5"></i>
                                <div>
                                    <h4 class="font-bold text-red-800">Verification Rejected</h4>
                                    <p class="text-sm text-red-700 mt-1"><?php echo e($user->kyc_rejection_reason); ?></p>
                                    <p class="text-sm text-red-600 mt-2 font-medium">Please correct the issue and re-upload your documents below.</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <form action="<?php echo e(route('kyc.store')); ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
                        <?php echo csrf_field(); ?>

                        <div>
                            <label class="block text-sm font-semibold text-slate-700 mb-2">Document Type</label>
                            <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                                <label class="cursor-pointer">
                                    <input type="radio" name="document_type" value="passport" class="peer sr-only" checked>
                                    <div class="rounded-xl border border-gray-200 p-4 text-center hover:bg-gray-50 peer-checked:border-indigo-600 peer-checked:bg-indigo-50 peer-checked:text-indigo-700 transition-all">
                                        <i data-lucide="book" class="w-6 h-6 mx-auto mb-2"></i>
                                        <span class="text-sm font-medium">Passport</span>
                                    </div>
                                </label>
                                <label class="cursor-pointer">
                                    <input type="radio" name="document_type" value="id_card" class="peer sr-only">
                                    <div class="rounded-xl border border-gray-200 p-4 text-center hover:bg-gray-50 peer-checked:border-indigo-600 peer-checked:bg-indigo-50 peer-checked:text-indigo-700 transition-all">
                                        <i data-lucide="credit-card" class="w-6 h-6 mx-auto mb-2"></i>
                                        <span class="text-sm font-medium">ID Card</span>
                                    </div>
                                </label>
                                <label class="cursor-pointer">
                                    <input type="radio" name="document_type" value="license" class="peer sr-only">
                                    <div class="rounded-xl border border-gray-200 p-4 text-center hover:bg-gray-50 peer-checked:border-indigo-600 peer-checked:bg-indigo-50 peer-checked:text-indigo-700 transition-all">
                                        <i data-lucide="car" class="w-6 h-6 mx-auto mb-2"></i>
                                        <span class="text-sm font-medium">Driver License</span>
                                    </div>
                                </label>
                            </div>
                        </div>

                        <div>
                            <label class="block text-sm font-semibold text-slate-700 mb-2">Upload File</label>
                            <div class="flex items-center justify-center w-full">
                                <label for="dropzone-file" class="flex flex-col items-center justify-center w-full h-48 border-2 border-gray-300 border-dashed rounded-2xl cursor-pointer bg-gray-50 hover:bg-gray-100 transition-colors">
                                    <div class="flex flex-col items-center justify-center pt-5 pb-6">
                                        <i data-lucide="cloud-upload" class="w-10 h-10 text-gray-400 mb-3"></i>
                                        <p class="text-sm text-gray-500 font-medium">Click to upload or drag and drop</p>
                                        <p class="text-xs text-gray-400 mt-1">SVG, PNG, JPG or PDF (MAX. 4MB)</p>
                                    </div>
                                    <input id="dropzone-file" name="document_file" type="file" class="hidden" onchange="showFileName(this)" />
                                </label>
                            </div>
                            <p id="file-name" class="text-sm text-indigo-600 mt-2 font-medium hidden"></p>
                            <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['messages' => $errors->get('document_file'),'class' => 'mt-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('document_file')),'class' => 'mt-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
                        </div>

                        <div class="pt-2">
                            <button type="submit" class="w-full py-3.5 bg-indigo-600 text-white font-bold rounded-xl shadow-lg shadow-indigo-500/30 hover:bg-indigo-700 transition-all flex items-center justify-center gap-2">
                                <i data-lucide="send" class="w-4 h-4"></i> Submit for Verification
                            </button>
                        </div>
                    </form>
                </div>
                <?php endif; ?>
            </div>

            
            <div class="space-y-8">
                <div class="bg-indigo-600 rounded-2xl shadow-lg shadow-indigo-500/30 p-8 text-white relative overflow-hidden">
                    <div class="absolute top-0 right-0 -mt-4 -mr-4 w-32 h-32 bg-white opacity-10 rounded-full blur-2xl"></div>
                    <h3 class="text-lg font-bold mb-4">Why verify identity?</h3>
                    <ul class="space-y-4 text-indigo-100 text-sm">
                        <li class="flex items-start gap-3">
                            <div class="w-5 h-5 rounded-full bg-white/20 flex items-center justify-center mt-0.5 flex-shrink-0">
                                <i data-lucide="check" class="w-3 h-3"></i>
                            </div>
                            <span>Unlock higher withdrawal limits and advanced trading features.</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <div class="w-5 h-5 rounded-full bg-white/20 flex items-center justify-center mt-0.5 flex-shrink-0">
                                <i data-lucide="check" class="w-3 h-3"></i>
                            </div>
                            <span>Secure your account against fraud and unauthorized access.</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <div class="w-5 h-5 rounded-full bg-white/20 flex items-center justify-center mt-0.5 flex-shrink-0">
                                <i data-lucide="check" class="w-3 h-3"></i>
                            </div>
                            <span>Comply with global financial regulations.</span>
                        </li>
                    </ul>
                </div>

                <div class="bg-white rounded-2xl border border-gray-100 shadow-sm p-6">
                    <h3 class="font-bold text-slate-900 mb-4">Guidelines</h3>
                    <div class="space-y-4">
                        <div class="flex gap-4">
                            <div class="w-20 h-14 bg-gray-100 rounded-lg flex items-center justify-center">
                                <i data-lucide="image" class="text-gray-400"></i>
                            </div>
                            <div>
                                <p class="text-sm font-bold text-slate-800">Good Quality</p>
                                <p class="text-xs text-gray-500">Ensure text is readable and corners are visible.</p>
                            </div>
                        </div>
                        <div class="flex gap-4">
                            <div class="w-20 h-14 bg-gray-100 rounded-lg flex items-center justify-center">
                                <i data-lucide="sun" class="text-gray-400"></i>
                            </div>
                            <div>
                                <p class="text-sm font-bold text-slate-800">Lighting</p>
                                <p class="text-xs text-gray-500">Avoid glare and shadows on the document.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        function showFileName(input) {
            const fileName = document.getElementById('file-name');
            if (input.files && input.files[0]) {
                fileName.textContent = 'Selected: ' + input.files[0].name;
                fileName.classList.remove('hidden');
            }
        }
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\exodus-clone-laravel\resources\views/user/kyc/index.blade.php ENDPATH**/ ?>