<!DOCTYPE html>
<html>
<head>
    <title><?php echo e($subject); ?></title>
    <style>
        /* Reset styles */
        body, html {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            color: #333;
        }

        .email-container {
            max-width: 600px;
            margin: 20px auto;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .brand-logo {
            text-align: center;
            margin-bottom: 20px;
        }

        .brand-logo img {
            max-width: 150px;
        }

        /* Hide the dark logo by default (light mode) */
        .logo-dark {
            display: none;
        }

        /* Show the light logo by default (light mode) */
        .logo-light {
            display: inline-block;
        }

        /* Dark mode settings */
        @media (prefers-color-scheme: dark) {
            body, html {
                background-color: #222;
                color: #f4f4f4;
            }

            .email-container {
                background: #333;
                color: #f4f4f4;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
            }

            /* Hide the light logo in dark mode */
            .logo-light {
                display: none;
            }

            /* Show the dark logo in dark mode */
            .logo-dark {
                display: inline-block;
            }

            .email-footer {
                color: #aaa;
            }
        }

        .email-body {
            line-height: 1.6;
        }

        .email-footer {
            margin-top: 20px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }

        .btn {
            display: inline-block;
            padding: 10px 20px;
            margin: 20px 0;
            background-color: #007bff;
            color: #fff;
            text-decoration: none;
            border-radius: 5px;
        }

        @media (max-width: 600px) {
            .email-container {
                padding: 15px;
            }
        }
    </style>
</head>
<body>

    <div class="email-container">
        <!-- App Logo -->
        <div class="brand-logo">
            <!-- <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="Swift Trade Logo"> -->
            <img class="logo-light" src="<?php echo e(env('APP_URL')); ?>/images/logo.png" alt="<?php echo e(env('APP_NAME')); ?> Logo">
            <!-- <img class="logo-dark" src="https://guaranteedtradinglimited.com/images/logo.png" alt="Swift Trade Logo"> -->
        </div>

        <!-- Dynamic Email Body Content -->
        <div class="email-body">
            <?php echo $bodyContent; ?>

        </div>

        <!-- Footer -->
        <div class="email-footer">
            &copy; <?php echo e(date('Y')); ?> <?php echo e(env('APP_NAME')); ?>. All rights reserved.
        </div>
    </div>

</body>
</html>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\exodus-clone-laravel\resources\views/emails/generic.blade.php ENDPATH**/ ?>