<div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
    <form class="space-y-4" action="{{route('trade.store')}}" method="POST" id="trade_form">
        @csrf
        <div class="investment">
            <h3 class="text-xl font-semibold text-white mb-4">Trade</h3>
            <label for="trade_amount" class="block text-gray-300 text-sm font-medium mb-1">Trade Amount</label>
            <div class="relative flex items-center mb-3">
                <span class="absolute left-0 pl-3 text-gray-300 pointer-events-none">$</span>
                <input type="number" required class="form-input block w-full pl-8 pr-3 py-2 rounded-md bg-gray-700 text-white border border-gray-600 focus:ring-primary-500 focus:border-primary-500" id="trade_amount" name="trade_amount" placeholder="USD" min="1" max="{{Auth::user()->wallet->balance}}">
            </div>

            <div class="mb-3">
                <label for="market" class="block text-gray-300 text-sm font-medium mb-1">Markets</label>
                <select class="form-select block w-full px-3 py-2 rounded-md bg-gray-700 text-white border border-gray-600 focus:ring-primary-500 focus:border-primary-500" required id="market" name="market">
                    <option selected value="Stocks">Stocks</option>
                    {{-- Uncomment these if you want to enable other markets --}}
                    {{-- <option value="Cryptocurrency">Cryptocurrency</option>
                    <option value="Indices">Indices</option> --}}
                </select>
            </div>
            <div class="mb-3" id="pair-options">
                {{-- Dynamic content based on market selection --}}
                <label for="stock" class="block text-gray-300 text-sm font-medium mb-1">Stock Options</label>
                <select class="form-select block w-full px-3 py-2 rounded-md bg-gray-700 text-white border border-gray-600 focus:ring-primary-500 focus:border-primary-500" required id="stock" name="pair">
                    <option value="FACEBOOK INC">FACEBOOK INC</option>
                    <option value="BOEING CO">BOEING CO</option>
                    <option value="APPLE INC">APPLE INC</option>
                    <option value="AMAZON COM INC">AMAZON COM INC</option>
                    <option value="MICROSOFT CORP">MICROSOFT CORP</option>
                    <option value="NETFLIX INC">NETFLIX INC</option>
                    <option value="MICRON TECHNOLOGY INC">MICRON TECHNOLOGY INC</option>
                    <option value="ALPHABET INC">ALPHABET INC</option>
                    <option value="NVIDIA CORP">NVIDIA CORP</option>
                    <option value="AURORA CANNABIS INC">AURORA CANNABIS INC</option>
                    <option value="CANOPY GROWTH INCORPORATION">CANOPY GROWTH INCORPORATION</option>
                    <option value="TESLA INC">TESLA INC</option>
                    <option value="TWITTER INC">TWITTER INC</option>
                    <option value="SBERBANK RUSSIA">SBERBANK RUSSIA</option>
                    <option value="CRONOS GROUP INC">CRONOS GROUP INC</option>
                    <option value="PENNYMAC FINCANCIAL SERVICES INC">PENNYMAC FINCANCIAL SERVICES INC</option>
                    <option value="PAN AMERICAN SILVER CORP">PAN AMERICAN SILVER CORP</option>
                    <option value="BANK OF AMERICAN CORPORATION">BANK OF AMERICAN CORPORATION</option>
                    <option value="INTEL CORP">INTEL CORP</option>
                    <option value="ISHARES TRUST RUSSELL 200 ETF">ISHARES TRUST RUSSELL 200 ETF</option>
                    <option value="RELIANCE INDS">RELIANCE INDS</option>
                    <option value="ELECTRONIC ARTS INC">ELECTRONIC ARTS INC</option>
                    <option value="SAMSUNG LIFE">SAMSUNG LIFE</option>
                    <option value="SHOPIFY INC">SHOPIFY INC</option>
                    <option value="PAYPAL HONDINGS INC">PAYPAL HONDINGS INC</option>
                </select>
            </div>

            <div class="mb-3">
                <label for="timer" class="block text-gray-300 text-sm font-medium mb-1">Timer</label>
                <select class="form-select block w-full px-3 py-2 rounded-md bg-gray-700 text-white border border-gray-600 focus:ring-primary-500 focus:border-primary-500" required id="timer" name="timer">
                    <option selected value="5">5mins</option>
                    <option value="10">10mins</option>
                    <option value="15">15mins</option>
                    <option value="30">30mins</option>
                    <option value="60">1hour</option>
                    <option value="120">2hour</option>
                </select>
            </div>

            <div class="flex items-center space-x-2 mb-4">
                <input class="form-checkbox h-5 w-5 text-primary-600 rounded border-gray-600 bg-gray-700 focus:ring-primary-500" type="checkbox" id="toggle_stoploss">
                <label class="text-gray-300 text-sm font-medium" for="toggle_stoploss">Stop Loss</label>
            </div>
            <div id="stop-loss-input" class="mb-4"></div>
            <input type="hidden" name="trade_action">

            @if(Auth::user()->wallet->balance <= 0)
                <div class="bg-red-800 text-white p-3 rounded-md text-center mt-3" role="alert">You don't have sufficient funds to trade</div>
            @else
                <div class="flex space-x-4 mt-4">
                    <button type="button" class="flex-1 px-4 py-3 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-md transition-colors duration-200" onclick="tradeAction('buy')">Buy</button>
                    <button type="button" class="flex-1 px-4 py-3 bg-red-600 hover:bg-red-700 text-white font-semibold rounded-md transition-colors duration-200" onclick="tradeAction('sell')">Sell</button>
                </div>
            @endif
        </div>
    </form>

    @if(Auth::user()->kyc_status_id === 1 || Auth::user()->kyc_status_id === 3)
        <div id="kyc-alert-modal" class="fixed inset-0 z-50 overflow-y-auto bg-[#000] bg-opacity-75 hidden flex items-center justify-center">
            <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-xl max-w-sm mx-auto">
                <div class="text-center">
                    <svg class="w-20 h-20 text-orange-500 mx-auto" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                    </svg>
                    <h2 class="mt-4 font-bold text-3xl text-white">Oops!</h2>
                    <p class="mt-2 text-gray-300">Your account has not been approved to make trades. Please complete your KYC verification or wait for approval.</p>
                    <button type="button" class="mt-5 px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-md transition-colors duration-200" onclick="closeKycModal()">Close</button>
                </div>
            </div>
        </div>
    @endif

    <script>
        function tradeAction(action) {
            const tradeAmount = document.getElementById("trade_amount");
            const market = document.getElementById("market");
            const pairSelect = document.querySelector('.form-select[name="pair"]');
            const timer = document.getElementById("timer");

            if (!tradeAmount.value || !market.value || !pairSelect.value || !timer.value) {
                alert("Please fill in all required fields.");
                return false;
            }

            if (isNaN(tradeAmount.value) || parseFloat(tradeAmount.value) <= 0) {
                alert("Please enter a valid positive number for trade amount.");
                tradeAmount.focus();
                return false;
            }

            @if(Auth::user()->kyc_status_id === 1 || Auth::user()->kyc_status_id === 3)
                openKycModal();
                return false;
            @endif

            if (!document.querySelector('form#trade_form').reportValidity()) {
                return;
            }

            document.querySelector('input[name="trade_action"]').value = action;
            document.querySelector('form#trade_form').submit();
        }

        document.getElementById('market').addEventListener('change', function() {
            const selectedMarket = this.value;
            const pairOptionsDiv = document.getElementById('pair-options');
            let optionsHtml = '';

            // The original script had Cryptocurrency and Indices options commented out.
            // I'm keeping the logic here in case you enable them later.
            switch (selectedMarket) {
                case 'Cryptocurrency':
                    optionsHtml = `
                        <label for="cryptocurrency" class="block text-gray-300 text-sm font-medium mb-1">Cryptocurrency Pair</label>
                        <select class="form-select block w-full px-3 py-2 rounded-md bg-gray-700 text-white border border-gray-600 focus:ring-primary-500 focus:border-primary-500" required id="cryptocurrency" name="pair">
                            <option value="" disabled selected>Select a Cryptocurrency</option>
                            <option value="USDT/BTC">USDT/BTC</option>
                            <option value="USDT/ETH">USDT/ETH</option>
                            <option value="USDT/USDC">USDT/USDC</option>
                            <option value="USDT/TRX">USDT/TRX</option>
                            <option value="USDT/SOL">USDT/SOL</option>
                            <option value="USDT/LTC">USDT/LTC</option>
                            <option value="USDT/BNB">USDT/BNB</option>
                            <option value="USDT/LINK">USDT/LINK</option>
                            <option value="USDT/FTT">USDT/FTT</option>
                            <option value="USDT/SHIB">USDT/SHIB</option>
                            <option value="USDT/ETC">USDT/ETC</option>
                            <option value="USDT/TFUEL">USDT/TFUEL</option>
                            <option value="USDT/ADA">USDT/ADA</option>
                            <option value="USDT/VET">USDT/VET</option>
                        </select>
                    `;
                    break;
                case 'Stocks':
                    optionsHtml = `
                        <label for="stock" class="block text-gray-300 text-sm font-medium mb-1">Stock Options</label>
                        <select class="form-select block w-full px-3 py-2 rounded-md bg-gray-700 text-white border border-gray-600 focus:ring-primary-500 focus:border-primary-500" required id="stock" name="pair">
                            <option value="" disabled selected>Select a Stock</option>
                            <option value="FACEBOOK INC">FACEBOOK INC</option>
                            <option value="BOEING CO">BOEING CO</option>
                            <option value="APPLE INC">APPLE INC</option>
                            <option value="AMAZON COM INC">AMAZON COM INC</option>
                            <option value="MICROSOFT CORP">MICROSOFT CORP</option>
                            <option value="NETFLIX INC">NETFLIX INC</option>
                            <option value="MICRON TECHNOLOGY INC">MICRON TECHNOLOGY INC</option>
                            <option value="ALPHABET INC">ALPHABET INC</option>
                            <option value="NVIDIA CORP">NVIDIA CORP</option>
                            <option value="AURORA CANNABIS INC">AURORA CANNABIS INC</option>
                            <option value="CANOPY GROWTH INCORPORATION">CANOPY GROWTH INCORPORATION</option>
                            <option value="TESLA INC">TESLA INC</option>
                            <option value="TWITTER INC">TWITTER INC</option>
                            <option value="SBERBANK RUSSIA">SBERBANK RUSSIA</option>
                            <option value="CRONOS GROUP INC">CRONOS GROUP INC</option>
                            <option value="PENNYMAC FINCANCIAL SERVICES INC">PENNYMAC FINCANCIAL SERVICES INC</option>
                            <option value="PAN AMERICAN SILVER CORP">PAN AMERICAN SILVER CORP</option>
                            <option value="BANK OF AMERICAN CORPORATION">BANK OF AMERICAN CORPORATION</option>
                            <option value="INTEL CORP">INTEL CORP</option>
                            <option value="ISHARES TRUST RUSSELL 200 ETF">ISHARES TRUST RUSSELL 200 ETF</option>
                            <option value="RELIANCE INDS">RELIANCE INDS</option>
                            <option value="ELECTRONIC ARTS INC">ELECTRONIC ARTS INC</option>
                            <option value="SAMSUNG LIFE">SAMSUNG LIFE</option>
                            <option value="SHOPIFY INC">SHOPIFY INC</option>
                            <option value="PAYPAL HONDINGS INC">PAYPAL HONDINGS INC</option>
                        </select>
                    `;
                    break;
                case 'Indices':
                    optionsHtml = `
                        <label for="indices" class="block text-gray-300 text-sm font-medium mb-1">Index Options</label>
                        <select class="form-select block w-full px-3 py-2 rounded-md bg-gray-700 text-white border border-gray-600 focus:ring-primary-500 focus:border-primary-500" required id="indices" name="pair">
                            <option value="" disabled selected>Select an Index</option>
                            <option value="GBPUSD">GBPUSD, Great Britain Pound vs US Dollar CHFJPY,Swiss Franc vs Japanise Yen</option>
                            <option value="EURAUD">EURAUD, Euro vs Australian Dollar</option>
                            <option value="EURUSD">EURUSD, Euro vs US Dollar</option>
                            <option value="EURCHF">EURCHF, Euro vs Swiss Franc</option>
                            <option value="EURGBP">EURGBP, Euro vs Great Britain</option>
                            <option value="GBPCAD">GBPCAD, Great Britain Pound vs Canadian Dollar</option>
                            <option value="GBPNZD">GBPNZD, Great Britain Pound vs New Zealand Dollar</option>
                            <option value="NZDUSD">NZDUSD, New Zealand vs US Dollar</option>
                            <option value="INZDCHF">INZDCHF. New Zealand vs Swiss France</option>
                            <option value="EURNZD">EURNZD, Euro vs New Zealand</option>
                            <option value="CADJPYm">CADJPYm, Canadian Dollar vs Japanise Yen AUDJPYm, Australian Dollar vs Japanise Yen</option>
                            <option value="USDCHF">USDCHF, US Dollar vs Swiss Franc</option>
                            <option value="GBPAUD">GBPAUD, Great Britain Pound vs Australian Dollar</option>
                            <option value="USDTRY">USDTRY, US Dollar vs Turkish New Lira</option>
                            <option value="USD vs THB">USD vs THB</option>
                            <option value="AUD vS USD">AUD vS USD</option>
                            <option value="CAD vs JPY">CAD vs JPY</option>
                            <option value="USDRUB">USDRUB, US Dollar vs Russian Ruble</option>
                            <option value="EURCHF">EURCHF, Furo vs Swiss France</option>
                            <option value="NZDCHF">NZDCHF, New Zealand Dollar vs Swiss France</option>
                            <option value="XAUUSD">XAUUSD, Gold vs US Dollar</option>
                            <option value="NZDJPY"> NZDJPY, New Zealand Dollar vs Japanise Yen</option>
                            <option value="CAD vS JPY">CAD vS JPY</option>
                        </select>
                    `;
                    break;
                default:
                    optionsHtml = ''; // Clear if no valid market is selected
                    break;
            }
            pairOptionsDiv.innerHTML = optionsHtml;
        });

        const toggleStopLossCheckbox = document.getElementById('toggle_stoploss');
        const stopLossInputDiv = document.getElementById('stop-loss-input');

        toggleStopLossCheckbox.addEventListener('change', () => {
            if (toggleStopLossCheckbox.checked) {
                const input = document.createElement('input');
                input.type = 'number'; // Changed to number for stop loss amount
                input.placeholder = 'Enter Stop Loss Amount';
                input.classList.add('block', 'w-full', 'px-3', 'py-2', 'rounded-md', 'bg-gray-700', 'text-white', 'border', 'border-gray-600', 'focus:ring-primary-500', 'focus:border-primary-500');
                input.required = true;
                input.name = 'stop_loss';
                stopLossInputDiv.appendChild(input);
            } else {
                stopLossInputDiv.innerHTML = '';
            }
        });

        // KYC Modal Logic
        const kycAlertModal = document.getElementById('kyc-alert-modal');

        function openKycModal() {
            kycAlertModal.classList.remove('hidden');
            kycAlertModal.classList.add('flex');
        }

        function closeKycModal() {
            kycAlertModal.classList.add('hidden');
            kycAlertModal.classList.remove('flex');
        }
    </script>

    {{-- Toast messages for success/failure, now styled with Tailwind --}}
    @if (session('success'))
        <div class="fixed bottom-4 right-4 z-[9999] bg-green-600 text-white px-6 py-3 rounded-lg shadow-lg flex items-center space-x-2">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
            <span>{{ session('success') }}</span>
        </div>
    @endif
    @if (session('success_decline'))
        <div class="fixed bottom-4 right-4 z-[9999] bg-red-600 text-white px-6 py-3 rounded-lg shadow-lg flex items-center space-x-2">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
            <span>{{ session('success_decline') }}</span>
        </div>
    @endif

    @if (isset($errors) && $errors->any())
    <div class="fixed bottom-4 right-4 z-[9999] bg-red-800 text-white p-4 rounded-md shadow-lg">
        <h4 class="font-bold mb-2">Errors:</h4>
        <ul class="list-disc list-inside">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
</div>
