<x-app-layout>
    <section class="pt-8 pb-4 px-4 sm:px-6 lg:px-8">
        <div class="max-w-7xl mx-auto">
            <h1 class="text-3xl font-bold text-white leading-tight">Trade</h1>
        </div>
    </section>

    <section class="px-4 sm:px-6 lg:px-8 pb-4">
        <div class="max-w-full mx-auto">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                {{-- Wallet Balance Card --}}
                <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-md">
                    <div class="flex items-center justify-between">
                        <div>
                            <h4 class="flex items-center text-primary-400 text-lg sm:text-xl font-semibold">
                                <svg data-lucide="wallet" class="w-6 h-6 mr-2 text-green-500"></svg>
                                Wallet Balance
                            </h4>
                            <p class="text-3xl md:text-4xl lg:text-5xl font-bold text-white mt-2">${{ number_format(Auth::user()->wallet->balance ?? 0, 2, '.', ',') }}</p>
                        </div>
                        <div class="flex-shrink-0">
                            <svg data-lucide="info" class="w-16 h-16 text-primary-500"></svg>
                        </div>
                    </div>
                </div>

                {{-- Bonus Balance Card --}}
                <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-md">
                    <div class="flex items-center justify-between">
                        <div>
                            <h4 class="flex items-center text-primary-400 text-lg sm:text-xl font-semibold">
                                <svg data-lucide="award" class="w-6 h-6 mr-2 text-orange-500"></svg>
                                Bonus
                            </h4>
                            <p class="text-3xl md:text-4xl lg:text-5xl font-bold text-white mt-2 flex items-center">
                                ${{ number_format(Auth::user()->wallet->bonus ?? 0, 2, '.', ',') }}
                                {{-- Assuming withdraw-bonus route --}}
                                @if(Auth::user()->wallet->bonus > 0)
                                <a href="withdraw-bonus" class="ml-3 px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-md text-sm font-semibold transition-colors duration-200">Withdraw Now</a>
                                @endif
                            </p>
                        </div>
                        <div class="flex-shrink-0">
                            <svg data-lucide="gift" class="w-16 h-16 text-orange-500"></svg>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="px-4 sm:px-6 lg:px-8 mt-6">
        <div class="max-w-full mx-auto grid grid-cols-1 lg:grid-cols-4 gap-6">
            <div class="lg:col-span-3">
                <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
                    <div class="tradingview-widget-container">
                        <div class="tradingview-widget-container__widget"></div>
                        <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-advanced-chart.js" async>
                            {
                                "width": "100%",
                                "height": "600",
                                "symbol": "OTC:QOIL",
                                "interval": "D",
                                "timezone": "Etc/UTC",
                                "theme": "dark",
                                "style": "1",
                                "locale": "en",
                                "allow_symbol_change": true,
                                "calendar": false,
                                "support_host": "https://www.tradingview.com"
                            }
                        </script>
                    </div>
                </div>

                {{-- NEW: Crypto Market Overview Widget --}}
                <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm mt-6">
                    <h3 class="text-lg font-semibold text-white mb-4">Cryptocurrency Market Snapshot</h3>
                    <!-- TradingView Widget BEGIN -->
                    <div class="tradingview-widget-container">
                        <div class="tradingview-widget-container__widget"></div>
                        <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text">Track all markets on TradingView</span></a></div>
                        <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-screener.js" async>
                            {
                                "width": "100%",
                                "height": 300,
                                "defaultColumn": "overview",
                                "screener_type": "crypto_mkt",
                                "displayCurrency": "USD",
                                "colorTheme": "dark",
                                "locale": "en"
                            }
                        </script>
                    </div>
                    <!-- TradingView Widget END -->
                </div>
            </div>

            <div class="lg:col-span-1">
                {{-- Trading Widget --}}
                @include('widgets.trading-widget') {{-- Make sure this widget also uses Lucide icons internally --}}

                <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm mt-6">
                    <div class="tradingview-widget-container">
                        <div class="tradingview-widget-container__widget"></div>
                        <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-market-overview.js" async>
                            {
                                "colorTheme": "dark",
                                "dateRange": "12M",
                                "showChart": true,
                                "locale": "en",
                                "largeChartUrl": "",
                                "isTransparent": false,
                                "showSymbolLogo": true,
                                "showFloatingTooltip": false,
                                "width": "100%",
                                "height": "300",
                                "plotLineColorGrowing": "rgba(41, 98, 255, 1)",
                                "plotLineColorFalling": "rgba(41, 98, 255, 1)",
                                "gridLineColor": "rgba(42, 46, 57, 0)",
                                "scaleFontColor": "rgba(209, 212, 220, 1)",
                                "belowLineFillColorGrowing": "rgba(41, 98, 255, 0.12)",
                                "belowLineFillColorFalling": "rgba(41, 98, 255, 0.12)",
                                "belowLineFillColorGrowingBottom": "rgba(41, 98, 255, 0)",
                                "belowLineFillColorFallingBottom": "rgba(41, 98, 255, 0)",
                                "symbolActiveColor": "rgba(41, 98, 255, 0.12)",
                                "tabs": [{
                                    "title": "Indices",
                                    "symbols": [{
                                        "s": "FOREXCOM:SPXUSD",
                                        "d": "S&P 500 Index"
                                    }, {
                                        "s": "OTC:QOIL",
                                        "d": "Quest Oil"
                                    }, {
                                        "s": "OTC:BPAQF",
                                        "d": "BP Plc"
                                    }, {
                                        "s": "NYSE:XOM",
                                        "d": "Exxon Mobil"
                                    }, {
                                        "s": "NYSE:CVX",
                                        "d": "Chevron Corp"
                                    }, {
                                        "s": "NYSE:TTE",
                                        "d": "Total Energies"
                                    }],
                                    "originalTitle": "Indices"
                                }, {
                                    "title": "Futures",
                                    "symbols": [{
                                        "s": "CME_MINI:ES1!",
                                        "d": "S&P 500"
                                    }, {
                                        "s": "CME:6E1!",
                                        "d": "Euro"
                                    }, {
                                        "s": "COMEX:GC1!",
                                        "d": "Gold"
                                    }, {
                                        "s": "NYMEX:CL1!",
                                        "d": "WTI Crude Oil"
                                    }, {
                                        "s": "NYMEX:NG1!",
                                        "d": "Gas"
                                    }, {
                                        "s": "CBOT:ZC1!",
                                        "d": "Corn"
                                    }],
                                    "originalTitle": "Futures"
                                }, {
                                    "title": "Bonds",
                                    "symbols": [{
                                        "s": "CBOT:ZB1!",
                                        "d": "T-Bond"
                                    }, {
                                        "s": "CBOT:UB1!",
                                        "d": "Ultra T-Bond"
                                    }, {
                                        "s": "EUREX:FGBL1!",
                                        "d": "Euro Bund"
                                    }, {
                                        "s": "EUREX:FBTP1!",
                                        "d": "Euro BTP"
                                    }, {
                                        "s": "EUREX:FGBM1!",
                                        "d": "Euro BOBL"
                                    }],
                                    "originalTitle": "Bonds"
                                }, {
                                    "title": "Forex",
                                    "symbols": [{
                                        "s": "FX:EURUSD",
                                        "d": "EUR to USD"
                                    }, {
                                        "s": "FX:GBPUSD",
                                        "d": "GBP to USD"
                                    }, {
                                        "s": "FX:USDJPY",
                                        "d": "USD to JPY"
                                    }, {
                                        "s": "FX:USDCHF",
                                        "d": "USD to CHF"
                                    }, {
                                        "s": "FX:AUDUSD",
                                        "d": "AUD to USD"
                                    }, {
                                        "s": "FX:USDCAD",
                                        "d": "USD to CAD"
                                    }],
                                    "originalTitle": "Forex"
                                }]
                            }
                        </script>
                    </div>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>
