<x-app-layout>
    <section class="p-4 sm:p-6 lg:p-8">
        <div class="mx-auto max-w-full">
            <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6">
                <h1 class="text-2xl font-semibold text-white">Available Signals</h1>
                <div class="mt-2 sm:mt-0">
                    <a href="{{ route('signals.my-signals') }}"
                       class="inline-flex items-center px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-lg text-sm font-semibold transition-colors duration-200">
                        My Subscriptions
                        <svg class="ml-2 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </section>

    @if (session('success'))
        <x-toast-success>{{ session('success') }}</x-toast-success>
    @endif
    @if (session('error'))
        <x-toast-danger>{{ session('error') }}</x-toast-danger>
    @endif

    <section class="px-4 sm:px-6 lg:px-8">
        <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
            @if($signals->isEmpty())
                <div class="p-8 text-center text-gray-400 text-lg">
                    No active signals available at the moment. Please check back later!
                </div>
            @else
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach($signals as $signal)
                    <div class="bg-gray-700 rounded-lg p-6 border border-gray-700 shadow-md flex flex-col justify-between transition-all duration-200 hover:border-primary-500 hover:shadow-lg">
                        <div>
                            <h3 class="text-xl font-bold text-white mb-2">{{ $signal->name }}</h3>
                            <p class="text-gray-300 text-sm mb-4 min-h-[50px]">{{ $signal->description }}</p>

                            <div class="mb-4 space-y-2">
                                <div class="flex items-center justify-between text-gray-300 text-sm">
                                    <span>Expected ROI:</span>
                                    <span class="font-semibold text-green-400">{{ $signal->roi_percentage }}%</span>
                                </div>
                                <div class="flex items-center justify-between text-gray-300 text-sm">
                                    <span>Default Period:</span>
                                    <span class="font-semibold">{{ $signal->default_duration_value }} {{ ucfirst($signal->duration_unit) }}{{ $signal->default_duration_value > 1 ? 's' : '' }}</span>
                                </div>
                                <div class="flex items-center justify-between text-gray-300 text-sm">
                                    <span>Base Price:</span>
                                    <span class="font-semibold text-primary-400">${{ number_format($signal->price_per_unit, 2) }}</span>
                                </div>
                                <div class="flex items-center justify-between text-gray-300 text-sm">
                                    <span>Slots Available:</span>
                                    <span class="font-semibold">{{ $signal->max_subscribers }}</span>
                                </div>
                            </div>
                        </div>
                        <button type="button" onclick="openSubscribeModal({{ $signal->id }}, '{{ $signal->name }}', {{ $signal->price_per_unit }}, {{ $signal->default_duration_value }}, '{{ $signal->duration_unit }}', {{ $signal->roi_percentage }})"
                                class="mt-4 w-full bg-primary-600 hover:bg-primary-700 text-white font-semibold py-2 px-4 rounded-lg transition-colors duration-200">
                            Subscribe
                        </button>
                    </div>
                    @endforeach
                </div>
            @endif
        </div>
    </section>

    {{-- Subscribe Signal Modal (Single Instance) --}}
    <x-modal id="subscribe-signal-modal">
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-gray-700">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h2 class="text-2xl font-bold text-white">Subscribe to <span id="modalSignalName"></span></h2>
            </div>
            <form action="{{ route('signals.subscribe') }}" method="POST">
                @csrf
                <input type="hidden" name="signal_id" id="modalSignalId">

                <div class="space-y-4 text-left mb-6">
                    <div>
                        <label for="modalDurationValue" class="block text-sm font-medium text-gray-300 mb-1">Duration</label>
                        <input type="number" name="duration_value" id="modalDurationValue" min="1" required value="1"
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="modalDurationUnit" class="block text-sm font-medium text-gray-300 mb-1">Unit</label>
                        <select name="duration_unit" id="modalDurationUnit" required
                                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                            <option value="day">Day(s)</option>
                            <option value="week">Week(s)</option>
                            <option value="month">Month(s)</option>
                            <option value="year">Year(s)</option>
                        </select>
                    </div>
                    <div class="text-white text-right">
                        <p class="text-sm text-gray-400">Total Price:</p>
                        <p class="text-xl font-bold text-primary-400" id="modalTotalPrice">$0.00</p>
                    </div>
                </div>

                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg transition-colors duration-200">Confirm Subscription</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('subscribe-signal-modal')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>

    <script>
        // Modal elements
        const modalSignalId = document.getElementById('modalSignalId');
        const modalSignalName = document.getElementById('modalSignalName');
        const modalDurationValue = document.getElementById('modalDurationValue');
        const modalDurationUnit = document.getElementById('modalDurationUnit');
        const modalTotalPrice = document.getElementById('modalTotalPrice');

        let currentBasePricePerUnit = 0; // Store the base price for calculations
        let currentDefaultDurationValue = 0;
        let currentDurationUnit = '';

        function openSubscribeModal(id, name, pricePerUnit, defaultDurationValue, durationUnit, roiPercentage) {
            modalSignalId.value = id;
            modalSignalName.textContent = name;
            modalDurationValue.value = defaultDurationValue; // Pre-fill with default
            modalDurationUnit.value = durationUnit; // Pre-fill with default unit

            currentBasePricePerUnit = pricePerUnit;
            currentDefaultDurationValue = defaultDurationValue;
            currentDurationUnit = durationUnit;

            updateTotalPrice(); // Calculate initial price

            openModal('subscribe-signal-modal');
        }

        function updateTotalPrice() {
            const durationValue = parseInt(modalDurationValue.value);
            const durationUnit = modalDurationUnit.value;

            if (isNaN(durationValue) || durationValue < 1) {
                modalTotalPrice.textContent = '$0.00';
                return;
            }

            // The paid price is base price per default unit multiplied by the number of units selected
            // For simplicity, let's assume price_per_unit is per ONE of its duration_unit.
            // If you want to scale the price linearly based on the new duration:
            // Calculate a "price per day" from the signal's defined price and default duration.
            // Then multiply that "price per day" by the user's selected total days.
            let pricePerDefaultUnitDay = currentBasePricePerUnit / currentDefaultDurationValue; // Price for one unit of default duration
            let selectedDurationInDays = 0; // Calculate selected duration in days for consistent scaling

            switch(durationUnit) {
                case 'day': selectedDurationInDays = durationValue; break;
                case 'week': selectedDurationInDays = durationValue * 7; break;
                case 'month': selectedDurationInDays = durationValue * 30.437; break; // Average days in a month
                case 'year': selectedDurationInDays = durationValue * 365.25; break; // Average days in a year
                default: selectedDurationInDays = durationValue; // Fallback
            }

            let calculatedPrice = pricePerDefaultUnitDay * selectedDurationInDays;

            modalTotalPrice.textContent = '$' + calculatedPrice.toFixed(2);
        }

        modalDurationValue.addEventListener('input', updateTotalPrice);
        modalDurationUnit.addEventListener('change', updateTotalPrice);
    </script>
</x-app-layout>
