<section>
    <header>
        <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
            {{ __('KYC Status') }}
        </h2>

    @if(Auth::user()->kyc_status->name == 'rejected')
        <!-- change to rejected -->
        <form method="post" action="{{ route('profile.kyc-update') }}" class="mt-6 space-y-6" enctype="multipart/form-data">
            @csrf
            @method('put')

            <div>
                <x-input-label for="kyc_picture" :value="__('KYC Picture')" />
                <input type="file" id="kyc_picture" name="kyc_picture" class="mt-1 block w-full" accept="image/*" />
                <x-input-error :messages="$errors->get('kyc_picture')" class="mt-2" />
            </div>

            <div class="flex items-center gap-4">
                <x-primary-button>{{ __('Upload ID') }}</x-primary-button>

                @if (session('status') === 'kyc-updated')
                    <p
                        x-data="{ show: true }"
                        x-show="show"
                        x-transition
                        x-init="setTimeout(() => show = false, 2000)"
                        class="text-sm text-gray-600 dark:text-gray-400"
                    >{{ __('KYC Updated.') }}</p>
                @endif
            </div>
        </form>



    @else
        <div class="text-black">
        <style>
            .kyc-status-pending {
                background-color: orange;
            }

            .kyc-status-completed {
                background-color: green;
            }

            .kyc-status-rejected {
                background-color: red;
            }
        </style>
        <div class="{{ 'kyc-status-' . strtolower(Auth::user()->kyc_status->name)}} py-2 px-6 rounded" style="padding: 5px">
            @if(Auth::user()->kyc_status->name === "completed")
                Account Approved
            @elseif(Auth::user()->kyc_status->name === "pending")
                Account pending approval
            @else
                Account approval failed
            @endif
        </div>
    @endif
</section>
