<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-[#131319] overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <div class="m-auto">
                        <header>
                            <h2 class="text-4xl text-center text-neutral-800/75 mb-4">User Onboarding</h2>
                        </header>
                    </div>
                    <form class="max-w-5xl mx-auto p-8 rounded-lg">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <!-- Row 1 -->
                            <div class="flex flex-col">
                                <label for="firstname" class="text-sm font-medium text-gray-500">First Name</label>
                                <input type="text" id="firstname" placeholder="Enter your Firstname" class="mt-1 border-gray-300 rounded-lg focus:ring focus:ring-gray-500/50">
                            </div>
                            <div class="flex flex-col">
                                <label for="lastname" class="text-sm font-medium text-gray-500">Last Name</label>
                                <input type="text" id="lastname" placeholder="Enter your Last name" class="mt-1 border-gray-300 rounded-lg focus:ring focus:ring-gray-500/50">
                            </div>
                        </div>

                        <!-- Row 2 -->
                        <div class="grid grid-cols-1 gap-4 mt-4">
                            <div class="flex flex-col">
                                <label for="email" class="text-sm font-medium text-gray-500">Email</label>
                                <input type="email" id="email" placeholder="me@example.com" class="mt-1 border-gray-300 rounded-lg focus:ring focus:ring-gray-500/50">
                            </div>
                        </div>

                        <!-- Row 4 -->
                        <div class="grid grid-cols-1 gap-4 mt-4">
                            <div class="flex flex-col">
                                <label for="address" class="text-sm font-medium text-gray-500">Residential Address</label>
                                <textarea name="" id="" placeholder="Enter you residential Address" class="mt-1 border-gray-300 rounded-lg focus:ring focus:ring-gray-500/50">

                                </textarea>
                            </div>
                        </div>
                        <div class="grid justify-end">

                            <button type="submit" class=" mt-4 border-solid border-2 border-red-900 border-1 text-red-900 hover:bg-red-950 hover:text-white font-bold py-2 px-14 rounded-lg">CREATE USER</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
