@php
    // 1. Fetch Active Persona Directly
    $activePersona = \App\Models\Persona::where('is_active', true)->first();

    // 2. Determine App Name
    $appName = $activePersona->name ?? config('app.name', 'Stackvault');

    // 3. Determine Logo (Prioritize Dark Mode Logo for this dark layout)
    if ($activePersona && !empty($activePersona->logo_dark_full_path)) {
        $appLogo = asset('storage/' . $activePersona->logo_dark_full_path);
    } elseif ($activePersona && !empty($activePersona->logo_full_path)) {
        $appLogo = asset('storage/' . $activePersona->logo_full_path);
    } elseif ($activePersona && !empty($activePersona->logo_path)) {
        $appLogo = asset('storage/' . $activePersona->logo_path);
    } else {
        $appLogo = asset('images/logo-v2.png'); // Default Fallback
    }

    // 4. Determine Favicon
    $appFavicon = ($activePersona && $activePersona->logo_path)
        ? asset('storage/' . $activePersona->logo_path)
        : asset('images/favicon.png');
@endphp

<!DOCTYPE html>
<html lang="en" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $appName }} | Dashboard</title>

    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="{{asset('build/assets/built.css')}}" rel="stylesheet" />

    {{-- Dynamic Favicon --}}
    <link rel="shortcut icon" href="{{ $appFavicon }}" type="image/x-icon">

    <script src="{{asset('build/assets/app2.js')}}"></script>
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#eff6ff', 100: '#dbeafe', 200: '#bfdbfe', 300: '#93c5fd', 400: '#60a5fa',
                            500: '#3b82f6', 600: '#2563eb', 700: '#1d4ed8', 800: '#1e40af', 900: '#1e3a8a',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        /* Custom Scrollbar */
        *::-webkit-scrollbar { width: 8px; }
        *::-webkit-scrollbar-track { background: #13131900; border-radius: 10px; }
        *::-webkit-scrollbar-thumb { background-color: #4b5563; border-radius: 10px; border: 2px solid #13131900; }
        * { scrollbar-width: thin; scrollbar-color: #4b5563 #13131900; }

        /* Dynamic Brand Color Injection */
        :root {
            --brand-primary: {{ $activePersona->primary_color ?? '#3b82f6' }};
        }
    </style>
</head>
<body class="bg-[#000] text-white font-sans antialiased">
    <div class="flex h-screen overflow-hidden">

        {{-- SIDEBAR --}}
        <div id="sidebar" class="fixed inset-y-0 left-0 z-50 w-64 bg-[#131319] transform -translate-x-full transition-transform duration-300 ease-in-out lg:translate-x-0 lg:static lg:inset-0 border-r border-gray-700">
            <div class="flex items-center justify-between h-16 px-6 bg-[#000] border-b border-gray-700">

                {{-- DYNAMIC LOGO --}}
                <img src="{{ $appLogo }}" alt="{{ $appName }}" class="h-10 object-contain">

                <button id="closeSidebar" class="lg:hidden text-gray-400 hover:text-white">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>

            <nav class="mt-8 px-4">
                @if(Auth::check() && Auth::user()->role_id === 1)
                    <x-admin-navigation />
                @else
                    <x-user-navigation />
                @endif
            </nav>
        </div>

        <div id="sidebarOverlay" class="fixed inset-0 z-40 bg-gray-600 bg-opacity-75 lg:hidden hidden"></div>

        <div class="flex-1 flex flex-col overflow-hidden">
            <header class="bg-[#131319] shadow-sm border-b border-gray-700">
                <div class="flex items-center justify-between px-4 py-4 sm:px-6 lg:px-8">
                    <div class="flex items-center">
                        <button id="openSidebar" class="lg:hidden -ml-0.5 -mt-0.5 h-12 w-12 inline-flex items-center justify-center rounded-md text-gray-400 hover:text-white hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-primary-500">
                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                            </svg>
                        </button>

                        <div class="ml-4 lg:ml-0">
                            <div class="bg-gray-700 px-4 py-2 rounded-lg">
                                <p id="dateTime" class="text-sm font-medium text-white"></p>
                            </div>
                        </div>
                    </div>

                    <div class="flex items-center space-x-4">
                        @if(Auth::check() && Auth::user()->role_id !== 1)
                            <div class="hidden md:block">
                                <div id="kycStatus" class="px-3 py-1 rounded-full text-sm font-medium
                                    @if(Auth::user()->kyc_status->name === 'completed') bg-green-600 text-white
                                    @elseif(Auth::user()->kyc_status->name === 'pending') bg-orange-500 text-white
                                    @else bg-red-600 text-white @endif">
                                    @if(Auth::user()->kyc_status->name === 'completed') Account Approved
                                    @elseif(Auth::user()->kyc_status->name === 'pending') Account Pending Approval
                                    @else Account Approval Failed @endif
                                </div>
                            </div>
                        @endif

                        @if(Auth::check())
                            <div class="hidden md:block text-sm text-gray-300">
                                {{ Auth::user()->firstname }} {{ Auth::user()->lastname }}
                            </div>
                        @endif

                        <div class="relative">
                            <button id="userMenuButton" class="flex items-center space-x-2 text-gray-300 hover:text-white focus:outline-none focus:ring-2 focus:ring-primary-500 rounded-lg p-1">
                                <div class="w-8 h-8 bg-primary-600 rounded-full flex items-center justify-center">
                                    <span class="text-sm font-medium text-white">
                                        @if(Auth::check()){{ strtoupper(substr(Auth::user()->firstname, 0, 1)) }}{{ strtoupper(substr(Auth::user()->lastname, 0, 1)) }}@else NA @endif
                                    </span>
                                </div>
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </button>

                            <div id="userMenu" class="absolute right-0 mt-2 w-48 bg-[#131319] rounded-md shadow-lg py-1 z-50 hidden border border-gray-700">
                                @if(Auth::check())
                                    <a href="{{ route('profile.edit') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 hover:text-white">Profile</a>
                                    <div class="border-t border-gray-700 my-1"></div>
                                    <form method="POST" action="{{ route('logout') }}">
                                        @csrf
                                        <a href="{{ route('logout') }}" onclick="event.preventDefault(); this.closest('form').submit();" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 hover:text-white">Sign out</a>
                                    </form>
                                @else
                                     <a href="/login" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 hover:text-white">Login</a>
                                     <a href="/register" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 hover:text-white">Register</a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <main class="flex-1 overflow-y-auto bg-[#000] p-4 sm:p-6 lg:p-8">
                @if(Auth::check())
                    @if (Auth::user()->status === 'suspended')
                        <div class="min-h-[500px] flex flex-col justify-center items-center space-y-4">
                            <svg class="w-32 h-32 text-red-500" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M7.29,12H6.87A5.73,5.73,0,0,0,1,17.54,2.38,2.38,0,0,0,1,18H8.26A7,7,0,0,1,7,14,7.27,7.27,0,0,1,7.29,12ZM8.46,9.73A7,7,0,0,1,14,7a5.12,5.12,0,0,1,.56,0A4.93,4.93,0,0,0,15,5,5,5,0,1,0,8.46,9.73Z"></path>
                                <path d="M14,8a6,6,0,1,0,6,6A6,6,0,0,0,14,8Zm0,10.8A4.8,4.8,0,1,1,18.8,14,4.8,4.8,0,0,1,14,18.8ZM17,12l-1-1-2,2-2-2-1,1,2,2-2,2,1,1,2-2,2,2,1-1-2-2Z"></path>
                            </svg>
                            <h2 class="text-3xl font-bold text-white">Account Suspended!</h2>
                            <p class="text-gray-300 text-center max-w-md">Your account has been suspended. Please contact support for more information.</p>
                            <p class="text-primary-400">support@stackvault.com</p>
                        </div>
                    @elseif (Auth::user()->status === 'deactivated')
                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="hidden">
                            @csrf
                            <button type="submit">Logout</button>
                        </form>
                        <script>document.getElementById('logout-form').submit();</script>
                    @else
                        {{ $slot }}
                    @endif
                @else
                    {{ $slot }}
                @endif
            </main>
        </div>
    </div>

    <script>
        // Sidebar Logic
        const sidebar = document.getElementById('sidebar');
        const sidebarOverlay = document.getElementById('sidebarOverlay');
        const openSidebarBtn = document.getElementById('openSidebar');
        const closeSidebarBtn = document.getElementById('closeSidebar');

        function openSidebar() {
            sidebar.classList.remove('-translate-x-full');
            sidebarOverlay.classList.remove('hidden');
        }

        function closeSidebar() {
            sidebar.classList.add('-translate-x-full');
            sidebarOverlay.classList.add('hidden');
        }

        if(openSidebarBtn) openSidebarBtn.addEventListener('click', openSidebar);
        if(closeSidebarBtn) closeSidebarBtn.addEventListener('click', closeSidebar);
        if(sidebarOverlay) sidebarOverlay.addEventListener('click', closeSidebar);

        // User Dropdown Logic
        const userMenuButton = document.getElementById('userMenuButton');
        const userMenu = document.getElementById('userMenu');

        if(userMenuButton) {
            userMenuButton.addEventListener('click', function(e) {
                e.stopPropagation();
                userMenu.classList.toggle('hidden');
            });

            document.addEventListener('click', function(e) {
                if (!userMenuButton.contains(e.target) && !userMenu.contains(e.target)) {
                    userMenu.classList.add('hidden');
                }
            });
        }

        // Date Time Logic
        function updateDateTime() {
            const now = new Date();
            const options = { year: 'numeric', month: 'long', day: 'numeric', hour: '2-digit', minute: '2-digit', second: '2-digit', hour12: false };
            const el = document.getElementById('dateTime');
            if(el) el.textContent = now.toLocaleString('en-US', options);
        }
        updateDateTime();
        setInterval(updateDateTime, 1000);

        // Responsive Sidebar Check
        window.addEventListener('resize', function() {
            if (window.innerWidth >= 1024) {
                sidebar.classList.remove('-translate-x-full');
                sidebarOverlay.classList.add('hidden');
            } else {
                sidebar.classList.add('-translate-x-full');
                sidebarOverlay.classList.add('hidden');
            }
        });

        // Init Icons
        lucide.createIcons();
    </script>
    <x-toast-group></x-toast-group>
</body>
</html>
