<!DOCTYPE html>
<html>
<head>
    <title>{{$type==="deposit"? 'Deposit': 'Withdrwal'}} Approved</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 16px;
            line-height: 1.5;
            margin: 0;
            padding: 20px;
        }

        h2 {
            font-size: 24px;
            margin-bottom: 10px;
        }

        p {
            margin-bottom: 10px;
        }

        ul {
            list-style-type: none;
            padding: 0;
            margin: 0;
        }

        li {
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    @if($type==="deposit")
    <h2>Deposit Approved</h2>
    @else
    <h2>Withdrawal Approved and Sent</h2>
    @endif

    <p>Dear {{ $transaction->user->name }},</p>

    @if($type==="deposit")
    <p>We are pleased to inform you that your recent deposit of ${{ number_format($transaction->amount, 2) }} has been successfully approved, and is now available in your wallet for investing and trading</p>
    @else
    <p>We are pleased to inform you that your recent withdrwal of ${{ number_format($transaction->amount, 2) }} has been successfully approved, and has been sent to your provided payment option</p>
    @endif

    <p><strong>Transaction Details</strong></p>
    <ul>
        <li><strong>Amount:</strong> {{ $transaction->amount }}</li>
        <li><strong>Date of Approval:</strong> {{ date('d/m/Y H:i:s', strtotime($transaction->action_at)) }}</li>
        <li><strong>Reference ID:</strong> {{ $transaction->transaction_id }}</li>
    </ul>

    <p>Should you have any questions or require further assistance, please do not hesitate to contact our support team.</p>

    <p>Thank you for choosing {{ config('app.name') }}.</p>

    <p>Sincerely,</p>
    <p>{{ config('app.name') }}</p>
</body>
</html>
