<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title id="app-title">{{ config('app.name', 'Stackvault') }} | Register</title>

    <link id="app-favicon" rel="shortcut icon" href="{{ asset('images/favicon.png') }}" type="image/x-icon">

    {{-- FONTS --}}
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    {{-- TAILWIND & VITE --}}
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    {{-- ICONS --}}
    <script src="https://unpkg.com/lucide@latest"></script>

    <style>
        body { font-family: 'Inter', sans-serif; }

        /* Wizard Logic Classes */
        .step-content { animation: fadeIn 0.4s ease-in-out; }
        .hidden-step { display: none !important; }
        .active-step { display: block !important; }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(5px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Dynamic Brand Variables */
        :root { --brand-primary: #4f46e5; }
        .text-brand { color: var(--brand-primary); }
        .bg-brand { background-color: var(--brand-primary); }
        .bg-brand:hover { filter: brightness(1.1); }
        .ring-brand:focus { --tw-ring-color: var(--brand-primary); }
        .border-brand:focus { border-color: var(--brand-primary); }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center bg-[#F8F9FB] font-sans antialiased p-4">

    <div class="w-full max-w-2xl bg-white rounded-2xl shadow-[0_8px_30px_rgb(0,0,0,0.04)] border border-gray-100 p-8 sm:p-10 relative overflow-hidden">

        {{-- LOGO --}}
        <div class="flex justify-center mb-8">
            <a href="{{env('WEBSITE_URL')}}">
                <img id="register-logo" src="{{ asset('images/logo-v2.png') }}" alt="Logo" class="h-10 w-auto object-contain">
            </a>
        </div>

        {{-- PROGRESS TRACKER --}}
        <div class="mb-8 px-4">
            <div class="flex items-center justify-between relative">
                <div class="absolute left-0 top-1/2 transform -translate-y-1/2 w-full h-1 bg-gray-100 rounded-full -z-10"></div>
                <div class="absolute left-0 top-1/2 transform -translate-y-1/2 h-1 bg-brand rounded-full -z-10 transition-all duration-300" id="progress-bar" style="width: 0%;"></div>

                <div class="step-dot w-8 h-8 rounded-full flex items-center justify-center text-xs font-bold bg-brand text-white transition-all duration-300" data-index="1">1</div>
                <div class="step-dot w-8 h-8 rounded-full flex items-center justify-center text-xs font-bold bg-gray-100 text-gray-400 transition-all duration-300" data-index="2">2</div>
                <div class="step-dot w-8 h-8 rounded-full flex items-center justify-center text-xs font-bold bg-gray-100 text-gray-400 transition-all duration-300" data-index="3">3</div>
            </div>
            <div class="flex justify-between mt-2 text-xs font-medium text-gray-400 px-1">
                <span>Identity</span>
                <span>Contact</span>
                <span>Security</span>
            </div>
        </div>

        <div class="text-center mb-6">
            <h2 class="text-2xl font-bold text-slate-900" id="step-title">Personal Details</h2>
            <p class="text-sm text-slate-500 font-medium mt-1">Please fill in your details to continue</p>
        </div>

        <form method="POST" action="{{ route('register') }}" enctype="multipart/form-data" id="registerForm">
            @csrf

            {{-- STEP 1: PERSONAL DETAILS --}}
            <div id="step-1" class="step-content active-step space-y-5">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 mb-1.5">First Name</label>
                        <x-text-input type="text" name="firstname" :value="old('firstname')" required
                            class="block w-full rounded-xl border-gray-200 bg-gray-50 p-3.5 text-sm text-slate-900 focus:bg-white focus:border-brand focus:ring-brand border-brand transition-all" placeholder="John" />
                        <x-input-error :messages="$errors->get('firstname')" class="mt-2 text-red-500 text-xs" />
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 mb-1.5">Last Name</label>
                        <x-text-input type="text" name="lastname" :value="old('lastname')" required
                            class="block w-full rounded-xl border-gray-200 bg-gray-50 p-3.5 text-sm text-slate-900 focus:bg-white focus:border-brand focus:ring-brand border-brand transition-all" placeholder="Doe" />
                        <x-input-error :messages="$errors->get('lastname')" class="mt-2 text-red-500 text-xs" />
                    </div>
                </div>
            </div>

            {{-- STEP 2: CONTACT DETAILS --}}
            <div id="step-2" class="step-content hidden-step space-y-5">
                <div>
                    <label class="block text-sm font-semibold text-slate-700 mb-1.5">Email Address</label>
                    <x-text-input type="email" name="email" :value="old('email')" required
                        class="block w-full rounded-xl border-gray-200 bg-gray-50 p-3.5 text-sm text-slate-900 focus:bg-white focus:border-brand focus:ring-brand border-brand transition-all" placeholder="name@example.com" />
                    <x-input-error :messages="$errors->get('email')" class="mt-2 text-red-500 text-xs" />
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 mb-1.5">Phone Number</label>
                        <x-text-input type="tel" name="phone" :value="old('phone')" required
                            class="block w-full rounded-xl border-gray-200 bg-gray-50 p-3.5 text-sm text-slate-900 focus:bg-white focus:border-brand focus:ring-brand border-brand transition-all" placeholder="+1 234 567 890" />
                        <x-input-error :messages="$errors->get('phone')" class="mt-2 text-red-500 text-xs" />
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 mb-1.5">Address</label>
                        <x-text-input type="text" name="address" :value="old('address')" required
                            class="block w-full rounded-xl border-gray-200 bg-gray-50 p-3.5 text-sm text-slate-900 focus:bg-white focus:border-brand focus:ring-brand border-brand transition-all" placeholder="City, Country" />
                        <x-input-error :messages="$errors->get('address')" class="mt-2 text-red-500 text-xs" />
                    </div>
                </div>
            </div>

            {{-- STEP 3: SECURITY & PROFILE --}}
            <div id="step-3" class="step-content hidden-step space-y-5">

                {{-- Profile Photo Upload --}}
                <div class="flex flex-col items-center justify-center mb-6">
                    <div class="relative w-24 h-24 mb-3">
                        <img id="profile-preview" src="https://ui-avatars.com/api/?name=User&background=eff6ff&color=4f46e5" class="w-full h-full rounded-full object-cover border-4 border-gray-100 shadow-sm">
                        <label for="profile_photo" class="absolute bottom-0 right-0 bg-brand text-white p-2 rounded-full cursor-pointer hover:brightness-110 shadow-md transition-all">
                            <i data-lucide="camera" class="w-4 h-4"></i>
                        </label>
                        <input type="file" id="profile_photo" name="profile_photo" accept="image/*" class="hidden" onchange="previewImage(event)">
                    </div>
                    <span class="text-xs text-slate-500">Upload Profile Photo (Optional)</span>
                    <x-input-error :messages="$errors->get('profile_photo')" class="mt-2 text-red-500 text-xs" />
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 mb-1.5">Password</label>
                        <div class="relative">
                            <x-text-input id="password" type="password" name="password" required
                                class="block w-full rounded-xl border-gray-200 bg-gray-50 p-3.5 text-sm text-slate-900 focus:bg-white focus:border-brand focus:ring-brand border-brand transition-all pr-10" placeholder="••••••••" />
                            <button type="button" class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-400 hover:text-gray-600" onclick="togglePass('password', this)">
                                <i data-lucide="eye" class="w-5 h-5"></i>
                            </button>
                        </div>
                        <x-input-error :messages="$errors->get('password')" class="mt-2 text-red-500 text-xs" />
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 mb-1.5">Confirm Password</label>
                        <div class="relative">
                            <x-text-input id="password_confirmation" type="password" name="password_confirmation" required
                                class="block w-full rounded-xl border-gray-200 bg-gray-50 p-3.5 text-sm text-slate-900 focus:bg-white focus:border-brand focus:ring-brand border-brand transition-all pr-10" placeholder="••••••••" />
                            <button type="button" class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-400 hover:text-gray-600" onclick="togglePass('password_confirmation', this)">
                                <i data-lucide="eye" class="w-5 h-5"></i>
                            </button>
                        </div>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-semibold text-slate-700 mb-1.5">Referral Code (Optional)</label>
                    <x-text-input type="text" name="referrer_code" value="{{ $referralCode ?? '' }}"
                        class="block w-full rounded-xl border-gray-200 bg-gray-50 p-3.5 text-sm text-slate-900 focus:bg-white focus:border-brand focus:ring-brand border-brand transition-all" placeholder="REF12345" />
                </div>

                <div class="flex items-start">
                    <input type="checkbox" id="privacy" required class="mt-1 rounded border-gray-300 text-brand shadow-sm focus:ring-brand bg-gray-50 cursor-pointer">
                    <label for="privacy" class="ml-2 text-sm text-slate-500">
                        I agree to the <a href="#" class="text-brand font-medium hover:underline">Terms of Service</a> & <a href="#" class="text-brand font-medium hover:underline">Privacy Policy</a>.
                    </label>
                </div>
            </div>

            {{-- BUTTONS --}}
            <div class="flex items-center justify-between mt-8 pt-6 border-t border-gray-100">
                <button type="button" id="prevBtn" class="hidden px-6 py-3 rounded-xl text-sm font-bold text-slate-500 hover:bg-gray-100 hover:text-slate-800 transition-colors">
                    Back
                </button>

                <div class="ml-auto">
                    <button type="button" id="nextBtn" class="px-8 py-3 rounded-xl text-sm font-bold text-white bg-brand shadow-lg shadow-indigo-500/20 hover:brightness-110 transition-all">
                        Continue
                    </button>

                    <button type="submit" id="submitBtn" class="hidden px-8 py-3 rounded-xl text-sm font-bold text-white bg-brand shadow-lg shadow-indigo-500/20 hover:brightness-110 transition-all">
                        Create Account
                    </button>
                </div>
            </div>

            <div class="text-center mt-6">
                <p class="text-sm text-slate-500">
                    Already have an account? <a href="{{ route('login') }}" class="font-bold text-brand hover:underline">Sign In</a>
                </p>
            </div>
        </form>
    </div>

    {{-- INLINE JAVASCRIPT FOR WIZARD FUNCTIONALITY --}}
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // --- 1. CONFIGURATION ---
            let currentStep = 1;
            const totalSteps = 3;

            // DOM Elements
            const nextBtn = document.getElementById('nextBtn');
            const prevBtn = document.getElementById('prevBtn');
            const submitBtn = document.getElementById('submitBtn');
            const progressBar = document.getElementById('progress-bar');
            const stepTitle = document.getElementById('step-title');

            // --- 2. UPDATE UI FUNCTION ---
            function updateUI() {
                // Handle Steps Visibility & Dots
                for(let i = 1; i <= totalSteps; i++) {
                    const stepDiv = document.getElementById(`step-${i}`);
                    const stepDot = document.querySelector(`.step-dot[data-index="${i}"]`);

                    if (i === currentStep) {
                        stepDiv.classList.remove('hidden-step');
                        stepDiv.classList.add('active-step');

                        // Active Dot
                        stepDot.classList.remove('bg-gray-100', 'text-gray-400');
                        stepDot.classList.add('bg-brand', 'text-white');
                    } else {
                        stepDiv.classList.add('hidden-step');
                        stepDiv.classList.remove('active-step');

                        if (i < currentStep) {
                            // Completed Dot
                            stepDot.classList.remove('bg-gray-100', 'text-gray-400');
                            stepDot.classList.add('bg-brand', 'text-white', 'opacity-50');
                        } else {
                            // Future Dot
                            stepDot.classList.add('bg-gray-100', 'text-gray-400');
                            stepDot.classList.remove('bg-brand', 'text-white', 'opacity-50');
                        }
                    }
                }

                // Progress Bar Width
                const progressPercentage = ((currentStep - 1) / (totalSteps - 1)) * 100;
                progressBar.style.width = `${progressPercentage}%`;

                // Handle Buttons & Titles
                if (currentStep === 1) {
                    prevBtn.classList.add('hidden');
                    nextBtn.classList.remove('hidden');
                    submitBtn.classList.add('hidden');
                    stepTitle.innerText = "Personal Details";
                } else if (currentStep === totalSteps) {
                    prevBtn.classList.remove('hidden');
                    nextBtn.classList.add('hidden');
                    submitBtn.classList.remove('hidden');
                    stepTitle.innerText = "Security Setup";
                } else {
                    prevBtn.classList.remove('hidden');
                    nextBtn.classList.remove('hidden');
                    submitBtn.classList.add('hidden');
                    stepTitle.innerText = "Contact Details";
                }
            }

            // --- 3. VALIDATION FUNCTION ---
            function validateStep(step) {
                const stepDiv = document.getElementById(`step-${step}`);
                // Get all required inputs in the current step
                const inputs = stepDiv.querySelectorAll('input[required]');
                let valid = true;

                inputs.forEach(input => {
                    if (!input.checkValidity()) {
                        input.reportValidity(); // Shows browser built-in validation bubble
                        valid = false;
                        return;
                    }
                });
                return valid;
            }

            // --- 4. EVENT LISTENERS ---
            nextBtn.addEventListener('click', () => {
                if (validateStep(currentStep)) {
                    if (currentStep < totalSteps) {
                        currentStep++;
                        updateUI();
                    }
                }
            });

            prevBtn.addEventListener('click', () => {
                if (currentStep > 1) {
                    currentStep--;
                    updateUI();
                }
            });

            // --- 5. DYNAMIC BRANDING FETCH ---
            fetch('/api/persona/active')
                .then(res => res.json())
                .then(data => {
                    document.title = `${data.name} | Register`;
                    const logo = document.getElementById('register-logo');
                    if(logo) logo.src = data.logo_full_url || data.logo_url;
                    const favicon = document.getElementById('app-favicon');
                    if(favicon) favicon.href = data.logo_url;

                    if(data.colors && data.colors.primary) {
                        document.documentElement.style.setProperty('--brand-primary', data.colors.primary);
                    }
                })
                .catch(err => console.log('Branding loaded default'));

            // Initialize Icons
            if(typeof lucide !== 'undefined') lucide.createIcons();
        });

        // --- GLOBAL HELPER FUNCTIONS ---
        // Toggle Password
        window.togglePass = function(inputId, btn) {
            const input = document.getElementById(inputId);
            const icon = btn.querySelector('i');
            if (input.type === 'password') {
                input.type = 'text';
                icon.setAttribute('data-lucide', 'eye-off');
            } else {
                input.type = 'password';
                icon.setAttribute('data-lucide', 'eye');
            }
            lucide.createIcons();
        };

        // Image Preview
        window.previewImage = function(event) {
            const reader = new FileReader();
            reader.onload = function() {
                const output = document.getElementById('profile-preview');
                output.src = reader.result;
            };
            if(event.target.files[0]){
                reader.readAsDataURL(event.target.files[0]);
            }
        };
    </script>
</body>
</html>
