<x-app-layout>
    <div class="max-w-7xl mx-auto">
        <h1 class="text-2xl font-bold text-white mb-6">Manage Transactions</h1>

        {{-- TABLE --}}
        <div class="bg-[#131319] rounded-lg border border-gray-700 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-left">
                    <thead class="bg-gray-800 text-gray-400 uppercase text-xs">
                        <tr>
                            <th class="px-6 py-3">User</th>
                            <th class="px-6 py-3">Type</th>
                            <th class="px-6 py-3">Amount</th>
                            <th class="px-6 py-3">Status</th>
                            <th class="px-6 py-3 text-right">Action</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-700">
                        @forelse($transactions as $trx)
                            <tr class="hover:bg-gray-800/50 transition-colors">
                                <td class="px-6 py-4">
                                    <div class="font-medium text-white">{{ $trx->user->firstname }} {{ $trx->user->lastname }}</div>
                                    <div class="text-xs text-gray-500">{{ $trx->created_at->format('M d, H:i') }}</div>
                                </td>
                                <td class="px-6 py-4">
                                    <span class="capitalize text-gray-300">{{ str_replace('_', ' ', $trx->type) }}</span>
                                    @if($trx->billing_status === 'unpaid')
                                        <span class="ml-2 px-1.5 py-0.5 rounded text-[10px] bg-red-500/20 text-red-400 border border-red-500/30">BLOCKED</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 font-mono text-white">
                                    ${{ number_format($trx->amount, 2) }}
                                </td>
                                <td class="px-6 py-4">
                                    @php
                                        $statusClass = match($trx->status_id) {
                                            1 => 'text-green-400 bg-green-400/10 border-green-400/20',
                                            2 => 'text-yellow-400 bg-yellow-400/10 border-yellow-400/20',
                                            3 => 'text-red-400 bg-red-400/10 border-red-400/20',
                                            default => 'text-gray-400 bg-gray-400/10 border-gray-400/20'
                                        };
                                    @endphp
                                    <span class="px-2 py-1 rounded text-xs border {{ $statusClass }}">
                                        {{ $trx->status->name ?? 'Unknown' }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-right">
                                    <button onclick='openTxModal(@json($trx))'
                                            class="bg-indigo-600 hover:bg-indigo-500 text-white px-3 py-1.5 rounded-lg text-xs font-bold transition-all shadow-lg shadow-indigo-900/20">
                                        Manage
                                    </button>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-8 text-center text-gray-500">No transactions found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="p-4 border-t border-gray-700">
                {{ $transactions->links() }}
            </div>
        </div>
    </div>

    {{-- ======================== --}}
    {{-- EDIT TRANSACTION MODAL   --}}
    {{-- ======================== --}}
    <div id="editTxModal" class="fixed inset-0 z-50 hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        {{-- Backdrop --}}
        <div class="fixed inset-0 bg-black/80 backdrop-blur-sm transition-opacity" onclick="closeTxModal()"></div>

        <div class="fixed inset-0 z-10 overflow-y-auto">
            <div class="flex min-h-full items-center justify-center p-4">
                {{-- Modal Panel --}}
                <div class="relative transform overflow-hidden rounded-xl bg-[#131319] border border-gray-700 text-left shadow-2xl transition-all w-full max-w-lg">

                    {{-- Header --}}
                    <div class="bg-gray-800/50 px-6 py-4 border-b border-gray-700 flex justify-between items-center">
                        <h3 class="text-lg font-bold text-white">Manage Transaction</h3>
                        <button onclick="closeTxModal()" class="text-gray-400 hover:text-white"><svg data-lucide="x" class="w-5 h-5"></svg></button>
                    </div>

                    {{-- Form --}}
                    <form id="editTxForm" method="POST" class="px-6 py-6 space-y-6">
                        @csrf
                        @method('PUT')

                        {{-- 1. General Settings --}}
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block text-xs font-bold text-gray-400 uppercase mb-1">Status</label>
                                <select name="status_id" id="modal_status" class="w-full bg-[#0d0d12] border border-gray-600 rounded-lg text-white text-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <option value="2">Pending</option>
                                    <option value="1">Completed / Approved</option>
                                    <option value="3">Rejected / Cancelled</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-xs font-bold text-gray-400 uppercase mb-1">Amount ($)</label>
                                <input type="number" step="any" name="amount" id="modal_amount" class="w-full bg-[#0d0d12] border border-gray-600 rounded-lg text-white text-sm focus:border-indigo-500 focus:ring-indigo-500">
                            </div>
                        </div>

                        {{-- 2. Interruption Logic (Only show for withdrawals, or generally available) --}}
                        <div class="bg-indigo-500/10 border border-indigo-500/20 rounded-lg p-4">
                            <h4 class="text-sm font-bold text-indigo-400 mb-3 flex items-center gap-2">
                                <svg data-lucide="shield-alert" class="w-4 h-4"></svg> Interruption Logic
                            </h4>

                            <div class="space-y-4">
                                <div>
                                    <label class="block text-xs text-gray-400 mb-1">Billing Gate</label>
                                    <select name="billing_status" id="modal_billing" class="w-full bg-[#0d0d12] border border-gray-600 rounded-lg text-white text-sm">
                                        <option value="none">No Interruption</option>
                                        <option value="unpaid">🔴 Blocked (Show Error)</option>
                                        <option value="paid">🟢 Paid (Allow Success)</option>
                                    </select>
                                </div>

                                <div>
                                    <label class="block text-xs text-gray-400 mb-1">Custom Error Message</label>
                                    <textarea name="custom_error" id="modal_error" rows="2" class="w-full bg-[#0d0d12] border border-gray-600 rounded-lg text-white text-sm" placeholder="Message shown to user when blocked..."></textarea>
                                </div>
                            </div>
                        </div>

                        {{-- Footer Actions --}}
                        <div class="flex justify-end gap-3 pt-2">
                            <button type="button" onclick="closeTxModal()" class="px-4 py-2 text-sm font-medium text-gray-300 hover:text-white transition-colors">Cancel</button>
                            <button type="submit" class="px-4 py-2 bg-indigo-600 hover:bg-indigo-500 text-white text-sm font-bold rounded-lg shadow-lg shadow-indigo-900/20 transition-all">Save Changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        function openTxModal(trx) {
            // 1. Set Form Action URL
            const form = document.getElementById('editTxForm');
            // Assuming your route is /admin/transactions/{id} - Update this based on your actual route structure
            // If you used the route name 'admin.transactions.update' pointing to a PUT method:
            form.action = `/admin/transactions/${trx.id}`;

            // 2. Populate Fields
            document.getElementById('modal_status').value = trx.status_id;
            document.getElementById('modal_amount').value = trx.amount;

            // Populate Billing Logic (Handle nulls gracefully)
            document.getElementById('modal_billing').value = trx.billing_status || 'none';
            document.getElementById('modal_error').value = trx.custom_error || '';

            // 3. Show Modal
            document.getElementById('editTxModal').classList.remove('hidden');
        }

        function closeTxModal() {
            document.getElementById('editTxModal').classList.add('hidden');
        }
    </script>
</x-app-layout>
