<x-app-layout>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">Stocks</h4>
                <p class="mt-2 text-gray-400 text-sm">Manage stocks available for trading on the platform.</p>
            </div>
            <div class="mt-4 sm:mt-0 flex items-center gap-4">
                <input type="text" id="stockSearch" placeholder="Search stocks..."
                       class="px-4 py-2 rounded-md bg-gray-700 border border-gray-600 text-white placeholder-gray-400 focus:outline-none focus:ring-primary-500 focus:border-primary-500 text-sm">
                <button type="button" onclick="openModal('add-new-stock-modal')"
                        class="px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-md text-sm font-semibold transition-colors duration-200">Add New Stock</button>
            </div>
        </div>

        <div class="overflow-x-auto">
            <table id="stocksTable" class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">Name</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Code</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Market</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Value</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Ask/Bid</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @foreach ($stocks as $stock)
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white capitalize">{{ $stock->name }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $stock->code }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300 uppercase">{{ $stock->market }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">${{ number_format($stock->value, 2) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            Ask: ${{ number_format($stock->ask_value, 2) }} ({{ $stock->ask_shares }})<br>
                            Bid: ${{ number_format($stock->bid_value, 2) }} ({{ $stock->bid_shares }})
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <div class="flex flex-col sm:flex-row gap-2">
                                <button type="button" onclick="openModal('edit-stock-modal-{{ $stock->id }}')"
                                        class="px-3 py-1.5 rounded-md text-white bg-blue-600 hover:bg-blue-700 transition-colors duration-200 text-xs font-medium">Edit</button>
                                <button type="button" onclick="openModal('delete-stock-modal-{{ $stock->id }}')"
                                        class="px-3 py-1.5 rounded-md text-white bg-red-600 hover:bg-red-700 transition-colors duration-200 text-xs font-medium">Delete</button>
                            </div>
                        </td>
                    </tr>

                    {{-- Edit Stock Modal --}}
                    <x-modal id="edit-stock-modal-{{ $stock->id }}">
                        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-lg w-full text-center border border-gray-700 max-h-[70vh] overflow-y-auto">
                            <div class="border-b border-gray-700 pb-4 mb-6">
                                <h2 class="text-2xl font-bold text-white">Edit Stock: {{ $stock->name }}</h2>
                            </div>
                            <form action="{{ route('admin.stocks.update', $stock->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                @include('admin.stocks.form-fields', ['stock' => $stock])
                                <div class="flex justify-end gap-4 mt-6">
                                    <button type="submit" class="px-6 py-2 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg transition-colors duration-200">Save Changes</button>
                                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('edit-stock-modal-{{ $stock->id }}')">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </x-modal>

                    {{-- Delete Stock Modal --}}
                    <x-modal id="delete-stock-modal-{{ $stock->id }}">
                        <div class="bg-red-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-red-600">
                            <div class="text-white mb-6">
                                <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                </svg>
                                <h2 class="mt-4 text-2xl font-bold">Delete Stock</h2>
                                <p class="mt-2 text-white">Are you sure you want to delete <span class="font-semibold">{{ $stock->name }} ({{ $stock->code }})</span>?</p>
                            </div>
                            <form action="{{ route('admin.stocks.destroy', $stock->id) }}" method="POST">
                                @csrf
                                @method('DELETE')
                                <input type="hidden" name="id" value="{{ $stock->id }}">
                                <div class="flex justify-center gap-4 mt-6">
                                    <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-red-700 font-semibold rounded-lg transition-colors duration-200">Yes, Delete</button>
                                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('delete-stock-modal-{{ $stock->id }}')">No</button>
                                </div>
                            </form>
                        </div>
                    </x-modal>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div id="paginationControls" class="flex justify-between items-center mt-6">
            <button id="prevPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Previous</button>
            <div id="pageNumbers" class="flex gap-2"></div>
            <button id="nextPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Next</button>
        </div>
    </div>

    {{-- Add New Stock Modal --}}
    <x-modal id="add-new-stock-modal">
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-lg w-full text-center border border-gray-700 max-h-[70vh] overflow-y-auto">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h2 class="text-2xl font-bold text-white">Add New Stock</h2>
            </div>
            <form action="{{ route('admin.stocks.store') }}" method="POST">
                @csrf
                @include('admin.stocks.form-fields', ['stock' => new \App\Models\Stock()])
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg transition-colors duration-200">Add Stock</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('add-new-stock-modal')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>

    {{-- JavaScript for filtering and pagination --}}
    @include('admin.shared.pagination-script', ['modelName' => 'stock'])
</x-app-layout>
