@php
    // Get the model name from the parent view. Default to 'item' if not provided.
    $modelName = $modelName ?? 'item';
@endphp
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const table = document.getElementById('{{ $modelName }}sTable');
        const tbody = table.querySelector('tbody');
        const rows = Array.from(tbody.querySelectorAll('tr'));
        const searchInput = document.getElementById('{{ $modelName }}Search');
        const prevButton = document.getElementById('prevPage');
        const nextButton = document.getElementById('nextPage');
        const pageNumbersContainer = document.getElementById('pageNumbers');

        const rowsPerPage = 10;
        let currentPage = 1;
        let filteredRows = [];

        function renderTable() {
            const searchTerm = searchInput.value.toLowerCase();
            filteredRows = rows.filter(row => {
                const textContent = row.textContent.toLowerCase();
                return textContent.includes(searchTerm);
            });

            const totalPages = Math.ceil(filteredRows.length / rowsPerPage);

            if (currentPage > totalPages && totalPages > 0) {
                currentPage = totalPages;
            } else if (totalPages === 0) {
                currentPage = 1;
            }

            const start = (currentPage - 1) * rowsPerPage;
            const end = start + rowsPerPage;
            const paginatedRows = filteredRows.slice(start, end);

            tbody.innerHTML = '';
            if (paginatedRows.length === 0) {
                tbody.innerHTML = `<tr><td colspan="6" class="px-6 py-8 text-center text-gray-500">No {{ $modelName }}s found.</td></tr>`;
            } else {
                paginatedRows.forEach(row => tbody.appendChild(row));
            }

            updatePaginationControls(totalPages);
        }

        function updatePaginationControls(totalPages) {
            prevButton.disabled = currentPage === 1;
            nextButton.disabled = currentPage === totalPages || totalPages === 0;

            pageNumbersContainer.innerHTML = '';
            const maxPageButtons = 5;

            let startPage = Math.max(1, currentPage - Math.floor(maxPageButtons / 2));
            let endPage = Math.min(totalPages, startPage + maxPageButtons - 1);

            if (endPage - startPage + 1 < maxPageButtons) {
                startPage = Math.max(1, endPage - maxPageButtons + 1);
            }

            if (startPage > 1) {
                const ellipsis = document.createElement('span');
                ellipsis.textContent = '...';
                ellipsis.className = 'px-2 text-gray-400';
                pageNumbersContainer.appendChild(ellipsis);
            }

            for (let i = startPage; i <= endPage; i++) {
                const pageButton = document.createElement('button');
                pageButton.textContent = i;
                pageButton.className = `px-3 py-1 rounded-md text-sm font-medium ${
                    i === currentPage ? 'bg-primary-600 text-white' : 'bg-gray-700 hover:bg-gray-600 text-gray-300'
                }`;
                pageButton.addEventListener('click', () => {
                    currentPage = i;
                    renderTable();
                });
                pageNumbersContainer.appendChild(pageButton);
            }

            if (endPage < totalPages) {
                const ellipsis = document.createElement('span');
                ellipsis.textContent = '...';
                ellipsis.className = 'px-2 text-gray-400';
                pageNumbersContainer.appendChild(ellipsis);
            }
        }

        searchInput.addEventListener('input', () => {
            currentPage = 1;
            renderTable();
        });

        prevButton.addEventListener('click', () => {
            if (currentPage > 1) {
                currentPage--;
                renderTable();
            }
        });

        nextButton.addEventListener('click', () => {
            const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
            if (currentPage < totalPages) {
                currentPage++;
                renderTable();
            }
        });

        renderTable();
    });
</script>
