<x-app-layout>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="flex justify-between items-center mb-6">
            <h4 class="text-2xl font-semibold text-white">KYC Applications</h4>
            <div class="flex gap-2">
                <a href="?status=pending" class="px-3 py-1 text-sm bg-yellow-500/20 text-yellow-500 rounded border border-yellow-500/50">Pending</a>
                <a href="?status=verified" class="px-3 py-1 text-sm bg-green-500/20 text-green-500 rounded border border-green-500/50">Verified</a>
                <a href="?status=rejected" class="px-3 py-1 text-sm bg-red-500/20 text-red-500 rounded border border-red-500/50">Rejected</a>
                <a href="{{ route('admin.kyc.index') }}" class="px-3 py-1 text-sm bg-gray-700 text-white rounded">All</a>
            </div>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-800">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">User</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Submitted At</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-400 uppercase">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @forelse($users as $u)
                    <tr class="hover:bg-gray-700 transition-colors">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-white">{{ $u->firstname }} {{ $u->lastname }}</div>
                            <div class="text-sm text-gray-400">{{ $u->email }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            {{ $u->updated_at->format('M d, Y H:i') }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @php
                                $color = match($u->kyc_status) {
                                    'verified' => 'bg-green-100 text-green-800',
                                    'rejected' => 'bg-red-100 text-red-800',
                                    'pending' => 'bg-yellow-100 text-yellow-800',
                                    default => 'bg-gray-100 text-gray-800'
                                };
                            @endphp
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $color }}">
                                {{ ucfirst($u->kyc_status) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                            <a href="{{ route('admin.kyc.show', $u->id) }}" class="text-indigo-400 hover:text-indigo-300 font-bold">Review</a>
                        </td>
                    </tr>
                    @empty
                    <tr><td colspan="4" class="px-6 py-10 text-center text-gray-500">No applications found.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-4">{{ $users->links() }}</div>
    </div>
</x-app-layout>
