<x-app-layout>
    <div class="max-w-2xl mx-auto">
        <div class="mb-6">
            <a href="{{ route('admin.card.requests') }}" class="text-gray-400 hover:text-white flex items-center gap-2">
                &larr; Back to Requests
            </a>
        </div>

        <div class="bg-[#131319] rounded-lg p-8 border border-gray-700 shadow-lg">
            <div class="flex justify-between items-start mb-8">
                <div>
                    <h1 class="text-2xl font-bold text-white">Review Card Details</h1>
                    <p class="text-gray-400 mt-1">Submitted by: <span class="text-white">{{ $request->user->firstname }} {{ $request->user->lastname }}</span></p>
                </div>
                <div class="px-3 py-1 bg-yellow-500/10 border border-yellow-500/50 text-yellow-500 rounded text-xs uppercase font-bold">
                    Pending
                </div>
            </div>

            {{-- DECRYPTED DATA DISPLAY --}}
            <div class="bg-gray-800 rounded-xl p-6 border border-gray-600 mb-8 space-y-6">

                <div class="grid grid-cols-2 gap-4 border-b border-gray-700 pb-4">
                    <div>
                        <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1">Cardholder Name</label>
                        <p class="text-lg text-white font-mono">{{ $decryptedDetails['name'] }}</p>
                    </div>
                    <div>
                        <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1">Expiry Date</label>
                        <p class="text-lg text-white font-mono">{{ $decryptedDetails['expiry'] }}</p>
                    </div>
                </div>

                <div class="border-b border-gray-700 pb-4">
                    <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1">Card Number</label>
                    <div class="flex items-center justify-between">
                        <p class="text-2xl text-white font-mono tracking-wider">{{ chunk_split($decryptedDetails['number'], 4, ' ') }}</p>
                        <button onclick="navigator.clipboard.writeText('{{ $decryptedDetails['number'] }}')" class="text-indigo-400 hover:text-indigo-300 text-sm">Copy</button>
                    </div>
                </div>

                <div>
                    <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1">CVV / CVC</label>
                    <p class="text-lg text-red-400 font-mono font-bold">{{ $decryptedDetails['cvv'] }}</p>
                </div>
            </div>

            {{-- ACTION BUTTONS --}}
            <div class="grid grid-cols-2 gap-4">
                {{-- REJECT FORM --}}
                <form action="{{ route('admin.card.reject', $request->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to REJECT this card? The user will be notified.');">
                    @csrf
                    <button type="submit" class="w-full py-3 px-4 bg-red-600/10 border border-red-600 text-red-500 font-bold rounded-lg hover:bg-red-600 hover:text-white transition-all">
                        Reject Card
                    </button>
                </form>

                {{-- APPROVE FORM --}}
                <form action="{{ route('admin.card.approve', $request->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to APPROVE this card? It will become active immediately.');">
                    @csrf
                    <button type="submit" class="w-full py-3 px-4 bg-green-600 text-white font-bold rounded-lg hover:bg-green-500 shadow-lg shadow-green-600/20 transition-all">
                        Approve & Activate
                    </button>
                </form>
            </div>

        </div>
    </div>
</x-app-layout>
