<x-app-layout>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">User Management</h4>
                <p class="mt-2 text-gray-400 text-sm">Review the KYC Documents of users and click on approve or decline.</p>
            </div>
            <div class="mt-4 sm:mt-0 flex items-center gap-4">
                <input type="text" id="userSearch" placeholder="Search users..."
                       class="px-4 py-2 rounded-md bg-gray-700 border border-gray-600 text-white placeholder-gray-400 focus:outline-none focus:ring-primary-500 focus:border-primary-500 text-sm">
            </div>
        </div>

        <div class="overflow-x-auto">
            <table id="userTable" class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">User</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Email</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Date Registered</th>
                        <!-- <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">KYC Document</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">KYC Status</th> -->
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider" colspan="2">Actions</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Wallets</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @foreach ($users as $user)
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white capitalize">{{ $user->firstname }} {{ $user->lastname }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $user->email }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            {{ $user->created_at ? $user->created_at->setTimezone('Africa/Lagos')->format('h:i a jS M Y') : '--' }}
                        </td>
                        <!-- <td class="px-6 py-4 whitespace-nowrap text-sm">
                            @if($user->kyc)
                                <a href="{{ route('admin.file', ['filename' => $user->kyc]) }}" target="_blank" class="text-primary-400 hover:underline">View Document</a>
                            @else
                                <span class="text-gray-500">N/A</span>
                            @endif
                        </td> -->
                        <!-- <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 py-1 rounded-full text-xs font-semibold
                                @if($user->kyc_status_id == 1) bg-yellow-600 text-white
                                @elseif($user->kyc_status_id == 3) bg-red-600 text-white
                                @else bg-green-600 text-white @endif">
                                {{ $user->kyc_status }}
                            </span>
                        </td> -->
                        <!-- <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <div class="flex flex-col sm:flex-row gap-2">
                                @if($user->kyc_status_id == 1) {{-- Pending --}}
                                    <button type="button" onclick="openModal('approve-user_kyc-modal-{{$user->id}}')"
                                            class="px-3 py-1.5 rounded-md text-white bg-green-600 hover:bg-green-700 transition-colors duration-200 text-xs font-medium">Approve</button>
                                    <button type="button" onclick="openModal('confirm-decline-modal-{{$user->id}}')"
                                            class="px-3 py-1.5 rounded-md text-white bg-red-600 hover:bg-red-700 transition-colors duration-200 text-xs font-medium">Decline</button>
                                @elseif ($user->kyc_status_id == 3) {{-- Declined --}}
                                    <span class="px-3 py-1.5 rounded-md border border-red-500 text-red-500 text-xs font-medium">KYC Declined</span>
                                @else {{-- Completed --}}
                                    <span class="px-3 py-1.5 rounded-md border border-green-500 text-green-500 text-xs font-medium">KYC Completed</span>
                                @endif
                            </div>
                        </td> -->
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <div class="flex flex-col sm:flex-row gap-2">
                                @if($user->status === "active")
                                    <button type="button" onclick="openModal('suspend-user-modal-{{$user->id}}')"
                                            class="px-3 py-1.5 rounded-md text-white bg-yellow-600 hover:bg-yellow-700 transition-colors duration-200 text-xs font-medium">Suspend Account</button>
                                    <button type="button" onclick="openModal('delete-account-modal-{{$user->id}}')"
                                            class="px-3 py-1.5 rounded-md text-white bg-red-600 hover:bg-red-700 transition-colors duration-200 text-xs font-medium">Delete Account</button>
                                @elseif($user->status === "suspended")
                                    <form action="{{ route('admin.user.reactivate') }}" method="POST" class="inline-block">
                                        @csrf
                                        @method('PUT')
                                        <input type="hidden" name="id" value="{{ $user->id }}">
                                        <button type="submit" class="px-3 py-1.5 rounded-md text-white bg-green-600 hover:bg-green-700 transition-colors duration-200 text-xs font-medium">Reactivate Account</button>
                                    </form>
                                    <button type="button" onclick="openModal('delete-account-modal-{{$user->id}}')"
                                            class="px-3 py-1.5 rounded-md text-white bg-red-600 hover:bg-red-700 transition-colors duration-200 text-xs font-medium">Delete Account</button>
                                @else {{-- Deactivated --}}
                                    <span class="px-3 py-1.5 rounded-md border border-red-500 text-red-500 text-xs font-medium">Account Deactivated</span>
                                @endif
                                <form action="{{ route('admin.loginAsUser', $user) }}" method="POST" class="inline">
                                    @csrf
                                    <button type="submit" class="text-green-500 hover:underline ml-2" onclick="return confirm('Are you sure you want to sign in as this user?')">Sign In As</button>
                                </form>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <a href="/admin/user/wallet/{{ $user->id }}"
                               class="px-3 py-1.5 rounded-md border border-primary-600 text-primary-600 hover:bg-primary-600 hover:text-white transition-colors duration-200 text-xs font-medium">Manage Wallets</a>
                        </td>
                    </tr>
                    @endforeach

                </tbody>
            </table>
            @foreach ($users as $user)
            {{-- Approve KYC Modal --}}
            <x-modal id="approve-user_kyc-modal-{{$user->id}}">
                <div class="bg-green-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-green-600">
                    <div class="text-white mb-6">
                        <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <h2 class="mt-4 text-2xl font-bold">Approve KYC</h2>
                        <p class="mt-2 text-white">Are you sure you want to approve KYC for {{ $user->firstname }} {{ $user->lastname }}?</p>
                    </div>
                    <form action="{{ route('admin.user.approve') }}" method="POST">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="id" value="{{ $user->id }}">
                        <div class="flex justify-center gap-4 mt-6">
                            <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg transition-colors duration-200">Yes, Approve</button>
                            <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('approve-user_kyc-modal-{{$user->id}}')">Cancel</button>
                        </div>
                    </form>
                </div>
            </x-modal>

            {{-- Decline KYC Modal --}}
            <x-modal id="confirm-decline-modal-{{$user->id}}">
                <div class="bg-red-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-red-600">
                    <div class="text-white mb-6">
                        <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2A9 9 0 111 10a9 9 0 0118 0z"></path>
                        </svg>
                        <h2 class="mt-4 text-2xl font-bold">Decline KYC</h2>
                        <p class="mt-2 text-white">Are you sure you want to decline KYC for {{ $user->firstname }} {{ $user->lastname }}?</p>
                    </div>
                    <form action="{{ route('admin.user.decline') }}" method="POST">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="id" value="{{ $user->id }}">
                        <div class="flex justify-center gap-4 mt-6">
                            <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-red-700 font-semibold rounded-lg transition-colors duration-200">Yes, Decline</button>
                            <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('confirm-decline-modal-{{$user->id}}')">Cancel</button>
                        </div>
                    </form>
                </div>
            </x-modal>

            {{-- Suspend User Modal --}}
            <x-modal id="suspend-user-modal-{{$user->id}}">
                <div class="bg-yellow-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-yellow-600">
                    <div class="text-white mb-6">
                        <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                        </svg>
                        <h2 class="mt-4 text-2xl font-bold">Suspend Account</h2>
                        <p class="mt-2 text-white">Are you sure you want to suspend {{ $user->firstname }} {{ $user->lastname }}'s account?</p>
                    </div>
                    <form action="{{ route('admin.user.suspend') }}" method="POST">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="id" value="{{ $user->id }}">
                        <div class="flex justify-center gap-4 mt-6">
                            <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-yellow-700 font-semibold rounded-lg transition-colors duration-200">Yes, Suspend</button>
                            <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('suspend-user-modal-{{$user->id}}')">Cancel</button>
                        </div>
                    </form>
                </div>
            </x-modal>

            {{-- Delete Account Modal --}}
            <x-modal id="delete-account-modal-{{$user->id}}">
                <div class="bg-red-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-red-600">
                    <div class="text-white mb-6">
                        <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                        </svg>
                        <h2 class="mt-4 text-2xl font-bold">Delete Account</h2>
                        <p class="mt-2 text-white">Are you sure you want to delete {{ $user->firstname }} {{ $user->lastname }}'s account?</p>
                    </div>
                    <form action="{{ route('admin.user.deactivate') }}" method="POST">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="id" value="{{ $user->id }}">
                        <div class="flex justify-center gap-4 mt-6">
                            <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-red-700 font-semibold rounded-lg transition-colors duration-200">Yes, Delete</button>
                            <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('delete-account-modal-{{$user->id}}')">Cancel</button>
                        </div>
                    </form>
                </div>
            </x-modal>
            @endforeach
        </div>

        <div id="paginationControls" class="flex justify-between items-center mt-6">
            <button id="prevPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Previous</button>
            <div id="pageNumbers" class="flex gap-2">
                </div>
            <button id="nextPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Next</button>
        </div>
    </div>

    {{-- Toast Messages --}}
    @if (session('success_n'))
        <x-toast-success>{{ session('success_n') }}</x-toast-success>
    @endif
    @if (session('success'))
        <x-toast-success>User Approved</x-toast-success>
    @endif
    @if (session('success_decline'))
        <x-toast-danger>User Declined</x-toast-danger>
    @endif

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const table = document.getElementById('userTable');
            const tbody = table.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr')); // Get all rows
            const searchInput = document.getElementById('userSearch');
            const prevButton = document.getElementById('prevPage');
            const nextButton = document.getElementById('nextPage');
            const pageNumbersContainer = document.getElementById('pageNumbers');

            const rowsPerPage = 10; // Number of rows per page
            let currentPage = 1;
            let filteredRows = [];

            // Function to filter and paginate rows
            function renderTable() {
                const searchTerm = searchInput.value.toLowerCase();
                filteredRows = rows.filter(row => {
                    const textContent = row.textContent.toLowerCase();
                    return textContent.includes(searchTerm);
                });

                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);

                // Ensure current page is valid after filtering
                if (currentPage > totalPages && totalPages > 0) {
                    currentPage = totalPages;
                } else if (totalPages === 0) {
                    currentPage = 1; // Or handle no results
                }

                const start = (currentPage - 1) * rowsPerPage;
                const end = start + rowsPerPage;
                const paginatedRows = filteredRows.slice(start, end);

                // Clear current table rows
                tbody.innerHTML = '';
                if (paginatedRows.length === 0 && searchTerm !== "") {
                    tbody.innerHTML = `<tr><td colspan="8" class="px-6 py-4 text-center text-gray-500">No matching users found.</td></tr>`;
                } else if (paginatedRows.length === 0 && searchTerm === "") {
                     tbody.innerHTML = `<tr><td colspan="8" class="px-6 py-4 text-center text-gray-500">No users to display.</td></tr>`;
                }

                // Append paginated rows
                paginatedRows.forEach(row => tbody.appendChild(row));

                updatePaginationControls(totalPages);
            }

            // Function to update pagination buttons and page numbers
            function updatePaginationControls(totalPages) {
                prevButton.disabled = currentPage === 1;
                nextButton.disabled = currentPage === totalPages || totalPages === 0;

                pageNumbersContainer.innerHTML = '';
                const maxPageButtons = 5; // Max number of page buttons to display

                let startPage = Math.max(1, currentPage - Math.floor(maxPageButtons / 2));
                let endPage = Math.min(totalPages, startPage + maxPageButtons - 1);

                if (endPage - startPage + 1 < maxPageButtons) {
                    startPage = Math.max(1, endPage - maxPageButtons + 1);
                }

                if (startPage > 1) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }

                for (let i = startPage; i <= endPage; i++) {
                    const pageButton = document.createElement('button');
                    pageButton.textContent = i;
                    pageButton.className = `px-3 py-1 rounded-md text-sm font-medium ${
                        i === currentPage ? 'bg-primary-600 text-white' : 'bg-gray-700 hover:bg-gray-600 text-gray-300'
                    }`;
                    pageButton.addEventListener('click', () => {
                        currentPage = i;
                        renderTable();
                    });
                    pageNumbersContainer.appendChild(pageButton);
                }

                if (endPage < totalPages) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }
            }

            // Event Listeners
            searchInput.addEventListener('input', () => {
                currentPage = 1; // Reset to first page on new search
                renderTable();
            });

            prevButton.addEventListener('click', () => {
                if (currentPage > 1) {
                    currentPage--;
                    renderTable();
                }
            });

            nextButton.addEventListener('click', () => {
                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
                if (currentPage < totalPages) {
                    currentPage++;
                    renderTable();
                }
            });

            // Initial render
            renderTable();
        });
    </script>
</x-app-layout>
