<x-app-layout>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">Trades</h4>
                <p class="mt-2 text-gray-400 text-sm">Review trade entries and close them as needed.</p>
            </div>
            <div class="mt-4 sm:mt-0 flex items-center gap-4">
                <input type="text" id="tradeSearch" placeholder="Search trades..."
                       class="px-4 py-2 rounded-md bg-gray-700 border border-gray-600 text-white placeholder-gray-400 focus:outline-none focus:ring-primary-500 focus:border-primary-500 text-sm">
            </div>
        </div>

        <div class="overflow-x-auto">
            <table id="tradesTable" class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">User</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Amount</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">P/L</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Market</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Trade Type</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Entry Date</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Exit Date</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @foreach ($trades as $trade)
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200"
                        data-trade-id="{{ $trade->id }}"
                        data-trade-market="{{ $trade->market }}"
                        data-trade-amount="{{ $trade->amount }}"
                        data-trade-pnl-calculated="{{ number_format($trade->amount * ($trade->roi / 100), 2) }}" {{-- Assuming ROI is a percentage, calculate default PnL amount --}}
                    >
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white capitalize">{{ $trade->user->firstname }} {{ $trade->user->lastname }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">${{ number_format($trade->amount, 2, '.', ',') }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{$trade->outcome}}${{ number_format($trade->pnl, 2, '.', ',') }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{$trade->market}}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{$trade->trade_action}}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            {{ $trade->created_at ? $trade->created_at->setTimezone('Africa/Lagos')->format('h:i a jS M Y') : '--'}}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            {{ $trade->exit_time ? \Carbon\Carbon::parse($trade->exit_time)->setTimezone('Africa/Lagos')->format('h:i a jS M Y') : '--'}}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 py-1 rounded-full text-xs font-semibold
                                @if ($trade->status == 0) bg-green-600 text-white
                                @else bg-red-600 text-white @endif">
                                @if ($trade->status == 0) Open @else Closed @endif
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            @if($trade->status == 0)
                                <button type="button" data-modal-target="close-trade-modal"
                                        class="open-close-trade-modal px-3 py-1.5 rounded-md text-white bg-primary-600 hover:bg-primary-700 transition-colors duration-200 text-xs font-medium">Close Trade</button>
                            @else
                                <span class="px-3 py-1.5 rounded-md borderxborder-gray-500 text-gray-500 text-xs font-medium">--</span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div id="paginationControls" class="flex justify-between items-center mt-6">
            <button id="prevPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Previous</button>
            <div id="pageNumbers" class="flex gap-2">
                </div>
            <button id="nextPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Next</button>
        </div>
    </div>

    {{-- Close Trade Modal (Single Instance) --}}
    <x-modal id="close-trade-modal">
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-gray-700">
            <div class="text-white mb-6">
                <svg class="mx-auto h-16 w-16 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                </svg>
                <h2 class="mt-4 text-2xl font-bold">Close Trade</h2>
                <p class="mt-2 text-white">Confirm closing trade for: <span id="modalTradeMarket" class="font-semibold"></span> (Amount: $<span id="modalTradeAmount" class="font-semibold"></span>)</p>
            </div>
            <form action="{{ route('admin.trade.close') }}" method="POST" id="closeTradeForm">
                @csrf
                @method('PUT')
                <div class="my-4 text-white text-left">
                    <p class="mb-2 text-sm">Select outcome for the trade:</p>
                    <div class="mb-3">
                        <input type="radio" name="pnl" value="profit" id="modalProfitRadio" class="rounded-full text-primary-600 border-gray-600 focus:ring-primary-500 bg-gray-700 mr-2" required>
                        <label for="modalProfitRadio" class="text-sm">Profit</label>
                        <input type="radio" name="pnl" value="loss" id="modalLossRadio" class="rounded-full text-primary-600 border-gray-600 focus:ring-primary-500 bg-gray-700 ml-4 mr-2" required>
                        <label for="modalLossRadio" class="text-sm">Loss</label>
                    </div>
                </div>
                <input type="number" step="any" name="pnl_amount" id="modalPnlAmount" placeholder="P/L Amount (USD)" required
                       class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500 mb-4" />
                <input type="hidden" name="id" id="modalTradeId" value="">
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-primary-700 font-semibold rounded-lg transition-colors duration-200">Close Trade</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('close-trade-modal')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>

    {{-- Toast Messages --}}
    @if (session('success'))
        <x-toast-success>Trade Closed</x-toast-success>
    @endif
    @if (session('success_decline'))
        <x-toast-danger>Trade Action Declined</x-toast-danger>
    @endif

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const table = document.getElementById('tradesTable');
            const tbody = table.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr'));
            const searchInput = document.getElementById('tradeSearch');
            const prevButton = document.getElementById('prevPage');
            const nextButton = document.getElementById('nextPage');
            const pageNumbersContainer = document.getElementById('pageNumbers');

            const rowsPerPage = 10;
            let currentPage = 1;
            let filteredRows = [];

            // Modal elements
            const closeTradeModal = document.getElementById('close-trade-modal');
            const modalTradeMarket = document.getElementById('modalTradeMarket');
            const modalTradeAmount = document.getElementById('modalTradeAmount');
            const modalPnlAmount = document.getElementById('modalPnlAmount');
            const modalTradeId = document.getElementById('modalTradeId');
            const modalProfitRadio = document.getElementById('modalProfitRadio');
            const modalLossRadio = document.getElementById('modalLossRadio');


            // Function to filter and paginate rows
            function renderTable() {
                const searchTerm = searchInput.value.toLowerCase();
                filteredRows = rows.filter(row => {
                    const textContent = row.textContent.toLowerCase();
                    return textContent.includes(searchTerm);
                });

                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);

                if (currentPage > totalPages && totalPages > 0) {
                    currentPage = totalPages;
                } else if (totalPages === 0 && searchTerm !== "") {
                    currentPage = 1;
                } else if (totalPages === 0 && searchTerm === "") {
                    currentPage = 1;
                }

                const start = (currentPage - 1) * rowsPerPage;
                const end = start + rowsPerPage;
                const paginatedRows = filteredRows.slice(start, end);

                tbody.innerHTML = '';
                if (paginatedRows.length === 0 && searchTerm !== "") {
                    tbody.innerHTML = `<tr><td colspan="9" class="px-6 py-8 text-center text-gray-500">No matching trades found.</td></tr>`;
                } else if (paginatedRows.length === 0 && searchTerm === "") {
                     tbody.innerHTML = `<tr><td colspan="9" class="px-6 py-8 text-center text-gray-500">No trades to display.</td></tr>`;
                }

                paginatedRows.forEach(row => tbody.appendChild(row));

                updatePaginationControls(totalPages);
            }

            // Function to update pagination buttons and page numbers
            function updatePaginationControls(totalPages) {
                prevButton.disabled = currentPage === 1;
                nextButton.disabled = currentPage === totalPages || totalPages === 0;

                pageNumbersContainer.innerHTML = '';
                const maxPageButtons = 5;

                let startPage = Math.max(1, currentPage - Math.floor(maxPageButtons / 2));
                let endPage = Math.min(totalPages, startPage + maxPageButtons - 1);

                if (endPage - startPage + 1 < maxPageButtons) {
                    startPage = Math.max(1, endPage - maxPageButtons + 1);
                }

                if (startPage > 1) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }

                for (let i = startPage; i <= endPage; i++) {
                    const pageButton = document.createElement('button');
                    pageButton.textContent = i;
                    pageButton.className = `px-3 py-1 rounded-md text-sm font-medium ${
                        i === currentPage ? 'bg-primary-600 text-white' : 'bg-gray-700 hover:bg-gray-600 text-gray-300'
                    }`;
                    pageButton.addEventListener('click', () => {
                        currentPage = i;
                        renderTable();
                    });
                    pageNumbersContainer.appendChild(pageButton);
                }

                if (endPage < totalPages) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }
            }

            // Event Listeners for search and pagination
            searchInput.addEventListener('input', () => {
                currentPage = 1;
                renderTable();
            });

            prevButton.addEventListener('click', () => {
                if (currentPage > 1) {
                    currentPage--;
                    renderTable();
                }
            });

            nextButton.addEventListener('click', () => {
                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
                if (currentPage < totalPages) {
                    currentPage++;
                    renderTable();
                }
            });

            // Handle opening the single modal and populating its data
            tbody.addEventListener('click', function(event) {
                const button = event.target.closest('.open-close-trade-modal');
                if (button) {
                    const row = button.closest('tr');
                    const tradeId = row.dataset.tradeId;
                    const tradeMarket = row.dataset.tradeMarket;
                    const tradeAmount = row.dataset.tradeAmount;
                    const tradePnlCalculated = row.dataset.tradePnlCalculated;

                    modalTradeId.value = tradeId;
                    modalTradeMarket.textContent = tradeMarket;
                    modalTradeAmount.textContent = tradeAmount;
                    modalPnlAmount.value = tradePnlCalculated; // Pre-fill with calculated PnL
                    modalProfitRadio.checked = true; // Default to profit

                    openModal('close-trade-modal');
                }
            });

            // Initial render
            renderTable();
        });
    </script>
</x-app-layout>
