<x-admin-layout>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">Signal Management</h4>
                <p class="mt-2 text-gray-400 text-sm">Create, edit, and manage trading signals for users.</p>
            </div>
            <div class="mt-4 sm:mt-0 flex items-center gap-4">
                <input type="text" id="signalSearch" placeholder="Search signals..."
                       class="px-4 py-2 rounded-md bg-gray-700 border border-gray-600 text-white placeholder-gray-400 focus:outline-none focus:ring-primary-500 focus:border-primary-500 text-sm">
                <button type="button" onclick="openModal('add-signal-modal')"
                        class="px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-md text-sm font-semibold transition-colors duration-200">Add New Signal</button>
            </div>
        </div>

        <div class="overflow-x-auto">
            <table id="signalsTable" class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">Name</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Price/Unit</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Default Duration</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">ROI (%)</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Max Subscribers</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @foreach ($signals as $signal)
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200"
                        data-signal-id="{{ $signal->id }}"
                        data-signal-name="{{ $signal->name }}"
                        data-signal-description="{{ $signal->description }}"
                        data-signal-price-per-unit="{{ $signal->price_per_unit }}"
                        data-signal-duration-unit="{{ $signal->duration_unit }}"
                        data-signal-default-duration-value="{{ $signal->default_duration_value }}"
                        data-signal-roi-percentage="{{ $signal->roi_percentage }}"
                        data-signal-max-subscribers="{{ $signal->max_subscribers }}"
                        data-signal-status="{{ $signal->status }}"
                    >
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white capitalize">{{ $signal->name }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">${{ number_format($signal->price_per_unit, 2) }}/{{ $signal->duration_unit }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $signal->default_duration_value }} {{ ucfirst($signal->duration_unit) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $signal->roi_percentage }}%</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $signal->max_subscribers }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 py-1 rounded-full text-xs font-semibold
                                @if($signal->status === 'active') bg-green-600 text-white
                                @else bg-red-600 text-white @endif">
                                {{ ucfirst($signal->status) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <div class="flex flex-col sm:flex-row gap-2">
                                <button type="button" data-modal-target="edit-signal-modal"
                                        class="open-edit-signal-modal px-3 py-1.5 rounded-md text-white bg-blue-600 hover:bg-blue-700 transition-colors duration-200 text-xs font-medium">Edit</button>
                                <button type="button" data-modal-target="delete-signal-modal"
                                        class="open-delete-signal-modal px-3 py-1.5 rounded-md text-white bg-red-600 hover:bg-red-700 transition-colors duration-200 text-xs font-medium">Delete</button>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                    @if($signals->isEmpty())
                        <tr>
                            <td colspan="7" class="px-6 py-8 text-center text-gray-500 text-lg">No signals to display.</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>

        <div id="paginationControls" class="flex justify-between items-center mt-6">
            <button id="prevPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Previous</button>
            <div id="pageNumbers" class="flex gap-2">
                </div>
            <button id="nextPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Next</button>
        </div>
    </div>

    {{-- Add New Signal Modal --}}
    <x-modal id="add-signal-modal">
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-lg w-full text-center border border-gray-700 max-h-[90vh] overflow-y-auto">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h2 class="text-2xl font-bold text-white">Add New Signal</h2>
            </div>
            <form action="{{ route('admin.signals.store') }}" method="POST">
                @csrf
                <div class="space-y-4 text-left">
                    <div>
                        <label for="add_name" class="block text-sm font-medium text-gray-300 mb-1">Signal Name</label>
                        <input type="text" name="name" id="add_name" maxlength="255" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="add_description" class="block text-sm font-medium text-gray-300 mb-1">Description</label>
                        <textarea name="description" id="add_description" rows="3"
                                  class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500"></textarea>
                    </div>
                    <div>
                        <label for="add_price_per_unit" class="block text-sm font-medium text-gray-300 mb-1">Price per Unit (USD)</label>
                        <input type="number" step="0.01" name="price_per_unit" id="add_price_per_unit" min="0.01" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="add_default_duration_value" class="block text-sm font-medium text-gray-300 mb-1">Default Duration Value</label>
                            <input type="number" name="default_duration_value" id="add_default_duration_value" min="1" required
                                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                        <div>
                            <label for="add_duration_unit" class="block text-sm font-medium text-gray-300 mb-1">Duration Unit</label>
                            <select name="duration_unit" id="add_duration_unit" required
                                    class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                                <option value="day">Day(s)</option>
                                <option value="week">Week(s)</option>
                                <option value="month">Month(s)</option>
                                <option value="year">Year(s)</option>
                            </select>
                        </div>
                    </div>
                    <div>
                        <label for="add_roi_percentage" class="block text-sm font-medium text-gray-300 mb-1">Expected ROI (%)</label>
                        <input type="number" step="0.01" name="roi_percentage" id="add_roi_percentage" min="0" max="100" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="add_max_subscribers" class="block text-sm font-medium text-gray-300 mb-1">Max Subscribers</label>
                        <input type="number" name="max_subscribers" id="add_max_subscribers" min="0" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="add_status" class="block text-sm font-medium text-gray-300 mb-1">Status</label>
                        <select name="status" id="add_status" required
                                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg transition-colors duration-200">Add Signal</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('add-signal-modal')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>

    {{-- Edit Signal Modal (Single Instance) --}}
    <x-modal id="edit-signal-modal">
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-lg w-full text-center border border-gray-700 max-h-[90vh] overflow-y-auto">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h2 class="text-2xl font-bold text-white">Edit Signal: <span id="editModalSignalName"></span></h2>
            </div>
            <form action="" method="POST" id="editSignalForm">
                @csrf
                @method('PUT')
                <input type="hidden" name="id" id="editSignalId">
                <div class="space-y-4 text-left">
                    <div>
                        <label for="edit_name" class="block text-sm font-medium text-gray-300 mb-1">Signal Name</label>
                        <input type="text" name="name" id="edit_name" maxlength="255" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="edit_description" class="block text-sm font-medium text-gray-300 mb-1">Description</label>
                        <textarea name="description" id="edit_description" rows="3"
                                  class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500"></textarea>
                    </div>
                    <div>
                        <label for="edit_price_per_unit" class="block text-sm font-medium text-gray-300 mb-1">Price per Unit (USD)</label>
                        <input type="number" step="0.01" name="price_per_unit" id="edit_price_per_unit" min="0.01" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="edit_default_duration_value" class="block text-sm font-medium text-gray-300 mb-1">Default Duration Value</label>
                            <input type="number" name="default_duration_value" id="edit_default_duration_value" min="1" required
                                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                        <div>
                            <label for="edit_duration_unit" class="block text-sm font-medium text-gray-300 mb-1">Duration Unit</label>
                            <select name="duration_unit" id="edit_duration_unit" required
                                    class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                                <option value="day">Day(s)</option>
                                <option value="week">Week(s)</option>
                                <option value="month">Month(s)</option>
                                <option value="year">Year(s)</option>
                            </select>
                        </div>
                    </div>
                    <div>
                        <label for="edit_roi_percentage" class="block text-sm font-medium text-gray-300 mb-1">Expected ROI (%)</label>
                        <input type="number" step="0.01" name="roi_percentage" id="edit_roi_percentage" min="0" max="100" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="edit_max_subscribers" class="block text-sm font-medium text-gray-300 mb-1">Max Subscribers</label>
                        <input type="number" name="max_subscribers" id="edit_max_subscribers" min="0" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="edit_status" class="block text-sm font-medium text-gray-300 mb-1">Status</label>
                        <select name="status" id="edit_status" required
                                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg transition-colors duration-200">Save Changes</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('edit-signal-modal')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>

    {{-- Delete Signal Modal (Single Instance) --}}
    <x-modal id="delete-signal-modal">
        <div class="bg-red-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-red-600">
            <div class="text-white mb-6">
                <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                </svg>
                <h2 class="mt-4 text-2xl font-bold">Delete Signal</h2>
                <p class="mt-2 text-white">Are you sure you want to delete signal: <span id="deleteModalSignalName" class="font-semibold"></span>?</p>
            </div>
            <form action="" method="POST" id="deleteSignalForm">
                @csrf
                @method('DELETE')
                <input type="hidden" name="id" id="deleteSignalId">
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-red-700 font-semibold rounded-lg transition-colors duration-200">Yes, Delete</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('delete-signal-modal')">No</button>
                </div>
            </form>
        </div>
    </x-modal>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const table = document.getElementById('signalsTable');
            const tbody = table.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr'));
            const searchInput = document.getElementById('signalSearch');
            const prevButton = document.getElementById('prevPage');
            const nextButton = document.getElementById('nextPage');
            const pageNumbersContainer = document.getElementById('pageNumbers');

            const rowsPerPage = 10;
            let currentPage = 1;
            let filteredRows = [];

            // Add Signal Modal elements
            const addSignalModal = document.getElementById('add-signal-modal');
            // No specific elements for form population needed here as it's 'add'

            // Edit Signal Modal elements
            const editSignalModal = document.getElementById('edit-signal-modal');
            const editSignalForm = document.getElementById('editSignalForm');
            const editSignalId = document.getElementById('editSignalId');
            const editModalSignalName = document.getElementById('editModalSignalName');
            const editNameInput = document.getElementById('edit_name');
            const editDescriptionInput = document.getElementById('edit_description');
            const editPricePerUnitInput = document.getElementById('edit_price_per_unit');
            const editDefaultDurationValueInput = document.getElementById('edit_default_duration_value');
            const editDurationUnitSelect = document.getElementById('edit_duration_unit');
            const editRoiPercentageInput = document.getElementById('edit_roi_percentage');
            const editMaxSubscribersInput = document.getElementById('edit_max_subscribers');
            const editStatusSelect = document.getElementById('edit_status');

            // Delete Signal Modal elements
            const deleteSignalModal = document.getElementById('delete-signal-modal');
            const deleteSignalForm = document.getElementById('deleteSignalForm');
            const deleteSignalId = document.getElementById('deleteSignalId');
            const deleteModalSignalName = document.getElementById('deleteModalSignalName');


            // Function to filter and paginate rows
            function renderTable() {
                const searchTerm = searchInput.value.toLowerCase();
                filteredRows = rows.filter(row => {
                    const textContent = row.textContent.toLowerCase();
                    return textContent.includes(searchTerm);
                });

                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);

                if (totalPages === 0 && searchTerm !== "") {
                    currentPage = 1;
                } else if (totalPages === 0 && searchTerm === "") {
                    currentPage = 1;
                } else if (currentPage > totalPages) {
                    currentPage = totalPages;
                }


                const start = (currentPage - 1) * rowsPerPage;
                const end = start + rowsPerPage;
                const paginatedRows = filteredRows.slice(start, end);

                tbody.innerHTML = '';
                if (paginatedRows.length === 0 && searchTerm !== "") {
                    tbody.innerHTML = `<tr><td colspan="7" class="px-6 py-8 text-center text-gray-500">No matching signals found.</td></tr>`;
                } else if (paginatedRows.length === 0 && searchTerm === "") {
                     tbody.innerHTML = `<tr><td colspan="7" class="px-6 py-8 text-center text-gray-500">No signals to display.</td></tr>`;
                }

                paginatedRows.forEach(row => tbody.appendChild(row));

                updatePaginationControls(totalPages);
            }

            // Function to update pagination buttons and page numbers
            function updatePaginationControls(totalPages) {
                prevButton.disabled = currentPage === 1;
                nextButton.disabled = currentPage === totalPages || totalPages === 0;

                pageNumbersContainer.innerHTML = '';
                const maxPageButtons = 5;

                let startPage = Math.max(1, currentPage - Math.floor(maxPageButtons / 2));
                let endPage = Math.min(totalPages, startPage + maxPageButtons - 1);

                if (endPage - startPage + 1 < maxPageButtons) {
                    startPage = Math.max(1, endPage - maxPageButtons + 1);
                }

                if (startPage > 1) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }

                for (let i = startPage; i <= endPage; i++) {
                    const pageButton = document.createElement('button');
                    pageButton.textContent = i;
                    pageButton.className = `px-3 py-1 rounded-md text-sm font-medium ${
                        i === currentPage ? 'bg-primary-600 text-white' : 'bg-gray-700 hover:bg-gray-600 text-gray-300'
                    }`;
                    pageButton.addEventListener('click', () => {
                        currentPage = i;
                        renderTable();
                    });
                    pageNumbersContainer.appendChild(pageButton);
                }

                if (endPage < totalPages) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }
            }

            // Event Listeners for search and pagination
            searchInput.addEventListener('input', () => {
                currentPage = 1;
                renderTable();
            });

            prevButton.addEventListener('click', () => {
                if (currentPage > 1) {
                    currentPage--;
                    renderTable();
                }
            });

            nextButton.addEventListener('click', () => {
                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
                if (currentPage < totalPages) {
                    currentPage++;
                    renderTable();
                }
            });

            // Handle opening the single Edit/Delete modals and populating their data
            tbody.addEventListener('click', function(event) {
                const editButton = event.target.closest('.open-edit-signal-modal');
                const deleteButton = event.target.closest('.open-delete-signal-modal');

                if (editButton) {
                    const row = editButton.closest('tr');
                    const signalId = row.dataset.signalId;
                    const signalName = row.dataset.signalName;
                    const signalDescription = row.dataset.signalDescription;
                    const signalPricePerUnit = row.dataset.signalPricePerUnit;
                    const signalDurationUnit = row.dataset.signalDurationUnit;
                    const signalDefaultDurationValue = row.dataset.signalDefaultDurationValue;
                    const signalRoiPercentage = row.dataset.signalRoiPercentage;
                    const signalMaxSubscribers = row.dataset.signalMaxSubscribers;
                    const signalStatus = row.dataset.signalStatus;

                    // Populate form fields
                    editSignalId.value = signalId;
                    editModalSignalName.textContent = signalName;
                    editNameInput.value = signalName;
                    editDescriptionInput.value = signalDescription;
                    editPricePerUnitInput.value = signalPricePerUnit;
                    editDefaultDurationValueInput.value = signalDefaultDurationValue;
                    editDurationUnitSelect.value = signalDurationUnit;
                    editRoiPercentageInput.value = signalRoiPercentage;
                    editMaxSubscribersInput.value = signalMaxSubscribers;
                    editStatusSelect.value = signalStatus;

                    // Set form action dynamically
                    editSignalForm.action = `/admin/signals/${signalId}`; // Update this route as necessary

                    openModal('edit-signal-modal');
                } else if (deleteButton) {
                    const row = deleteButton.closest('tr');
                    const signalId = row.dataset.signalId;
                    const signalName = row.dataset.signalName;

                    deleteSignalId.value = signalId;
                    deleteModalSignalName.textContent = signalName;

                    // Set form action dynamically
                    deleteSignalForm.action = `/admin/signals/${signalId}`; // Update this route as necessary

                    openModal('delete-signal-modal');
                }
            });

            // Initial render
            renderTable();
        });
    </script>
</x-admin-layout>
