<x-admin-layout>
    <div class="box">
        <div class="box-header">
            <h4 class="font-bold text-3xl">Refunds</h4>
        </div>

        <div class="box-body">
            <div class="table-responsive">
                <table id="generic_table" class="text-fade table table-bordered">
                    <thead>
                        <tr class="text-dark">
                            <th>New User</th>
                            <th>Referrer</th>
                            <th>Intial Deposit</th>
                            <th>Bonus</th>
                            <th>Date</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($referrals as $referral)
                        <tr class="capitalize">
                            <td>{{$referral->referer->firstname}} {{$referral->referer->lastname}}</td>
                            <td>{{$referral->referee->firstname}} {{$referral->referee->lastname}}</td>
                            <td>{{$referral->initial_deposit}}</td>
                            <td>{{$referral->bonus}}</td>
                            <td>{{ $referral->created_at ? $referral->created_at->setTimezone('Africa/Lagos')->format('h:i a jS M Y') :'--'}}</td>
                            <td class="gap-4">
                                @if($referral->status_id == 2)
                                    <x-primary-button class="mb-2" data-bs-toggle="modal" data-bs-target="#approve-deposit-modal-{{$referral->id}}">Disburse Bonus</x-primary-button>
                                    <!-- <x-danger-button class="bg-red-700 mr-4 inline-flex " data-bs-toggle="modal" data-bs-target="#confirm-decline-modal-{{$referral->id}}" >Decline</x-danger-button> -->

                                    <!-- Approval modal -->
                                    <div id="approve-deposit-modal-{{$referral->id}}" class="modal fade" style="background: rgba(0, 0, 0, 0.7);" tabindex="-1" role="dialog" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content modal-filled bg-success">
                                                <div class="modal-body p-4">
                                                    <div class="text-center">
                                                        <i class="dripicons-checkmark h1"></i>
                                                        <h2 class="mt-2 font-bold text-3xl">Approve Disbursement of Bonus</h2>
                                                        <form action="{{ route('admin.referrals.update', $referral->id) }}" method="POST">
                                                            @csrf
                                                            @method('PUT')
                                                            <label for="">How much bonus? (default 5% of deposit)</label>
                                                            <input type="number" class="block w-full rounded-lg border border-gray-300 bg-gray-50 p-2.5 text-sm text-gray-900 focus:border-primary-500 focus:ring-primary-500 dark:border-gray-600  dark:placeholder:text-gray-400" value="{{$referral->initial_deposit*0.05}}" name="amount">
                                                            <!-- <input type="hidden" name="type" value="approve"> -->
                                                            <!-- <input type="hidden" name="id" value="{{$referral->id}}"> -->
                                                            <div class="flex item-center justify-center gap-4 my-4">
                                                                <button type="submit" class="btn btn-light my-2 bg-white">Approve</button>
                                                                <button type="button" class="btn btn-light my-2 bg-gray-300 text-white" data-bs-dismiss="modal">Cancel</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div><!-- /.modal-content -->
                                        </div><!-- /.modal-dialog -->
                                    </div><!-- /.modal -->
                                    <!-- confirm decline -->


                                    {{--
                                        <div id="confirm-decline-modal-{{$referral->id}}" class="modal fade" style="background: rgba(0, 0, 0, 0.7);" tabindex="-1" role="dialog" aria-hidden="true">
                                            <!-- <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content modal-filled bg-danger">
                                                    <div class="modal-body p-4">
                                                        <div class="text-center">
                                                            <i class="dripicons-checkmark h1"></i>
                                                            <h2 class="mt-2">Are You Sure You Want To Decline</h2>
                                                            <h2 class="mt-2 text-2xl">{{$referral->transaction_id}}</h2>
                                                            <form action="{{ url('/admin/refunds') }}" method="POST" class="flex item-center justify-center gap-4">
                                                                @csrf
                                                                @method('PUT')
                                                                <input type="hidden" name="id" value="{{$referral->id}}">
                                                                <input type="hidden" name="type" value="decline">
                                                                <button type="submit" class="btn btn-light my-2 bg-white">Yes</button>
                                                                <button type="button" class="btn btn-light my-2 bg-white" data-bs-dismiss="modal">No</button>
                                                            </form>
                                                        </div>
                                                    </div> -->
                                                </div><!-- /.modal-content -->
                                            </div><!-- /.modal-dialog -->
                                        </div><!-- /.modal -->
                                    --}}
                                @elseif ($referral->status_id == 1)
                                    <div class="px-8 py-2 border-2 border-green-300 text-green-300 w-fit rounded">Approved</div>
                                @else
                                    <div class="px-8 py-2 border-2 border-red-300 text-red-300 w-fit rounded">Declined</div>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- <div id="toast_success" class="fixed z-[1000] flex items-center w-fit max-w-xs p-4 space-x-4 text-gray-100 bg-green-400 divide-x rtl:divide-x-reverse divide-gray-200 rounded-lg shadow top-20 right-5 dark:text-gray-400 dark:divide-gray-700" role="alert">
        <div class="text-sm font-normal">Deposit Approved.</div>
    </div>

    <script>
        setTimeout(() => {
            const toast = document.getElementById('toast_success');
            if (toast) {
                toast.remove();
            }
        }, 5000); // Remove after 5 seconds
    </script> -->
@if (session('success'))
    <x-toast-success>Refund Approved</x-toast-success>
@endif
@if (session('success_decline'))
    <x-toast-danger>Refund Declined</x-toast-danger>
@endif

</x-admin-layout>
