<x-app-layout>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">Deposits</h4>
                <p class="mt-2 text-gray-400 text-sm">Review deposit requests and click on approve or decline.</p>
            </div>
            <div class="mt-4 sm:mt-0 flex items-center gap-4">
                <input type="text" id="depositSearch" placeholder="Search deposits..."
                       class="px-4 py-2 rounded-md bg-gray-700 border border-gray-600 text-white placeholder-gray-400 focus:outline-none focus:ring-primary-500 focus:border-primary-500 text-sm">
            </div>
        </div>

        <div class="overflow-x-auto">
            <table id="depositsTable" class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">Transaction ID</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">User</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Amount (USD)</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Payment Method</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Wallet</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Deposit Date</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Action Date</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @foreach ($deposits as $deposit)
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white">{{ $deposit->transaction_id }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300 capitalize">{{ $deposit->user->firstname }} {{ $deposit->user->lastname }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">${{ number_format($deposit->amount, 2) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ optional($deposit->paymentOption)->name ?? '--' }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ optional($deposit->walletOption)->name ?? '--' }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            {{ $deposit->created_at ? $deposit->created_at->setTimezone('Africa/Lagos')->format('h:i a jS M Y') : '--' }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            {{ $deposit->action_at ? \Carbon\Carbon::parse($deposit->action_at)->setTimezone('Africa/Lagos')->format('h:i a jS M Y') : '--' }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 py-1 rounded-full text-xs font-semibold
                                @if($deposit->status_id == 2) bg-yellow-600 text-white
                                @elseif($deposit->status_id == 1) bg-green-600 text-white
                                @else bg-red-600 text-white @endif">
                                {{ $deposit->status->name }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <div class="flex flex-col sm:flex-row gap-2">
                                @if($deposit->status_id == 2) {{-- Pending --}}
                                    <button type="button" onclick="openModal('approve-deposit-modal-{{$deposit->id}}')"
                                            class="px-3 py-1.5 rounded-md text-white bg-green-600 hover:bg-green-700 transition-colors duration-200 text-xs font-medium">Approve</button>
                                    <button type="button" onclick="openModal('confirm-decline-modal-{{$deposit->id}}')"
                                            class="px-3 py-1.5 rounded-md text-white bg-red-600 hover:bg-red-700 transition-colors duration-200 text-xs font-medium">Decline</button>
                                @elseif ($deposit->status_id == 1) {{-- Approved --}}
                                    <span class="px-3 py-1.5 rounded-md border border-green-500 text-green-500 text-xs font-medium">Approved</span>
                                @else {{-- Declined --}}
                                    <span class="px-3 py-1.5 rounded-md border border-red-500 text-red-500 text-xs font-medium">Declined</span>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div id="paginationControls" class="flex justify-between items-center mt-6">
            <button id="prevPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Previous</button>
            <div id="pageNumbers" class="flex gap-2">
            </div>
            <button id="nextPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Next</button>
        </div>
    </div>

    {{-- Approve Deposit Modal --}}
    @foreach ($deposits as $deposit)
    <x-modal id="approve-deposit-modal-{{$deposit->id}}">
        <div class="bg-green-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-green-600">
            <div class="text-white mb-6">
                <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <h2 class="mt-4 text-2xl font-bold">Approve Deposit</h2>
                <p class="mt-2 text-white">Confirm approval for transaction ID: <span class="font-semibold">{{ $deposit->transaction_id }}</span> <br>(Amount: ${{ number_format($deposit->amount, 2) }}, Wallet: {{ optional($deposit->walletOption)->name ?? '--' }})</p>
            </div>
            <form action="{{ url('/admin/transaction/approve') }}" method="POST">
                @csrf
                @method('PUT')
                <input type="hidden" name="id" value="{{ $deposit->id }}">
                <input type="hidden" name="type" value="deposit">
                <input type="number" step="any" name="amount" value="{{ $deposit->amount }}"
                       class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500 mb-4 xcursor-not-allowed" />
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg transition-colors duration-200">Yes, Approve</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('approve-deposit-modal-{{$deposit->id}}')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>

    {{-- Decline Deposit Modal --}}
    <x-modal id="confirm-decline-modal-{{$deposit->id}}">
        <div class="bg-red-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-red-600">
            <div class="text-white mb-6">
                <svg data-lucide="x-circle" class="mx-auto h-16 w-16"></svg>
                <h2 class="mt-4 text-2xl font-bold">Decline Deposit</h2>
                <p class="mt-2 text-white">Are you sure you want to decline transaction ID: <span class="font-semibold">{{ $deposit->transaction_id }}</span>?</p>
            </div>
            <form action="{{ route('admin.transaction.decline') }}" method="POST">
                @csrf
                @method('PUT')
                <input type="hidden" name="id" value="{{ $deposit->id }}">
                <input type="hidden" name="type" value="deposit">
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-red-700 font-semibold rounded-lg transition-colors duration-200">Yes, Decline</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('confirm-decline-modal-{{$deposit->id}}')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>
    @endforeach

    {{-- Toast Messages --}}
    @if (session('success'))
        <x-toast-success>Deposit Approved</x-toast-success>
    @endif
    @if (session('success_decline'))
        <x-toast-danger>Deposit Declined</x-toast-danger>
    @endif

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const table = document.getElementById('depositsTable');
            const tbody = table.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr')); // Get all rows
            const searchInput = document.getElementById('depositSearch');
            const prevButton = document.getElementById('prevPage');
            const nextButton = document.getElementById('nextPage');
            const pageNumbersContainer = document.getElementById('pageNumbers');

            const rowsPerPage = 10; // Number of rows per page
            let currentPage = 1;
            let filteredRows = [];

            // Function to filter and paginate rows
            function renderTable() {
                const searchTerm = searchInput.value.toLowerCase();
                filteredRows = rows.filter(row => {
                    const textContent = row.textContent.toLowerCase();
                    return textContent.includes(searchTerm);
                });

                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);

                // Ensure current page is valid after filtering
                if (currentPage > totalPages && totalPages > 0) {
                    currentPage = totalPages;
                } else if (totalPages === 0 && searchTerm !== "") {
                    currentPage = 1; // Show no results if search term exists
                } else if (totalPages === 0 && searchTerm === "") {
                    currentPage = 1; // Stay on page 1 if no data and no search
                }

                const start = (currentPage - 1) * rowsPerPage;
                const end = start + rowsPerPage;
                const paginatedRows = filteredRows.slice(start, end);

                // Clear current table rows
                tbody.innerHTML = '';
                if (paginatedRows.length === 0 && searchTerm !== "") {
                    tbody.innerHTML = `<tr><td colspan="9" class="px-6 py-4 text-center text-gray-500">No matching deposits found.</td></tr>`;
                } else if (paginatedRows.length === 0 && searchTerm === "") {
                     tbody.innerHTML = `<tr><td colspan="9" class="px-6 py-4 text-center text-gray-500">No deposits to display.</td></tr>`;
                }

                // Append paginated rows
                paginatedRows.forEach(row => tbody.appendChild(row));

                updatePaginationControls(totalPages);
            }

            // Function to update pagination buttons and page numbers
            function updatePaginationControls(totalPages) {
                prevButton.disabled = currentPage === 1;
                nextButton.disabled = currentPage === totalPages || totalPages === 0;

                pageNumbersContainer.innerHTML = '';
                const maxPageButtons = 5; // Max number of page buttons to display

                let startPage = Math.max(1, currentPage - Math.floor(maxPageButtons / 2));
                let endPage = Math.min(totalPages, startPage + maxPageButtons - 1);

                if (endPage - startPage + 1 < maxPageButtons) {
                    startPage = Math.max(1, endPage - maxPageButtons + 1);
                }

                if (startPage > 1) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }

                for (let i = startPage; i <= endPage; i++) {
                    const pageButton = document.createElement('button');
                    pageButton.textContent = i;
                    pageButton.className = `px-3 py-1 rounded-md text-sm font-medium ${
                        i === currentPage ? 'bg-primary-600 text-white' : 'bg-gray-700 hover:bg-gray-600 text-gray-300'
                    }`;
                    pageButton.addEventListener('click', () => {
                        currentPage = i;
                        renderTable();
                    });
                    pageNumbersContainer.appendChild(pageButton);
                }

                if (endPage < totalPages) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }
            }

            // Event Listeners
            searchInput.addEventListener('input', () => {
                currentPage = 1; // Reset to first page on new search
                renderTable();
            });

            prevButton.addEventListener('click', () => {
                if (currentPage > 1) {
                    currentPage--;
                    renderTable();
                }
            });

            nextButton.addEventListener('click', () => {
                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
                if (currentPage < totalPages) {
                    currentPage++;
                    renderTable();
                }
            });

            // Initial render
            renderTable();
        });
    </script>
</x-app-layout>
