/*
SQLyog Community v13.3.0 (64 bit)
MySQL - 8.4.3 : Database - exodus-app
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`exodus-app` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

/*Table structure for table `cache` */

DROP TABLE IF EXISTS `cache`;

CREATE TABLE `cache` (
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `cache` */

insert  into `cache`(`key`,`value`,`expiration`) values 
('admin@nordspheretrade.com|127.0.0.1','i:1;',1759769284),
('admin@nordspheretrade.com|127.0.0.1:timer','i:1759769284;',1759769284),
('anaya1127@gmail.com|108.29.199.58','i:1;',1764799692),
('anaya1127@gmail.com|108.29.199.58:timer','i:1764799692;',1764799692),
('antonio96burgos@icloud.com|24.35.149.131','i:1;',1765064463),
('antonio96burgos@icloud.com|24.35.149.131:timer','i:1765064463;',1765064463),
('badeveryday300@gmail.com|197.211.59.185','i:1;',1764356160),
('badeveryday300@gmail.com|197.211.59.185:timer','i:1764356160;',1764356160),
('bennett.romaine@yahoo.com|23.117.43.156','i:1;',1764728200),
('bennett.romaine@yahoo.com|23.117.43.156:timer','i:1764728200;',1764728200),
('bshane598@gmail.com|99.235.130.89','i:1;',1764032674),
('bshane598@gmail.com|99.235.130.89:timer','i:1764032674;',1764032674),
('ch.o.at.ecostellokr.ol.6.6.815@gmail.com|185.25.111.48','i:3;',1764286368),
('ch.o.at.ecostellokr.ol.6.6.815@gmail.com|185.25.111.48:timer','i:1764286368;',1764286368),
('e3prods@gmail.com|174.234.98.213','i:1;',1764692117),
('e3prods@gmail.com|174.234.98.213:timer','i:1764692117;',1764692117),
('eloisfullerllc@gmail.com|98.79.139.101','i:1;',1764864058),
('eloisfullerllc@gmail.com|98.79.139.101:timer','i:1764864058;',1764864058),
('johnsonalfred442@proton.me|127.0.0.1','i:1;',1758002473),
('johnsonalfred442@proton.me|127.0.0.1:timer','i:1758002473;',1758002473),
('kade.guzman.mail@gmail.com|99.97.20.16','i:1;',1765150612),
('kade.guzman.mail@gmail.com|99.97.20.16:timer','i:1765150612;',1765150612),
('katukadinatu5@gmail.com|79.127.149.13','i:1;',1764997278),
('katukadinatu5@gmail.com|79.127.149.13:timer','i:1764997278;',1764997278),
('kiah.mallory89@gmail.com|12.218.191.19','i:1;',1764969519),
('kiah.mallory89@gmail.com|12.218.191.19:timer','i:1764969519;',1764969519),
('kyleerwhitfield01@gmail.com|206.171.115.125','i:1;',1764211853),
('kyleerwhitfield01@gmail.com|206.171.115.125:timer','i:1764211853;',1764211853),
('ola.cooper@yahoo.com|166.199.150.19','i:1;',1764294316),
('ola.cooper@yahoo.com|166.199.150.19:timer','i:1764294316;',1764294316),
('omariholmes82@gmail.com|198.23.182.63','i:1;',1764954936),
('omariholmes82@gmail.com|198.23.182.63:timer','i:1764954936;',1764954936),
('robbie.g767@gmail.com|207.244.221.249','i:2;',1764277301),
('robbie.g767@gmail.com|207.244.221.249:timer','i:1764277301;',1764277301),
('robertbeauvoir@ymail.com|73.100.133.203','i:1;',1764684520),
('robertbeauvoir@ymail.com|73.100.133.203:timer','i:1764684520;',1764684520),
('samzena384@gmail.com|102.22.122.18','i:1;',1764680079),
('samzena384@gmail.com|102.22.122.18:timer','i:1764680079;',1764680079),
('samzena384@gmail.con|102.22.122.18','i:1;',1764680113),
('samzena384@gmail.con|102.22.122.18:timer','i:1764680113;',1764680113),
('support@stakeorbityield.com|127.0.0.1','i:1;',1765191112),
('support@stakeorbityield.com|127.0.0.1:timer','i:1765191112;',1765191112);

/*Table structure for table `cache_locks` */

DROP TABLE IF EXISTS `cache_locks`;

CREATE TABLE `cache_locks` (
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `cache_locks` */

/*Table structure for table `card_activation_requests` */

DROP TABLE IF EXISTS `card_activation_requests`;

CREATE TABLE `card_activation_requests` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `virtual_card_id` bigint unsigned NOT NULL,
  `actual_card_number` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `actual_card_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `actual_expiry` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `actual_cvv` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('pending','approved','rejected') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `admin_notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `processed_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `card_activation_requests_user_id_foreign` (`user_id`),
  KEY `card_activation_requests_virtual_card_id_foreign` (`virtual_card_id`),
  CONSTRAINT `card_activation_requests_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `card_activation_requests_virtual_card_id_foreign` FOREIGN KEY (`virtual_card_id`) REFERENCES `virtual_cards` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `card_activation_requests` */

insert  into `card_activation_requests`(`id`,`user_id`,`virtual_card_id`,`actual_card_number`,`actual_card_name`,`actual_expiry`,`actual_cvv`,`status`,`admin_notes`,`created_at`,`updated_at`,`processed_at`) values 
(1,132,1,'eyJpdiI6Ii93ZVBBamNsOFNUUURhbUFXbVRQd2c9PSIsInZhbHVlIjoiYnlEaUZvb0JtdVJ4aS9STXVsMVVndz09IiwibWFjIjoiZGZlOGYzZTAzMjQ5ZTMwM2FiNGY5YzVhODc2NTM3MjkyM2Y2NDBmNDk1YWRiMTY0MzViN2EyNDkzNTFmMDUzNyIsInRhZyI6IiJ9','eyJpdiI6IkcwdjdEMUtXcTRVT3BqcWNpRWE0Ync9PSIsInZhbHVlIjoia3ZlZFlsNWNjM0p2TGFrMmlkWHFsQT09IiwibWFjIjoiMDg1NGVmYTEzYzIyMzIwODk4MDFiYzI4M2Y5MjY0NGMxNTA0OTFiMzMzNDA1MzJjNDkwYjYzNmJkYjYwMmEyYyIsInRhZyI6IiJ9','eyJpdiI6IkxrTXViQmlqajhZR3NoeHdVMzhrRXc9PSIsInZhbHVlIjoiU1NpVXgzZ0RJK2VtUGhNYWVJM1dRZz09IiwibWFjIjoiY2M2ZWRhM2NmNzYwYWExYjZkYWZkZGMyN2ZmYzQ2MDMyZTM4Yzg4YWNjNDI5YTNjYTI1YjAwZWMyNmZhNDkyMCIsInRhZyI6IiJ9','eyJpdiI6IjJKWUs0Mndwb0JZRTBobTF1Ty81TXc9PSIsInZhbHVlIjoiMGM3dFJsZzJ2dXJJUGxMWnpyYyt3QT09IiwibWFjIjoiZmI4NDc4ZTgwNmEzODU0YTlmYmQ4OWZjOTU1NTc1ZjFlZThjZDdiNzJhMWJjMmU0ZDgyMDg5MWZmNWZmZjE5YSIsInRhZyI6IiJ9','pending',NULL,'2026-01-16 14:34:51','2026-01-16 14:34:51',NULL),
(2,132,1,'eyJpdiI6IkVpOUtMNnhEZXhnSnMxWkpqR1hrUUE9PSIsInZhbHVlIjoiMDN4dE93L2gvODBVQzNicTc4bktmc1Z4QndiM1JiSjQxRXhzSEpjKzhUVT0iLCJtYWMiOiI5OTI2NDA5MGU5ODdhNGI4NTE2NDBjNGRlNDRlNDM3NTc1MWM0Njc1NDE3MDNjYjhhMjA3ZjZiZWU0ZDdiN2Q0IiwidGFnIjoiIn0=','eyJpdiI6InBWK1NOU0hVWU5mT1Jwc0t2Y09rTVE9PSIsInZhbHVlIjoiTVI2bmRzakk0K1ZVNGhMWitiNExjdz09IiwibWFjIjoiMjVlMTViYmUxMGMzOTg4ODYxZmMwMWYxZDViYjE0NjE2OTg3YTg3YWJjMzg5YTIxMjkyZTYyYjFlMjNmNzcxZCIsInRhZyI6IiJ9','eyJpdiI6Imd2YVQwOXVkSjZkdzE2RHlUbHhNNmc9PSIsInZhbHVlIjoiM0xvTW0wZnNnSVJFZGRJa3E3TU5YQT09IiwibWFjIjoiMjExOTZhZDQwNzAwOGYxZWIzYmU5NTljMTI4ZTAxMTdiODcwN2E0Nzg0MmVkNGE2ZTdiNjlhN2M0MGRlZmQ4ZiIsInRhZyI6IiJ9','eyJpdiI6ImJ5Yng0M01oTm1mdUhxS3lMYWhMUVE9PSIsInZhbHVlIjoiM0RjTzgwblZ1UXlyejJmSzBLWFJnQT09IiwibWFjIjoiZTVmMjM0ODkzN2Y3YzBjNzI5MWY3M2M5NTNlNDViZTA5MTJiYzFhZGQwYzY5ZWZiYWMzNjAzMjNiNWM2YzUxYSIsInRhZyI6IiJ9','pending',NULL,'2026-01-16 14:37:28','2026-01-16 14:37:28',NULL),
(3,132,1,'eyJpdiI6Indnb0JJdnhpTGo2V3ZKR0JFM3A1Nmc9PSIsInZhbHVlIjoiUnJyaVM1OHdsMEhLRmZUUDdHZGJlSkVDZDZoT2UxVkIwV0JaMFRaWVFndz0iLCJtYWMiOiJkMGI3NGY5ZWUxOGQ2NDYzZWY3M2EyM2VkMDkzZWQ4ZDFkZjBlNzBiNDEzYjczNDk1N2EzYjFhY2NlYWNkMjY5IiwidGFnIjoiIn0=','eyJpdiI6IkdUZEZEMlZkUXZsT0xncCtUNU8zL2c9PSIsInZhbHVlIjoia0EvdFJrTnkveUFTeW5ROGZISXR3dz09IiwibWFjIjoiZGVkZWUyY2FiMTBiMmY0NTU0NTkwODNlOWY5NmZhMTlhZjdiYTI0NzhlZTdiZDY1ZDJjNTY1ZWZmMjAyMDUzYSIsInRhZyI6IiJ9','eyJpdiI6ImFYRUVZQm00bWJBNmM4NDBlWkVpYlE9PSIsInZhbHVlIjoiaVN4MUVIeHM4UmE4NE9aNDFteDkvdz09IiwibWFjIjoiZmFlMzIxOTZlZDZkYTdiNDUyNzE2ZjliMTRhZmZhMzk5MDM4YjEyODliNDAzMDljZGM0YTczZjNjZTliOTA0YSIsInRhZyI6IiJ9','eyJpdiI6ImxTYzFyaWEwVGMwVnlMRHppeEMwWWc9PSIsInZhbHVlIjoiVHF4ekU5L2ZmZHBLWnJ5NlkzMVhRQT09IiwibWFjIjoiZmQzYWIwZTc4N2U4M2RiMmI0MWI2ZWU0NjkzODA0YTdkZDNkZjA0YjE3ZjYxMzM5MjM3YzhmYTMwY2VjYWM4ZiIsInRhZyI6IiJ9','pending',NULL,'2026-01-16 14:42:44','2026-01-16 14:42:44',NULL),
(4,129,2,'eyJpdiI6IlFYeUZzUXh0cmtGa2Z3QjhTZk0zdFE9PSIsInZhbHVlIjoiaENOWFZyT1VSdEFOUzR6dWVEZElxenZNeHFacVZPWnZIWVU4UWNIWFJMYz0iLCJtYWMiOiJhNDIzNzgzZDAxOTZmNzM0MDUwN2NlN2YyZTY5NzI0ZmUwMDQ0ZjU0MDg1YTliOGM4ZTkwOWRlZDkzMWJhN2EzIiwidGFnIjoiIn0=','eyJpdiI6IlNMNjNyRFBiRnZ3ZGFJOUtXYTAwQ2c9PSIsInZhbHVlIjoiaStpVjFCVVYvb3NPVHNFR3B3Vnozdz09IiwibWFjIjoiMGZiZGRkYjMyNmI1MjVmZjQ2NWQ2ZjZhNDk5M2I2ZGZiOTZmZTk3MjhjOTAwNzE1OWFlNzg4NDYyZTJkYmM5ZiIsInRhZyI6IiJ9','eyJpdiI6IlprMWpPcWRDQ1E0dmxlMkJwUmJEb2c9PSIsInZhbHVlIjoiQlRWSVBiK3dYaWlzSHFuZ2lYLy80QT09IiwibWFjIjoiNGUzZDRmNzlmN2ZiYzE5MDY3YzNjYzJmNTllMmU1NjMzNzBkMWM5OTk1MzQ5NWJkYWU5NzlkYTRjYTkwNWY3YSIsInRhZyI6IiJ9','eyJpdiI6InhkR3VyV01XY3JTaFJYTmo4blFqS1E9PSIsInZhbHVlIjoib0VhbnpIZVJIKzhoVGVkMTN4WDRTZz09IiwibWFjIjoiZTBkNWNmNjdmYjk1N2RiZTNlY2ZlY2FhOWVjMWY2ZmM5OTQ5MWVmMDg5ODdiMjc3YTNlZDM0ZDFlYmU4Mzk4MSIsInRhZyI6IiJ9','pending',NULL,'2026-01-19 09:22:36','2026-01-19 09:22:36',NULL),
(5,129,2,'eyJpdiI6Ilp1a0hHY0V3cTNLeXhMd3ZzQ3hJUVE9PSIsInZhbHVlIjoiekpZcUN4Ri8yeWJBamtRNERRWDZIN1kyNCtEOFJuSUlQd3NxQU54WWNuOD0iLCJtYWMiOiJmNmNhZTRmNmZkZDY2MGI4ZTBhMjg5MDhiZGI4OGJiYmE3MGQ1NTZlYTJkZWI4N2I5NzY4NTE2MjE2YWUxNjI3IiwidGFnIjoiIn0=','eyJpdiI6IlhRL1NxZktsUGM4cHQzQzY0b0V4M0E9PSIsInZhbHVlIjoiTXVSc1dpRXIrTUZTaUdnbDJxSjFwZz09IiwibWFjIjoiYzZkOWJkNjYzMDVjZTJiZWFlMzllZjE1N2JjYjMxYjBmNmZiNTA3OGY1YzZkOTVmODBhMWU4YmQ1OWYzODMxYyIsInRhZyI6IiJ9','eyJpdiI6InJnVnVEcXFwN3J2RDB3T29Xbm5UOFE9PSIsInZhbHVlIjoicy9RZlFCa2d3RmMrbmpXc3QwMURyQT09IiwibWFjIjoiODg5NjQ1ZTRkZmEzMDllYTk3ZTFjMzQzZTIxYTEwNjZmZTA5OTFkYjRhYzQzYWFlNjI0MjFiZmIyNGViNzM0MSIsInRhZyI6IiJ9','eyJpdiI6ImwyTVRqOW5jYW13cFRZd0NBTmZEMlE9PSIsInZhbHVlIjoiSy9QSEJQTUpvUzNPbGFNMFc1a0REdz09IiwibWFjIjoiNjJhZTBiMmUyZDg3YzcyZjI3NjY0OTViY2U2NDA5NjVkNzY0MGZiOGE2ODRmOGVkYjNkYTQxODljZDAzOGZjNSIsInRhZyI6IiJ9','pending',NULL,'2026-01-19 09:37:12','2026-01-19 09:37:12',NULL),
(6,129,2,'eyJpdiI6IjdwWlQ0VU8rNGcrb05QRGNFSlNkSXc9PSIsInZhbHVlIjoib0o5L0Ivd3l0MHVLNWxaMTUxYm5jNmU3WlBTTkZ2TndCNjVJVTBFTVYyVT0iLCJtYWMiOiIwMDk5YTc5ZThiMWFkOWY3YzkzNjkyZGJmYWUzOWRmZmQ3NDRiM2VkMzk0OTMwNDFlYTEyOWI5YTUxMjcxMzczIiwidGFnIjoiIn0=','eyJpdiI6IjdjR2dHS3FhWkhWS3BKK21sZXNac1E9PSIsInZhbHVlIjoieU9PN2VRVVBoVWtsV2prS0ZDVWU4QT09IiwibWFjIjoiMGNkZjMyMjZiZDY0YmE3NTQxYzVmY2I1ODM2MzRkNWYzYzgzNDA1NDQ4YTI4ZjRkNjU5NzVjZmZlNWFiNzE3NCIsInRhZyI6IiJ9','eyJpdiI6IklnTmM3TTZ6VG8vVmtRQVF5K0g0ZlE9PSIsInZhbHVlIjoiQnNQb3U0cS90L2tYTFBteEIvTFFHQT09IiwibWFjIjoiNzUwOWI1NWQ1ZGIxNzg2YTA2MzVlM2Q3YTBiODdmOGQ0NjRiZTE0NDljMjZkZjNkZTY1NGY1YzNkY2MzNGY4ZiIsInRhZyI6IiJ9','eyJpdiI6IkI1MW9JV09UQkY5S0dzc0REb3RMVEE9PSIsInZhbHVlIjoiQjlEV242UUExamRkcFFYemM3YjdNZz09IiwibWFjIjoiMmExNjRkMTg2MTI3ZDk2ZDdhNDhhYTdjZjExZTlhYWY1OGJhNmIzM2U2MDMzYjkzMmI1MWI5ZTI5NzE2MjcwZSIsInRhZyI6IiJ9','rejected',NULL,'2026-01-19 09:39:01','2026-01-19 10:11:24','2026-01-19 10:11:24'),
(7,129,2,'eyJpdiI6Ii9VVkF5UnhYNU5uQkVncU9PbHRBcnc9PSIsInZhbHVlIjoiNTVDbW10ZXpnekdDTVZkQTBjUkdnVEowMkRHMlZNZG9ScnA3WFFtWFJMND0iLCJtYWMiOiJiNWMxNTgyNDRlMmI2ODM5YTExZDRjZDJiMGE0ODlhZGNhMDk5YWNkYjg5MWIyODc4Nzg2ZGZkZTA1Y2FlNDU2IiwidGFnIjoiIn0=','eyJpdiI6IitmU2RUcTROZWFvRkNwaktHanMzbnc9PSIsInZhbHVlIjoiSEQ1RTJXdkpqeFZZNG5YaWhtZWg2QT09IiwibWFjIjoiYmExZDhlMWIxZTc2YTAwNjA3MGM0Y2M5MzUwZjIzZjI1YzVkYzBjOTFhZDRjZmEwMzk4YmRiMDU0OTBjMzA5NSIsInRhZyI6IiJ9','eyJpdiI6IkxBRDA2ZE96VmdaZ09JK3V3K3dVL2c9PSIsInZhbHVlIjoiSlF6Rm1rRXdYVEoraDAzYjF5RFBsZz09IiwibWFjIjoiNzU4MjdiYTYwNGY3Y2QxMGUyMzJkYmZjYjYyOGZiYWFlYzQxZTFjZTUxNzZkOTVmMTViMzVlY2NlOGIxMzgyYiIsInRhZyI6IiJ9','eyJpdiI6ImJDaHUrNnhUY2NXRGZhQW1LZlN6OFE9PSIsInZhbHVlIjoiV01kK0FIWlNtS1FQTVQ2cDJBTWRKUT09IiwibWFjIjoiZDM1YWQ5YTIzMzM5YjI2MmUwODBjYzdlOTg5ZGUyNDUxYjg3Y2VhODBjMTQxZTg3NWQ3NWMzNDIzNDVhNmY0NiIsInRhZyI6IiJ9','approved',NULL,'2026-01-19 10:13:52','2026-01-19 10:28:42','2026-01-19 10:28:42');

/*Table structure for table `claimed_shares` */

DROP TABLE IF EXISTS `claimed_shares`;

CREATE TABLE `claimed_shares` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `letter_explanation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `signed_contract` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `breach_proof` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('pending','approved','rejected') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `claimed_shares_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `claimed_shares` */

insert  into `claimed_shares`(`id`,`user_id`,`letter_explanation`,`signed_contract`,`breach_proof`,`status`,`created_at`,`updated_at`) values 
(1,13,'uploads/letter_explanations/1732186812_kindle book cover --LOGBOOK.pdf','uploads/signed_contracts/1732186815_kindle-book-cover--LOGBOOK.pdf','uploads/breach_proofs/1732186815_kindle-book-cover--LOGBOOK.pdf','pending','2024-11-22 05:00:15','2024-11-22 05:00:15'),
(2,13,'uploads/letter_explanations/1732187042_kindle-book-cover--LOGBOOK.pdf','uploads/signed_contracts/1732187042_kindle book cover --LOGBOOK.pdf','uploads/breach_proofs/1732187042_kindle-book-cover--LOGBOOK.pdf','pending','2024-11-22 05:04:02','2024-11-22 05:04:02'),
(3,13,'uploads/letter_explanations/1732187327_kindle book cover --LOGBOOK.pdf','uploads/signed_contracts/1732187327_kindle book cover --LOGBOOK.pdf','uploads/breach_proofs/1732187327_kindle-book-cover--LOGBOOK.pdf','pending','2024-11-22 05:08:47','2024-11-22 05:08:47'),
(4,13,'uploads/letter_explanations/1732187506_kindle-book-cover--LOGBOOK.pdf','uploads/signed_contracts/1732187506_kindle-book-cover--LOGBOOK.pdf','uploads/breach_proofs/1732187506_kindle-book-cover--LOGBOOK.pdf','pending','2024-11-22 05:11:46','2024-11-22 05:11:46'),
(5,27,'uploads/letter_explanations/1732257829_CamScanner 08-16-2024 09.21.pdf','uploads/signed_contracts/1732257832_CamScanner 08-16-2024 09.21.pdf','uploads/breach_proofs/1732257832_Transaction-172353922144-BuyPower.pdf','rejected','2024-11-23 00:43:52','2024-11-23 04:31:12'),
(6,27,'uploads/letter_explanations/1732258035_CamScanner 08-16-2024 09.21.pdf','uploads/signed_contracts/1732258035_AITF_18th_Trade_Fair_Brochure_.pdf','uploads/breach_proofs/1732258035_CamScanner 08-16-2024 09.21.pdf','rejected','2024-11-23 00:47:15','2024-11-23 04:30:50'),
(7,27,'uploads/letter_explanations/1732259933_2024_Deda_Employee_Engagement_Survey_(Responses)_-_Report_Charts--5Aug2024.pdf','uploads/signed_contracts/1732259933_Transaction-172353922144-BuyPower.pdf','uploads/breach_proofs/1732259933_CamScanner 08-16-2024 09.21.pdf','approved','2024-11-23 01:18:54','2024-11-23 04:22:31'),
(8,13,'uploads/letter_explanations/1732186812_kindle book cover --LOGBOOK.pdf','uploads/signed_contracts/1732186815_kindle-book-cover--LOGBOOK.pdf','uploads/breach_proofs/1732186815_kindle-book-cover--LOGBOOK.pdf','pending','2024-11-22 05:00:15','2024-11-22 05:00:15'),
(9,27,'uploads/letter_explanations/1732259933_2024_Deda_Employee_Engagement_Survey_(Responses)_-_Report_Charts--5Aug2024.pdf','uploads/signed_contracts/1732259933_Transaction-172353922144-BuyPower.pdf','uploads/breach_proofs/1732259933_CamScanner 08-16-2024 09.21.pdf','approved','2024-11-23 01:18:54','2024-11-23 04:44:50'),
(10,27,'uploads/letter_explanations/1732259933_2024_Deda_Employee_Engagement_Survey_(Responses)_-_Report_Charts--5Aug2024.pdf','uploads/signed_contracts/1732259933_Transaction-172353922144-BuyPower.pdf','uploads/breach_proofs/1732259933_CamScanner 08-16-2024 09.21.pdf','approved','2024-11-23 01:18:54','2024-11-23 04:52:00'),
(11,27,'uploads/letter_explanations/1732259933_2024_Deda_Employee_Engagement_Survey_(Responses)_-_Report_Charts--5Aug2024.pdf','uploads/signed_contracts/1732259933_Transaction-172353922144-BuyPower.pdf','uploads/breach_proofs/1732259933_CamScanner 08-16-2024 09.21.pdf','rejected','2024-11-23 01:18:54','2024-11-23 04:52:13'),
(12,27,'uploads/letter_explanations/1732259933_2024_Deda_Employee_Engagement_Survey_(Responses)_-_Report_Charts--5Aug2024.pdf','uploads/signed_contracts/1732259933_Transaction-172353922144-BuyPower.pdf','uploads/breach_proofs/1732259933_CamScanner 08-16-2024 09.21.pdf','rejected','2024-11-23 01:18:54','2024-11-26 09:25:15'),
(13,27,'uploads/letter_explanations/1732259933_2024_Deda_Employee_Engagement_Survey_(Responses)_-_Report_Charts--5Aug2024.pdf','uploads/signed_contracts/1732259933_Transaction-172353922144-BuyPower.pdf','uploads/breach_proofs/1732259933_CamScanner 08-16-2024 09.21.pdf','pending','2024-11-23 01:18:54','2024-11-23 04:22:31'),
(14,28,'uploads/letter_explanations/1732546622_kindle-book-cover--LOGBOOK.pdf','uploads/signed_contracts/1732546623_kindle book cover --LOGBOOK.pdf','uploads/breach_proofs/1732546623_kindle book cover --LOGBOOK.pdf','approved','2024-11-26 08:57:03','2024-11-26 09:24:31'),
(15,28,'uploads/letter_explanations/1732549529_kindle-book-cover--LOGBOOK.pdf','uploads/signed_contracts/1732549530_kindle book cover --LOGBOOK.pdf','uploads/breach_proofs/1732549530_kindle book cover --LOGBOOK.pdf','approved','2024-11-26 09:45:30','2024-11-26 09:46:46'),
(16,31,'uploads/letter_explanations/1733826772_18JAN2024_LogBook-v2.pdf','uploads/signed_contracts/1733826772_18JAN2024_LogBook-v2.pdf','uploads/breach_proofs/1733826772_18JAN2024_LogBook-v2.pdf','rejected','2024-12-11 04:32:53','2024-12-11 05:37:50'),
(17,31,'uploads/letter_explanations/1733831248_18JAN2024_LogBook-v2.pdf','uploads/signed_contracts/1733831248_18JAN2024_LogBook-v2.pdf','uploads/breach_proofs/1733831248_18JAN2024_LogBook-v2.pdf','pending','2024-12-11 05:47:28','2024-12-11 05:47:28');

/*Table structure for table `coins` */

DROP TABLE IF EXISTS `coins`;

CREATE TABLE `coins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `stake_apr` decimal(10,2) DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `account_details` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'N/A',
  `value` decimal(20,2) DEFAULT '0.00',
  `api_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `coins` */

insert  into `coins`(`id`,`name`,`code`,`stake_apr`,`created_at`,`updated_at`,`deleted_at`,`account_details`,`value`,`api_name`) values 
(1,'Bitcoin','bitcoin',7.00,'2025-02-04 06:18:49','2025-12-04 20:47:05',NULL,'bc1p2cev09zmqsepm6cd787rwvhwafs32agpwy857l3s0uvz6jf7femsr9hmj4',109718.00,'bitcoin'),
(2,'Tether','USDT',6.00,'2025-02-04 06:18:49','2025-11-25 05:08:22',NULL,'0xA36470BA43037A8E9c0d746125091A3d73181aeE',1.00,'tether'),
(3,'USD Coin','USDC',7.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',1.00,'usd coin'),
(4,'Ethereum','ETH',7.00,'2025-02-04 06:18:49','2025-11-25 05:04:30',NULL,'0xA36470BA43037A8E9c0d746125091A3d73181aeE',2689.20,'ethereum'),
(5,'Solana','SOL',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',166.85,'solana'),
(6,'Ripple','XRP',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',2.60,'ripple'),
(7,'Ripple USD','RLUSD',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',0.00,'ripple usd'),
(8,'Binance Coin','BNB',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',310.00,'binance coin'),
(9,'Toncoin','TON',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',2.40,'toncoin'),
(10,'Tron','TRON',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',0.29,'tron'),
(11,'Litecoin','LTC',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',89.97,'litecoin'),
(12,'Avalanche','AVAX',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',35.00,'avalanche'),
(13,'Bitcoin Cash','BCH',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',241.00,'bitcoin cash'),
(14,'Dai','DAI',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',1.00,'dai'),
(15,'Binance USD','BUSD',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',1.00,'binance usd'),
(16,'POL','POL',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',3.00,'pol'),
(17,'TrueUSD','TUSD',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',1.00,'trueusd'),
(18,'Arbitrum','ARB',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',0.36,'arbitrum'),
(19,'ChainLink','LINK',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',17.18,'chainlink'),
(20,'USDD','USDD',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',1.00,'usdd'),
(21,'Pax Dollar','USDP',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',1.00,'pax dollar'),
(22,'Wrapped Bitcoin','WBTC',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',43000.00,'wrapped bitcoin'),
(23,'Lido Staked ETH','stETH',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',2300.00,'lido staked eth'),
(24,'Kaspa','KAS',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',0.07,'kaspa'),
(25,'Book of Meme','BOME',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',5.00,'book of meme'),
(26,'Dogecoin','DOGE',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',0.20,'dogecoin'),
(27,'ETH (Base)','ETH',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',2300.00,'eth (base)'),
(28,'USDT (Base)','USDT',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',1.00,'usdt (base)'),
(29,'USDC (Base)','USDC',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',1.00,'usdc (base)'),
(30,'OFFICIAL TRUMP','TRUMP',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',0.00,'official trump'),
(31,'Coinbase Wrapped BTC','CBBTC',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',43000.00,'coinbase wrapped btc'),
(32,'Wrapped Ethereum','WETH',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',2300.00,'wrapped ethereum'),
(33,'Airdrop USDT','AUSDT',0.00,'2025-02-04 06:18:49','2025-09-10 06:36:14','2025-09-10 06:36:14','N/A',1.00,'airdrop usdt'),
(35,'Dollars','USD',0.00,'2025-02-26 09:02:10','2025-03-03 18:00:00',NULL,'USD payment directions',1.00,'dollars'),
(36,'Zelda Logan','Atque doloribus volu',1.00,'2025-06-12 01:00:57','2025-09-10 06:36:14','2025-09-10 06:36:14','Magnam dolorum illum',40.00,'Kelsie Macias'),
(37,'Solana','Sol',7.00,'2025-12-05 02:59:01','2025-12-05 02:59:01',NULL,'Ag9ViFB8nFXJNBnUTWQkJu9GHWHaEHKcP4rumMJ7eGyt',140.35,'Solana');

/*Table structure for table `country` */

DROP TABLE IF EXISTS `country`;

CREATE TABLE `country` (
  `id` int NOT NULL AUTO_INCREMENT,
  `iso` char(2) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `name` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nicename` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `iso3` char(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numcode` smallint DEFAULT NULL,
  `phonecode` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=240 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `country` */

insert  into `country`(`id`,`iso`,`name`,`nicename`,`iso3`,`numcode`,`phonecode`) values 
(1,'AF','AFGHANISTAN','Afghanistan','AFG',4,93),
(2,'AL','ALBANIA','Albania','ALB',8,355),
(3,'DZ','ALGERIA','Algeria','DZA',12,213),
(4,'AS','AMERICAN SAMOA','American Samoa','ASM',16,1684),
(5,'AD','ANDORRA','Andorra','AND',20,376),
(6,'AO','ANGOLA','Angola','AGO',24,244),
(7,'AI','ANGUILLA','Anguilla','AIA',660,1264),
(8,'AQ','ANTARCTICA','Antarctica',NULL,NULL,0),
(9,'AG','ANTIGUA AND BARBUDA','Antigua and Barbuda','ATG',28,1268),
(10,'AR','ARGENTINA','Argentina','ARG',32,54),
(11,'AM','ARMENIA','Armenia','ARM',51,374),
(12,'AW','ARUBA','Aruba','ABW',533,297),
(13,'AU','AUSTRALIA','Australia','AUS',36,61),
(14,'AT','AUSTRIA','Austria','AUT',40,43),
(15,'AZ','AZERBAIJAN','Azerbaijan','AZE',31,994),
(16,'BS','BAHAMAS','Bahamas','BHS',44,1242),
(17,'BH','BAHRAIN','Bahrain','BHR',48,973),
(18,'BD','BANGLADESH','Bangladesh','BGD',50,880),
(19,'BB','BARBADOS','Barbados','BRB',52,1246),
(20,'BY','BELARUS','Belarus','BLR',112,375),
(21,'BE','BELGIUM','Belgium','BEL',56,32),
(22,'BZ','BELIZE','Belize','BLZ',84,501),
(23,'BJ','BENIN','Benin','BEN',204,229),
(24,'BM','BERMUDA','Bermuda','BMU',60,1441),
(25,'BT','BHUTAN','Bhutan','BTN',64,975),
(26,'BO','BOLIVIA','Bolivia','BOL',68,591),
(27,'BA','BOSNIA AND HERZEGOVINA','Bosnia and Herzegovina','BIH',70,387),
(28,'BW','BOTSWANA','Botswana','BWA',72,267),
(29,'BV','BOUVET ISLAND','Bouvet Island',NULL,NULL,0),
(30,'BR','BRAZIL','Brazil','BRA',76,55),
(31,'IO','BRITISH INDIAN OCEAN TERRITORY','British Indian Ocean Territory',NULL,NULL,246),
(32,'BN','BRUNEI DARUSSALAM','Brunei Darussalam','BRN',96,673),
(33,'BG','BULGARIA','Bulgaria','BGR',100,359),
(34,'BF','BURKINA FASO','Burkina Faso','BFA',854,226),
(35,'BI','BURUNDI','Burundi','BDI',108,257),
(36,'KH','CAMBODIA','Cambodia','KHM',116,855),
(37,'CM','CAMEROON','Cameroon','CMR',120,237),
(38,'CA','CANADA','Canada','CAN',124,1),
(39,'CV','CAPE VERDE','Cape Verde','CPV',132,238),
(40,'KY','CAYMAN ISLANDS','Cayman Islands','CYM',136,1345),
(41,'CF','CENTRAL AFRICAN REPUBLIC','Central African Republic','CAF',140,236),
(42,'TD','CHAD','Chad','TCD',148,235),
(43,'CL','CHILE','Chile','CHL',152,56),
(44,'CN','CHINA','China','CHN',156,86),
(45,'CX','CHRISTMAS ISLAND','Christmas Island',NULL,NULL,61),
(46,'CC','COCOS (KEELING) ISLANDS','Cocos (Keeling) Islands',NULL,NULL,672),
(47,'CO','COLOMBIA','Colombia','COL',170,57),
(48,'KM','COMOROS','Comoros','COM',174,269),
(49,'CG','CONGO','Congo','COG',178,242),
(50,'CD','CONGO, THE DEMOCRATIC REPUBLIC OF THE','Congo, the Democratic Republic of the','COD',180,242),
(51,'CK','COOK ISLANDS','Cook Islands','COK',184,682),
(52,'CR','COSTA RICA','Costa Rica','CRI',188,506),
(53,'CI','COTE D\'IVOIRE','Cote D\'Ivoire','CIV',384,225),
(54,'HR','CROATIA','Croatia','HRV',191,385),
(55,'CU','CUBA','Cuba','CUB',192,53),
(56,'CY','CYPRUS','Cyprus','CYP',196,357),
(57,'CZ','CZECH REPUBLIC','Czech Republic','CZE',203,420),
(58,'DK','DENMARK','Denmark','DNK',208,45),
(59,'DJ','DJIBOUTI','Djibouti','DJI',262,253),
(60,'DM','DOMINICA','Dominica','DMA',212,1767),
(61,'DO','DOMINICAN REPUBLIC','Dominican Republic','DOM',214,1809),
(62,'EC','ECUADOR','Ecuador','ECU',218,593),
(63,'EG','EGYPT','Egypt','EGY',818,20),
(64,'SV','EL SALVADOR','El Salvador','SLV',222,503),
(65,'GQ','EQUATORIAL GUINEA','Equatorial Guinea','GNQ',226,240),
(66,'ER','ERITREA','Eritrea','ERI',232,291),
(67,'EE','ESTONIA','Estonia','EST',233,372),
(68,'ET','ETHIOPIA','Ethiopia','ETH',231,251),
(69,'FK','FALKLAND ISLANDS (MALVINAS)','Falkland Islands (Malvinas)','FLK',238,500),
(70,'FO','FAROE ISLANDS','Faroe Islands','FRO',234,298),
(71,'FJ','FIJI','Fiji','FJI',242,679),
(72,'FI','FINLAND','Finland','FIN',246,358),
(73,'FR','FRANCE','France','FRA',250,33),
(74,'GF','FRENCH GUIANA','French Guiana','GUF',254,594),
(75,'PF','FRENCH POLYNESIA','French Polynesia','PYF',258,689),
(76,'TF','FRENCH SOUTHERN TERRITORIES','French Southern Territories',NULL,NULL,0),
(77,'GA','GABON','Gabon','GAB',266,241),
(78,'GM','GAMBIA','Gambia','GMB',270,220),
(79,'GE','GEORGIA','Georgia','GEO',268,995),
(80,'DE','GERMANY','Germany','DEU',276,49),
(81,'GH','GHANA','Ghana','GHA',288,233),
(82,'GI','GIBRALTAR','Gibraltar','GIB',292,350),
(83,'GR','GREECE','Greece','GRC',300,30),
(84,'GL','GREENLAND','Greenland','GRL',304,299),
(85,'GD','GRENADA','Grenada','GRD',308,1473),
(86,'GP','GUADELOUPE','Guadeloupe','GLP',312,590),
(87,'GU','GUAM','Guam','GUM',316,1671),
(88,'GT','GUATEMALA','Guatemala','GTM',320,502),
(89,'GN','GUINEA','Guinea','GIN',324,224),
(90,'GW','GUINEA-BISSAU','Guinea-Bissau','GNB',624,245),
(91,'GY','GUYANA','Guyana','GUY',328,592),
(92,'HT','HAITI','Haiti','HTI',332,509),
(93,'HM','HEARD ISLAND AND MCDONALD ISLANDS','Heard Island and Mcdonald Islands',NULL,NULL,0),
(94,'VA','HOLY SEE (VATICAN CITY STATE)','Holy See (Vatican City State)','VAT',336,39),
(95,'HN','HONDURAS','Honduras','HND',340,504),
(96,'HK','HONG KONG','Hong Kong','HKG',344,852),
(97,'HU','HUNGARY','Hungary','HUN',348,36),
(98,'IS','ICELAND','Iceland','ISL',352,354),
(99,'IN','INDIA','India','IND',356,91),
(100,'ID','INDONESIA','Indonesia','IDN',360,62),
(101,'IR','IRAN, ISLAMIC REPUBLIC OF','Iran, Islamic Republic of','IRN',364,98),
(102,'IQ','IRAQ','Iraq','IRQ',368,964),
(103,'IE','IRELAND','Ireland','IRL',372,353),
(104,'IL','ISRAEL','Israel','ISR',376,972),
(105,'IT','ITALY','Italy','ITA',380,39),
(106,'JM','JAMAICA','Jamaica','JAM',388,1876),
(107,'JP','JAPAN','Japan','JPN',392,81),
(108,'JO','JORDAN','Jordan','JOR',400,962),
(109,'KZ','KAZAKHSTAN','Kazakhstan','KAZ',398,7),
(110,'KE','KENYA','Kenya','KEN',404,254),
(111,'KI','KIRIBATI','Kiribati','KIR',296,686),
(112,'KP','KOREA, DEMOCRATIC PEOPLE\'S REPUBLIC OF','Korea, Democratic People\'s Republic of','PRK',408,850),
(113,'KR','KOREA, REPUBLIC OF','Korea, Republic of','KOR',410,82),
(114,'KW','KUWAIT','Kuwait','KWT',414,965),
(115,'KG','KYRGYZSTAN','Kyrgyzstan','KGZ',417,996),
(116,'LA','LAO PEOPLE\'S DEMOCRATIC REPUBLIC','Lao People\'s Democratic Republic','LAO',418,856),
(117,'LV','LATVIA','Latvia','LVA',428,371),
(118,'LB','LEBANON','Lebanon','LBN',422,961),
(119,'LS','LESOTHO','Lesotho','LSO',426,266),
(120,'LR','LIBERIA','Liberia','LBR',430,231),
(121,'LY','LIBYAN ARAB JAMAHIRIYA','Libyan Arab Jamahiriya','LBY',434,218),
(122,'LI','LIECHTENSTEIN','Liechtenstein','LIE',438,423),
(123,'LT','LITHUANIA','Lithuania','LTU',440,370),
(124,'LU','LUXEMBOURG','Luxembourg','LUX',442,352),
(125,'MO','MACAO','Macao','MAC',446,853),
(126,'MK','MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF','Macedonia, the Former Yugoslav Republic of','MKD',807,389),
(127,'MG','MADAGASCAR','Madagascar','MDG',450,261),
(128,'MW','MALAWI','Malawi','MWI',454,265),
(129,'MY','MALAYSIA','Malaysia','MYS',458,60),
(130,'MV','MALDIVES','Maldives','MDV',462,960),
(131,'ML','MALI','Mali','MLI',466,223),
(132,'MT','MALTA','Malta','MLT',470,356),
(133,'MH','MARSHALL ISLANDS','Marshall Islands','MHL',584,692),
(134,'MQ','MARTINIQUE','Martinique','MTQ',474,596),
(135,'MR','MAURITANIA','Mauritania','MRT',478,222),
(136,'MU','MAURITIUS','Mauritius','MUS',480,230),
(137,'YT','MAYOTTE','Mayotte',NULL,NULL,269),
(138,'MX','MEXICO','Mexico','MEX',484,52),
(139,'FM','MICRONESIA, FEDERATED STATES OF','Micronesia, Federated States of','FSM',583,691),
(140,'MD','MOLDOVA, REPUBLIC OF','Moldova, Republic of','MDA',498,373),
(141,'MC','MONACO','Monaco','MCO',492,377),
(142,'MN','MONGOLIA','Mongolia','MNG',496,976),
(143,'MS','MONTSERRAT','Montserrat','MSR',500,1664),
(144,'MA','MOROCCO','Morocco','MAR',504,212),
(145,'MZ','MOZAMBIQUE','Mozambique','MOZ',508,258),
(146,'MM','MYANMAR','Myanmar','MMR',104,95),
(147,'NA','NAMIBIA','Namibia','NAM',516,264),
(148,'NR','NAURU','Nauru','NRU',520,674),
(149,'NP','NEPAL','Nepal','NPL',524,977),
(150,'NL','NETHERLANDS','Netherlands','NLD',528,31),
(151,'AN','NETHERLANDS ANTILLES','Netherlands Antilles','ANT',530,599),
(152,'NC','NEW CALEDONIA','New Caledonia','NCL',540,687),
(153,'NZ','NEW ZEALAND','New Zealand','NZL',554,64),
(154,'NI','NICARAGUA','Nicaragua','NIC',558,505),
(155,'NE','NIGER','Niger','NER',562,227),
(156,'NG','NIGERIA','Nigeria','NGA',566,234),
(157,'NU','NIUE','Niue','NIU',570,683),
(158,'NF','NORFOLK ISLAND','Norfolk Island','NFK',574,672),
(159,'MP','NORTHERN MARIANA ISLANDS','Northern Mariana Islands','MNP',580,1670),
(160,'NO','NORWAY','Norway','NOR',578,47),
(161,'OM','OMAN','Oman','OMN',512,968),
(162,'PK','PAKISTAN','Pakistan','PAK',586,92),
(163,'PW','PALAU','Palau','PLW',585,680),
(164,'PS','PALESTINIAN TERRITORY, OCCUPIED','Palestinian Territory, Occupied',NULL,NULL,970),
(165,'PA','PANAMA','Panama','PAN',591,507),
(166,'PG','PAPUA NEW GUINEA','Papua New Guinea','PNG',598,675),
(167,'PY','PARAGUAY','Paraguay','PRY',600,595),
(168,'PE','PERU','Peru','PER',604,51),
(169,'PH','PHILIPPINES','Philippines','PHL',608,63),
(170,'PN','PITCAIRN','Pitcairn','PCN',612,0),
(171,'PL','POLAND','Poland','POL',616,48),
(172,'PT','PORTUGAL','Portugal','PRT',620,351),
(173,'PR','PUERTO RICO','Puerto Rico','PRI',630,1787),
(174,'QA','QATAR','Qatar','QAT',634,974),
(175,'RE','REUNION','Reunion','REU',638,262),
(176,'RO','ROMANIA','Romania','ROM',642,40),
(177,'RU','RUSSIAN FEDERATION','Russian Federation','RUS',643,70),
(178,'RW','RWANDA','Rwanda','RWA',646,250),
(179,'SH','SAINT HELENA','Saint Helena','SHN',654,290),
(180,'KN','SAINT KITTS AND NEVIS','Saint Kitts and Nevis','KNA',659,1869),
(181,'LC','SAINT LUCIA','Saint Lucia','LCA',662,1758),
(182,'PM','SAINT PIERRE AND MIQUELON','Saint Pierre and Miquelon','SPM',666,508),
(183,'VC','SAINT VINCENT AND THE GRENADINES','Saint Vincent and the Grenadines','VCT',670,1784),
(184,'WS','SAMOA','Samoa','WSM',882,684),
(185,'SM','SAN MARINO','San Marino','SMR',674,378),
(186,'ST','SAO TOME AND PRINCIPE','Sao Tome and Principe','STP',678,239),
(187,'SA','SAUDI ARABIA','Saudi Arabia','SAU',682,966),
(188,'SN','SENEGAL','Senegal','SEN',686,221),
(189,'CS','SERBIA AND MONTENEGRO','Serbia and Montenegro',NULL,NULL,381),
(190,'SC','SEYCHELLES','Seychelles','SYC',690,248),
(191,'SL','SIERRA LEONE','Sierra Leone','SLE',694,232),
(192,'SG','SINGAPORE','Singapore','SGP',702,65),
(193,'SK','SLOVAKIA','Slovakia','SVK',703,421),
(194,'SI','SLOVENIA','Slovenia','SVN',705,386),
(195,'SB','SOLOMON ISLANDS','Solomon Islands','SLB',90,677),
(196,'SO','SOMALIA','Somalia','SOM',706,252),
(197,'ZA','SOUTH AFRICA','South Africa','ZAF',710,27),
(198,'GS','SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS','South Georgia and the South Sandwich Islands',NULL,NULL,0),
(199,'ES','SPAIN','Spain','ESP',724,34),
(200,'LK','SRI LANKA','Sri Lanka','LKA',144,94),
(201,'SD','SUDAN','Sudan','SDN',736,249),
(202,'SR','SURINAME','Suriname','SUR',740,597),
(203,'SJ','SVALBARD AND JAN MAYEN','Svalbard and Jan Mayen','SJM',744,47),
(204,'SZ','SWAZILAND','Swaziland','SWZ',748,268),
(205,'SE','SWEDEN','Sweden','SWE',752,46),
(206,'CH','SWITZERLAND','Switzerland','CHE',756,41),
(207,'SY','SYRIAN ARAB REPUBLIC','Syrian Arab Republic','SYR',760,963),
(208,'TW','TAIWAN, PROVINCE OF CHINA','Taiwan, Province of China','TWN',158,886),
(209,'TJ','TAJIKISTAN','Tajikistan','TJK',762,992),
(210,'TZ','TANZANIA, UNITED REPUBLIC OF','Tanzania, United Republic of','TZA',834,255),
(211,'TH','THAILAND','Thailand','THA',764,66),
(212,'TL','TIMOR-LESTE','Timor-Leste',NULL,NULL,670),
(213,'TG','TOGO','Togo','TGO',768,228),
(214,'TK','TOKELAU','Tokelau','TKL',772,690),
(215,'TO','TONGA','Tonga','TON',776,676),
(216,'TT','TRINIDAD AND TOBAGO','Trinidad and Tobago','TTO',780,1868),
(217,'TN','TUNISIA','Tunisia','TUN',788,216),
(218,'TR','TURKEY','Turkey','TUR',792,90),
(219,'TM','TURKMENISTAN','Turkmenistan','TKM',795,7370),
(220,'TC','TURKS AND CAICOS ISLANDS','Turks and Caicos Islands','TCA',796,1649),
(221,'TV','TUVALU','Tuvalu','TUV',798,688),
(222,'UG','UGANDA','Uganda','UGA',800,256),
(223,'UA','UKRAINE','Ukraine','UKR',804,380),
(224,'AE','UNITED ARAB EMIRATES','United Arab Emirates','ARE',784,971),
(225,'GB','UNITED KINGDOM','United Kingdom','GBR',826,44),
(226,'US','UNITED STATES','United States','USA',840,1),
(227,'UM','UNITED STATES MINOR OUTLYING ISLANDS','United States Minor Outlying Islands',NULL,NULL,1),
(228,'UY','URUGUAY','Uruguay','URY',858,598),
(229,'UZ','UZBEKISTAN','Uzbekistan','UZB',860,998),
(230,'VU','VANUATU','Vanuatu','VUT',548,678),
(231,'VE','VENEZUELA','Venezuela','VEN',862,58),
(232,'VN','VIET NAM','Viet Nam','VNM',704,84),
(233,'VG','VIRGIN ISLANDS, BRITISH','Virgin Islands, British','VGB',92,1284),
(234,'VI','VIRGIN ISLANDS, U.S.','Virgin Islands, U.s.','VIR',850,1340),
(235,'WF','WALLIS AND FUTUNA','Wallis and Futuna','WLF',876,681),
(236,'EH','WESTERN SAHARA','Western Sahara','ESH',732,212),
(237,'YE','YEMEN','Yemen','YEM',887,967),
(238,'ZM','ZAMBIA','Zambia','ZMB',894,260),
(239,'ZW','ZIMBABWE','Zimbabwe','ZWE',716,263);

/*Table structure for table `deposits` */

DROP TABLE IF EXISTS `deposits`;

CREATE TABLE `deposits` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `transaction_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'TRD000000',
  `user_id` bigint unsigned DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `amount_disbursed` decimal(10,2) DEFAULT NULL,
  `option` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_at` datetime DEFAULT NULL,
  `action_by` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status_id` int unsigned NOT NULL DEFAULT '2',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status_id`),
  CONSTRAINT `deposits_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `deposits_ibfk_2` FOREIGN KEY (`status_id`) REFERENCES `payment_statuses` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `deposits` */

/*Table structure for table `expert_traders` */

DROP TABLE IF EXISTS `expert_traders`;

CREATE TABLE `expert_traders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `min_investment_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `max_investment_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `expected_duration_value` int NOT NULL DEFAULT '0',
  `expected_duration_unit` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'days',
  `risk_level` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Medium',
  `features` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `expected_roi_percentage` decimal(5,2) NOT NULL,
  `revenue_share_percentage` decimal(5,2) NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `expert_traders_chk_1` CHECK (json_valid(`features`))
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `expert_traders` */

insert  into `expert_traders`(`id`,`name`,`email`,`min_investment_amount`,`max_investment_amount`,`expected_duration_value`,`expected_duration_unit`,`risk_level`,`features`,`expected_roi_percentage`,`revenue_share_percentage`,`description`,`status`,`created_at`,`updated_at`,`deleted_at`) values 
(1,'Lareina Alston','dogadiwek@mailinator.com',0.00,0.00,0,'days','Medium',NULL,15.00,59.00,'Enim enim rem ad et','deleted','2025-06-17 01:56:18','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(2,'Altcoin Gordon','altcoingordon@example.com',18000.00,60000.00,30,'days','Low','[\"Personalized crypto asset strategy\", \"Priority analyst support\", \"High-frequency algo insights\"]',95.50,19.00,'Master of high-frequency algorithms across volatile crypto pairs. Achieves rapid, consistent gains with advanced risk management.','active','2025-06-16 23:26:11','2025-10-06 21:20:22',NULL),
(3,'Blockchain Backer','blockchainbacker@example.com',55000.00,180000.00,90,'days','Medium','[\"Strategic blue-chip crypto accumulation\", \"Exclusive DeFi project vetting\", \"Long-term growth focus\"]',89.20,15.00,'Strategic accumulation in blue-chip cryptos (BTC, ETH) and calculated dives into high-potential DeFi projects for stellar long-term growth.','active','2025-06-16 23:26:11','2025-06-27 07:26:25',NULL),
(4,'Alex Becker','alexbecker@example.com',22000.00,85000.00,60,'days','Medium','[\"Global macro crypto analysis\", \"High-conviction BTC/Altcoin trades\", \"Anticipating market shifts\"]',92.00,17.00,'Leverages global macroeconomic shifts to predict major crypto market movements, executing high-conviction trades across BTC and major altcoins.','active','2025-06-16 23:26:11','2025-06-27 07:26:25',NULL),
(5,'Ansem Blknoiz','xxxxxxansemblknoiz@example.com',12000.00,45000.00,180,'days','Low','[\"Diversified crypto portfolio construction\", \"Steady, robust growth strategies\", \"Established coin focus\"]',81.00,11.00,'Diversified crypto portfolio construction focusing on established coins and carefully vetted emerging projects for steady, robust growth.','active','2025-06-16 23:26:11','2025-10-06 22:07:23',NULL),
(6,'Ashcryptoreal','ashcryptoreal@example.com',5000.00,25000.00,7,'days','High','[\"Aggressive DeFi yield farming\", \"Optimized liquidity pool strategies\", \"High capital efficiency\"]',88.00,16.50,'Aggressively seeks out the highest, sustainable yield farming and liquidity mining opportunities within the DeFi ecosystem, optimizing capital efficiency.','active','2025-06-16 23:26:11','2025-06-27 07:26:25',NULL),
(7,'Carl Moon','carlmoon@example.com',30000.00,100000.00,1,'month','High','[\"Quantum-inspired crypto arbitrage\", \"Unparalleled speed and precision\", \"Micro-profit compounding\"]',96.50,21.00,'Pioneers quantum-inspired algorithms for unparalleled speed and precision in crypto market arbitrage and high-frequency trading.','active','2025-06-16 23:26:11','2025-06-27 07:26:25',NULL),
(8,'Michael Saylor','michaelsaylor@example.com',8000.00,30000.00,90,'days','Medium','[\"Exclusive DeFi alpha discovery\", \"Advanced farming strategies\", \"High-percentage gains\"]',91.00,17.00,'Uncovers exclusive alpha in the DeFi space, from presales to advanced farming strategies, delivering consistent, high-percentage gains.','active','2025-06-16 23:26:11','2025-06-27 07:26:26',NULL),
(9,'Bitboy Crypto','bitboycrypto@example.com',18000.00,70000.00,6,'months','Medium','[\"Crypto-related equities & tokenized stocks\", \"Early-stage innovator identification\", \"Blockchain leader appreciation\"]',90.00,15.00,'Specializes in crypto-related equities and tokenized stocks, identifying early-stage innovators and established blockchain leaders for significant appreciation.','active','2025-06-16 23:26:11','2025-06-27 07:26:26',NULL),
(10,'Joel Katz','joelkatz@example.com',10000.00,45000.00,1,'quarter','Medium','[\"Digital commodity market navigation\", \"Utility token insights\", \"Sector-specific return maximization\"]',86.00,13.00,'Navigates the digital commodity markets, including tokenized resources and utility tokens, leveraging sector-specific insights for strong returns.','active','2025-06-16 23:26:11','2025-06-27 07:26:26',NULL),
(11,'Ted Pillows','tedpillows@example.com',25000.00,90000.00,15,'days','High','[\"Aggressive crypto momentum trading\", \"Swift entry/exit strategies\", \"Strict stop-loss protocols\"]',93.00,18.50,'Aggressively trades crypto market momentum, entering and exiting trending assets swiftly to capture significant short-term gains with strict stop-losses.','active','2025-06-16 23:26:11','2025-06-27 07:26:26',NULL),
(12,'Ben Cowen','bencowen@example.com',7000.00,30000.00,45,'days','Medium','[\"Lucrative mid-cap crypto swing capture\", \"Technical analysis for optimal points\", \"Medium-term position management\"]',83.00,14.00,'Captures lucrative price swings in mid-cap cryptocurrencies, utilizing technical analysis for optimal entry and exit points over days to weeks.','active','2025-06-16 23:26:11','2025-06-27 07:26:26',NULL),
(13,'BondMaster','bondmaster@example.com',0.00,0.00,0,'days','Medium',NULL,78.00,10.00,'Focuses on generating stable yield from staked digital bonds and decentralized lending protocols, balancing risk for consistent passive income in crypto.','deleted','2025-06-16 23:26:11','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(14,'AltCoinAce','altcoinace@example.com',0.00,0.00,0,'days','Medium',NULL,85.50,18.00,'A specialist in identifying and capitalizing on the explosive growth of high-potential altcoins before they hit mainstream attention.','deleted','2025-06-16 23:26:11','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(15,'MacroMaestro','macromaestro@example.com',0.00,0.00,0,'days','Medium',NULL,91.00,19.00,'Interprets global macro events and central bank policies to anticipate and trade major shifts in the entire crypto market cycle.','deleted','2025-06-16 23:26:11','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(16,'ScalpSensei','scalpsensei@example.com',0.00,0.00,0,'days','Medium',NULL,97.50,22.00,'Executes extremely rapid, high-volume trades on minimal crypto price fluctuations, aiming for consistent, compounded gains throughout the day.','deleted','2025-06-16 23:26:11','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(17,'EmergingGem','emerginggem@example.com',0.00,0.00,0,'days','Medium',NULL,80.00,12.00,'Identifies and invests early in promising, emerging blockchain projects and cryptocurrencies with significant long-term growth potential.','deleted','2025-06-16 23:26:11','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(18,'OptionsStrategist','optionsstrat@example.com',0.00,0.00,0,'days','Medium',NULL,86.00,16.50,'Applies sophisticated options strategies (covered calls, puts, iron condors) to crypto derivatives for enhanced yield and hedging.','deleted','2025-06-16 23:26:11','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(19,'ValueInvestor','valueinvestor@example.com',0.00,0.00,0,'days','Medium',NULL,70.00,9.00,'A long-term value investor in crypto, meticulously researching projects with strong fundamentals and innovative technology for substantial future gains.','deleted','2025-06-16 23:26:11','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(20,'FutureFighter','futurefighter@example.com',0.00,0.00,0,'days','Medium',NULL,90.50,18.50,'Aggressively trades crypto perpetual swaps and futures, utilizing high leverage and rapid execution to maximize returns from market volatility.','deleted','2025-06-16 23:26:11','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(21,'DefensiveDiver','defensivediver@example.com',0.00,0.00,0,'days','Medium',NULL,75.00,8.50,'Focuses on stablecoin yield strategies and low-risk DeFi protocols to generate consistent, defensive returns in any market condition.','deleted','2025-06-16 23:26:11','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(22,'AlgoMaster','algomaster@example.com',0.00,0.00,0,'days','Medium',NULL,95.25,18.00,'Master of high-frequency algorithms across volatile crypto pairs. Achieves rapid, consistent gains with advanced risk management.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(23,'CryptoSage','cryptosage@example.com',0.00,0.00,0,'days','Medium',NULL,88.70,14.50,'Strategic accumulation in blue-chip cryptos (BTC, ETH) and calculated dives into high-potential DeFi projects for stellar long-term growth.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(24,'ForexTitan','forextitan@example.com',0.00,0.00,0,'days','Medium',NULL,91.50,16.00,'Leverages global macroeconomic shifts to predict major crypto market movements, executing high-conviction trades across BTC and major altcoins.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(25,'GrowthHarbor','growthharbor@example.com',0.00,0.00,0,'days','Medium',NULL,80.20,10.00,'Diversified crypto portfolio construction focusing on established coins and carefully vetted emerging projects for steady, robust growth.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(26,'YieldSeeker','yieldseeker@example.com',0.00,0.00,0,'days','Medium',NULL,87.40,15.50,'Aggressively seeks out the highest, sustainable yield farming and liquidity mining opportunities within the DeFi ecosystem, optimizing capital efficiency.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(27,'QuantumForex','quantumfx@example.com',0.00,0.00,0,'days','Medium',NULL,96.00,20.00,'Pioneers quantum-inspired algorithms for unparalleled speed and precision in crypto market arbitrage and high-frequency trading.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(28,'DeFi_Guru','defiguru@example.com',0.00,0.00,0,'days','Medium',NULL,90.00,16.00,'Uncovers exclusive alpha in the DeFi space, from presales to advanced farming strategies, delivering consistent, high-percentage gains.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(29,'EquityEagle','equityeagle@example.com',0.00,0.00,0,'days','Medium',NULL,89.50,14.00,'Specializes in crypto-related equities and tokenized stocks, identifying early-stage innovators and established blockchain leaders for significant appreciation.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(30,'CommodityKing','commodityking@example.com',0.00,0.00,0,'days','Medium',NULL,85.00,12.00,'Navigates the digital commodity markets, including tokenized resources and utility tokens, leveraging sector-specific insights for strong returns.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(31,'Momentum_Pro','momentumpro@example.com',0.00,0.00,0,'days','Medium',NULL,92.50,17.50,'Aggressively trades crypto market momentum, entering and exiting trending assets swiftly to capture significant short-term gains with strict stop-losses.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(32,'SwingTraderX','swingtraderx@example.com',0.00,0.00,0,'days','Medium',NULL,82.00,13.00,'Captures lucrative price swings in mid-cap cryptocurrencies, utilizing technical analysis for optimal entry and exit points over days to weeks.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(33,'BondMaster','bondmaster@example.com',0.00,0.00,0,'days','Medium',NULL,78.00,10.00,'Focuses on generating stable yield from staked digital bonds and decentralized lending protocols, balancing risk for consistent passive income in crypto.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(34,'AltCoinAce','altcoinace@example.com',0.00,0.00,0,'days','Medium',NULL,85.50,18.00,'A specialist in identifying and capitalizing on the explosive growth of high-potential altcoins before they hit mainstream attention.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(35,'MacroMaestro','macromaestro@example.com',0.00,0.00,0,'days','Medium',NULL,91.00,19.00,'Interprets global macro events and central bank policies to anticipate and trade major shifts in the entire crypto market cycle.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(36,'ScalpSensei','scalpsensei@example.com',0.00,0.00,0,'days','Medium',NULL,97.50,22.00,'Executes extremely rapid, high-volume trades on minimal crypto price fluctuations, aiming for consistent, compounded gains throughout the day.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(37,'EmergingGem','emerginggem@example.com',0.00,0.00,0,'days','Medium',NULL,80.00,12.00,'Identifies and invests early in promising, emerging blockchain projects and cryptocurrencies with significant long-term growth potential.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(38,'OptionsStrategist','optionsstrat@example.com',0.00,0.00,0,'days','Medium',NULL,86.00,16.50,'Applies sophisticated options strategies (covered calls, puts, iron condors) to crypto derivatives for enhanced yield and hedging.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(39,'ValueInvestor','valueinvestor@example.com',0.00,0.00,0,'days','Medium',NULL,70.00,9.00,'A long-term value investor in crypto, meticulously researching projects with strong fundamentals and innovative technology for substantial future gains.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(40,'FutureFighter','futurefighter@example.com',0.00,0.00,0,'days','Medium',NULL,90.50,18.50,'Aggressively trades crypto perpetual swaps and futures, utilizing high leverage and rapid execution to maximize returns from market volatility.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(41,'DefensiveDiver','defensivediver@example.com',0.00,0.00,0,'days','Medium',NULL,75.00,8.50,'Focuses on stablecoin yield strategies and low-risk DeFi protocols to generate consistent, defensive returns in any market condition.','deleted','2025-06-16 23:26:28','2025-06-27 05:32:19','2025-06-27 05:32:19'),
(42,'SCI','kuqyjol@mailinator.com',10.00,60.00,10,'days','Medium','[]',5.00,25.00,'Itaque sint nemo ne','active','2025-10-06 21:27:13','2025-11-25 05:44:06',NULL);

/*Table structure for table `failed_jobs` */

DROP TABLE IF EXISTS `failed_jobs`;

CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `failed_jobs` */

/*Table structure for table `forex_pairs` */

DROP TABLE IF EXISTS `forex_pairs`;

CREATE TABLE `forex_pairs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `symbol` varchar(20) NOT NULL,
  `name` varchar(255) NOT NULL,
  `base_currency` varchar(10) NOT NULL,
  `quote_currency` varchar(10) NOT NULL,
  `exchange_rate` decimal(20,8) DEFAULT '0.00000000',
  `leverage` int DEFAULT '500',
  `tradingview_code` varchar(50) NOT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `year_range_min` decimal(20,8) DEFAULT '0.00000000',
  `year_range_max` decimal(20,8) DEFAULT '0.00000000',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `symbol` (`symbol`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `forex_pairs` */

insert  into `forex_pairs`(`id`,`symbol`,`name`,`base_currency`,`quote_currency`,`exchange_rate`,`leverage`,`tradingview_code`,`is_active`,`year_range_min`,`year_range_max`,`created_at`,`updated_at`) values 
(1,'EUR/USD','Euro / US Dollar','EUR','USD',1.05400000,500,'FX:EURUSD',1,1.04480000,1.12750000,'2025-12-12 05:51:02','2025-12-12 05:51:02'),
(2,'GBP/USD','British Pound / US Dollar','GBP','USD',1.27200000,500,'FX:GBPUSD',1,1.20370000,1.31420000,'2025-12-12 05:51:02','2025-12-12 05:51:02'),
(3,'USD/JPY','US Dollar / Japanese Yen','USD','JPY',153.20000000,500,'FX:USDJPY',1,139.50000000,161.95000000,'2025-12-12 05:51:02','2025-12-12 05:51:02'),
(4,'USD/CHF','US Dollar / Swiss Franc','USD','CHF',0.88500000,500,'FX:USDCHF',1,0.83300000,0.92400000,'2025-12-12 05:51:02','2025-12-12 05:51:02'),
(5,'AUD/USD','Australian Dollar / US Dollar','AUD','USD',0.64500000,500,'FX:AUDUSD',1,0.62700000,0.68700000,'2025-12-12 05:51:02','2025-12-12 05:51:02'),
(6,'USD/CAD','US Dollar / Canadian Dollar','USD','CAD',1.40500000,500,'FX:USDCAD',1,1.31700000,1.41000000,'2025-12-12 05:51:02','2025-12-12 05:51:02'),
(7,'NZD/USD','New Zealand Dollar / US Dollar','NZD','USD',0.58900000,500,'FX:NZDUSD',1,0.57700000,0.63600000,'2025-12-12 05:51:02','2025-12-12 05:51:02');

/*Table structure for table `forex_trades` */

DROP TABLE IF EXISTS `forex_trades`;

CREATE TABLE `forex_trades` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `forex_pair_id` bigint unsigned NOT NULL,
  `type` enum('buy','sell') NOT NULL,
  `entry_price` decimal(20,8) NOT NULL,
  `quantity` decimal(20,8) NOT NULL,
  `leverage_used` int NOT NULL,
  `margin_amount` decimal(20,8) NOT NULL,
  `executed_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `forex_pair_id` (`forex_pair_id`),
  CONSTRAINT `forex_trades_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `forex_trades_ibfk_2` FOREIGN KEY (`forex_pair_id`) REFERENCES `forex_pairs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `forex_trades` */

insert  into `forex_trades`(`id`,`user_id`,`forex_pair_id`,`type`,`entry_price`,`quantity`,`leverage_used`,`margin_amount`,`executed_at`,`created_at`,`updated_at`) values 
(1,128,4,'buy',0.88500000,9.00000000,1,7.96500000,'2025-12-12 09:32:09','2025-12-12 08:32:09','2025-12-12 08:32:09');

/*Table structure for table `forex_wallets` */

DROP TABLE IF EXISTS `forex_wallets`;

CREATE TABLE `forex_wallets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `forex_pair_id` bigint unsigned NOT NULL,
  `balance` decimal(20,8) DEFAULT '0.00000000',
  `avg_entry_price` decimal(20,8) DEFAULT '0.00000000',
  `avg_leverage` int DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `forex_pair_id` (`forex_pair_id`),
  CONSTRAINT `forex_wallets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `forex_wallets_ibfk_2` FOREIGN KEY (`forex_pair_id`) REFERENCES `forex_pairs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `forex_wallets` */

insert  into `forex_wallets`(`id`,`user_id`,`forex_pair_id`,`balance`,`avg_entry_price`,`avg_leverage`,`created_at`,`updated_at`) values 
(1,128,4,9.00000000,0.88500000,1,'2025-12-12 08:32:09','2025-12-12 08:32:09');

/*Table structure for table `investment_plans` */

DROP TABLE IF EXISTS `investment_plans`;

CREATE TABLE `investment_plans` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `min_investment` decimal(10,2) NOT NULL DEFAULT '0.00',
  `max_investment` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_roi_percentage` decimal(10,4) DEFAULT NULL,
  `min_duration_value` int NOT NULL DEFAULT '1',
  `max_duration_value` int NOT NULL DEFAULT '365',
  `allowed_duration_units` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `daily_roi_percentage` decimal(5,2) NOT NULL DEFAULT '0.00',
  `duration_value` int NOT NULL DEFAULT '0',
  `duration_unit` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'days',
  `features` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `created_by` int DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `investment_plans_chk_1` CHECK (json_valid(`allowed_duration_units`)),
  CONSTRAINT `investment_plans_chk_2` CHECK (json_valid(`features`))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `investment_plans` */

insert  into `investment_plans`(`id`,`name`,`description`,`min_investment`,`max_investment`,`total_roi_percentage`,`min_duration_value`,`max_duration_value`,`allowed_duration_units`,`daily_roi_percentage`,`duration_value`,`duration_unit`,`features`,`created_by`,`created_at`,`updated_at`,`deleted_at`) values 
(4,'SILVER PLAN','Step up your earnings with a higher capital tier. Enhanced daily returns for more experienced investors.',1000.00,25000.00,912.5000,1,365,'[\"days\"]',2.50,5,'days','[\"Higher profit margins\", \"Access to exclusive market reports\", \"Priority support queue\"]',NULL,'2025-06-27 01:38:38','2025-11-24 23:12:28',NULL),
(5,'GOLD PLAN','Maximize your potential with substantial capital. Achieve significant daily ROI with dedicated resources.',30000.00,50000.00,15.0000,1,365,NULL,3.00,5,'days','[\"Maximum profit potential\", \"Personalized asset growth strategy\", \"AI-driven portfolio optimization\"]',NULL,'2025-06-27 01:38:38','2025-06-27 03:20:37',NULL),
(6,'PLATINUM PLAN','For serious investors seeking premium returns. Extended duration with consistent high daily ROI.',60000.00,100000.00,24.5000,1,365,NULL,3.50,7,'days','[\"Accelerated returns\", \"Dedicated investment advisor\", \"Advanced risk management tools\"]',NULL,'2025-06-27 01:38:38','2025-06-27 03:20:37',NULL),
(7,'ELITE PLAN','The ultimate plan for elite investors. Highest daily ROI over a focused trading period.',110000.00,500000.00,40.0000,1,365,NULL,4.00,10,'days','[\"Top-tier exclusive opportunities\", \"Direct line to expert analysts\", \"Tailored investment strategies\"]',NULL,'2025-06-27 01:38:38','2025-06-27 03:20:37',NULL),
(8,'ELITE GOLD PLAN','Experience unparalleled growth with extensive capital and maximized daily returns.',550000.00,1500000.00,42.5000,1,365,NULL,4.25,10,'days','[\"Unparalleled profit potential\", \"Comprehensive market intelligence\", \"24/7 premium support\"]',NULL,'2025-06-27 01:38:38','2025-06-27 03:20:37',NULL),
(9,'STACKDEXK ELITE','The pinnacle of investment opportunities. Large capital, highest daily ROI, and extended trading period for maximum compounding.',1500000.00,10000000.00,63.0000,1,365,NULL,4.50,14,'days','[\"Ultra-exclusive investment access\", \"Dedicated private wealth manager\", \"Custom algorithm deployment\"]',NULL,'2025-06-27 01:38:38','2025-06-27 03:20:37',NULL),
(10,'Trevor Forbes','Expedita quidem magn',39.00,91.00,3819.0000,6,57,'[\"days\"]',67.00,0,'days','[\"Duis voluptatem sint asperiores porro non ut eveniet quam quasi quas neque ea et esse voluptas aliquam eos\", \"Non minus tempor in eveniet aspernatur odio natus voluptas ut nostrud cupiditate veritatis\", \"Illum cum ut qui alias rem et incididunt\"]',NULL,'2025-08-20 14:25:16','2025-08-20 15:36:52','2025-08-20 15:36:52'),
(11,'Signature ICC','A precision-based forex plan built around the ICC trading approach, focused on structure, inducements, corrections, and clean entry models during high-liquidity sessions.',1000.00,25000.00,3115.0000,2,35,'[\"days\"]',89.00,0,'days','[\"Real Time Mirrored Trades All trades are copied instantly into investor accounts as SCI executes them.\",\"ICC Based Entry Models Every position follows the indication , Correction , Continuation framework for consistency.\",\"Daily NY Session Activity Trades mainly during high-liquidity periods for stronger moves and tighter entries.\"]',NULL,'2025-08-20 15:29:15','2025-12-04 15:47:46',NULL);

/*Table structure for table `investment_statuses` */

DROP TABLE IF EXISTS `investment_statuses`;

CREATE TABLE `investment_statuses` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `investment_statuses` */

insert  into `investment_statuses`(`id`,`name`) values 
(1,'pending'),
(2,'active'),
(3,'matured'),
(4,'disbursed'),
(5,'canceled');

/*Table structure for table `investments` */

DROP TABLE IF EXISTS `investments`;

CREATE TABLE `investments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `inv_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'INV000000',
  `user_id` bigint unsigned NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `pnl_amount` decimal(10,2) DEFAULT NULL,
  `pnl` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `disbursed_amount` decimal(10,2) DEFAULT NULL,
  `disbursed_by` bigint unsigned DEFAULT NULL,
  `investment_plan_id` bigint unsigned NOT NULL,
  `roi` decimal(10,2) unsigned NOT NULL DEFAULT '6.00',
  `duration` int unsigned NOT NULL DEFAULT '1',
  `disbursed_at` datetime DEFAULT NULL,
  `status_id` int unsigned NOT NULL DEFAULT '2',
  `ended_at` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `disbursed_by` (`disbursed_by`),
  KEY `investment_plan_id` (`investment_plan_id`),
  KEY `investment_status_id` (`status_id`),
  CONSTRAINT `investments_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `investments_ibfk_2` FOREIGN KEY (`disbursed_by`) REFERENCES `users` (`id`),
  CONSTRAINT `investments_ibfk_3` FOREIGN KEY (`investment_plan_id`) REFERENCES `coins` (`id`),
  CONSTRAINT `investments_ibfk_4` FOREIGN KEY (`status_id`) REFERENCES `investment_statuses` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `investments` */

/*Table structure for table `job_batches` */

DROP TABLE IF EXISTS `job_batches`;

CREATE TABLE `job_batches` (
  `id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `job_batches` */

/*Table structure for table `jobs` */

DROP TABLE IF EXISTS `jobs`;

CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `jobs` */

/*Table structure for table `kyc_statuses` */

DROP TABLE IF EXISTS `kyc_statuses`;

CREATE TABLE `kyc_statuses` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `kyc_statuses` */

insert  into `kyc_statuses`(`id`,`name`) values 
(1,'pending'),
(2,'completed'),
(3,'rejected');

/*Table structure for table `migrations` */

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `migrations` */

/*Table structure for table `password_reset_tokens` */

DROP TABLE IF EXISTS `password_reset_tokens`;

CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `password_reset_tokens` */

/*Table structure for table `payment_options` */

DROP TABLE IF EXISTS `payment_options`;

CREATE TABLE `payment_options` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_details` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `payment_options` */

insert  into `payment_options`(`id`,`name`,`account_details`,`deleted_at`,`created_at`,`updated_at`) values 
(1,'bitcoin','Wallet Address: erxdtfyguhijokohgfdfgyuhjikohhhhhhhhhhhhhhhhhvvvvvvvvvvvvvvvvvvt',NULL,NULL,NULL),
(2,'bank transfer','-----------',NULL,NULL,'2024-11-14 06:30:57'),
(3,'test','000000000000','2024-11-14 06:51:01','2024-11-14 06:35:44','2024-11-14 06:51:01'),
(4,'gggggg','ggggggg','2024-11-14 06:50:15','2024-11-14 06:48:06','2024-11-14 06:50:15'),
(5,'test option','send to this test option info','2024-11-14 08:38:19','2024-11-14 06:49:59','2024-11-14 08:38:19'),
(6,'etherum','mallet address:   ophigio[gggggggggggggvroirvhrvihooorvhroivhhhhhhhhh',NULL,'2024-11-14 08:38:02','2024-11-14 08:38:02');

/*Table structure for table `payment_statuses` */

DROP TABLE IF EXISTS `payment_statuses`;

CREATE TABLE `payment_statuses` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `payment_statuses` */

insert  into `payment_statuses`(`id`,`name`) values 
(1,'completed'),
(2,'pending'),
(3,'declined');

/*Table structure for table `personas` */

DROP TABLE IF EXISTS `personas`;

CREATE TABLE `personas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tagline` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo_full_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo_dark_full_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo_with_name_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `primary_color` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#000000',
  `secondary_color` varchar(7) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `personas` */

insert  into `personas`(`id`,`name`,`tagline`,`logo_path`,`logo_full_path`,`logo_dark_full_path`,`logo_with_name_path`,`primary_color`,`secondary_color`,`is_active`,`created_at`,`updated_at`,`deleted_at`) values 
(1,'Exodus','Crypto Exchange','personas/RQDzxGtSUPQXqrA3OQx8yh8OTKong0IKJ4ZQIHgm.svg','branding/g3BHSMBNGpyvdMYtpErwCuuz64DvzpAGq1IOrh8z.svg',NULL,'personas/iNjqNwxuYya1t9hyBUpyHkuvu84MTNuEA29fGMmT.svg','#6b46c1',NULL,1,'2026-01-12 13:36:18','2026-01-16 16:43:46',NULL),
(2,'Trust wallet','Crypto Exchange','personas/5ElGjjM0PHDOk309VGSuMETN0qj2ikXmDd5OVl0t.jpg',NULL,NULL,'personas/wSNhUW4gkyce6C1kq3NuKTZVqOwkcRqwkfRO9YoP.jpg','#0500ff',NULL,0,'2026-01-12 13:53:12','2026-01-12 15:07:23',NULL);

/*Table structure for table `referrals` */

DROP TABLE IF EXISTS `referrals`;

CREATE TABLE `referrals` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `referer_id` bigint unsigned NOT NULL,
  `referee_id` bigint unsigned NOT NULL,
  `initial_deposit` decimal(10,2) NOT NULL,
  `bonus` decimal(10,2) DEFAULT NULL,
  `date_disbursed` date DEFAULT NULL,
  `status_id` int unsigned NOT NULL,
  `action_by` int unsigned DEFAULT NULL,
  `action_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `transaction_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `referer_id` (`referer_id`),
  KEY `referee_id` (`referee_id`),
  KEY `status_id` (`status_id`),
  KEY `transaction_id` (`transaction_id`),
  CONSTRAINT `referrals_ibfk_1` FOREIGN KEY (`referer_id`) REFERENCES `users` (`id`),
  CONSTRAINT `referrals_ibfk_2` FOREIGN KEY (`referee_id`) REFERENCES `users` (`id`),
  CONSTRAINT `referrals_ibfk_3` FOREIGN KEY (`status_id`) REFERENCES `payment_statuses` (`id`),
  CONSTRAINT `referrals_ibfk_4` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `referrals` */

insert  into `referrals`(`id`,`referer_id`,`referee_id`,`initial_deposit`,`bonus`,`date_disbursed`,`status_id`,`action_by`,`action_at`,`updated_at`,`created_at`,`deleted_at`,`transaction_id`) values 
(2,19,24,8999.00,449.95,'2024-11-20',1,13,'2024-11-21 10:42:34','2024-11-20 16:42:34','2024-11-20 12:41:13',NULL,43);

/*Table structure for table `refunds` */

DROP TABLE IF EXISTS `refunds`;

CREATE TABLE `refunds` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `investment_id` bigint unsigned NOT NULL,
  `reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `refund_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'RFD0000',
  `status_id` int unsigned DEFAULT '2',
  `action_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `action_at` datetime DEFAULT NULL,
  `amount_refunded` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `action_by` (`action_by`),
  KEY `investment_id` (`investment_id`),
  KEY `payment_status_id` (`status_id`),
  CONSTRAINT `refunds_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `refunds_ibfk_2` FOREIGN KEY (`action_by`) REFERENCES `users` (`id`),
  CONSTRAINT `refunds_ibfk_3` FOREIGN KEY (`investment_id`) REFERENCES `investments` (`id`),
  CONSTRAINT `refunds_ibfk_4` FOREIGN KEY (`status_id`) REFERENCES `payment_statuses` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `refunds` */

/*Table structure for table `reviews` */

DROP TABLE IF EXISTS `reviews`;

CREATE TABLE `reviews` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `rating` int DEFAULT NULL,
  `comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `reviews_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `reviews` */

/*Table structure for table `roles` */

DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `roles` */

insert  into `roles`(`id`,`name`,`created_at`,`updated_at`,`deleted_at`) values 
(1,'admin','2024-11-11 06:09:30','2024-11-12 00:09:30',NULL),
(2,'client','2024-11-11 06:09:30','2024-11-12 00:09:49',NULL),
(3,'buyer','2024-11-11 06:09:30','2024-11-12 00:09:55',NULL);

/*Table structure for table `sessions` */

DROP TABLE IF EXISTS `sessions`;

CREATE TABLE `sessions` (
  `id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `sessions` */

insert  into `sessions`(`id`,`user_id`,`ip_address`,`user_agent`,`payload`,`last_activity`) values 
('CVsQSF4gxAzHsDyEgx1YkuLBNlkEkIWR9uLfsQkA',129,'127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36 Edg/144.0.0.0','YTo1OntzOjY6Il90b2tlbiI7czo0MDoiaHhBcWl4T1JyakY0enQxbTgybXNQR0t1bHRjZU9iWlpxRGhzZHBnaCI7czozOiJ1cmwiO2E6MTp7czo4OiJpbnRlbmRlZCI7czoyMToiaHR0cDovLzEyNy4wLjAuMTo4MDAwIjt9czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6MzE6Imh0dHA6Ly8xMjcuMC4wLjE6ODAwMC9kYXNoYm9hcmQiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX1zOjUwOiJsb2dpbl93ZWJfNTliYTM2YWRkYzJiMmY5NDAxNTgwZjAxNGM3ZjU4ZWE0ZTMwOTg5ZCI7aToxMjk7fQ==',1768818843),
('VGHDQ6dDqJoflg5PkecMOX6pBbOy4RuaROm67BAh',3,'127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/146.0.0.0 Safari/537.36','YTo1OntzOjY6Il90b2tlbiI7czo0MDoieWpEeklsdjdqeDJCUEM0bUVBMDFQVWRlcnpRazZSZVJ0M3FVWWw4MiI7czozOiJ1cmwiO2E6MTp7czo4OiJpbnRlbmRlZCI7czozNjoiaHR0cDovL2xvY2FsaG9zdDo4MDAwL2FkbWluL3BlcnNvbmFzIjt9czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6NDM6Imh0dHA6Ly9sb2NhbGhvc3Q6ODAwMC9hZG1pbi9jYXJkLXJlcXVlc3RzLzQiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX1zOjUwOiJsb2dpbl93ZWJfNTliYTM2YWRkYzJiMmY5NDAxNTgwZjAxNGM3ZjU4ZWE0ZTMwOTg5ZCI7aTozO30=',1768818819);

/*Table structure for table `signals` */

DROP TABLE IF EXISTS `signals`;

CREATE TABLE `signals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `price_per_unit` decimal(10,2) NOT NULL,
  `duration_unit` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_duration_value` int NOT NULL,
  `roi_percentage` decimal(5,2) NOT NULL,
  `max_subscribers` int NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `signals` */

insert  into `signals`(`id`,`name`,`description`,`price_per_unit`,`duration_unit`,`default_duration_value`,`roi_percentage`,`max_subscribers`,`status`,`created_at`,`updated_at`,`deleted_at`) values 
(1,'Plato Hardin','In et quisquam earum',449.00,'week',63,1.00,59,'active','2025-06-17 01:10:30','2025-06-17 03:38:05','2025-06-17 03:38:05'),
(2,'High-Frequency Crypto Scalps','Execute rapid, high-volume trades on minute crypto price fluctuations. Aims for daily compounding gains with tight risk controls.',75.00,'month',1,18.00,200,'active','2025-06-16 23:37:32','2025-06-16 23:37:32',NULL),
(3,'Premier Altcoin Alpha','Exclusive weekly signals for high-growth altcoins. Identify breakout potentials before they hit mainstream attention for substantial gains.',180.00,'month',1,28.00,150,'active','2025-06-16 23:37:32','2025-06-16 23:37:32',NULL),
(4,'Decentralized Stock Derivatives','Trade tokenized real-world assets on decentralized exchanges. Capitalize on traditional market movements with crypto liquidity.',300.00,'quarter',3,35.00,100,'active','2025-06-16 23:37:32','2025-06-16 23:37:32',NULL),
(5,'Tokenized Precious Metals','Access signals for tokenized Gold and Silver, allowing you to trade physical assets on the blockchain with enhanced liquidity and lower fees.',90.00,'month',1,12.00,80,'active','2025-06-16 23:37:32','2025-06-16 23:37:32',NULL),
(6,'Digital Asset Futures Mastery','Advanced signals for crypto futures (BTC, ETH, major altcoins). Leverage volatility with sophisticated strategies for maximized returns.',450.00,'year',1,40.00,50,'active','2025-06-16 23:37:32','2025-06-16 23:37:32',NULL),
(7,'Bitcoin Blitz Signals','Ultra-short term signals for Bitcoin’s rapid price swings. Designed for aggressive traders capitalizing on intraday volatility. High frequency, high impact.',60.00,'week',1,15.00,250,'active','2025-06-16 23:37:32','2025-06-16 23:37:32',NULL),
(8,'Crypto Blue-Chip Accumulator','Curated signals for accumulating established, high-cap cryptocurrencies with proven track records. Build a robust long-term digital asset portfolio.',550.00,'year',1,28.00,75,'active','2025-06-16 23:37:32','2025-06-16 23:37:32',NULL),
(9,'Next-Gen Blockchain Innovators','Signals pinpointing early investment opportunities in groundbreaking blockchain projects and tokens set to disrupt industries. High growth potential.',250.00,'month',1,45.00,60,'active','2025-06-16 23:37:32','2025-06-16 23:37:32',NULL),
(10,'DeFi Options Arbitrage','Sophisticated signals for exploiting pricing discrepancies in decentralized options markets. Advanced strategies for highly skilled traders.',400.00,'month',1,50.00,40,'active','2025-06-16 23:37:32','2025-06-16 23:37:32',NULL),
(11,'Liquidity Pool Alpha','Exclusive signals to enter the most profitable and secure liquidity pools and yield farms across various DeFi protocols. Maximize passive income.',280.00,'month',1,38.00,90,'active','2025-06-16 23:37:32','2025-06-16 23:37:32',NULL);

/*Table structure for table `site_settings` */

DROP TABLE IF EXISTS `site_settings`;

CREATE TABLE `site_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `site_settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `site_settings` */

insert  into `site_settings`(`id`,`key`,`value`,`created_at`,`updated_at`) values 
(1,'crypto_send_error','Unable to connect to the MoonPay gateway. Your wallet address needs to be verified on the Blockchain network before assets can be transferred. Please contact support to resolve this node issue.','2026-01-16 18:00:57','2026-01-16 18:00:57');

/*Table structure for table `stock_trades` */

DROP TABLE IF EXISTS `stock_trades`;

CREATE TABLE `stock_trades` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `stock_id` int unsigned NOT NULL,
  `trade_action` varchar(4) CHARACTER SET ucs2 COLLATE ucs2_unicode_ci NOT NULL,
  `quantity` int NOT NULL,
  `price_per_share` decimal(16,8) NOT NULL,
  `account_type` varchar(255) CHARACTER SET ucs2 COLLATE ucs2_unicode_ci NOT NULL,
  `order_type` varchar(255) CHARACTER SET ucs2 COLLATE ucs2_unicode_ci DEFAULT NULL,
  `executed_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `stock_id` (`stock_id`),
  CONSTRAINT `stock_trades_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_trades_ibfk_2` FOREIGN KEY (`stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=115 DEFAULT CHARSET=ucs2 COLLATE=ucs2_unicode_ci;

/*Data for the table `stock_trades` */

insert  into `stock_trades`(`id`,`user_id`,`stock_id`,`trade_action`,`quantity`,`price_per_share`,`account_type`,`order_type`,`executed_at`,`created_at`,`updated_at`) values 
(112,82,1,'buy',0,212.33000000,'usd_balance','limit','2025-12-05 02:53:47','2025-12-05 02:53:47','2025-12-05 02:53:47'),
(113,128,1,'buy',89,212.33000000,'usd_balance','market','2025-12-12 08:51:02','2025-12-12 08:51:02','2025-12-12 08:51:02'),
(114,128,1,'buy',90,212.33000000,'usd_balance','limit','2025-12-12 08:51:13','2025-12-12 08:51:13','2025-12-12 08:51:13');

/*Table structure for table `stock_wallets` */

DROP TABLE IF EXISTS `stock_wallets`;

CREATE TABLE `stock_wallets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `stock_id` int unsigned NOT NULL,
  `claimed` decimal(10,2) unsigned DEFAULT '0.00',
  `unclaimed` decimal(10,2) unsigned DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `sold` decimal(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `stock_id` (`stock_id`),
  CONSTRAINT `stock_wallets_stock_id_foreign` FOREIGN KEY (`stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_wallets_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=221 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `stock_wallets` */

insert  into `stock_wallets`(`id`,`user_id`,`stock_id`,`claimed`,`unclaimed`,`created_at`,`updated_at`,`sold`) values 
(164,69,19,0.00,0.00,'2025-05-01 23:51:19','2025-05-02 00:04:00',0.00),
(165,69,21,0.00,0.00,'2025-05-01 23:51:54','2025-05-01 23:54:08',30600.00),
(166,67,19,0.00,0.00,'2025-05-02 00:25:43','2025-05-02 00:34:48',15.00),
(167,67,21,0.00,0.00,'2025-05-02 00:26:15','2025-05-02 00:56:04',38700.00),
(168,70,19,0.00,0.00,'2025-05-02 06:10:31','2025-05-02 06:11:34',2.00),
(169,70,21,0.00,0.00,'2025-05-02 06:10:41','2025-05-02 06:16:03',500.00),
(170,75,19,0.00,0.00,'2025-05-02 06:31:24','2025-05-02 06:43:43',2.00),
(171,75,21,0.00,0.00,'2025-05-02 06:31:24','2025-05-02 06:45:41',500.00),
(172,76,19,5.00,0.00,'2025-05-03 00:00:54','2025-05-06 14:17:38',20.00),
(173,76,21,2000.00,0.00,'2025-05-03 00:00:54','2025-05-06 14:08:47',750.00),
(174,76,9,10.00,0.00,'2025-05-03 00:06:41','2025-05-03 00:25:55',0.00),
(175,78,41,2.00,0.00,'2025-05-05 22:35:29','2025-05-05 22:35:29',0.00),
(176,78,21,500.00,0.00,'2025-05-05 22:35:49','2025-05-05 22:35:49',0.00),
(177,79,41,2.00,0.00,'2025-05-06 00:22:38','2025-05-06 00:22:38',0.00),
(178,79,21,500.00,0.00,'2025-05-06 00:23:22','2025-05-06 00:23:22',0.00),
(179,76,41,10.00,0.00,'2025-05-06 14:08:26','2025-05-06 14:08:26',0.00),
(180,80,41,10.00,0.00,'2025-05-06 19:23:42','2025-05-06 19:26:27',0.00),
(181,80,19,0.00,0.00,'2025-05-06 19:24:20','2025-05-06 19:27:16',0.00),
(182,80,21,500.00,0.00,'2025-05-06 19:24:30','2025-05-06 19:24:30',0.00),
(183,82,19,0.00,0.00,'2025-05-06 23:38:04','2025-05-17 00:26:04',5.00),
(184,82,21,10.00,0.00,'2025-05-06 23:38:34','2025-05-06 23:38:34',0.00),
(185,83,41,0.00,0.00,'2025-05-06 23:54:58','2025-05-20 02:40:51',0.00),
(186,83,21,0.00,0.00,'2025-05-06 23:55:16','2025-05-20 02:55:33',30.00),
(187,83,19,5.00,0.00,'2025-05-06 23:57:23','2025-07-09 02:10:04',5.00),
(188,84,41,10.00,0.00,'2025-05-12 22:22:53','2025-05-12 22:22:53',0.00),
(189,84,21,10.00,0.00,'2025-05-12 22:23:02','2025-05-12 22:23:02',0.00),
(190,85,41,0.00,0.00,'2025-05-15 21:34:08','2025-05-15 21:44:46',5.00),
(191,85,21,0.00,0.00,'2025-05-15 21:34:39','2025-05-15 21:48:11',200.00),
(192,86,41,0.00,0.00,'2025-05-15 23:45:39','2025-05-15 23:51:04',5.00),
(193,86,21,0.00,0.00,'2025-05-15 23:45:48','2025-05-15 23:52:39',50.00),
(194,87,41,5.00,0.00,'2025-05-16 00:47:58','2025-05-16 00:47:58',0.00),
(195,87,21,50.00,0.00,'2025-05-16 00:48:10','2025-05-16 00:48:10',0.00),
(196,88,41,0.00,0.00,'2025-05-16 00:51:22','2025-05-16 00:53:18',4.00),
(197,88,21,0.00,0.00,'2025-05-16 00:51:42','2025-05-16 00:56:02',40.00),
(198,89,41,0.00,0.00,'2025-05-17 00:49:18','2025-05-20 03:04:48',5.00),
(199,89,21,0.00,0.00,'2025-05-17 00:49:54','2025-05-20 03:07:01',30.00),
(200,90,41,50.00,0.00,'2025-05-18 02:49:05','2025-09-04 21:30:17',9.00),
(201,90,21,20.00,0.00,'2025-05-18 02:49:16','2025-09-04 21:30:12',80.00),
(202,92,21,1923.00,0.00,'2025-06-14 06:07:36','2025-06-14 06:19:26',0.00),
(203,92,19,0.00,0.00,'2025-06-14 06:07:58','2025-06-14 06:18:02',5.00),
(204,91,21,1923.00,0.00,'2025-06-14 06:14:21','2025-06-14 06:14:21',0.00),
(205,91,19,0.00,0.00,'2025-06-14 06:14:58','2025-07-09 00:53:27',5.00),
(206,93,19,0.00,0.00,'2025-07-09 04:07:06','2025-07-09 04:55:12',15.00),
(207,93,21,0.76,0.49,'2025-07-09 04:07:25','2025-09-05 23:46:26',5.15),
(208,95,19,0.00,0.00,'2025-07-16 00:23:53','2025-07-18 18:18:02',5.00),
(209,95,21,19851.00,0.00,'2025-07-16 00:24:30','2025-07-16 00:24:30',0.00),
(210,93,2,1.00,2.00,'2025-09-05 20:22:33','2025-09-05 23:27:31',0.00),
(211,93,1,3.10,24.12,'2025-09-05 22:45:05','2025-09-05 23:55:30',3.00),
(212,93,36,2.00,0.00,'2025-09-05 23:39:40','2025-09-05 23:39:40',0.00),
(214,69,1,17.00,0.00,'2025-09-09 21:20:41','2025-09-10 08:44:32',18.00),
(215,69,2,8.00,0.00,'2025-09-10 07:13:58','2025-09-10 07:49:54',0.00),
(216,69,4,8.00,0.00,'2025-09-10 07:14:24','2025-09-10 07:14:24',0.00),
(217,69,32,4.00,0.00,'2025-09-10 07:15:14','2025-09-10 07:22:49',0.00),
(218,69,3,1.00,0.00,'2025-09-10 07:46:24','2025-09-10 07:46:24',0.00),
(219,82,1,0.01,0.00,'2025-12-05 02:53:47','2025-12-05 02:53:47',0.00),
(220,128,1,179.00,0.00,'2025-12-12 08:51:02','2025-12-12 08:51:13',0.00);

/*Table structure for table `stocks` */

DROP TABLE IF EXISTS `stocks`;

CREATE TABLE `stocks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET ucs2 COLLATE ucs2_unicode_ci DEFAULT NULL,
  `code` varchar(50) CHARACTER SET ucs2 COLLATE ucs2_unicode_ci DEFAULT NULL,
  `tradingview_code` varchar(50) CHARACTER SET ucs2 COLLATE ucs2_unicode_ci DEFAULT NULL,
  `value` decimal(10,2) DEFAULT NULL,
  `ask_value` decimal(10,2) DEFAULT NULL,
  `ask_shares` int DEFAULT NULL,
  `bid_value` decimal(10,2) DEFAULT NULL,
  `bid_shares` int DEFAULT NULL,
  `year_range_min` decimal(10,2) DEFAULT NULL,
  `year_range_max` decimal(10,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `market` enum('gbx','usd') CHARACTER SET ucs2 COLLATE ucs2_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `tradingview_code` (`tradingview_code`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=ucs2 COLLATE=ucs2_unicode_ci;

/*Data for the table `stocks` */

insert  into `stocks`(`id`,`name`,`code`,`tradingview_code`,`value`,`ask_value`,`ask_shares`,`bid_value`,`bid_shares`,`year_range_min`,`year_range_max`,`created_at`,`updated_at`,`market`) values 
(1,'Apple Inc.','AAPL','NASDAQ:AAPL',212.33,212.54,10000,212.12,8000,169.11,260.10,'2025-04-11 22:22:21','2025-05-15 14:00:05','usd'),
(2,'Microsoft Corp.','MSFT','NASDAQ:MSFT',453.13,453.58,12000,452.68,9000,344.79,468.35,'2025-04-11 22:22:21','2025-05-16 14:00:13','usd'),
(3,'Amazon.com Inc.','AMZN','NASDAQ:AMZN',210.25,210.46,11000,210.04,8500,160.00,200.00,'2025-04-11 22:22:21','2025-05-15 20:00:06','usd'),
(4,'Alphabet Inc. (Google)','GOOGL','NASDAQ:GOOGL',163.96,164.12,10000,163.80,10000,2500.00,3000.00,'2025-04-11 22:22:21','2025-05-16 08:00:13','usd'),
(5,'Tesla Inc.','TSLA','NASDAQ:TSLA',347.68,348.03,3000,347.33,7000,700.00,950.00,'2025-04-11 22:22:21','2025-05-16 02:00:07','usd'),
(6,'NVIDIA Corp.','NVDA','NASDAQ:NVDA',135.34,135.48,8000,135.20,7000,750.00,1000.00,'2025-04-11 22:22:21','2025-05-15 20:00:06','usd'),
(7,'Berkshire Hathaway Inc.','BRK.B','NYSE:BRK.B',503.40,503.90,8000,502.90,8000,396.35,539.00,'2025-04-11 22:22:21','2025-05-16 02:00:06','usd'),
(8,'Meta Platforms Inc. (Facebook)','META','NASDAQ:META',640.34,640.98,11000,639.70,9000,427.11,740.91,'2025-04-11 22:22:21','2025-05-18 20:00:06','usd'),
(9,'ExxonMobil Corp.','XOM','NYSE:XOM',108.19,108.30,9500,108.08,7500,97.80,126.34,'2025-04-11 22:22:21','2025-05-18 14:00:08','usd'),
(10,'Johnson & Johnson','JNJ','NYSE:JNJ',149.63,149.77,8000,149.48,8000,155.00,190.00,'2025-04-11 22:22:21','2025-05-16 08:00:14','usd'),
(11,'JPMorgan Chase & Co.','JPM','NYSE:JPM',267.49,267.76,8000,267.22,8000,180.00,220.00,'2025-04-11 22:22:21','2025-05-16 14:00:13','usd'),
(12,'Visa Inc.','V','NYSE:V',365.12,365.49,9000,364.75,7000,240.00,290.00,'2025-04-11 22:22:21','2025-05-18 20:00:06','usd'),
(13,'UnitedHealth Group Inc.','UNH','NYSE:UNH',291.91,292.20,7500,291.62,5500,500.00,600.00,'2025-04-11 22:22:21','2025-05-19 02:00:04','usd'),
(14,'Procter & Gamble Co.','PG','NYSE:PG',163.28,163.44,8000,163.12,6000,140.00,175.00,'2025-04-11 22:22:21','2025-05-19 02:00:05','usd'),
(15,'Walmart Inc.','WMT','NYSE:WMT',96.35,96.45,9000,96.25,7000,165.00,200.00,'2025-04-11 22:22:21','2025-05-17 02:00:05','usd'),
(16,'Mastercard Inc.','MA','NYSE:MA',583.13,583.71,8500,582.55,6500,400.00,500.00,'2025-04-11 22:22:21','2025-05-17 08:00:04','usd'),
(17,'Chevron Corp.','CVX','NYSE:CVX',142.26,142.40,9000,142.12,7000,115.00,150.00,'2025-04-11 22:22:21','2025-05-16 20:00:06','usd'),
(18,'Home Depot Inc.','HD','NYSE:HD',378.63,379.01,8000,378.25,6000,323.77,439.37,'2025-04-11 22:22:21','2025-05-17 02:00:05','usd'),
(19,'Bank of America Corp.','BAC','NYSE:BAC',50.29,50.34,12000,50.24,10000,33.07,48.08,'2025-04-11 22:22:21','2025-09-10 08:37:58','usd'),
(20,'Walt Disney Co.','DIS','NYSE:DIS',112.22,112.33,11000,112.11,9000,90.00,125.00,'2025-04-11 22:22:21','2025-05-16 20:00:06','usd'),
(21,'Shell PLC LSE','SHEL.L','TURQUOISE:SHELL',2664.50,2667.16,8000,2661.84,8000,18.00,25.00,'2025-04-11 22:22:21','2025-09-10 08:38:00','gbx'),
(22,'BP PLC','BP.','LSE:BP',3.36,3.37,8000,3.35,6000,2.80,3.80,'2025-04-11 22:22:21','2025-04-11 22:22:21','gbx'),
(23,'TotalEnergies SE','TTE','EURONEXT:TTE',53.26,53.31,6500,53.21,4500,55.00,70.00,'2025-04-11 22:22:21','2025-05-14 20:00:05','gbx'),
(24,'Unilever PLC','ULVR','LSE:ULVR',4625.00,4629.63,7500,4620.38,5500,40.00,48.00,'2025-04-11 22:22:21','2025-05-19 08:00:04','gbx'),
(25,'AstraZeneca PLC','AZN','LSE:AZN',10330.00,10340.33,6000,10319.67,4000,90.00,110.00,'2025-04-11 22:22:21','2025-05-19 20:00:06','gbx'),
(26,'HSBC Holdings PLC','HSBA','LSE:HSBA',882.80,883.68,9000,881.92,7000,5.50,6.50,'2025-04-11 22:22:21','2025-05-19 14:00:09','gbx'),
(27,'GlaxoSmithKline PLC','GSK','LSE:GSK',1358.00,1359.36,8000,1356.64,6000,15.00,18.00,'2025-04-11 22:22:21','2025-05-15 02:00:06','gbx'),
(28,'Diageo PLC','DGE','LSE:DGE',2118.00,2120.12,7000,2115.88,5000,35.00,40.00,'2025-04-11 22:22:21','2025-05-15 08:00:05','gbx'),
(29,'Rio Tinto PLC','RIO','LSE:RIO',4684.00,4688.68,6500,4679.32,4500,48.00,55.00,'2025-04-11 22:22:21','2025-05-15 14:00:05','gbx'),
(30,'Lloyds Banking Group PLC','LLOY','LSE:LLOY',73.40,73.47,10000,73.33,8000,2.00,2.60,'2025-04-11 22:22:21','2025-05-15 08:00:06','gbx'),
(31,'Pfizer Inc.','PFE','NYSE:PFE',22.83,22.85,9500,22.80,7500,25.00,30.00,'2025-04-11 22:22:21','2025-05-17 08:00:05','usd'),
(32,'PepsiCo Inc.','PEP','NASDAQ:PEP',131.98,132.11,8000,131.85,6000,150.00,180.00,'2025-04-11 22:22:21','2025-05-17 14:00:06','usd'),
(33,'Coca-Cola Co.','KO','NYSE:KO',72.00,72.07,11000,71.93,9000,55.00,65.00,'2025-04-11 22:22:21','2025-05-18 14:00:07','usd'),
(34,'AT&T Inc.','T','NYSE:T',27.72,27.75,12000,27.69,10000,16.00,20.00,'2025-04-11 22:22:21','2025-05-18 08:00:05','usd'),
(35,'Verizon Communications Inc.','VZ','NYSE:VZ',43.99,44.03,10000,43.95,8000,48.00,55.00,'2025-04-11 22:22:21','2025-05-18 02:00:06','usd'),
(36,'Comcast Corp.','CMCSA','NASDAQ:CMCSA',35.48,35.52,9000,35.44,7000,42.00,48.00,'2025-04-11 22:22:21','2025-05-18 08:00:05','usd'),
(37,'McDonalds Corp.','MCD','NYSE:MCD',318.61,318.93,8500,318.29,6500,260.00,300.00,'2025-04-11 22:22:21','2025-05-18 02:00:05','usd'),
(38,'Starbucks Corp.','SBUX','NASDAQ:SBUX',85.57,85.66,7000,85.48,5000,90.00,110.00,'2025-04-11 22:22:21','2025-05-17 20:00:05','usd'),
(39,'Nike Inc.','NKE','NYSE:NKE',63.11,63.17,8000,63.05,6000,52.28,98.04,'2025-04-11 22:22:21','2025-05-17 20:00:06','usd'),
(40,'CVS Health Corp.','CVS','NYSE:CVS',62.53,62.59,9000,62.47,7000,43.56,71.45,'2025-04-11 22:22:21','2025-05-17 14:00:05','usd'),
(41,'Shell PLC ADR','SHEL','NYSE:SHEL',71.92,71.99,8500,71.85,7500,65.25,78.40,'2025-04-11 22:22:21','2025-09-10 08:38:02','usd');

/*Table structure for table `trades` */

DROP TABLE IF EXISTS `trades`;

CREATE TABLE `trades` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `qty` decimal(10,0) DEFAULT NULL,
  `market` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pair` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `entry_price` decimal(2,0) DEFAULT NULL,
  `exit_price` decimal(2,0) DEFAULT NULL,
  `trade_action` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `entry_time` datetime DEFAULT NULL,
  `exit_time` datetime DEFAULT NULL,
  `pnl` decimal(10,2) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `stop_loss` int DEFAULT NULL,
  `outcome` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `trades_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `trades` */

insert  into `trades`(`id`,`user_id`,`amount`,`qty`,`market`,`pair`,`entry_price`,`exit_price`,`trade_action`,`entry_time`,`exit_time`,`pnl`,`status`,`created_at`,`updated_at`,`deleted_at`,`stop_loss`,`outcome`) values 
(12,73,10.00,NULL,'Stocks','FACEBOOK INC',NULL,NULL,'buy',NULL,'2025-11-24 21:44:06',9000.00,1,'2025-11-24 20:42:34','2025-11-25 02:44:06',NULL,NULL,'+'),
(13,73,100.00,NULL,'Stocks','APPLE INC',NULL,NULL,'buy',NULL,NULL,NULL,0,'2025-11-24 21:02:56','2025-11-25 03:02:56',NULL,NULL,NULL),
(14,73,200.00,NULL,'Stocks','FACEBOOK INC',NULL,NULL,'buy',NULL,'2025-12-03 05:16:10',9909.00,1,'2025-11-27 03:59:19','2025-12-03 10:16:10',NULL,NULL,'+'),
(15,73,600.00,NULL,'Stocks','FACEBOOK INC',NULL,NULL,'sell',NULL,'2025-11-29 17:44:24',1000.00,1,'2025-11-27 03:59:27','2025-11-29 22:44:24',NULL,NULL,'+');

/*Table structure for table `transactions` */

DROP TABLE IF EXISTS `transactions`;

CREATE TABLE `transactions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'TRD000000',
  `user_id` bigint unsigned DEFAULT NULL,
  `amount` decimal(40,18) NOT NULL,
  `details` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount_released` decimal(40,18) DEFAULT NULL,
  `payment_option_id` bigint unsigned DEFAULT NULL,
  `wallet_option_id` bigint unsigned DEFAULT NULL,
  `action_at` datetime DEFAULT NULL,
  `action_by` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status_id` int unsigned NOT NULL DEFAULT '2',
  `withdrawal_location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status_id`),
  KEY `payment_option_id` (`payment_option_id`),
  CONSTRAINT `transactions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `transactions_ibfk_2` FOREIGN KEY (`status_id`) REFERENCES `payment_statuses` (`id`),
  CONSTRAINT `transactions_ibfk_3` FOREIGN KEY (`payment_option_id`) REFERENCES `coins` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=250 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `transactions` */

insert  into `transactions`(`id`,`transaction_id`,`user_id`,`amount`,`details`,`amount_released`,`payment_option_id`,`wallet_option_id`,`action_at`,`action_by`,`type`,`status_id`,`withdrawal_location`,`created_at`,`updated_at`,`deleted_at`) values 
(152,'TRDYULBYBJF',19,50000.000000000000000000,NULL,NULL,1,35,'2025-11-24 08:10:20','3','deposit',3,NULL,'2025-11-24 08:10:01','2025-11-24 14:10:20',NULL),
(153,'TRDEMAHUN6Y',19,90000.000000000000000000,NULL,NULL,1,35,'2025-11-24 08:10:51','3','deposit',1,NULL,'2025-11-24 08:10:41','2025-11-24 14:10:51',NULL),
(154,'TRDZRVF7I5K',19,7000.000000000000000000,NULL,NULL,35,NULL,'2025-11-24 08:20:00','3','withdrawal',3,'gerwghwrhrtykm,tukltu78kjterhjetrjrsyjsjysyjkrg','2025-11-24 08:11:45','2025-11-24 14:20:00',NULL),
(155,'TRDNTF7ECQT',19,7000.000000000000000000,NULL,NULL,35,NULL,'2025-11-24 08:22:04','3','withdrawal',3,'sAFveashggm,.iyul,tjky7jwg234t','2025-11-24 08:21:32','2025-11-24 14:22:04',NULL),
(156,'TRDKWV8SOEI',73,100.000000000000000000,NULL,NULL,1,1,'2025-11-24 20:22:29','13','deposit',1,NULL,'2025-11-24 19:11:34','2025-11-25 02:22:29',NULL),
(157,'TRDKC481HI9',73,500.000000000000000000,NULL,NULL,2,NULL,NULL,NULL,'top-up',2,NULL,'2025-11-24 19:24:55','2025-11-25 01:24:55',NULL),
(158,'TRD1CYEPRUC',73,100.000000000000000000,NULL,NULL,2,NULL,NULL,NULL,'withdrawal',2,'Hdosbdnxbcjcbfdjxjxbxbcbcbcbcbcbbcbcbcbcbcbcbbcccb','2025-11-24 20:26:24','2025-11-25 02:26:24',NULL),
(159,'TRDSDFR1LBJ',73,200.000000000000000000,NULL,NULL,35,2,'2025-11-24 20:31:02','13','deposit',1,NULL,'2025-11-24 20:30:06','2025-11-25 02:31:02',NULL),
(160,'TRD3D3KIF49',73,100.000000000000000000,NULL,NULL,2,35,'2025-11-24 20:32:07','13','deposit',1,NULL,'2025-11-24 20:31:58','2025-11-25 02:32:07',NULL),
(161,'TRDQGOJ8YQ8',73,500.000000000000000000,NULL,NULL,35,2,NULL,NULL,'deposit',2,NULL,'2025-11-24 20:45:08','2025-11-25 02:45:08',NULL),
(162,'TRDUJO7MWRN',73,5000.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-11-24 20:47:55','2025-11-25 02:47:55',NULL),
(163,'TRD5IGSFS00',73,25000.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'top-up',2,NULL,'2025-11-24 20:48:39','2025-11-25 02:48:39',NULL),
(164,'TRDP7LOJTK4',73,100.000000000000000000,NULL,NULL,4,35,NULL,NULL,'deposit',2,NULL,'2025-11-24 23:09:51','2025-11-25 05:09:51',NULL),
(165,'TRD07MPVRTS',73,50000.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'top-up',2,NULL,'2025-11-24 23:49:25','2025-11-25 05:49:25',NULL),
(166,'TRDCI0J57AA',74,17.380000000000000000,NULL,NULL,1,35,'2025-11-25 02:05:40','13','deposit',1,NULL,'2025-11-25 01:02:25','2025-11-25 08:05:40',NULL),
(167,'TRDLOFZMMHA',74,17.380000000000000000,NULL,NULL,35,NULL,'2025-11-25 13:23:45','13','withdrawal',3,'bc1qc8cpgrc4dgqwjl0e8jehg3c6jwvmgpgstan','2025-11-25 03:48:16','2025-11-25 19:23:45',NULL),
(168,'TRDGJDZAFCI',74,17.380000000000000000,NULL,NULL,35,NULL,'2025-11-27 02:16:39','13','withdrawal',3,'bc1qc8cpgurc4dgqwjl0e8jehg3c6jw97vmgpgstan','2025-11-25 16:47:59','2025-11-27 08:16:39',NULL),
(169,'TRD2HUCJVOL',78,0.820000000000000000,NULL,NULL,1,35,'2025-11-28 04:28:16','13','deposit',3,NULL,'2025-11-27 02:53:12','2025-11-28 10:28:16',NULL),
(170,'TRDMPMFXGJ3',74,15.000000000000000000,NULL,NULL,35,NULL,'2025-11-28 04:10:23','13','withdrawal',3,'bc1qc8cpgurc4dgqwjl0e8jehg3c6jw97vmgpgstan','2025-11-27 04:58:44','2025-11-28 10:10:23',NULL),
(171,'TRDLKGGUD46',85,1000.000000000000000000,NULL,NULL,1,NULL,NULL,NULL,'top-up',2,NULL,'2025-11-28 18:38:30','2025-11-29 00:38:30',NULL),
(172,'TRDYVMZRBKL',85,-100.000000000000000000,NULL,NULL,1,NULL,NULL,NULL,'admin-deduction',2,NULL,'2025-11-28 18:46:51','2025-11-29 00:46:51',NULL),
(173,'TRDNXA0YWMI',85,20.000000000000000000,NULL,NULL,1,NULL,NULL,NULL,'top-up',2,NULL,'2025-11-28 18:48:20','2025-11-29 00:48:20',NULL),
(174,'TRDJRBEUQGQ',85,-500.000000000000000000,NULL,NULL,1,NULL,NULL,NULL,'admin-deduction',2,NULL,'2025-11-28 18:48:53','2025-11-29 00:48:53',NULL),
(175,'TRDNZRZ5ODC',73,-500.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'admin-deduction',2,NULL,'2025-11-28 18:53:59','2025-11-29 00:53:59',NULL),
(176,'TRDCZXRZ74B',73,-500.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'admin-deduction',2,NULL,'2025-11-28 18:54:07','2025-11-29 00:54:07',NULL),
(177,'TRDCBJQMSAI',80,233.470000000000000000,NULL,NULL,1,1,'2025-11-29 01:43:01','13','deposit',3,NULL,'2025-11-28 23:59:57','2025-11-29 07:43:01',NULL),
(178,'TRD1CAU4NYB',80,132.000000000000000000,NULL,NULL,1,35,'2025-11-29 01:43:14','13','deposit',3,NULL,'2025-11-29 00:56:49','2025-11-29 07:43:14',NULL),
(179,'TRDV6LRUSIZ',80,131.000000000000000000,NULL,NULL,1,NULL,NULL,NULL,'top-up',2,NULL,'2025-11-29 01:55:16','2025-11-29 07:55:16',NULL),
(180,'TRDEPUGNA9J',87,449.910000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-11-29 02:05:29','2025-11-29 08:05:29',NULL),
(181,'TRDHQAZHC8R',88,200.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-11-29 02:34:25','2025-11-29 08:34:25',NULL),
(182,'TRDMITDYBAG',87,50.000000000000000000,NULL,NULL,1,35,'2025-11-30 03:58:42','13','deposit',1,NULL,'2025-11-30 02:06:20','2025-11-30 09:58:42',NULL),
(183,'TRDAASPE7W5',93,300.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-11-30 02:59:20','2025-11-30 08:59:20',NULL),
(184,'TRDY86MOCXE',87,246.160000000000000000,NULL,NULL,1,35,'2025-11-30 03:58:50','13','deposit',1,NULL,'2025-11-30 03:20:21','2025-11-30 09:58:50',NULL),
(185,'TRDL4B8XKXP',94,44500.000000000000000000,NULL,NULL,1,NULL,NULL,NULL,'top-up',2,NULL,'2025-11-30 04:26:28','2025-11-30 10:26:28',NULL),
(186,'TRDWPRVSGXV',94,-1000.000000000000000000,NULL,NULL,1,NULL,NULL,NULL,'admin-deduction',2,NULL,'2025-11-30 04:26:40','2025-11-30 10:26:40',NULL),
(187,'TRDTHE0A4NJ',94,-4100.000000000000000000,NULL,NULL,1,NULL,NULL,NULL,'admin-deduction',2,NULL,'2025-11-30 04:27:16','2025-11-30 10:27:16',NULL),
(188,'TRDGMPFPEGF',94,-30000.000000000000000000,NULL,NULL,1,NULL,NULL,NULL,'admin-deduction',2,NULL,'2025-11-30 04:27:30','2025-11-30 10:27:30',NULL),
(189,'TRDPYGJ1IEB',87,110.000000000000000000,NULL,NULL,1,1,'2025-11-30 21:32:50','13','deposit',1,NULL,'2025-11-30 14:13:13','2025-12-01 03:32:50',NULL),
(190,'TRDS5UYYREF',87,94.000000000000000000,NULL,NULL,35,NULL,'2025-12-02 15:51:29','13','withdrawal',3,'3Ln7owixQoUU2bzH4f4JcNr5zQSHAysZTF','2025-11-30 21:41:32','2025-12-02 21:51:29',NULL),
(191,'TRDOM6CPYW4',97,63.000000000000000000,NULL,NULL,1,1,'2025-12-02 00:26:49','13','deposit',1,NULL,'2025-12-01 23:59:18','2025-12-02 06:26:49',NULL),
(192,'TRD5K0HXCO5',99,487.720000000000000000,NULL,NULL,35,35,'2025-12-02 00:41:27','13','deposit',1,NULL,'2025-12-02 00:40:58','2025-12-02 06:41:27',NULL),
(193,'TRDDHGUGCJH',100,109.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-12-02 05:02:13','2025-12-02 11:02:13',NULL),
(194,'TRDUNDABAYU',97,46.000000000000000000,NULL,NULL,1,35,'2025-12-02 23:46:44','13','deposit',1,NULL,'2025-12-02 23:17:29','2025-12-03 05:46:44',NULL),
(195,'TRDCXBGANAY',97,100.000000000000000000,NULL,NULL,1,35,'2025-12-02 23:56:30','13','deposit',1,NULL,'2025-12-02 23:25:05','2025-12-03 05:56:30',NULL),
(196,'TRDNQ0JEJRC',97,146.000000000000000000,NULL,NULL,1,1,'2025-12-03 00:15:21','13','deposit',1,NULL,'2025-12-03 00:14:07','2025-12-03 06:15:21',NULL),
(197,'TRDWIEQELOD',97,700.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'top-up',2,NULL,'2025-12-03 04:15:19','2025-12-03 10:15:19',NULL),
(198,'TRDEHD3HL6U',87,1900.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'top-up',2,NULL,'2025-12-03 04:21:56','2025-12-03 10:21:56',NULL),
(199,'TRDRDQVZMS8',91,50.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-12-03 23:56:12','2025-12-04 05:56:12',NULL),
(200,'TRDKLMLYRR9',91,40.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-12-04 00:17:59','2025-12-04 06:17:59',NULL),
(201,'TRD9NTPYORJ',91,38.000000000000000000,NULL,NULL,1,35,'2025-12-04 01:16:01','13','deposit',1,NULL,'2025-12-04 00:22:04','2025-12-04 07:16:01',NULL),
(202,'TRDPES0LDNU',87,1999.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'top-up',2,NULL,'2025-12-04 00:41:27','2025-12-04 06:41:27',NULL),
(203,'TRDPTCKWPPY',94,1000.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'top-up',2,NULL,'2025-12-04 00:43:01','2025-12-04 06:43:01',NULL),
(204,'TRDXCBS8SUN',99,287.720000000000000000,NULL,NULL,35,NULL,'2025-12-05 03:32:53','13','withdrawal',3,'twohavinnn.cb.id','2025-12-04 04:28:27','2025-12-05 09:32:53',NULL),
(205,'TRDUUIHQR6C',82,48.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-12-04 14:31:47','2025-12-04 20:31:47',NULL),
(206,'TRDS89I6VZE',82,35.000000000000000000,NULL,NULL,1,35,'2025-12-04 15:18:45','13','deposit',1,NULL,'2025-12-04 14:53:07','2025-12-04 21:18:45',NULL),
(207,'TRDDOAQK0RM',99,1999.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'top-up',2,NULL,'2025-12-04 16:05:08','2025-12-04 22:05:08',NULL),
(208,'TRDTBFTAXGG',116,100.000000000000000000,NULL,NULL,35,35,NULL,NULL,'deposit',2,NULL,'2025-12-04 16:11:55','2025-12-04 22:11:55',NULL),
(209,'TRDHMGVBNYT',115,500.000000000000000000,NULL,NULL,1,1,'2025-12-04 16:59:36','13','deposit',1,NULL,'2025-12-04 16:58:43','2025-12-04 22:59:36',NULL),
(210,'TRDIW7LU6KZ',117,100.000000000000000000,NULL,NULL,35,35,NULL,NULL,'deposit',2,NULL,'2025-12-04 20:20:01','2025-12-05 02:20:01',NULL),
(211,'TRDUR9GTUHY',118,133.000000000000000000,NULL,NULL,1,35,'2025-12-04 21:18:44','13','deposit',1,NULL,'2025-12-04 20:48:50','2025-12-05 03:18:44',NULL),
(212,'TRDYQJAYHOI',82,2.123300000000000000,'Bought 0.01 shares of Apple Inc. (AAPL) at 212.33',NULL,NULL,NULL,'2025-12-04 20:53:47','82','stock_buy',1,NULL,'2025-12-04 20:53:47','2025-12-05 02:53:47',NULL),
(213,'TRD83DCE7JK',119,140.000000000000000000,NULL,NULL,37,35,NULL,NULL,'deposit',2,NULL,'2025-12-04 21:06:47','2025-12-05 03:06:47',NULL),
(214,'TRDUHVQ82ID',119,140.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-12-04 21:11:01','2025-12-05 03:11:01',NULL),
(215,'TRDXQW8XOY6',119,1.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-12-04 21:16:12','2025-12-05 03:16:12',NULL),
(216,'TRDHEG5JOV9',119,150.000000000000000000,NULL,NULL,37,35,'2025-12-04 21:19:57','13','deposit',1,NULL,'2025-12-04 21:18:09','2025-12-05 03:19:57',NULL),
(217,'TRDRDDAOUVH',118,360.800000000000000000,NULL,NULL,1,35,'2025-12-05 04:41:19','13','deposit',1,NULL,'2025-12-04 22:12:55','2025-12-05 10:41:19',NULL),
(218,'TRDSUHXHVO0',117,100.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-12-04 22:52:36','2025-12-05 04:52:36',NULL),
(219,'TRDLYPHFREH',119,151.000000000000000000,NULL,NULL,35,NULL,'2025-12-05 03:32:45','13','withdrawal',3,'FxucAwiUNvG3rkc7eVtTgrTq4WW8LNgUu6sgC14NRSkM','2025-12-04 23:21:34','2025-12-05 09:32:45',NULL),
(220,'TRDB131RIT7',91,38.000000000000000000,NULL,NULL,35,NULL,'2025-12-05 03:33:03','13','withdrawal',3,'17MeFeXZMx3ZnWgE8gcGECcGrsSPV5Lsgc','2025-12-04 23:31:42','2025-12-05 09:33:03',NULL),
(221,'TRDFLQEOGNS',91,1999.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'top-up',2,NULL,'2025-12-05 04:45:54','2025-12-05 10:45:54',NULL),
(222,'TRDTW3Y2MW0',91,-1500.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'admin-deduction',2,NULL,'2025-12-05 04:46:26','2025-12-05 10:46:26',NULL),
(223,'TRDQBX9HVBL',122,100.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-12-05 05:28:10','2025-12-05 11:28:10',NULL),
(224,'TRDMYZVRKBY',122,100.000000000000000000,NULL,NULL,1,35,'2025-12-05 06:14:19','13','deposit',1,NULL,'2025-12-05 05:32:07','2025-12-05 12:14:19',NULL),
(225,'TRDNDNINNWD',100,50.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-12-05 14:27:23','2025-12-05 20:27:23',NULL),
(226,'TRDSGDAI3KQ',114,100.000000000000000000,NULL,NULL,1,35,'2025-12-05 16:59:04','13','deposit',1,NULL,'2025-12-05 15:48:25','2025-12-05 22:59:04',NULL),
(227,'TRDIQBOTJLU',114,100.000000000000000000,NULL,NULL,1,1,'2025-12-05 16:58:24','13','deposit',1,NULL,'2025-12-05 15:49:34','2025-12-05 22:58:24',NULL),
(228,'TRDF4GIBUT7',97,800.000000000000000000,NULL,NULL,1,1,NULL,NULL,'deposit',2,NULL,'2025-12-05 15:53:45','2025-12-05 21:53:45',NULL),
(229,'TRD8LLMHNYH',118,100.000000000000000000,NULL,NULL,35,35,NULL,NULL,'deposit',2,NULL,'2025-12-05 23:45:03','2025-12-06 05:45:03',NULL),
(230,'TRDTTCIWY5I',99,1000.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'withdrawal',2,'TRD5K0HXCO5','2025-12-06 00:12:31','2025-12-06 06:12:31',NULL),
(231,'TRDDX97YTWZ',100,44.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-12-06 00:19:25','2025-12-06 06:19:25',NULL),
(232,'TRDJX3LRL5F',122,100.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'withdrawal',2,'bc1q2j57l89qzdhxfjydaupkz8huwhk258tedehawl','2025-12-06 01:48:35','2025-12-06 07:48:35',NULL),
(233,'TRDJX3LRL5F',122,100.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'withdrawal',2,'bc1q2j57l89qzdhxfjydaupkz8huwhk258tedehawl','2025-12-06 01:48:35','2025-12-06 07:48:35',NULL),
(234,'TRD2EFJTCSX',100,99.000000000000000000,NULL,NULL,1,35,'2025-12-06 05:45:51','13','deposit',1,NULL,'2025-12-06 05:27:44','2025-12-06 11:45:51',NULL),
(235,'TRDXUGECGBM',91,500.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'withdrawal',2,'17MeFeXZMx3ZnWgE8gcGECcGrsSPV5Lsgc','2025-12-06 11:05:22','2025-12-06 17:05:22',NULL),
(236,'TRDYX8JMUYP',94,800.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'top-up',2,NULL,'2025-12-06 18:24:13','2025-12-07 00:24:13',NULL),
(237,'TRDVTXVGWSB',126,50.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2025-12-07 01:16:01','2025-12-07 07:16:01',NULL),
(238,'TRDMRLRNLIK',97,200.000000000000000000,NULL,NULL,35,NULL,NULL,NULL,'withdrawal',2,'222196696624','2025-12-07 18:09:44','2025-12-08 00:09:44',NULL),
(239,'TRDP8R9WX1E',125,788.000000000000000000,NULL,NULL,1,NULL,NULL,NULL,'top-up',2,NULL,'2025-12-08 12:00:30','2025-12-08 12:00:30',NULL),
(240,'TRDCUTRJMHW',125,647.666547920000000000,NULL,NULL,37,NULL,NULL,NULL,'top-up',2,NULL,'2025-12-08 12:08:17','2025-12-08 12:08:17',NULL),
(241,'TRDBBQPWDH0',125,4.275026720000000000,NULL,NULL,37,NULL,NULL,NULL,'top-up',2,NULL,'2025-12-08 12:18:25','2025-12-08 12:18:25',NULL),
(242,'TRDNZBVGIKM',125,599.000000000000000000,NULL,NULL,37,NULL,NULL,NULL,'top-up',2,NULL,'2025-12-08 12:18:46','2025-12-08 12:18:46',NULL),
(243,'TRD0WTXR8NP',125,-1200.000000000000000000,NULL,NULL,37,NULL,NULL,NULL,'top-up',2,NULL,'2025-12-08 12:21:45','2025-12-08 12:21:45',NULL),
(244,'TRD0HABMXTZ',125,-50.000000000000000000,NULL,NULL,37,NULL,NULL,NULL,'top-up',2,NULL,'2025-12-08 12:23:23','2025-12-08 12:23:23',NULL),
(245,'TRDVLO5FYBB',128,800000.000000000000000000,NULL,NULL,35,35,'2025-12-12 08:31:09','3','deposit',1,NULL,'2025-12-12 08:29:38','2025-12-12 08:31:09',NULL),
(246,'TRDLZUTAO6O',128,18897.370000000000000000,'Bought 89 shares of Apple Inc. (AAPL) at 212.33',NULL,NULL,NULL,'2025-12-12 08:51:02','128','stock_buy',1,NULL,'2025-12-12 08:51:02','2025-12-12 08:51:02',NULL),
(247,'TRD72JPTPVJ',128,19109.700000000000000000,'Bought 90 shares of Apple Inc. (AAPL) at 212.33',NULL,NULL,NULL,'2025-12-12 08:51:13','128','stock_buy',1,NULL,'2025-12-12 08:51:13','2025-12-12 08:51:13',NULL),
(248,'TRDRX50HCFM',132,26892.000000000000000000,NULL,NULL,2,4,NULL,NULL,'deposit',2,NULL,'2026-01-16 15:33:42','2026-01-16 15:33:42',NULL),
(249,'TRD4ACOF2UU',129,4000.000000000000000000,NULL,NULL,1,35,NULL,NULL,'deposit',2,NULL,'2026-01-19 09:05:19','2026-01-19 09:05:19',NULL);

/*Table structure for table `user_fixed_investments` */

DROP TABLE IF EXISTS `user_fixed_investments`;

CREATE TABLE `user_fixed_investments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `inv_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `investment_plan_id` int unsigned NOT NULL,
  `invested_amount` decimal(15,2) NOT NULL,
  `current_pnl` decimal(15,2) NOT NULL DEFAULT '0.00',
  `start_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `end_date` timestamp NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `user_chosen_duration_value` int NOT NULL DEFAULT '0',
  `user_chosen_duration_unit` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'days',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `disbursed_amount` decimal(15,2) DEFAULT NULL,
  `coin_id` bigint unsigned NOT NULL DEFAULT '35',
  `pnl_amount` decimal(15,2) DEFAULT '0.00',
  `pnl` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `disbursed_by_id` bigint unsigned DEFAULT NULL,
  `disbursed_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_user_fixed_investments_user_id` (`user_id`),
  KEY `fk_user_fixed_investments_plan_id` (`investment_plan_id`),
  KEY `fk_user_fixed_investments_coin_id` (`coin_id`),
  KEY `fk_user_fixed_investments_disbursed_by_id` (`disbursed_by_id`),
  CONSTRAINT `fk_user_fixed_investments_coin_id` FOREIGN KEY (`coin_id`) REFERENCES `coins` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_user_fixed_investments_disbursed_by_id` FOREIGN KEY (`disbursed_by_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_user_fixed_investments_plan_id` FOREIGN KEY (`investment_plan_id`) REFERENCES `investment_plans` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_user_fixed_investments_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `user_fixed_investments` */

insert  into `user_fixed_investments`(`id`,`inv_id`,`user_id`,`investment_plan_id`,`invested_amount`,`current_pnl`,`start_date`,`end_date`,`status`,`user_chosen_duration_value`,`user_chosen_duration_unit`,`created_at`,`updated_at`,`deleted_at`,`disbursed_amount`,`coin_id`,`pnl_amount`,`pnl`,`disbursed_by_id`,`disbursed_at`) values 
(12,'FIXINVMMT8YTEQ',73,11,35.00,72.45,'2025-11-25 02:41:42','2025-12-26 02:41:42','active',31,'days','2025-11-25 02:41:42','2025-11-29 01:13:14',NULL,NULL,2,0.00,NULL,NULL,NULL),
(13,'FIXINVNYIXBGYV',73,4,25000.00,1875.00,'2025-11-25 03:02:14','2025-11-30 03:02:14','active',5,'days','2025-11-25 03:02:14','2025-11-28 21:36:04',NULL,NULL,35,0.00,NULL,NULL,NULL),
(14,'FIXINVAOTZDZRN',73,11,9000.00,18630.00,'2025-11-25 05:39:46','2025-11-30 05:39:46','active',5,'days','2025-11-25 05:39:46','2025-11-29 01:13:14',NULL,NULL,35,0.00,NULL,NULL,NULL),
(15,'FIXINV3QZD7COP',73,11,1000.00,690.00,'2025-11-27 08:42:31','2025-11-29 08:42:31','matured',2,'days','2025-11-27 08:42:31','2025-11-28 21:36:04',NULL,NULL,35,0.00,NULL,NULL,NULL),
(16,'FIXINVLJ1GD1G0',73,11,25000.00,17250.00,'2025-11-27 08:43:25','2025-11-29 08:43:25','matured',2,'days','2025-11-27 08:43:25','2025-11-28 21:36:04',NULL,NULL,35,0.00,NULL,NULL,NULL),
(17,'FIXINVDT8TZXE3',94,9,1500000.00,67500.00,'2025-11-30 10:26:49','2025-12-01 10:26:49','matured',1,'days','2025-11-30 10:26:49','2025-12-04 06:41:56',NULL,NULL,1,0.00,NULL,NULL,NULL),
(18,'FIXINVOYUEDRYR',87,11,200.00,276.00,'2025-11-30 11:13:39','2025-12-02 11:13:39','matured',2,'days','2025-11-30 11:13:39','2025-12-02 23:35:07',NULL,NULL,35,0.00,NULL,NULL,NULL),
(19,'FIXINVEQNWGVYF',99,11,200.00,890.00,'2025-12-02 09:11:31','2025-12-09 09:11:31','active',7,'days','2025-12-02 09:11:31','2025-12-07 22:23:19',NULL,NULL,35,0.00,NULL,NULL,NULL),
(20,'FIXINVOGHPDAH9',97,11,209.00,372.02,'2025-12-03 06:24:02','2025-12-05 06:24:02','disbursed',2,'days','2025-12-03 06:24:02','2025-12-08 11:17:42',NULL,581.02,1,372.02,'+',3,'2025-12-08 12:17:42'),
(21,'FIXINV7IXL4FAQ',99,11,2286.72,4070.36,'2025-12-06 06:15:44','2026-01-10 06:15:44','active',35,'days','2025-12-06 06:15:44','2025-12-08 08:23:43',NULL,NULL,35,0.00,NULL,NULL,NULL);

/*Table structure for table `user_replications` */

DROP TABLE IF EXISTS `user_replications`;

CREATE TABLE `user_replications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `expert_trader_id` bigint unsigned NOT NULL,
  `allocated_amount` decimal(15,2) NOT NULL,
  `current_pnl` decimal(15,2) NOT NULL DEFAULT '0.00',
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `expert_trader_id` (`expert_trader_id`),
  CONSTRAINT `user_replications_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `user_replications_ibfk_2` FOREIGN KEY (`expert_trader_id`) REFERENCES `expert_traders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `user_replications` */

insert  into `user_replications`(`id`,`user_id`,`expert_trader_id`,`allocated_amount`,`current_pnl`,`status`,`created_at`,`updated_at`) values 
(3,128,2,18000.00,0.00,'active','2025-12-23 11:05:45','2025-12-23 11:05:45');

/*Table structure for table `user_signal_subscriptions` */

DROP TABLE IF EXISTS `user_signal_subscriptions`;

CREATE TABLE `user_signal_subscriptions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `signal_id` bigint unsigned NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `paid_price` decimal(10,2) NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `signal_id` (`signal_id`),
  CONSTRAINT `user_signal_subscriptions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `user_signal_subscriptions_ibfk_2` FOREIGN KEY (`signal_id`) REFERENCES `signals` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `user_signal_subscriptions` */

/*Table structure for table `users` */

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `referal` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `firstname` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastname` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `gender` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `role_id` int unsigned DEFAULT NULL,
  `profile_photo` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `kyc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `kyc_status_id` int unsigned NOT NULL DEFAULT '1',
  `kyc_verified_at` timestamp NULL DEFAULT NULL,
  `referral_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('active','suspended','deactivated') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  KEY `role_contraint` (`role_id`),
  KEY `kyc_status_contraint` (`kyc_status_id`),
  CONSTRAINT `kyc_status_contraint` FOREIGN KEY (`kyc_status_id`) REFERENCES `kyc_statuses` (`id`),
  CONSTRAINT `role_contraint` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `users` */

insert  into `users`(`id`,`email`,`email_verified_at`,`password`,`referal`,`address`,`remember_token`,`created_at`,`updated_at`,`firstname`,`lastname`,`dob`,`gender`,`phone`,`role_id`,`profile_photo`,`kyc`,`kyc_status_id`,`kyc_verified_at`,`referral_code`,`referrer_code`,`status`,`deleted_at`) values 
(2,'rivuw@mailinator.com',NULL,'$2y$12$hBhmKXsMZZLhTW7ubKKmI.4lkE2XQV3B/AtyMSOcHrSaJXsJpDRQy',NULL,'Iste consequatur co','1fwblczKjEQhck6M7o6wjzkWGq9DfZp3SprX5KymeEMM31XMQ2PtPZ7LNpWl','2024-11-08 07:34:10','2024-11-14 06:16:20','Hanna','Haney','2024-11-07','1','42',1,NULL,NULL,3,NULL,NULL,NULL,'active',NULL),
(3,'support@app.com',NULL,'$2y$12$T2hVqQNptIrTjpSpjBTKiOB.n6uPyfbV.GK2Gja.k/QoFoPXe7VFG',NULL,'Aliquip duis adipisc',NULL,'2024-11-09 01:40:06','2024-11-13 08:27:04','Dustin','Skinner','2024-11-08','1','65',1,NULL,NULL,2,NULL,NULL,NULL,'active',NULL),
(4,'ruwesa@mailinator.com',NULL,'$2y$12$7rY5tVRF6pmV3gLLMXJmsOS4/vgluw78adn9llu9zJFVPaC.DBHb.',NULL,'Hic praesentium volu',NULL,'2024-11-13 07:02:15','2024-11-13 08:29:21','Felix','Sherman','2024-11-12','1','40',3,NULL,'1731416534_1464950609109515.jpg',3,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(5,'xijopedela@mailinator.com',NULL,'$2y$12$zR5k.GpV9bFCLcJPNKaqmOz8Sik/93faTA5X6RmVZguZdqS3xRj6.',NULL,'Qui duis laborum vol',NULL,'2024-11-13 07:03:08','2024-11-13 07:03:08','Naida','Levine','2024-11-12','1','59',3,NULL,'1731416588_1-1606031S33I54.jpg',1,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(6,'qudygan@mailinator.com',NULL,'$2y$12$PCWQp.cXzwQZLOJugVT27O1Pscg2wzxUbMgfXz/4PisOopVM3xhd6',NULL,'Ipsa debitis reicie',NULL,'2024-11-13 08:31:51','2024-11-13 08:31:51','Fallon','Branch','2024-11-12','1','78',3,NULL,'1731421910_1-1606031S33I54.jpg',1,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(7,'sadopopir@mailinator.com',NULL,'$2y$12$A4xnXuSvUunhLxe1FbCX1.wKVqJLXHZRpr4HCHxXplEYhKEHJmOd.',NULL,'Ipsa exercitation u',NULL,'2024-11-13 08:37:04','2025-02-14 03:42:33','Hilel','Sexton','2024-11-12','1','41',3,NULL,'1731422223_1464950609109515.jpg',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(8,'tecipoqy@mailinator.com',NULL,'$2y$12$cd6e/CVOHp1c/lF3QEmq8eft5r7PyBAHBf.3UhKoZBTSkVGqFlrlq',NULL,'Autem quod vel aut m',NULL,'2024-11-13 08:39:34','2024-11-13 08:39:34','Blaine','Stanley','2024-11-12','1','54',3,NULL,'1731422374_1-1606031S33I54.jpg',1,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(9,'posobedazy@mailinator.com',NULL,'$2y$12$ZpdNMLRAK8VbF0ZkQvc55OE/F2t4cOmGotpLgLbVlcLpYaxAqydoy',NULL,'Adipisicing non eum',NULL,'2024-11-13 09:32:11','2024-11-13 09:32:11','Hammett','Hanson','2024-11-12','1','22',3,NULL,'1731425531_banner_temp.png',1,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(10,'nogiw@mailinator.com',NULL,'$2y$12$Atifh4hDnx11P8Z3kt8yTu5gr/Y717FyNcCgf4enpML0qML.zInQe',NULL,'Similique voluptas q',NULL,'2024-11-13 09:38:31','2024-11-13 09:38:31','Daria','Wagner','2024-11-12','1','99',3,NULL,'1731425910_Asset 1.png',1,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(11,'gonunygyz@mailinator.com',NULL,'$2y$12$CnZXe/H6a2bSKm3GsmJQwuAd09NGVDIBvuIFx6VMguHm.K0kwY7PC',NULL,'Non repellendus Tem',NULL,'2024-11-13 21:48:47','2024-11-13 21:48:47','Lesley','Mercer','2024-11-13','1','44',3,NULL,'1731469723_1-1606031S33I54.jpg',1,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(12,'bizido@mailinator.com',NULL,'$2y$12$f.C72D2UyJlVQ29N8W1rre193L3xTyAKne0KPssuqZOPOfvUK9jfS',NULL,'Rerum occaecat incid',NULL,'2024-11-13 23:11:23','2024-11-13 23:11:23','Chase','Vang','2024-11-13','1','31',3,NULL,'1731474682_DSC_6741-1-scaled.jpg',1,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(13,'admin@app.com',NULL,'$2y$12$T2hVqQNptIrTjpSpjBTKiOB.n6uPyfbV.GK2Gja.k/QoFoPXe7VFG',NULL,'wretyuiop[','BWsiw5bYrhZDvMxDLaVKNTeRwSdTtjQXplSBIAeMoq3y0w6sHDuNQqxHpekA','2024-11-14 02:42:19','2025-02-27 08:58:26','Super','admin','2024-11-13','1','123456789',1,NULL,'1731487337_temp_logo.png',1,NULL,NULL,NULL,'active',NULL),
(14,'johon@gmail.com',NULL,'$2y$12$qGr1Dt4er71iPsoJHomZAO5WIxjkKChTkqHcxduJludJii6jjQJW.',NULL,'1 avd jude street','1YfjhFXPN8cGjGnnlOpdmBrrFVJiyM6W4gV31FvWnhx9MRAtL7nGVXIYixq6','2024-11-14 08:07:12','2025-02-14 03:26:13','Jogo','John','2024-11-13','1','099832183485',3,NULL,'1731506829_passport photograph-croped.jpg',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(15,'johnndss@gamil.com',NULL,'$2y$12$j3J4vjw2.N62voiX9BAycupryeW.S6M.t00hx4ZuKxSQVOD6w7JTG',NULL,'Kansas city Texas',NULL,'2024-11-14 08:40:28','2025-02-14 03:34:16','johho','doess','2024-11-13','1','483493719',3,NULL,'1731508828_Annotation 2021-07-23 081628.png',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(16,'guzor@mailinator.com',NULL,'$2y$12$u2pFmwRfljtxsrGkT4ShROVNuXQhcSe6G/qlEWvKunLkFbcWeTGHS',NULL,'Nisi ullam quia dolo',NULL,'2024-11-15 04:12:10','2024-11-15 09:13:41','Ray','Henderson','2024-11-14','1','15',3,NULL,'1731579128_1-1606031S425964.jpg',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(17,'nipukigip@mailinator.com',NULL,'$2y$12$7o0dtlkjirafVGmhTWtCjuFhlucMj7CwIzkNQ9c4zgPqgnabm4xXG',NULL,'Amet dignissimos op',NULL,'2024-11-15 14:23:53','2024-11-15 14:25:25','Steel','Graves','2024-11-14','1','43',3,NULL,'1731615829_1-1606031S33I54.jpg',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(18,'koxely@mailinator.com',NULL,'$2y$12$E10SFSIQvD0surX.paBswuEt7ZaIjyfEuKf/PVbnNU9Cb/RZjvTmS',NULL,'Voluptas dolores lab',NULL,'2024-11-15 20:32:35','2025-02-14 03:43:07','Jael','Hayes','2024-11-15','1','9',3,NULL,'1731637952_1464950609109515.jpg',3,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(19,'zacal@mailinator.com',NULL,'$2y$12$SCG/fDK5S0IpKQULz6b06.DK5NjXjrNWcr4pXEtVZlDGSArlNSaVa',NULL,'Cupidatat est aut pr',NULL,'2024-11-20 22:58:16','2024-11-21 04:14:02','Maia','Benson','2024-11-20','1','61',2,NULL,'1732078694_c2b3ad93ccff584f36db4ee482a84162.jpg',2,NULL,'J1FTTFLW',NULL,'active',NULL),
(20,'wwse@app.com',NULL,'$2y$12$alPXsENfzsmmnTn5eA3IZu4Pwr828oKyHw4N999BK25fJbvLQM93.',NULL,'wuye',NULL,'2024-11-21 04:32:53','2024-11-21 04:32:53','felix','tester','2024-11-20','1','88876655555',3,NULL,'1732098771_peririodic table --Screenshot 2022-06-29 125404.png',1,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(21,'delix@app.ee',NULL,'$2y$12$/NTVutQ4jPGwacPEU0269eKc5Gd1CbFZR4GwryR7CHf5y2BjLvgUm',NULL,'hello',NULL,'2024-11-21 04:35:28','2025-02-14 04:03:34','fleix','quee','2024-11-20','1','90988877',2,NULL,'1732098928_peririodic table --Screenshot 2022-06-29 125404.png',2,NULL,NULL,NULL,'active',NULL),
(22,'tyty@dddd.dd',NULL,'$2y$12$i/zx9wdHSSPqWL7GbBPW0eR1IGfpK2k9qHLyxVlkLtE2lFZ7d8BLy',NULL,'tytyt',NULL,'2024-11-21 04:39:01','2025-02-14 04:01:55','tyt','tyt','2024-11-20','1','6868',2,NULL,'1732099141_Annotation 2021-07-23 081628.png',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(23,'yuyu@fg.viu',NULL,'$2y$12$4euODtpJdXBEvfZXk.m3J.znXnMvrqftevw/G8pcOw7yymaMAbFa6',NULL,'iiioin',NULL,'2024-11-21 04:42:50','2025-02-14 04:00:16','ioi','uiu','2024-11-20','1','123456789',2,NULL,'1732099369_peririodic table --Screenshot 2022-06-29 125404.png',2,NULL,NULL,NULL,'suspended','2025-11-23 16:53:17'),
(24,'hhu@dffkk.kk',NULL,'$2y$12$rC0qFmSPOlyeD3Cnh0tUd.nHGE5CJJB4j5e4JST0MUoIab8aKbQ3y',NULL,'123456789',NULL,'2024-11-21 04:45:15','2025-02-14 04:00:05','uiui','uiiu','2024-11-20','1','123456789',2,NULL,'1732099514_Annotation 2021-07-23 081628.png',2,NULL,'QVO3YJ2U_24','J1FTTFLW','suspended','2025-11-23 16:53:17'),
(25,'1felixjideonwo@gmail.com',NULL,'$2y$12$vHzQA5jqZdVKFMaD0rv7UesCVHvzuQ2nVmSaeI4lcWRD98Em85KMe',NULL,'Tenetur voluptas eu',NULL,'2024-11-22 07:43:23','2025-01-16 06:09:46','Reuben','Chang','2024-11-21','1','47',3,NULL,'1732196602_temp_logo.png',3,NULL,NULL,'Nesciunt','deactivated','2025-11-23 16:53:17'),
(26,'liqitezo@mailinator.com',NULL,'$2y$12$vPLHVOOZQX5ig6Mfu91g/uYRT3gThVt9SvAjxUYTG6KGb.V4aZ1Sa',NULL,'Ea quas veniam cons',NULL,'2024-11-22 07:45:04','2025-02-14 03:32:03','Kareem','Roberts','2024-11-21','1','9',3,NULL,'1732196703_1-1606031S425964.jpg',2,NULL,NULL,'Reiciendis eum i','active','2025-11-23 16:53:17'),
(27,'felixjideonwo@gmail.com',NULL,'$2y$12$xxlzlPySm3X3XsJi.Vb03u.rZvzxOAciEQXER2ln0Evdcr92JLzBK',NULL,'Nisi tempora libero',NULL,'2024-11-22 07:45:54','2024-11-22 08:43:49','Jermaine','Tran','2024-11-21','1','78',3,NULL,'1732196754_1-1606031S425964.jpg',2,NULL,NULL,'Sed aliquam null','active','2025-11-23 16:53:17'),
(28,'buyer_tester@mail.com',NULL,'$2y$12$PNNxRvDf1rn/B71gHdTXYOXVJ0M4uD6kiWoB4I0twi4Gpe23uv6aa',NULL,'At minus quis cumque',NULL,'2024-11-26 08:15:58','2024-11-26 08:55:49','Buyer','Tester','2024-11-25','1','17',3,NULL,'1732544155_WhatsApp Image 2023-03-23 at 20.09.50.jpg',2,NULL,NULL,'Magna veniam es','active','2025-11-23 16:53:17'),
(29,'buyerx@app.com',NULL,'$2y$12$oK/O/k70zuhw.EUawFZcMOrRAK1G/7J5cAngDcoGteOmPey8FsG2u',NULL,'Necessitatibus volup',NULL,'2024-12-11 03:48:16','2025-02-19 05:11:19','Connor','Shields','2024-12-10','1','79',3,NULL,'1733824093_Screenshot 2023-07-06 121528.png',2,NULL,NULL,'Quae in eum mole','active','2025-11-23 16:53:17'),
(30,'client@app.com',NULL,'$2y$12$PN3uvIGEw7whU/qrX/0UTuT/.BFiSqdgcApIb13SD0EiHuTODB4Dm',NULL,'Necessitatibus volup',NULL,'2024-12-11 03:54:14','2025-02-19 05:11:28','Connor','Shields','2024-12-10','1','79',2,NULL,'1733824453_Screenshot (8).png',2,NULL,'Q2ZA1PEV_30',NULL,'active','2025-11-23 16:53:17'),
(31,'buyer@app.com',NULL,'$2y$12$Lxo5bMoFw40Mrzy41jFvt.2qBecHJlDhfc7OPohUh.gDREj3tKnMm',NULL,'Necessitatibus volup',NULL,'2024-12-11 03:59:34','2024-12-11 04:02:12','Connor','Shields','2024-12-10','1','79',3,NULL,'1733824773_Screenshot (8).png',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(32,'zuryp@mailinator.com',NULL,'$2y$12$pKUneQda5OyP5IhyY/vGpOJ/GnpeC73o2t0nZA5trip1G1ttQCPpi',NULL,'Sit duis officia li',NULL,'2024-12-13 21:08:42','2024-12-13 21:08:42','Quinlan','Rowe','2024-12-13','1','54',2,NULL,'1734059321_LOGO-BG.png',1,NULL,NULL,'Exercitation ali','active','2025-11-23 16:53:17'),
(33,'sukutu@mailinator.com',NULL,'$2y$12$76Rw665ZYSKY0VD/wUkGh.DQCBMcZEatb5.RWgKHQkTYX22pGNjK6',NULL,'Voluptatum est labo',NULL,'2025-02-01 06:46:01','2025-02-01 06:46:01','Chadwick','Wells','2025-01-31','1','57',2,NULL,'1738327559_63c6b96d86c0c985079d8d60_project-02-thumb.webp',1,NULL,NULL,'Culpa enim dolor','active','2025-11-23 16:53:17'),
(34,'jyrixy@mailinator.com',NULL,'$2y$12$Q.ZJDEoUaYvknqAjq51GEe4rJvnsORxz/FTq7AgtBMdQYqZpW8wDm',NULL,'Est id nostrum aute',NULL,'2025-02-04 05:01:14','2025-02-04 05:01:14','Leah','Byers','2025-02-03','1','+1 (284) 915-9877',2,NULL,'1738580473_63c6b943f334e17d7007a0ea_project-04-thumb.webp',1,NULL,NULL,'Consequatur ess','active','2025-11-23 16:53:17'),
(35,'wipazijid@mailinator.com',NULL,'$2y$12$5Z9EQDm3E.vnKmf362xQVuyr3JI/boLCmtgkfgBfA7CwYszV4moNe',NULL,'Blanditiis voluptas',NULL,'2025-02-04 05:03:53','2025-02-14 03:25:59','Lawrence','Mcfarland','2025-02-03','1','+1 (139) 545-5391',2,NULL,'1738580633_3.png',2,NULL,NULL,'Nemo amet aliqu','active','2025-11-23 16:53:17'),
(36,'sonogus@mailinator.com',NULL,'$2y$12$SHAwJh6LZ2L6f.ZqbMHZduvQzs3d.whAXhoC5xkr4hTUHp5PVNn4K',NULL,'Culpa alias molliti',NULL,'2025-02-04 05:06:18','2025-02-14 03:42:55','Kyle','Grimes','2025-02-03','1','+1 (797) 852-5473',2,NULL,'1738580777_63c6b96d86c0c985079d8d60_project-02-thumb.webp',2,NULL,NULL,'Eiusmod reiciend','active','2025-11-23 16:53:17'),
(37,'fobixany@mailinator.com',NULL,'$2y$12$2iQGjjzFHalFiEjI345OXO1FdJtbEKyjlpriIS5TtzM3pEtpiP1v.',NULL,'Reprehenderit corrup',NULL,'2025-02-04 05:11:55','2025-02-12 07:21:32','Eagan','Sampson','2025-02-03','1','+1 (135) 233-1159',2,NULL,'1738581115_63c6b96d86c0c985079d8d60_project-02-thumb.webp',3,NULL,NULL,'Aperiam voluptat','active','2025-11-23 16:53:17'),
(40,'ragah@mailinator.com',NULL,'$2y$12$N8TQCGMXGBs8Q1xVAusJ/eUdQMrH0rMHkmymoRe6jx.PYu7NyFEeO',NULL,'Alias voluptatem cup',NULL,'2025-02-04 05:19:21','2025-02-19 05:11:43','Raya','Hayes','2025-02-03','1','+1 (581) 184-1398',2,NULL,'1738581561_3.png',2,NULL,NULL,'Cupiditate est e','active','2025-11-23 16:53:17'),
(41,'pawylo@mailinator.com',NULL,'$2y$12$T2hVqQNptIrTjpSpjBTKiOB.n6uPyfbV.GK2Gja.k/QoFoPXe7VFG',NULL,'Anim nihil aut ut ab',NULL,'2025-02-04 20:29:26','2025-02-19 05:10:43','Christian','Hawkins','2025-02-04','1','+1 (522) 961-9603',2,NULL,'1738636165_63c6b92f935d20848f686f45_project-gallery-03.webp',2,NULL,NULL,'In necessitatibu','active','2025-11-23 16:53:17'),
(42,'nada101@getnada.com',NULL,'$2y$12$um191mdHd/SN724uuvMDb.bA3b/KwsHJrEU7nuLEpnPICxi/YSzzi',NULL,'No, 394 ekifenf',NULL,'2025-02-08 03:19:22','2025-02-12 07:20:55','Mike','run','2025-02-07','1','9343948343',2,NULL,'1738919962_9ca7a609acbe4684ab55956ea01f9665c962a35980e743fdbe8ef3426208b906.png',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(43,'jeleyi7548@shouxs.com',NULL,'$2y$12$Trlp80cnSZB6TasHhIe/2eDCDBT/S73oSGyRNAlw0jjEFlMVjwGri',NULL,'3, wuse zone C, abuja',NULL,'2025-02-08 06:43:11','2025-02-14 03:25:45','Jekeyi','Huh','2025-02-07','1','0708317201',2,NULL,'1738932190_IMG_1673.jpeg',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(44,'babsnbs@gmail.com',NULL,'$2y$12$cSYtvdeusTZGmCKtw4hMw.jGgrQpaRs8mjWmOiNofl8mM/S0m6.j2',NULL,'Baba s',NULL,'2025-02-08 10:33:50','2025-02-19 05:10:55','Hahsh','Abbssb','2025-02-07','1','0756312232',2,NULL,'1738946030_D2BF4862-0EDB-493E-A560-0AE15111E002.jpeg',2,NULL,NULL,'Baba','active','2025-11-23 16:53:17'),
(45,'nansnwlwnbdusbdhsh@gmail.com',NULL,'$2y$12$r0ibC4s/fhEsSfMcyY9T6.2NeBO5Gqmy8ioggOn6sK2iIro16nY6q',NULL,'Nasnsisbshsb',NULL,'2025-02-08 10:47:25','2025-02-19 05:11:04','Haha s','Nsnsnsn','2025-02-07','1','0782321153',2,NULL,'1738946845_D2BF4862-0EDB-493E-A560-0AE15111E002.jpeg',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(46,'hhddhhshjds@gmail.com',NULL,'$2y$12$lNHHHHmG6J57ssWZkifYJ.h4BC92RAzdsqQ2i5ytMUjH6.FF.3Ppm',NULL,'Syjhjsjhshjs sbjsjszjh',NULL,'2025-02-12 06:12:58','2025-02-12 07:19:58','Janet','daisy','2025-02-11','1','55256352654',2,NULL,'1739275978_IMG_0005.png',2,NULL,NULL,'5456556','active','2025-11-23 16:53:17'),
(47,'notucobopa@mailinator.com',NULL,'$2y$12$8fc986NgGdYkGG1p/f8fQulJy0vEHgU/d0B2zCIF/T38LZGsZ..xK',NULL,'Tempore deserunt it',NULL,'2025-02-14 06:44:37','2025-02-14 06:45:28','Wang','Lee','2025-02-13','1','+1 (195) 955-1428',2,NULL,'1739450677_Dementia-Care-600x450.jpg',2,NULL,NULL,'Cum in amet ani','active','2025-11-23 16:53:17'),
(48,'xigenol499@sectorid.com',NULL,'$2y$12$7wDLZ66mIY0J9TcRy8RVUOODhcpstUUesnmxcBs552NzEb.Zyf5Bu',NULL,'Gwa, wuse 2, Abuja',NULL,'2025-02-14 07:13:21','2025-02-14 07:13:49','Li','Hoo','2025-02-13','1','09016288034',2,NULL,'1739452400_-DO YOUR THING-.png',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(49,'6ng694n7ih@qzueos.com',NULL,'$2y$12$3qg6re.ZyZC/ORhtYKFk4.926Fb./ylUiBGcY6FqSq4gRuK8z0H52',NULL,'Wuse 3, Abuja',NULL,'2025-02-14 07:24:31','2025-02-14 07:38:21','PG','Lang','2025-02-13','1','09063845364',2,NULL,'1739453071_1.2.png',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(50,'sahjxhgsajysagf@ghaiua.com',NULL,'$2y$12$G6zW6a2QB8O1UVd7o/VllO.RRhG7xWRBViCW/n4FI91L2CHm1kqJK',NULL,'i7373748347328',NULL,'2025-02-18 04:37:04','2025-02-19 04:23:48','Shjghcsahxsa','`xhasjkchksa','2025-02-17','1','5623623626',2,NULL,'1739788623_IMG_0005.png',2,NULL,NULL,'Y63y3','active','2025-11-23 16:53:17'),
(51,'puxevaqalu@mailinator.com',NULL,'$2y$12$wfm8uzuQ056/Hs3IPMIkzOhj9PcbBmltGKDCSTGLSDXdbNF89aHau',NULL,'Quia quam fugit ita',NULL,'2025-02-22 04:35:37','2025-02-22 04:35:51','Ashely','Good','2025-02-21','1','+1 (985) 867-4409',2,NULL,'1740134137_5rhtW8BBAMHYYosrwnHpimcKIrnn7a054epnzyhY.jpg',2,NULL,NULL,'Iusto nihil dolo','active','2025-11-23 16:53:17'),
(52,'hshahaha@gmail.com',NULL,'$2y$12$WVEJCgQxMribjG92fB1Q2uLUiJys.ojTTkvJ.SFFbGHuNpIWPganq',NULL,'Babababs1223',NULL,'2025-02-25 09:37:28','2025-02-25 09:38:34','Hahsbs','Hahahs','2025-02-24','1','2138121311',2,NULL,'1740411447_IMG_0857.jpeg',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(53,'nitejaf558@jarars.com',NULL,'$2y$12$KaIm/TrHHKyFYss0bCwmkuu/UkvnspJaFwIkdLPAU23bQjs5eECCm',NULL,'3, gbewa round about',NULL,'2025-02-26 06:11:23','2025-02-26 06:14:04','Jenni','Las','2025-02-25','1','09041116020',2,NULL,'1740485483_-DO YOUR THING-.png',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(54,'lipycac@mailinator.com',NULL,'$2y$12$zhXRauzNjIrP8eGQfsW7X.rSI3VCyk3syhb5sJaCDdXMFDCyTjvOy',NULL,'Nisi ut nisi volupta',NULL,'2025-02-26 06:16:38','2025-02-26 06:21:59','Oren','Rios','2025-02-25','1','+1 (716) 927-8702',2,NULL,'1740485798_Artboard 1_1-8feb2025.jpg',2,NULL,NULL,'Eius ut reiciend','active','2025-11-23 16:53:17'),
(55,'wikidabij@mailinator.com',NULL,'$2y$12$t11.XXHxSpmp2Ni/VsLIgexCNVZFjqg.TPYIco92FKvIXe5ij7Cx2',NULL,'Ut voluptate archite',NULL,'2025-02-26 06:29:24','2025-02-26 06:29:24','Kaden','Rojas','2025-02-25','1','+1 (891) 229-6014',2,NULL,'1740486564_Artboard 1_1-8feb2025.jpg',1,NULL,NULL,'Dolor amet aper','active','2025-11-23 16:53:17'),
(56,'sidndkn@ehd.com',NULL,'$2y$12$5.aNDHrzJw1Swd5IXGxHTui9p/mWeVdpZtuiaEDdZPhgpIvkDoHdO',NULL,'Hadidi, dull',NULL,'2025-02-26 07:17:14','2025-02-26 07:18:41','Jun','Hou','2025-02-25','1','8523339605',2,NULL,'1740489434_IMG_3277.png',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(57,'jea@getnada.com',NULL,'$2y$12$zR9VkEglBQgppIkDIxVifuN/Q5XNndvanB1Gxtu/wceZBfpkXjNTW',NULL,'Hugging hugging hhhhh',NULL,'2025-02-27 07:24:02','2025-02-27 08:17:42','Mark','Jae','2025-02-26','1','25266655585696',2,NULL,'1740576241_IMG_8390.jpeg',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(58,'muzodat@mailinator.com',NULL,'$2y$12$.onkSPjVNSN2a7Q/WEluceOy.FIg0MEU/4cfz66cQmQ5z.PdxpH9q',NULL,'Dolore consequat No',NULL,'2025-02-27 08:22:21','2025-02-27 10:25:02','Berk','Dorsey','2025-02-26','1','+1 (429) 427-2642',2,NULL,'1740587102_371189.jpg',1,NULL,NULL,'Animi ut simili','active','2025-11-23 16:53:17'),
(59,'vewuhiso@asciibinder.net',NULL,'$2y$12$ao5MYW3myvDWAuVclgCGROgMNRy2v.BSGLI6d0dSB3NAiikYqpWJG',NULL,'Damstraat 5',NULL,'2025-02-28 23:30:18','2025-02-28 23:30:18','sdfsdfsd','gdfgdfg','2025-02-28','1','+31612345678',2,NULL,'1740720618_Driver-license.jpg',1,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(60,'bifyri@logsmarter.net',NULL,'$2y$12$gCNj0z.jwhRmpAoxuJE.8.gq/2pcif6CttbirIot2iziEWCHGv63a',NULL,'123india',NULL,'2025-03-02 03:18:55','2025-03-12 08:50:32','swfrawfrwef','sfwwqrfw','2025-03-01','1','+918765453645',2,NULL,'1740820735_image.jpg',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(61,'dakozyp@mailinator.com',NULL,'$2y$12$eupBFlj5TtR238hRs560zuGhO5W9QJuUASyHE/x10coa1C4Py.6qa',NULL,'Id hic fugiat deser',NULL,'2025-03-05 08:13:31','2025-03-05 08:28:26','Sonya','Graham','2025-03-04','1','+1 (142) 701-1722',2,NULL,'1741097610_371271.jpg',2,NULL,'FS7TXOK3_61','Qui velit qui du','active','2025-11-23 16:53:17'),
(62,'hshshsh@gmail.com',NULL,'$2y$12$Zozor96Nsm9tFc8J0xiTXeFgu3QbwkiL7PQvu6iX9q6ax8wxCVv9y',NULL,'Babahshsh',NULL,'2025-03-12 08:55:10','2025-03-12 08:55:48','Jajs','Hshjss','2025-03-11','1','24348454211',2,NULL,'1741715710_IMG_0876.jpeg',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(63,'nanansnsns@gmail.com',NULL,'$2y$12$KS3epk727OSQGpAL8skrE.4DYP8k/LiBJwebLouoGAheO.fR2UD5K',NULL,'Uwhwhsb',NULL,'2025-03-18 11:24:44','2025-03-18 11:24:44','Nanana','Nanansn','2025-03-17','1','7243548484',2,NULL,'1742243084_IMG_0950.jpeg',1,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(64,'jgiacomino11@gmail.com',NULL,'$2y$12$ZYwMzz/MqAeXOQ7WHYDsm.AMx224gYjn1KsvTEQzQe/n3IfOCd.8y',NULL,'3707 Dorchester Place',NULL,'2025-03-18 11:34:31','2025-03-19 08:42:01','Jeannine','Giacomino','2025-03-17','1','6307427216',2,NULL,'1742243670_image.jpg',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(65,'keanureeves747458@gmail.com',NULL,'$2y$12$YEmOSBbIyvCe7L1nitG7feuH6M8b5.k9CN4txDT/avORs2UZUSLPK',NULL,'Los angels','uBv4c3yXxS6Dm1gCrSsHROPspZm6vCzYF0AO7pp8TQ9lSCISpPOfF6cBunhm','2025-03-19 06:29:04','2025-03-19 06:30:20','Keanu','Reeves','2025-03-18','1','+13236949368',2,NULL,'1742311744_IMG_0951.jpeg',2,NULL,NULL,NULL,'active','2025-11-23 16:53:17'),
(66,'jypybu6755@clowmail.com',NULL,'$2y$12$n//aRdc320vc.91vpcCAVu3m0PevOlU.WO.mfXouwtoZjNRwmaUTu',NULL,'jypybu6755@clowmail.com','yv3gOHSE6UWfCu0cVSxnzSqGJoeXH2tV3ojUUojyX3EXi8Ny1q38NvyYCqmG','2025-05-23 09:11:55','2025-05-24 22:25:15','Peter','Smith','2025-05-22','1','29832983203',2,NULL,'1747937515_photo_2025-05-18 06.58.55.jpeg',2,NULL,'HQVJBDFZ_66',NULL,'active','2025-11-23 16:53:17'),
(67,'user@app.com',NULL,'$2y$12$JpeopM5/Rn9ZYphYptjPy.djTDK/IomFF5M7qgAEwsCo.OzNf1ocS',NULL,'Est omnis minus off','xvjUia1Xr94WKrdOFzx8pqGD85PaNxEQ6Ca41geuEXdzXM1eGxqCJujdZDsD','2025-06-11 21:40:22','2025-06-11 23:08:37','Chloe','Thornton','2025-06-11','1','+1 (294) 815-6921',2,NULL,'1749642020_Comfort-Ekeikhorr-2.png',2,NULL,'RYLO5AV1_67','Ut ea fugit ut','active','2025-11-23 16:53:17'),
(68,'piruwyg@mailinator.com',NULL,'$2y$12$h8y3Yz5Zzf3.DwODZutCkuuxpOBc0X0cnRAH3CcM2OQ9.cDlu4Xsq',NULL,'Voluptatibus sit do',NULL,'2025-06-13 22:25:41','2025-06-13 23:54:23','Emerald','Rosales','2025-06-13','1','+1 (427) 247-5945',2,NULL,'1749817538_cb8715a0-bc50-4231-b0fa-88182839e8a2.jpg',2,NULL,'U3RC75GB_68','Est lorem et pra','active','2025-11-23 16:53:17'),
(69,'xyhoqazy@mailinator.com',NULL,'$2y$12$Bsiot.z411ezF1jeAOBna.KoRDQkLwnQRMdY6XiNnuoEdYjB5rXbe',NULL,'Praesentium quis est',NULL,'2025-06-17 03:23:25','2025-06-17 03:23:25','Brenda','Kelley','2025-06-16','1','+1 (294) 588-5961',2,NULL,'1750094605_logo.png',1,NULL,NULL,'Amet vero quisq','active','2025-11-23 16:53:17'),
(70,'doryfywoc@mailinator.com',NULL,'$2y$12$VtRG7cEyqJonQIxD0NGRFeBz.cWbNDz5HrZfh0iwXexFb4vcZit3a',NULL,'Dolorem tempora repu',NULL,'2025-06-20 22:44:40','2025-06-20 22:44:40','Chastity','Church','2025-06-20','1','+1 (999) 972-9829',2,NULL,'1750423480_login-logo-v2.png',1,NULL,NULL,'Autem cupiditate','active','2025-11-23 16:53:17'),
(71,'nupucucyh@mailinator.com',NULL,'$2y$12$t3wvP7ydM8a0ys9cmbKudem.nbCWpl4.hP9ltOfc3WX8iyWdmoLya',NULL,'Cum ad ut asperiores',NULL,'2025-06-21 00:57:11','2025-11-06 19:02:30','August','Coffey','2025-06-20','1','+1 (195) 391-4237',2,NULL,'1750431430_favicon.ico',1,NULL,'9KJS3CXM_71','Esse voluptate n','active','2025-11-23 16:53:17'),
(72,'johnsonalfred442@proton.me',NULL,'$2y$12$Bi8kzOr0Gs5gABO5zSngXuNomDs9QMclzJb3pppoM6OAvzdrbu7tm',NULL,'Jhgfhjkjhgfdsdfghjhgfd',NULL,'2025-06-21 10:39:18','2025-06-21 11:01:01','Altcoin','Gordon','2025-06-21','1','73656846276',2,NULL,'1750466358_A5C16CBE-E6AA-41CB-A646-5284B48ED8EB.jpeg',1,NULL,'AEIP98QO_72','Altcoin','active','2025-11-23 16:53:17'),
(73,'badeveryday300@gmail.com',NULL,'$2y$12$30cD6cH840omxuIMyO3cg.c0s8NbG37SighyhjdOxCF/vfLIA1B/y',NULL,'United state',NULL,'2025-11-25 01:07:53','2025-11-25 01:18:37','Bad','Everyday','2025-11-24','1','9050147951',2,NULL,'1764011272_IMG_0734.jpeg',2,NULL,'XOIYQS9B_73',NULL,'active',NULL),
(74,'sinceremcclelland17@gmail.com',NULL,'$2y$12$rYt8cODUbWDiD0qTl0.Mn.ERzGqR1hSdPMtDGl8OuzvZS.2Bh0mla',NULL,'1189 opal creek dr','N2BOYZc22nl1Z3ltucPgzTiCU014BddVstP4Y6XxyKyVxoDvR8PQe1QM2Dly','2025-11-25 06:23:54','2025-11-25 06:24:53','Sincere','Mcclelland','2025-11-25','1','8287817003',2,NULL,'1764030233_IMG_7451.jpeg',2,NULL,NULL,NULL,'active',NULL),
(75,'quortneywalker@icloud.com',NULL,'$2y$12$aBBrX4UUWpICS0RSCqLBg.A6B3CwNh4IBWliYxFVgiSWShgq0oEK2',NULL,'Quortneywalker@icloud.com',NULL,'2025-11-25 23:17:29','2025-11-26 00:16:11','Quortney','Walker','2025-11-25','1','7736104493',2,NULL,'1764091049_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(76,'roonsonko@gmail.com',NULL,'$2y$12$vZyh.VEjWWI7oaW/R572du4LcYdZOmes2R6zOsrrxuLh5QXEVfACS',NULL,'1 Winrose garth',NULL,'2025-11-26 01:22:02','2025-11-26 03:56:06','Haruna','Sonko','2025-11-25','1','07425926296',2,NULL,'1764098522_IMG_2541.jpeg',2,NULL,NULL,NULL,'active',NULL),
(77,'hmae51374@gmail.com',NULL,'$2y$12$jWQN7dSz5DK.VbYXPPFCc.9RuTtcLftl1rKAlBcRprlAYFLTlIwOi',NULL,'7818 Tacoma Ave S',NULL,'2025-11-26 06:47:52','2025-11-26 06:49:15','Mae','Howard','2025-11-26','1','2068877995',2,NULL,'1764118071_IMG_0472.jpeg',2,NULL,NULL,NULL,'active',NULL),
(78,'leerk75@gmail.com',NULL,'$2y$12$J3m0ps7QQCQ21jwjf2xIrO.ePLzumG.k..VTDZpizcMhw3A/gmwGi',NULL,'1120 Read Street','yPQXRJ47rvYigl8SKeZlwEEXcSqbUjhDQEebmnxzbtguxHaGmHzjGQIkxb7R','2025-11-26 08:43:30','2025-11-26 08:45:04','Kyleer','Whitfield','2025-11-26','1','3026472073',2,NULL,'1764125009_IMG_1346.jpeg',2,NULL,NULL,NULL,'active',NULL),
(79,'mthire077@gmail.com',NULL,'$2y$12$87TZ7hdxGQ0w7kkJdeBMQeel5xy0Yrd1gTZdP8gNkPYh9R8LZoN3.',NULL,'28180 oregon rd  43551','OZDBqcDLenjfL1wsuIO4h7PjhszEqXbbVQbgM6FLfULBVkHpyAVBffp8HV2B','2025-11-26 09:34:55','2025-11-26 10:01:09','Thire','Manning','2025-11-26','1','7636205196',2,NULL,'1764128095_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(80,'sherodtheprofit@gmail.com',NULL,'$2y$12$2Jy/UqkRBmiXMBAE1trpAeFucGUH675Ju/HCH6ob3nXzEI.K3Se86',NULL,'6 McGEE LANE','ug3UNtbua2MP25Vq0JjyYEcRa1NM77w5DUzrR7w1MSsVWgFESm5kUCErMJIY','2025-11-26 10:13:23','2025-11-26 10:20:08','Hezekiah','Boyd','2025-11-26','1','4849953848',2,NULL,'1764130403_IMG_9537.jpeg',2,NULL,NULL,NULL,'active',NULL),
(81,'tt6155095@gmail.com',NULL,'$2y$12$wfJr1lslf97bYBls6eXHYOPH4rNraA2SAY8pi.HpJ6K5kX9lz7qIG',NULL,'143 Stoneridge Dr',NULL,'2025-11-26 10:16:39','2025-11-26 10:20:13','Tamia','Thompson','2025-11-26','1','4706632589',2,NULL,'1764130599_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(82,'gabrielbynoe6@gmail.com',NULL,'$2y$12$sQhip2/B.xLaHg19CN280eBEIYzX3CVEnioFeKNsNPONayW6kDBIO',NULL,'44605 Roosevelt Ct, 3',NULL,'2025-11-27 13:50:46','2025-11-27 17:44:24','Gabriel','Bynoe','2025-11-27','1','6469404312',2,NULL,'1764229846_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(83,'frvnkmt@gmail.com',NULL,'$2y$12$Qbdsig90MMwK6NvZ9IunBufvaJsba5VxUhecNsN11qhGK5kAB/Jx2',NULL,'Frvnkmt@gmail.com',NULL,'2025-11-27 14:56:49','2025-11-27 17:44:28','Francisco','Montoya','2025-11-27','1','9035638638',2,NULL,'1764233809_IMG_0666.jpeg',2,NULL,NULL,NULL,'active',NULL),
(84,'robbie.g767@gmail.com',NULL,'$2y$12$j0X56bHDy9fZLe62hD9AKOSIl/7N4tUzPZPn1cglHQhLrZjWOwDKa',NULL,'Robbie.g767@gmail.com',NULL,'2025-11-28 03:31:08','2025-11-28 03:33:44','Robbie','Gutekunst','2025-11-27','1','9895059179',2,NULL,'1764279068_1000007785.jpg',2,NULL,NULL,NULL,'active',NULL),
(85,'ola.cooper@yahoo.com',NULL,'$2y$12$Vf4TqzMGnfWQcBuPeTmz3O9.4fTy4vdFsYyYBpUQKYPTzby4eV3E.',NULL,'215 woodtrails dr',NULL,'2025-11-28 07:46:03','2025-11-28 07:54:34','Ola','Cooper','2025-11-28','1','8437314174',2,NULL,'1764294362_IMG_0566.jpeg',2,NULL,NULL,NULL,'active',NULL),
(86,'pj3iqipfxh@xkxkud.com',NULL,'$2y$12$iHJsbK8Yl971JhDo.7hJoucoDt1wft/pd1JvEeZubRYbEyy/tV15e',NULL,'wsaxz 22',NULL,'2025-11-28 09:48:38','2025-11-28 20:26:18','DSXSASA','FDDSFDS','2025-11-28','1','12124567890',2,NULL,'1764301718_Annotation 2025-10-15 112204   cucu.png',3,NULL,NULL,NULL,'suspended',NULL),
(87,'rockythomas137@gmail.com',NULL,'$2y$12$pl0rEGCiFqrczt5rl2lPl.lzZsq/BKOECAhZG6d0CpELIVxuYghJS',NULL,'67 Tierney Road sw2 4qh','W9iRYemmSCgGK1agjDVVFoOZzWz717r9M5ZOK3dwCxXMoxhiaCmYlgTne19s','2025-11-29 06:43:41','2025-11-29 06:46:22','Rockwayne','Thomas','2025-11-29','1','+447495727137',2,NULL,'1764377020_112C2D72-C90D-4948-8CE4-82E5D79F37A3.JPG',2,NULL,NULL,NULL,'active',NULL),
(88,'s.said46876@gmail.com',NULL,'$2y$12$I24o3RgKM.pZnz92kI6Ulu8dGOQFZngPUUgvbUepOnRecm9kPmEbO',NULL,'5452 colfax ave','pRksuc5Q120ikRam7pXk28ZHc4NIPEesOzVlsj32RGHGcD2MJ1ukigtAjPTV','2025-11-29 07:41:30','2025-11-29 07:45:18','Sami','Said','2025-11-29','1','2138081874',2,NULL,'1764380490_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(89,'taheda_warriest86@yahoo.com',NULL,'$2y$12$Ll872s/t4fphwUf8utDhr.PwOIo.x6y.OTxgZCKaKFSZZOYGF7ZKG',NULL,'12236 Fox Hound Ln',NULL,'2025-11-29 08:28:15','2025-11-29 08:32:21','Trisha','Regius','2025-11-29','1','4045919417',2,NULL,'1764383295_IMG_0827.jpeg',2,NULL,NULL,NULL,'active',NULL),
(90,'izaguirred003@gmail.com',NULL,'$2y$12$uayrd2ez5w7AcnOWk7we5uxekxABEYBjUrcvoFoEP.cbVUbk0H3fy',NULL,'24 hazlett street Morristown NJ',NULL,'2025-11-29 08:40:44','2025-11-29 23:42:00','Diego','Izaguirre','2025-11-29','1','9739068557',2,NULL,'1764384044_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(91,'gcollins917@gmail.com',NULL,'$2y$12$VsvmK9BtSrs5RNpgJIqTq.DXObaKa8ttVoSJEyI7yKMwK.kMnyZzS',NULL,'15350 Wind Tree Drive',NULL,'2025-11-29 13:32:12','2025-12-05 11:36:47','Mary','Collins','2025-11-29','1','7272413943',2,NULL,'1764401531_IMG_4067.jpeg',2,NULL,'MFPC4YLF_91',NULL,'active',NULL),
(92,'demontrejones10@gmail.com',NULL,'$2y$12$TdFe47Pt6E6HfuXEqYa90OhSFFWRemsU19VGH8p9fwMkXGhv1wLaS',NULL,'11456 ardelle avenue',NULL,'2025-11-29 16:04:48','2025-11-29 23:42:23','Demontre','Jones','2025-11-29','1','9123216852',2,NULL,'1764410688_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(93,'smarvensjerome@gmail.com',NULL,'$2y$12$XywLt2OsGo1E0WFaSyQnueOAvFZ7hnxZ0IWm894iBsjiCLaElrYhW',NULL,'306 S william st Apt c1','kF7OrZLuGuS1S58AN6xzc5T1QuLogvuAFE0132vNBTGdEWXFNUizVwNUyHw1','2025-11-30 08:38:28','2025-11-30 09:00:27','Smarvens','Jerome','2025-11-30','1','9195812484',2,NULL,'1764470308_IMG_5783.jpeg',2,NULL,NULL,NULL,'active',NULL),
(94,'chizeangozidaniel@gmail.com',NULL,'$2y$12$nLpiJwhvAmudNa8RkEMrVO6p7lpfYxO0eFuCeXD3nHc28hR/bSDne',NULL,'Innois',NULL,'2025-11-30 10:17:42','2025-11-30 10:26:01','Chizea','Ngozi','2025-11-30','1','08078658962',2,NULL,'1764476261_8c59a3b2-10bb-43f2-827c-57c18cf4f493.jpeg',2,NULL,NULL,NULL,'active',NULL),
(95,'nanasuni02@gmail.com',NULL,'$2y$12$Tk4P71GczxNKEKwKjMc3He7MAL9JnOItuU5AM33ULRW/sVX.9N1Dm',NULL,'38 Mallory Court',NULL,'2025-12-01 04:05:07','2025-12-02 05:00:58','Nandipha','Basutu','2025-11-30','1','+447930532385',2,NULL,'1764540307_IMG_5259.jpeg',2,NULL,NULL,NULL,'active',NULL),
(96,'veraniacastrodelamatao@gmail.com',NULL,'$2y$12$Ky48pDyhSdQ/snlxZGUBc.1Wrw.flGrUW2n3LbuMHjPUvCVj.prKq',NULL,'1062 Edmiston Pl, na',NULL,'2025-12-01 12:08:54','2025-12-02 05:01:18','Verania','Castrodelamata','2025-12-01','1','14075296133',2,NULL,'1764569334_Screenshot 2025-09-23 at 10.51.37 PM.png',2,NULL,NULL,'2276','active',NULL),
(97,'adrianhuerta2021@gmail.com',NULL,'$2y$12$OTSJHHhREguLY1xekKnrfeTBZj2L/HjOzhnWP2sDUPbVLWcLmDQR2',NULL,'102 lisa st',NULL,'2025-12-02 05:01:38','2025-12-03 05:22:14','Adrián','Huerta','2025-12-01','1','9362213778',2,NULL,'1764630098_IMG_0710.jpeg',2,NULL,'CPF29T84_97',NULL,'active',NULL),
(98,'tealagriffin@gmail.com',NULL,'$2y$12$a/hikI24YGNOxcpMhMaVeO3oV0hiOcd7X24/83ETMWL6jv9AWMnyu',NULL,'3375 spring hill pkwy se','FyHJDmj7fWguyww8Sus97iaq5H2hrh4pTe2bbcvh1LOENeWq3NruSgxEASCf','2025-12-02 05:10:15','2025-12-02 05:14:57','Teala','Griffin','2025-12-01','1','3054694262',2,NULL,'1764630615_IMG_3480.jpeg',2,NULL,NULL,NULL,'active',NULL),
(99,'tommyjerardadams@gmail.com',NULL,'$2y$12$tGcgo.0Rt415yRHrLVJ.mOm70Jmix.v0gYZEO5uTZLJ1cBzwRj9r6',NULL,'1725 Darwin Rd','j5cehGcG9BA1FXF9POYiTyEOiAvwRlXB6p8T0U4BAHoJnt9EEeYk8n4va7at','2025-12-02 06:10:56','2025-12-08 08:19:05','Tommy','Adams','2025-12-02','1','6785164709',2,NULL,'1764634255_ID.JPG',2,NULL,'IRBDHGRY_99',NULL,'active',NULL),
(100,'daileylee42@gmail.com',NULL,'$2y$12$1ypBTimgd9Ft715rne0k4OOvdDFfiuQ9SoGacpcPdbAQXXVa821pW',NULL,'4011 lasher rd','w0wjJwQGohz4N6n98iPmWW3sZphjjJDZML7imcOupq0hGyNf2EZ3wMTwhXxm','2025-12-02 10:50:46','2025-12-02 11:49:55','Sherry','Dailey','2025-12-02','1','14845216976',2,NULL,'1764651046_IMG_0227.jpeg',2,NULL,NULL,NULL,'active',NULL),
(101,'samzena384@gmail.com',NULL,'$2y$12$RfXQJrpx7kzrCZzQcKBgWOmO.b4V/XTAfIBZzDe0w5inGSnsGdwDO',NULL,'37 Senator Marks Avenue',NULL,'2025-12-02 19:00:47','2025-12-02 21:13:00','Tseganesh Petros','Abose','2025-12-02','1','0685621771',2,NULL,'1764680447_IMG_0596.jpeg',2,NULL,NULL,NULL,'active',NULL),
(102,'robertbeauvoir@ymail.com',NULL,'$2y$12$3lAPvC60o69fsrYtPNVu/utp8KP8a2J/0dPfq7l6CSAf0L.L.9vQ.',NULL,'21 noyes street',NULL,'2025-12-02 20:09:03','2025-12-02 21:14:11','Robert','B','2025-12-02','1','5084843599',2,NULL,'1764684543_MASSACHUSETTS 4.jpeg',2,NULL,NULL,NULL,'active',NULL),
(103,'delmika.smith16@gmail.com',NULL,'$2y$12$sZDt4nPwphWOrapKbKzhHO28YgLy/yusXp/HOD8N3pVjY/2XySlI.',NULL,'13637 cedar',NULL,'2025-12-02 21:09:16','2025-12-02 21:16:14','Delmika','Smith','2025-12-02','1','2164109913',2,NULL,'1764688156_Current ID.heic',2,NULL,NULL,NULL,'active',NULL),
(104,'e3prods@gmail.com',NULL,'$2y$12$fQpX27T1r52I0.Xmm7NxTO6xAt9AljwfQQ9F/I5y8ZbnqDsJKGkpS',NULL,'790 Eldert Ln APT 14T',NULL,'2025-12-02 22:23:51','2025-12-02 22:25:14','NV','!','2025-12-02','1','9292320982',2,NULL,'1764692631_IMG_3515.jpeg',2,NULL,NULL,NULL,'active',NULL),
(105,'certified.vick@icloud.com',NULL,'$2y$12$5jspTtHe0xZ4YyXwYBhDBusaGq7vHX7eMz/3uqgQKBmDeqhp1GAyK',NULL,'vick',NULL,'2025-12-03 03:17:49','2025-12-03 07:10:41','Tseganesh Petros','Abose','2025-12-02','1','0685621771',2,NULL,'1764710269_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(106,'carloslucas2005@gmail.com',NULL,'$2y$12$YL7aAXWAvqOnz8CLer9LzOAjn/sZL6XGXFRJFflod7Ou7wk8ZKOnC',NULL,'2904 Modred Ln',NULL,'2025-12-03 07:16:25','2025-12-03 07:23:30','Carlos','Lucas Jr','2025-12-03','1','9803169308',2,NULL,'1764724584_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(107,'bennett.romaine@yahoo.com',NULL,'$2y$12$5.SJ/UkssDWuYjaHtxU9VuoixDJHRkLFYtzTTEae8Kne1XRm1ZFO6',NULL,'2954 lucille lN',NULL,'2025-12-03 08:20:43','2025-12-03 08:22:15','Romaine','Bennett','2025-12-03','1','9043334071',2,NULL,'1764728443_IMG_1228.jpeg',2,NULL,NULL,NULL,'active',NULL),
(108,'stocklordmiami@gmail.com',NULL,'$2y$12$GDDrRVkS0EMmAP7LGkGlseF7bxBpziYSTxxc722vHSfGzAMJ5Nnmm',NULL,'27541 sw 139th pl',NULL,'2025-12-03 09:10:26','2025-12-03 09:16:04','Iyamille','Michelin','2025-12-03','1','7868014144',2,NULL,'1764731426_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(109,'yungbg33@gmail.com',NULL,'$2y$12$vB/kbvaVxbI3hhoQnGdwhucV7iOBixzs8dPBj4SlR.WRpfdBNvqiG',NULL,'Yungbg33@gmail.com',NULL,'2025-12-03 18:38:18','2025-12-03 18:42:00','Bryce','Griffin','2025-12-03','1','9739306763',2,NULL,'1764765498_IMG_6791.png',2,NULL,NULL,NULL,'active',NULL),
(110,'okeenobarrett@gmail.com',NULL,'$2y$12$/2ani9cW3cQvX9XemBwI6e7CwF9zhNknID2vIxPbOBXSvy/7GVSam',NULL,'CornwallCourtsMontegoBayStJames',NULL,'2025-12-03 23:46:18','2025-12-04 02:14:00','Okeeno','Barrett','2025-12-03','1','18763384600',2,NULL,'1764783977_IMG_0457.jpeg',2,NULL,NULL,NULL,'active',NULL),
(111,'sahilverma019@gmail.com',NULL,'$2y$12$b.B3UznTaFZ0U6E0pMS.0eBJ9mCEy0Vfm.1ktzcJCmj1QtYZ4itI6',NULL,'2245 Twilight Rd','tjK2Fj4oOnUOSayxlGN0yUIRT0j7ryTtBBildRUvkzdhuZTZDIagqKKNxU6M','2025-12-04 00:35:40','2025-12-04 02:13:53','sahil','verma','2025-12-03','1','6479805400',2,NULL,'1764786940_IMG_3825.jpeg',3,NULL,NULL,NULL,'active',NULL),
(112,'tanayayoung2@gmail.com',NULL,'$2y$12$fSw8J1N.hY6dz0ViVV20POWOrUpDKktZBWLeNV42lQYjD9yxfyIFK',NULL,'11322 jewett ave',NULL,'2025-12-04 06:18:59','2025-12-04 06:28:31','Tanaya','Young','2025-12-04','1','5867822684',2,NULL,'1764807539_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(113,'rossievan927@gmail.com',NULL,'$2y$12$EfXPY4g72O6YTcgowbS9../vzXtlax.wLbC6ByXk4vs/6WK3e4JBy',NULL,'32 west Barrett hill rd',NULL,'2025-12-04 06:26:26','2025-12-04 06:28:42','Evan','Rossi','2025-12-04','1','8456084209',2,NULL,'1764807986_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(114,'kevful23@gmail.com',NULL,'$2y$12$GpqhnbQw01YrvvX1eaV5xO2r5MSS9SFxeh1UFukcj6v1hTJG6EgTW',NULL,'5030 Golden Fig Ln, Wimauma,Fl',NULL,'2025-12-04 19:40:49','2025-12-04 20:46:02','Kevin','Fuller','2025-12-04','1','8137288949',2,NULL,'1764855648_Screenshot (241).png',2,NULL,NULL,NULL,'active',NULL),
(115,'wolfbam123@gmail.com',NULL,'$2y$12$bFsDPBfiYVkkVFBpaLG.g.S/6Pf//ZjxLWfFPbp8yQ7a2AzwcDbNi',NULL,'13440 N 44th St','fD1dNV0wgIAa9h3M1jLHtvqf7Tj9CX3Ng5UTf60ThTdwIPn6UiBJRHCjDagb','2025-12-04 20:42:34','2025-12-04 20:45:49','Bryson','Modenessi','2025-12-04','1','6027069980',2,NULL,'1764859354_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(116,'eloisfullerllc@gmail.com',NULL,'$2y$12$c9qS/D/VQVs7t6J.8POoBOc1etfZDJCl4ryRmQO1MJT4L9s27hHB2',NULL,'471 NW 44 Ave',NULL,'2025-12-04 22:03:23','2025-12-05 02:05:25','Elois','Fuller','2025-12-04','1','9544449096',2,NULL,'1764864202_1000025553.jpg',2,NULL,NULL,NULL,'active',NULL),
(117,'jayyrod722@gmail.com',NULL,'$2y$12$711ZIkYwSoa2AxXd/OI/IeOP18XTHlk/hVlqM/HwMRgtZt66KB0X6',NULL,'954 villa de matel rd.','KvwAsDS8yj046f4nXRIHBcB0n1S1FUQnk0Iud61ghgCDoXCb31w8idCEJz3Q','2025-12-05 02:18:24','2025-12-05 02:34:53','Juan','Arriola','2025-12-04','1','3465547754',2,NULL,'1764879504_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(118,'zionmunroe313@gmail.com',NULL,'$2y$12$4Ixtyttv6fj5v9dFNcrI4uB/5gyLbNLx9/7h7.iriv3sgOnOcajCG',NULL,'Poplar Street, Nassau, Bahamas',NULL,'2025-12-05 02:33:21','2025-12-05 02:35:28','Zion','Munroe','2025-12-04','1','2428211165',2,NULL,'1764880401_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(119,'matthewmontero10@yahoo.com',NULL,'$2y$12$7.MCHbODD0HOR8i77TUVXOnOz3thAwFJ7R5MZlwxw/WPCUdjHbfHK',NULL,'3925 Omega Ln',NULL,'2025-12-05 02:47:37','2025-12-05 02:48:56','Matthew','Montero','2025-12-04','1','7866172731',2,NULL,'1764881257_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(120,'nelsonmakganye@gmail.com',NULL,'$2y$12$TB4bu/RuqQNtru6Amh6yweE9NUEozqjdhYoXoIORyG9QvUsLj9ZnO',NULL,'725 Ennerdale South',NULL,'2025-12-05 08:19:58','2025-12-05 09:34:31','Sibusiso','Makganye','2025-12-05','1','+27696950671',2,NULL,'1764901198_1000156046.jpg',2,NULL,NULL,NULL,'active',NULL),
(121,'shalamiyahh@gmail.com',NULL,'$2y$12$R3xzusb71T9RmCy2vQqKEOICQcIGPqelByduClzXTOVhggm.0AhQm',NULL,'2625 dewey st hollywood fl 33020',NULL,'2025-12-05 11:14:04','2025-12-05 22:55:44','Schelemia','Mangnant','2025-12-05','1','7542734983',2,NULL,'1764911644_IMG_0263.jpeg',2,NULL,NULL,NULL,'active',NULL),
(122,'elijah.armentor@gmail.com',NULL,'$2y$12$EYlUFXWNH/DkQr5MBGN2v.9XBoVOuONx3Ld3PKYDjA7VrGBewQJPG',NULL,'1413 Saint Charles street',NULL,'2025-12-05 11:16:47','2025-12-05 22:56:54','Elijah','Armentor','2025-12-05','1','3376800197',2,NULL,'1764911807_IMG_4411.jpeg',2,NULL,NULL,NULL,'active',NULL),
(123,'bmosss432@gmail.com',NULL,'$2y$12$AE7FdhWoZeunHgeZ1U/lIeP1uj2IiZUT2EbWxdbrlilzN2EWJlAd.',NULL,'14831 N 37th St','MfLQ32u7FXzSohd5b8br62P0xoeAGEGpD89fG3zLsUmqLA78fJxlb3wEzkYe','2025-12-06 07:22:24','2025-12-07 18:33:13','Blake','Moss','2025-12-06','1','6023633514',2,NULL,'1764984143_image.jpg',2,NULL,NULL,NULL,'active',NULL),
(124,'katukadinatu5@gmail.com',NULL,'$2y$12$8./GiSBVeux25FxxormpX.0ixaqNs/PDXLQdks3QsAJIuoPDhqUbq',NULL,'180 south 12 street newark nj','prWlvUlmFusNeU4hz0LyDdGO2VMxxdOYLpo50ZOaQfyDDS61RcLVZmYbE0TO','2025-12-06 11:06:23','2025-12-06 12:38:27','Dinatu','Oyatorisa','2025-12-06','1','6463310380',2,NULL,'1764997583_inbound5440118604183684801.jpg',1,NULL,NULL,NULL,'active',NULL),
(125,'doncashmere123@gmail.com',NULL,'$2y$12$JMG0mKHZd7qRJZmKDzzaret9Pd98TodDaCluHdlRDntXx4D1aDa3K',NULL,'16436 78th rd north',NULL,'2025-12-07 05:36:31','2025-12-07 18:33:29','Donald','Little','2025-12-06','1','7866961141',2,NULL,'1765064191_image_6487327.jpeg',2,NULL,NULL,NULL,'active',NULL),
(126,'kiripati.taua673@gmail.com',NULL,'$2y$12$IOS3WuU/Cl.yE3qfCUVdfemqGUg69SKNtud7kGZeaBuKiyPmZrrgu',NULL,'18 Mundarda Place',NULL,'2025-12-07 06:38:17','2025-12-07 18:33:32','Kiripati','Taua','2025-12-07','1','0416227922',2,NULL,'1765067897_IMG_1633.jpeg',2,NULL,'YQOODEK8_126',NULL,'active',NULL),
(127,'mercyndirangu2023@gmail.com',NULL,'$2y$12$6kRkUmZcw/2w/HTf7/Cqje13x8QjD4R3A9bi6xJEthKMnlTzUwAyW',NULL,'Lebanon',NULL,'2025-12-08 02:18:43','2025-12-08 02:44:24','Mercy','Nyambura','2025-12-07','1','+96171613404',2,NULL,'1765138723_1000008430.jpg',2,NULL,NULL,NULL,'active',NULL),
(128,'elizabethorganillo2@gmail.com',NULL,'$2y$12$M4NdeOieTAjBVVep2z41q.l2T5vYCWzJAf4omJh3VELYwXrtbn86C',NULL,'127 old roosa gap rd',NULL,'2025-12-08 05:19:12','2025-12-08 09:21:10','Elizabeth','Organillo','2025-12-07','1','8457797025',2,NULL,'1765149552_IMG_1331.jpeg',2,NULL,NULL,NULL,'active',NULL),
(129,'kodisangmohlala@gmail.com',NULL,'$2y$12$nz.CxtR6SU/12IX1/JYjZOI9kMitsqWHz7OH.aGZ7pdwcRfNvRKSO',NULL,'155 Pienaar street',NULL,'2025-12-08 06:28:59','2026-01-19 07:34:22','Warona','Mohlala','2025-12-08','1','0720813500',2,'profile-photos/N3aq4gNBxKh9yAtCFoj9VUFV9vp8rLl1Sstf2Eu3.png','1765153739_IMG_6364.jpeg',2,NULL,NULL,NULL,'active',NULL),
(130,'ismenia.darosa@gmail.com',NULL,'$2y$12$luCHz7u06zR8Ky0cpzhKI.THDOY18AcZWMnjwCj0qSp3n/BbuEhLm',NULL,'Praia, Santiago Cabo Verde',NULL,'2025-12-08 15:18:30','2025-12-08 15:18:30','Ismenia','Da Rosa','2025-12-08','1','998 63 36',2,NULL,'1765185510_WhatsApp Image 2025-12-08 at 8.16.04 AM.jpeg',1,NULL,NULL,NULL,'active',NULL),
(131,'info@thoth-technologies.ng',NULL,'$2y$12$ePPDyvFTaFe4XyCy0hiq5uyIGSwNXdTqD5EMaPriTz5hbt4nU8CuK',NULL,'Aperiam nobis volupt',NULL,'2026-01-15 16:36:26','2026-01-15 17:42:18','Jideonwo Felix','support@app.com',NULL,NULL,'+2349056653909',2,'profile-photos/oxZrn7xWP7yhqmvYkbzMzaPHgQVyx0CWTfAqe9s7.jpg','1768494985_nigeria-flag.png',1,NULL,NULL,NULL,'active',NULL),
(132,'pixefar@mailinator.com',NULL,'$2y$12$f1F/wYUFX1uLaZv8XJLLXOHFu0.jpSqUSY5Jo0jc8GEOltPI3vIde',NULL,'Minima sint expedita',NULL,'2026-01-16 12:02:47','2026-01-16 15:16:25','Bree','Crawford',NULL,NULL,'+1 (421) 567-5087',2,NULL,NULL,1,NULL,'U46Q5LK6_132','Aperiam harum autem','active',NULL);

/*Table structure for table `virtual_cards` */

DROP TABLE IF EXISTS `virtual_cards`;

CREATE TABLE `virtual_cards` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `card_number` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cvv` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiry_month` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiry_year` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `status` enum('active','inactive','frozen','pending') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `virtual_cards_card_number_unique` (`card_number`),
  KEY `virtual_cards_user_id_foreign` (`user_id`),
  CONSTRAINT `virtual_cards_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `virtual_cards` */

insert  into `virtual_cards`(`id`,`user_id`,`card_number`,`cvv`,`expiry_month`,`expiry_year`,`balance`,`status`,`created_at`,`updated_at`) values 
(1,132,'4006696323881177','147','01','2029',0.00,'inactive','2026-01-16 12:02:47','2026-01-16 12:02:47'),
(2,129,'4307767186600366','807','01','2029',0.00,'active','2026-01-19 06:45:32','2026-01-19 10:34:02');

/*Table structure for table `wallet_coins` */

DROP TABLE IF EXISTS `wallet_coins`;

CREATE TABLE `wallet_coins` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `wallet_id` bigint NOT NULL,
  `coin_id` bigint unsigned NOT NULL,
  `balance` decimal(40,18) NOT NULL DEFAULT '0.000000000000000000',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wallet_id` (`wallet_id`),
  KEY `coin_id` (`coin_id`),
  CONSTRAINT `wallet_coins_ibfk_1` FOREIGN KEY (`wallet_id`) REFERENCES `wallets` (`id`),
  CONSTRAINT `wallet_coins_ibfk_2` FOREIGN KEY (`coin_id`) REFERENCES `coins` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1398 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `wallet_coins` */

insert  into `wallet_coins`(`id`,`wallet_id`,`coin_id`,`balance`,`created_at`,`updated_at`,`deleted_at`) values 
(1,33,1,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(2,33,2,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(3,33,3,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(4,33,4,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(5,33,5,999999.000000000000000000,'2025-02-04 05:19:21','2025-02-25 09:34:41',NULL),
(6,33,6,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(7,33,7,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(8,33,8,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(9,33,9,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(10,33,10,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(11,33,11,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(12,33,12,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(13,33,13,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(14,33,14,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(15,33,15,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(16,33,16,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(17,33,17,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(18,33,18,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(19,33,19,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(20,33,20,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(21,33,21,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(22,33,22,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(23,33,23,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(24,33,24,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(25,33,25,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(26,33,26,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(27,33,27,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(28,33,28,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(29,33,29,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(30,33,30,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(31,33,31,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(32,33,32,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(33,33,33,0.000000000000000000,'2025-02-04 05:19:21','2025-02-04 05:19:21',NULL),
(34,34,1,21.120000000000000000,'2025-02-04 20:29:26','2025-02-05 03:45:55',NULL),
(35,34,2,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(36,34,3,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(37,34,4,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(38,34,5,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(39,34,6,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(40,34,7,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(41,34,8,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(42,34,9,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(43,34,10,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(44,34,11,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(45,34,12,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(46,34,13,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(47,34,14,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(48,34,15,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(49,34,16,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(50,34,17,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(51,34,18,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(52,34,19,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(53,34,20,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(54,34,21,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(55,34,22,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(56,34,23,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(57,34,24,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(58,34,25,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(59,34,26,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(60,34,27,700.000000000000000000,'2025-02-04 20:29:26','2025-02-04 21:37:31',NULL),
(61,34,28,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(62,34,29,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(63,34,30,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(64,34,31,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(65,34,32,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(66,34,33,0.000000000000000000,'2025-02-04 20:29:26','2025-02-04 20:29:26',NULL),
(67,35,1,10.000000000000000000,'2025-02-08 03:19:22','2025-03-04 09:38:16',NULL),
(68,35,2,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(69,35,3,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(70,35,4,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(71,35,5,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(72,35,6,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(73,35,7,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(74,35,8,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(75,35,9,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(76,35,10,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(77,35,11,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(78,35,12,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(79,35,13,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(80,35,14,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(81,35,15,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(82,35,16,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(83,35,17,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(84,35,18,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(85,35,19,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(86,35,20,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(87,35,21,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(88,35,22,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(89,35,23,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(90,35,24,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(91,35,25,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(92,35,26,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(93,35,27,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(94,35,28,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(95,35,29,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(96,35,30,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(97,35,31,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(98,35,32,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(99,35,33,0.000000000000000000,'2025-02-08 03:19:22','2025-02-08 03:19:22',NULL),
(100,36,1,456000.000000000000000000,'2025-02-08 06:43:11','2025-02-25 12:59:18',NULL),
(101,36,2,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(102,36,3,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(103,36,4,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(104,36,5,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(105,36,6,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(106,36,7,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(107,36,8,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(108,36,9,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(109,36,10,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(110,36,11,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(111,36,12,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(112,36,13,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(113,36,14,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(114,36,15,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(115,36,16,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(116,36,17,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(117,36,18,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(118,36,19,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(119,36,20,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(120,36,21,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(121,36,22,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(122,36,23,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(123,36,24,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(124,36,25,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(125,36,26,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(126,36,27,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(127,36,28,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(128,36,29,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(129,36,30,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(130,36,31,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(131,36,32,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(132,36,33,0.000000000000000000,'2025-02-08 06:43:11','2025-02-08 06:43:11',NULL),
(133,37,1,2.000000000000000000,'2025-02-08 10:33:50','2025-02-25 09:34:35',NULL),
(134,37,2,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(135,37,3,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(136,37,4,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(137,37,5,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(138,37,6,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(139,37,7,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(140,37,8,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(141,37,9,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(142,37,10,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(143,37,11,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(144,37,12,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(145,37,13,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(146,37,14,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(147,37,15,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(148,37,16,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(149,37,17,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(150,37,18,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(151,37,19,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(152,37,20,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(153,37,21,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(154,37,22,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(155,37,23,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(156,37,24,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(157,37,25,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(158,37,26,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(159,37,27,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(160,37,28,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(161,37,29,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(162,37,30,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(163,37,31,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(164,37,32,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(165,37,33,0.000000000000000000,'2025-02-08 10:33:50','2025-02-08 10:33:50',NULL),
(166,38,1,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(167,38,2,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(168,38,3,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(169,38,4,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(170,38,5,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(171,38,6,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(172,38,7,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(173,38,8,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(174,38,9,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(175,38,10,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(176,38,11,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(177,38,12,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(178,38,13,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(179,38,14,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(180,38,15,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(181,38,16,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(182,38,17,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(183,38,18,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(184,38,19,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(185,38,20,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(186,38,21,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(187,38,22,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(188,38,23,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(189,38,24,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(190,38,25,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(191,38,26,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(192,38,27,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(193,38,28,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(194,38,29,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(195,38,30,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(196,38,31,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(197,38,32,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(198,38,33,0.000000000000000000,'2025-02-08 10:47:25','2025-02-08 10:47:25',NULL),
(199,39,1,2000.000000000000000000,'2025-02-12 06:12:58','2025-02-21 07:33:21',NULL),
(200,39,2,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(201,39,3,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(202,39,4,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(203,39,5,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(204,39,6,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(205,39,7,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(206,39,8,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(207,39,9,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(208,39,10,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(209,39,11,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(210,39,12,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(211,39,13,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(212,39,14,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(213,39,15,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(214,39,16,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(215,39,17,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(216,39,18,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(217,39,19,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(218,39,20,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(219,39,21,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(220,39,22,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(221,39,23,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(222,39,24,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(223,39,25,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(224,39,26,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(225,39,27,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(226,39,28,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(227,39,29,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(228,39,30,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(229,39,31,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(230,39,32,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(231,39,33,0.000000000000000000,'2025-02-12 06:12:58','2025-02-12 06:12:58',NULL),
(232,40,1,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(233,40,2,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(234,40,3,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(235,40,4,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(236,40,5,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(237,40,6,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(238,40,7,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(239,40,8,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(240,40,9,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(241,40,10,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(242,40,11,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(243,40,12,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(244,40,13,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(245,40,14,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(246,40,15,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(247,40,16,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(248,40,17,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(249,40,18,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(250,40,19,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(251,40,20,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(252,40,21,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(253,40,22,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(254,40,23,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(255,40,24,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(256,40,25,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(257,40,26,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(258,40,27,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(259,40,28,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(260,40,29,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(261,40,30,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(262,40,31,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(263,40,32,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(264,40,33,0.000000000000000000,'2025-02-14 06:44:37','2025-02-14 06:44:37',NULL),
(265,41,1,2996000.000000000000000000,'2025-02-14 07:13:21','2025-02-25 05:00:20',NULL),
(266,41,2,196000.000000000000000000,'2025-02-14 07:13:21','2025-02-25 05:08:06',NULL),
(267,41,3,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(268,41,4,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(269,41,5,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(270,41,6,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(271,41,7,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(272,41,8,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(273,41,9,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(274,41,10,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(275,41,11,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(276,41,12,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(277,41,13,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(278,41,14,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(279,41,15,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(280,41,16,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(281,41,17,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(282,41,18,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(283,41,19,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(284,41,20,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(285,41,21,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(286,41,22,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(287,41,23,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(288,41,24,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(289,41,25,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(290,41,26,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(291,41,27,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(292,41,28,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(293,41,29,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(294,41,30,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(295,41,31,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(296,41,32,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(297,41,33,0.000000000000000000,'2025-02-14 07:13:21','2025-02-14 07:13:21',NULL),
(298,42,1,196000.000000000000000000,'2025-02-14 07:24:31','2025-02-22 04:21:52',NULL),
(299,42,2,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(300,42,3,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(301,42,4,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(302,42,5,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(303,42,6,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(304,42,7,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(305,42,8,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(306,42,9,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(307,42,10,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(308,42,11,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(309,42,12,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(310,42,13,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(311,42,14,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(312,42,15,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(313,42,16,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(314,42,17,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(315,42,18,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(316,42,19,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(317,42,20,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(318,42,21,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(319,42,22,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(320,42,23,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(321,42,24,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(322,42,25,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(323,42,26,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(324,42,27,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(325,42,28,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(326,42,29,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(327,42,30,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(328,42,31,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(329,42,32,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(330,42,33,0.000000000000000000,'2025-02-14 07:24:31','2025-02-14 07:24:31',NULL),
(331,43,1,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(332,43,2,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(333,43,3,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(334,43,4,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(335,43,5,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(336,43,6,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(337,43,7,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(338,43,8,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(339,43,9,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(340,43,10,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(341,43,11,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(342,43,12,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(343,43,13,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(344,43,14,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(345,43,15,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(346,43,16,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(347,43,17,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(348,43,18,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(349,43,19,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(350,43,20,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(351,43,21,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(352,43,22,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(353,43,23,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(354,43,24,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(355,43,25,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(356,43,26,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(357,43,27,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(358,43,28,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(359,43,29,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(360,43,30,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(361,43,31,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(362,43,32,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(363,43,33,0.000000000000000000,'2025-02-18 04:37:04','2025-02-18 04:37:04',NULL),
(364,44,1,0.950000000000000000,'2025-02-22 04:35:37','2025-03-19 07:47:05',NULL),
(365,44,2,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(366,44,3,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(367,44,4,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(368,44,5,20.000000000000000000,'2025-02-22 04:35:37','2025-03-12 10:37:22',NULL),
(369,44,6,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(370,44,7,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(371,44,8,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(372,44,9,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(373,44,10,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(374,44,11,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(375,44,12,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(376,44,13,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(377,44,14,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(378,44,15,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(379,44,16,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(380,44,17,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(381,44,18,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(382,44,19,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(383,44,20,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(384,44,21,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(385,44,22,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(386,44,23,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(387,44,24,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(388,44,25,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(389,44,26,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(390,44,27,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(391,44,28,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(392,44,29,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(393,44,30,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(394,44,31,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(395,44,32,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(396,44,33,0.000000000000000000,'2025-02-22 04:35:37','2025-02-22 04:35:37',NULL),
(397,45,1,28.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:43:03',NULL),
(398,45,2,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(399,45,3,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(400,45,4,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(401,45,5,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(402,45,6,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(403,45,7,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(404,45,8,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(405,45,9,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(406,45,10,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(407,45,11,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(408,45,12,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(409,45,13,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(410,45,14,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(411,45,15,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(412,45,16,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(413,45,17,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(414,45,18,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(415,45,19,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(416,45,20,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(417,45,21,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(418,45,22,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(419,45,23,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(420,45,24,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(421,45,25,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(422,45,26,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(423,45,27,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(424,45,28,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(425,45,29,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(426,45,30,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(427,45,31,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(428,45,32,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(429,45,33,0.000000000000000000,'2025-02-25 09:37:28','2025-02-25 09:37:28',NULL),
(430,46,1,4516.110000000000000000,'2025-02-26 06:11:23','2025-02-27 08:18:40',NULL),
(431,46,2,68900.000000000000000000,'2025-02-26 06:11:23','2025-09-07 18:47:31',NULL),
(432,46,3,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(433,46,4,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(434,46,5,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(435,46,6,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(436,46,7,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(437,46,8,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(438,46,9,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(439,46,10,10000.000000000000000000,'2025-02-26 06:11:23','2025-06-17 19:35:07',NULL),
(440,46,11,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(441,46,12,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(442,46,13,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(443,46,14,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(444,46,15,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(445,46,16,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(446,46,17,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(447,46,18,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(448,46,19,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(449,46,20,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(450,46,21,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(451,46,22,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(452,46,23,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(453,46,24,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(454,46,25,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(455,46,26,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(456,46,27,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(457,46,28,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(458,46,29,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(459,46,30,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(460,46,31,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(461,46,32,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(462,46,33,0.000000000000000000,'2025-02-26 06:11:23','2025-02-26 06:11:23',NULL),
(463,47,1,38333.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:23:01',NULL),
(464,47,2,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(465,47,3,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(466,47,4,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(467,47,5,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(468,47,6,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(469,47,7,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(470,47,8,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(471,47,9,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(472,47,10,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(473,47,11,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(474,47,12,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(475,47,13,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(476,47,14,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(477,47,15,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(478,47,16,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(479,47,17,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(480,47,18,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(481,47,19,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(482,47,20,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(483,47,21,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(484,47,22,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(485,47,23,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(486,47,24,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(487,47,25,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(488,47,26,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(489,47,27,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(490,47,28,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(491,47,29,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(492,47,30,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(493,47,31,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(494,47,32,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(495,47,33,0.000000000000000000,'2025-02-26 06:16:38','2025-02-26 06:16:38',NULL),
(496,48,1,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(497,48,2,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(498,48,3,5001.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:30:00',NULL),
(499,48,4,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(500,48,5,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(501,48,6,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(502,48,7,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(503,48,8,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(504,48,9,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(505,48,10,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(506,48,11,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(507,48,12,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(508,48,13,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(509,48,14,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(510,48,15,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(511,48,16,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(512,48,17,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(513,48,18,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(514,48,19,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(515,48,20,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(516,48,21,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(517,48,22,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(518,48,23,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(519,48,24,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(520,48,25,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(521,48,26,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(522,48,27,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(523,48,28,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(524,48,29,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(525,48,30,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(526,48,31,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(527,48,32,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(528,48,33,0.000000000000000000,'2025-02-26 06:29:24','2025-02-26 06:29:24',NULL),
(529,49,1,4.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:18:54',NULL),
(530,49,2,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(531,49,3,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(532,49,4,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(533,49,5,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(534,49,6,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(535,49,7,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(536,49,8,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(537,49,9,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(538,49,10,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(539,49,11,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(540,49,12,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(541,49,13,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(542,49,14,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(543,49,15,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(544,49,16,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(545,49,17,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(546,49,18,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(547,49,19,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(548,49,20,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(549,49,21,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(550,49,22,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(551,49,23,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(552,49,24,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(553,49,25,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(554,49,26,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(555,49,27,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(556,49,28,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(557,49,29,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(558,49,30,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(559,49,31,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(560,49,32,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(561,49,33,0.000000000000000000,'2025-02-26 07:17:14','2025-02-26 07:17:14',NULL),
(562,47,35,600.000000000000000000,'2025-02-26 08:32:54','2025-03-19 14:56:34',NULL),
(563,46,35,125763.718897540000000000,'2025-02-26 09:08:15','2025-06-18 01:06:50',NULL),
(564,50,1,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(565,50,2,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(566,50,3,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(567,50,4,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(568,50,5,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(569,50,6,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(570,50,7,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(571,50,8,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(572,50,9,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(573,50,10,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(574,50,11,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(575,50,12,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(576,50,13,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(577,50,14,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(578,50,15,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(579,50,16,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(580,50,17,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(581,50,18,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(582,50,19,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(583,50,20,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(584,50,21,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(585,50,22,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(586,50,23,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(587,50,24,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(588,50,25,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(589,50,26,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(590,50,27,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(591,50,28,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(592,50,29,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(593,50,30,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(594,50,31,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(595,50,32,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(596,50,33,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(597,50,35,0.000000000000000000,'2025-02-27 07:24:02','2025-02-27 07:24:02',NULL),
(598,24,1,-7999.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(599,24,2,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(600,24,3,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(601,24,4,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(602,24,5,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(603,24,6,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(604,24,7,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(605,24,8,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(606,24,9,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(607,24,10,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(608,24,11,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(609,24,12,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(610,24,13,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(611,24,14,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(612,24,15,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(613,24,16,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(614,24,17,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(615,24,18,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(616,24,19,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(617,24,20,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(618,24,21,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(619,24,22,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(620,24,23,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(621,24,24,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(622,24,25,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(623,24,26,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(624,24,27,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(625,24,28,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(626,24,29,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(627,24,30,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(628,24,31,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(629,24,32,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(630,24,33,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(631,24,35,0.000000000000000000,'2025-02-27 08:19:45','2025-02-27 08:19:45',NULL),
(632,51,1,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(633,51,2,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(634,51,3,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(635,51,4,600.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:25:12',NULL),
(636,51,5,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(637,51,6,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(638,51,7,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(639,51,8,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(640,51,9,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(641,51,10,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(642,51,11,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(643,51,12,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(644,51,13,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(645,51,14,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(646,51,15,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(647,51,16,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(648,51,17,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(649,51,18,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(650,51,19,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(651,51,20,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(652,51,21,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(653,51,22,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(654,51,23,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(655,51,24,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(656,51,25,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(657,51,26,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(658,51,27,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(659,51,28,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(660,51,29,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(661,51,30,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(662,51,31,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(663,51,32,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(664,51,33,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(665,51,35,0.000000000000000000,'2025-02-27 08:22:21','2025-02-27 08:22:21',NULL),
(666,52,1,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(667,52,2,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(668,52,3,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(669,52,4,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(670,52,5,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(671,52,6,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(672,52,7,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(673,52,8,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(674,52,9,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(675,52,10,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(676,52,11,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(677,52,12,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(678,52,13,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(679,52,14,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(680,52,15,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(681,52,16,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(682,52,17,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(683,52,18,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(684,52,19,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(685,52,20,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(686,52,21,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(687,52,22,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(688,52,23,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(689,52,24,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(690,52,25,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(691,52,26,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(692,52,27,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(693,52,28,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(694,52,29,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(695,52,30,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(696,52,31,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(697,52,32,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(698,52,33,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(699,52,35,0.000000000000000000,'2025-02-28 23:30:18','2025-02-28 23:30:18',NULL),
(700,53,1,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(701,53,2,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(702,53,3,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(703,53,4,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(704,53,5,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(705,53,6,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(706,53,7,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(707,53,8,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(708,53,9,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(709,53,10,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(710,53,11,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(711,53,12,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(712,53,13,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(713,53,14,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(714,53,15,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(715,53,16,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(716,53,17,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(717,53,18,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(718,53,19,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(719,53,20,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(720,53,21,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(721,53,22,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(722,53,23,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(723,53,24,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(724,53,25,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(725,53,26,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(726,53,27,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(727,53,28,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(728,53,29,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(729,53,30,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(730,53,31,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(731,53,32,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(732,53,33,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(733,53,35,0.000000000000000000,'2025-03-02 03:18:55','2025-03-02 03:18:55',NULL),
(734,35,35,1000.000000000000000000,'2025-03-04 09:28:09','2025-03-04 09:28:09',NULL),
(735,54,1,2.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:52:40',NULL),
(736,54,2,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(737,54,3,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(738,54,4,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(739,54,5,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(740,54,6,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(741,54,7,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(742,54,8,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(743,54,9,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(744,54,10,20.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:14:33',NULL),
(745,54,11,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(746,54,12,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(747,54,13,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(748,54,14,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(749,54,15,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(750,54,16,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(751,54,17,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(752,54,18,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(753,54,19,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(754,54,20,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(755,54,21,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(756,54,22,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(757,54,23,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(758,54,24,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(759,54,25,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(760,54,26,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(761,54,27,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(762,54,28,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(763,54,29,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(764,54,30,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(765,54,31,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(766,54,32,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(767,54,33,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(768,54,35,0.000000000000000000,'2025-03-05 08:13:31','2025-03-05 08:13:31',NULL),
(769,55,1,20000.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:58:10',NULL),
(770,55,2,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(771,55,3,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(772,55,4,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(773,55,5,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(774,55,6,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(775,55,7,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(776,55,8,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(777,55,9,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(778,55,10,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(779,55,11,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(780,55,12,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(781,55,13,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(782,55,14,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(783,55,15,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(784,55,16,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(785,55,17,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(786,55,18,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(787,55,19,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(788,55,20,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(789,55,21,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(790,55,22,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(791,55,23,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(792,55,24,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(793,55,25,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(794,55,26,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(795,55,27,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(796,55,28,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(797,55,29,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(798,55,30,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(799,55,31,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(800,55,32,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(801,55,33,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(802,55,35,0.000000000000000000,'2025-03-12 08:55:10','2025-03-12 08:55:10',NULL),
(803,44,35,0.000000000000000000,'2025-03-12 10:37:22','2025-03-12 10:37:22',NULL),
(804,56,1,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(805,56,2,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(806,56,3,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(807,56,4,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(808,56,5,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(809,56,6,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(810,56,7,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(811,56,8,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(812,56,9,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(813,56,10,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(814,56,11,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(815,56,12,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(816,56,13,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(817,56,14,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(818,56,15,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(819,56,16,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(820,56,17,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(821,56,18,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(822,56,19,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(823,56,20,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(824,56,21,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(825,56,22,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(826,56,23,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(827,56,24,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(828,56,25,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(829,56,26,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(830,56,27,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(831,56,28,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(832,56,29,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(833,56,30,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(834,56,31,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(835,56,32,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(836,56,33,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(837,56,35,0.000000000000000000,'2025-03-18 11:24:44','2025-03-18 11:24:44',NULL),
(838,57,1,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(839,57,2,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(840,57,3,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(841,57,4,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(842,57,5,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(843,57,6,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(844,57,7,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(845,57,8,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(846,57,9,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(847,57,10,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(848,57,11,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(849,57,12,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(850,57,13,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(851,57,14,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(852,57,15,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(853,57,16,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(854,57,17,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(855,57,18,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(856,57,19,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(857,57,20,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(858,57,21,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(859,57,22,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(860,57,23,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(861,57,24,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(862,57,25,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(863,57,26,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(864,57,27,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(865,57,28,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(866,57,29,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(867,57,30,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(868,57,31,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(869,57,32,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(870,57,33,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(871,57,35,0.000000000000000000,'2025-03-18 11:34:31','2025-03-18 11:34:31',NULL),
(872,58,1,4.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:39:51',NULL),
(873,58,2,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(874,58,3,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(875,58,4,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(876,58,5,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(877,58,6,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(878,58,7,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(879,58,8,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(880,58,9,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(881,58,10,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(882,58,11,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(883,58,12,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(884,58,13,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(885,58,14,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(886,58,15,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(887,58,16,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(888,58,17,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(889,58,18,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(890,58,19,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(891,58,20,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(892,58,21,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(893,58,22,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(894,58,23,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(895,58,24,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(896,58,25,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(897,58,26,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(898,58,27,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(899,58,28,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(900,58,29,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(901,58,30,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(902,58,31,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(903,58,32,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(904,58,33,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(905,58,35,0.000000000000000000,'2025-03-19 06:29:04','2025-03-19 06:29:04',NULL),
(906,59,1,4312.000000000000000000,'2025-05-23 09:11:56','2025-05-24 18:02:29',NULL),
(907,59,2,5000.000000000000000000,'2025-05-23 09:11:56','2025-05-23 10:09:23',NULL),
(908,59,3,60000.000000000000000000,'2025-05-23 09:11:56','2025-05-23 10:09:37',NULL),
(909,59,4,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(910,59,5,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(911,59,6,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(912,59,7,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(913,59,8,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(914,59,9,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(915,59,10,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(916,59,11,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(917,59,12,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(918,59,13,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(919,59,14,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(920,59,15,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(921,59,16,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(922,59,17,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(923,59,18,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(924,59,19,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(925,59,20,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(926,59,21,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(927,59,22,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(928,59,23,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(929,59,24,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(930,59,25,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(931,59,26,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(932,59,27,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(933,59,28,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(934,59,29,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(935,59,30,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(936,59,31,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(937,59,32,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(938,59,33,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(939,59,35,0.000000000000000000,'2025-05-23 09:11:56','2025-05-23 09:11:56',NULL),
(940,60,1,788.821269071630000000,'2025-06-11 21:40:22','2025-08-25 21:50:20',NULL),
(941,60,2,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(942,60,3,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(943,60,4,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(944,60,5,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(945,60,6,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(946,60,7,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(947,60,8,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(948,60,9,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(949,60,10,931.034482758630000000,'2025-06-11 21:40:22','2025-08-25 19:45:01',NULL),
(950,60,11,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(951,60,12,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(952,60,13,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(953,60,14,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(954,60,15,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(955,60,16,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(956,60,17,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(957,60,18,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(958,60,19,4.074505238649600000,'2025-06-11 21:40:22','2025-08-25 20:00:29',NULL),
(959,60,20,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(960,60,21,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(961,60,22,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(962,60,23,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(963,60,24,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(964,60,25,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(965,60,26,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(966,60,27,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(967,60,28,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(968,60,29,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(969,60,30,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(970,60,31,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(971,60,32,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(972,60,33,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(973,60,35,0.000000000000000000,'2025-06-11 21:40:22','2025-06-11 21:40:22',NULL),
(974,61,1,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(975,61,2,68900.000000000000000000,'2025-06-13 22:25:42','2025-09-07 18:47:37',NULL),
(976,61,3,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(977,61,4,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(978,61,5,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(979,61,6,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(980,61,7,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(981,61,8,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(982,61,9,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(983,61,10,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(984,61,11,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(985,61,12,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(986,61,13,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(987,61,14,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(988,61,15,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(989,61,16,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(990,61,17,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(991,61,18,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(992,61,19,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(993,61,20,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(994,61,21,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(995,61,22,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(996,61,23,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(997,61,24,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(998,61,25,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(999,61,26,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(1000,61,27,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(1001,61,28,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(1002,61,29,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(1003,61,30,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(1004,61,31,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(1005,61,32,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(1006,61,33,0.000000000000000000,'2025-06-13 22:25:42','2025-06-13 22:25:42',NULL),
(1007,61,35,248490.000000000000000000,'2025-06-13 22:25:42','2025-06-27 09:40:07',NULL),
(1008,62,1,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1009,62,2,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1010,62,3,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1011,62,4,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1012,62,5,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1013,62,6,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1014,62,7,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1015,62,8,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1016,62,9,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1017,62,10,114560.344827588000000000,'2025-06-17 03:23:25','2025-09-07 23:08:21',NULL),
(1018,62,11,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1019,62,12,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1020,62,13,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1021,62,14,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1022,62,15,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1023,62,16,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1024,62,17,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1025,62,18,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1026,62,19,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1027,62,20,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1028,62,21,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1029,62,22,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1030,62,23,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1031,62,24,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1032,62,25,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1033,62,26,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1034,62,27,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1035,62,28,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1036,62,29,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1037,62,30,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1038,62,31,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1039,62,32,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1040,62,33,0.000000000000000000,'2025-06-17 03:23:25','2025-06-17 03:23:25',NULL),
(1041,62,35,267415.500000000000000000,'2025-06-17 03:23:25','2025-09-10 08:44:32',NULL),
(1042,63,1,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1043,63,2,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1044,63,3,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1045,63,4,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1046,63,5,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1047,63,6,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1048,63,7,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1049,63,8,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1050,63,9,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1051,63,10,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1052,63,11,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1053,63,12,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1054,63,13,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1055,63,14,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1056,63,15,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1057,63,16,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1058,63,17,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1059,63,18,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1060,63,19,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1061,63,20,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1062,63,21,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1063,63,22,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1064,63,23,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1065,63,24,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1066,63,25,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1067,63,26,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1068,63,27,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1069,63,28,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1070,63,29,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1071,63,30,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1072,63,31,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1073,63,32,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1074,63,33,0.000000000000000000,'2025-06-20 22:44:40','2025-06-20 22:44:40',NULL),
(1075,63,35,28450.000000000000000000,'2025-06-20 22:44:40','2025-09-07 22:31:45',NULL),
(1076,64,1,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1077,64,2,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1078,64,3,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1079,64,4,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1080,64,5,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1081,64,6,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1082,64,7,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1083,64,8,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1084,64,9,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1085,64,10,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1086,64,11,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1087,64,12,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1088,64,13,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1089,64,14,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1090,64,15,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1091,64,16,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1092,64,17,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1093,64,18,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1094,64,19,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1095,64,20,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1096,64,21,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1097,64,22,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1098,64,23,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1099,64,24,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1100,64,25,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1101,64,26,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1102,64,27,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1103,64,28,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1104,64,29,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1105,64,30,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1106,64,31,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1107,64,32,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1108,64,33,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1109,64,35,0.000000000000000000,'2025-06-21 00:57:11','2025-06-21 00:57:11',NULL),
(1110,65,1,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1111,65,2,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1112,65,3,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1113,65,4,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1114,65,5,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1115,65,6,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1116,65,7,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1117,65,8,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1118,65,9,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1119,65,10,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1120,65,11,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1121,65,12,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1122,65,13,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1123,65,14,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1124,65,15,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1125,65,16,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1126,65,17,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1127,65,18,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1128,65,19,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1129,65,20,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1130,65,21,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1131,65,22,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1132,65,23,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1133,65,24,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1134,65,25,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1135,65,26,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1136,65,27,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1137,65,28,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1138,65,29,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1139,65,30,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1140,65,31,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1141,65,32,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1142,65,33,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1143,65,35,0.000000000000000000,'2025-06-21 10:39:18','2025-06-21 10:39:18',NULL),
(1144,16,35,90000.000000000000000000,'2025-11-24 14:10:51','2025-11-24 14:10:51',NULL),
(1145,66,1,0.000911427477715600,'2025-11-25 01:07:53','2025-11-25 02:22:29',NULL),
(1146,66,2,665.000000000000000000,'2025-11-25 01:07:53','2025-11-25 02:41:42',NULL),
(1147,66,4,0.000000000000000000,'2025-11-25 01:07:53','2025-11-25 01:07:53',NULL),
(1148,66,35,33909.000000000000000000,'2025-11-25 01:07:53','2025-12-03 10:16:10',NULL),
(1149,67,1,0.000000000000000000,'2025-11-25 06:23:54','2025-11-25 06:23:54',NULL),
(1150,67,2,0.000000000000000000,'2025-11-25 06:23:54','2025-11-25 06:23:54',NULL),
(1151,67,4,0.000000000000000000,'2025-11-25 06:23:54','2025-11-25 06:23:54',NULL),
(1152,67,35,17.380000000000000000,'2025-11-25 06:23:54','2025-11-25 08:05:40',NULL),
(1153,68,1,0.000000000000000000,'2025-11-25 23:17:29','2025-11-25 23:17:29',NULL),
(1154,68,2,0.000000000000000000,'2025-11-25 23:17:29','2025-11-25 23:17:29',NULL),
(1155,68,4,0.000000000000000000,'2025-11-25 23:17:29','2025-11-25 23:17:29',NULL),
(1156,68,35,0.000000000000000000,'2025-11-25 23:17:29','2025-11-25 23:17:29',NULL),
(1157,69,1,0.000000000000000000,'2025-11-26 01:22:02','2025-11-26 01:22:02',NULL),
(1158,69,2,0.000000000000000000,'2025-11-26 01:22:02','2025-11-26 01:22:02',NULL),
(1159,69,4,0.000000000000000000,'2025-11-26 01:22:02','2025-11-26 01:22:02',NULL),
(1160,69,35,0.000000000000000000,'2025-11-26 01:22:02','2025-11-26 01:22:02',NULL),
(1161,70,1,0.000000000000000000,'2025-11-26 06:47:52','2025-11-26 06:47:52',NULL),
(1162,70,2,0.000000000000000000,'2025-11-26 06:47:52','2025-11-26 06:47:52',NULL),
(1163,70,4,0.000000000000000000,'2025-11-26 06:47:52','2025-11-26 06:47:52',NULL),
(1164,70,35,0.000000000000000000,'2025-11-26 06:47:52','2025-11-26 06:47:52',NULL),
(1165,71,1,0.000000000000000000,'2025-11-26 08:43:30','2025-11-26 08:43:30',NULL),
(1166,71,2,0.000000000000000000,'2025-11-26 08:43:30','2025-11-26 08:43:30',NULL),
(1167,71,4,0.000000000000000000,'2025-11-26 08:43:30','2025-11-26 08:43:30',NULL),
(1168,71,35,0.000000000000000000,'2025-11-26 08:43:30','2025-11-26 08:43:30',NULL),
(1169,72,1,0.000000000000000000,'2025-11-26 09:34:55','2025-11-26 09:34:55',NULL),
(1170,72,2,0.000000000000000000,'2025-11-26 09:34:55','2025-11-26 09:34:55',NULL),
(1171,72,4,0.000000000000000000,'2025-11-26 09:34:55','2025-11-26 09:34:55',NULL),
(1172,72,35,0.000000000000000000,'2025-11-26 09:34:55','2025-11-26 09:34:55',NULL),
(1173,73,1,131.000000000000000000,'2025-11-26 10:13:23','2025-11-29 07:55:16',NULL),
(1174,73,2,0.000000000000000000,'2025-11-26 10:13:23','2025-11-26 10:13:23',NULL),
(1175,73,4,0.000000000000000000,'2025-11-26 10:13:23','2025-11-26 10:13:23',NULL),
(1176,73,35,0.000000000000000000,'2025-11-26 10:13:23','2025-11-26 10:13:23',NULL),
(1177,74,1,0.000000000000000000,'2025-11-26 10:16:39','2025-11-26 10:16:39',NULL),
(1178,74,2,0.000000000000000000,'2025-11-26 10:16:39','2025-11-26 10:16:39',NULL),
(1179,74,4,0.000000000000000000,'2025-11-26 10:16:39','2025-11-26 10:16:39',NULL),
(1180,74,35,0.000000000000000000,'2025-11-26 10:16:39','2025-11-26 10:16:39',NULL),
(1181,75,1,0.000000000000000000,'2025-11-27 13:50:46','2025-11-27 13:50:46',NULL),
(1182,75,2,0.000000000000000000,'2025-11-27 13:50:46','2025-11-27 13:50:46',NULL),
(1183,75,4,0.000000000000000000,'2025-11-27 13:50:46','2025-11-27 13:50:46',NULL),
(1184,75,35,32.876700000000000000,'2025-11-27 13:50:46','2025-12-05 02:53:47',NULL),
(1185,76,1,0.000000000000000000,'2025-11-27 14:56:49','2025-11-27 14:56:49',NULL),
(1186,76,2,0.000000000000000000,'2025-11-27 14:56:49','2025-11-27 14:56:49',NULL),
(1187,76,4,0.000000000000000000,'2025-11-27 14:56:49','2025-11-27 14:56:49',NULL),
(1188,76,35,0.000000000000000000,'2025-11-27 14:56:49','2025-11-27 14:56:49',NULL),
(1189,77,1,0.000000000000000000,'2025-11-28 03:31:08','2025-11-28 03:31:08',NULL),
(1190,77,2,0.000000000000000000,'2025-11-28 03:31:08','2025-11-28 03:31:08',NULL),
(1191,77,4,0.000000000000000000,'2025-11-28 03:31:08','2025-11-28 03:31:08',NULL),
(1192,77,35,0.000000000000000000,'2025-11-28 03:31:08','2025-11-28 03:31:08',NULL),
(1193,78,1,420.000000000000000000,'2025-11-28 07:46:03','2025-11-29 00:48:53',NULL),
(1194,78,2,0.000000000000000000,'2025-11-28 07:46:03','2025-11-28 07:46:03',NULL),
(1195,78,4,0.000000000000000000,'2025-11-28 07:46:03','2025-11-28 07:46:03',NULL),
(1196,78,35,0.000000000000000000,'2025-11-28 07:46:03','2025-11-28 07:46:03',NULL),
(1197,79,1,0.000000000000000000,'2025-11-28 09:48:38','2025-11-28 09:48:38',NULL),
(1198,79,2,0.000000000000000000,'2025-11-28 09:48:38','2025-11-28 09:48:38',NULL),
(1199,79,4,0.000000000000000000,'2025-11-28 09:48:38','2025-11-28 09:48:38',NULL),
(1200,79,35,0.000000000000000000,'2025-11-28 09:48:38','2025-11-28 09:48:38',NULL),
(1201,80,1,0.001002570225487200,'2025-11-29 06:43:41','2025-12-01 03:32:50',NULL),
(1202,80,2,0.000000000000000000,'2025-11-29 06:43:41','2025-11-29 06:43:41',NULL),
(1203,80,4,0.000000000000000000,'2025-11-29 06:43:41','2025-11-29 06:43:41',NULL),
(1204,80,35,3995.160000000000000000,'2025-11-29 06:43:41','2025-12-04 06:41:27',NULL),
(1205,81,1,0.000000000000000000,'2025-11-29 07:41:30','2025-11-29 07:41:30',NULL),
(1206,81,2,0.000000000000000000,'2025-11-29 07:41:30','2025-11-29 07:41:30',NULL),
(1207,81,4,0.000000000000000000,'2025-11-29 07:41:30','2025-11-29 07:41:30',NULL),
(1208,81,35,0.000000000000000000,'2025-11-29 07:41:30','2025-11-29 07:41:30',NULL),
(1209,82,1,0.000000000000000000,'2025-11-29 08:28:15','2025-11-29 08:28:15',NULL),
(1210,82,2,0.000000000000000000,'2025-11-29 08:28:15','2025-11-29 08:28:15',NULL),
(1211,82,4,0.000000000000000000,'2025-11-29 08:28:15','2025-11-29 08:28:15',NULL),
(1212,82,35,0.000000000000000000,'2025-11-29 08:28:15','2025-11-29 08:28:15',NULL),
(1213,83,1,0.000000000000000000,'2025-11-29 08:40:44','2025-11-29 08:40:44',NULL),
(1214,83,2,0.000000000000000000,'2025-11-29 08:40:44','2025-11-29 08:40:44',NULL),
(1215,83,4,0.000000000000000000,'2025-11-29 08:40:44','2025-11-29 08:40:44',NULL),
(1216,83,35,0.000000000000000000,'2025-11-29 08:40:44','2025-11-29 08:40:44',NULL),
(1217,84,1,0.000000000000000000,'2025-11-29 13:32:12','2025-11-29 13:32:12',NULL),
(1218,84,2,0.000000000000000000,'2025-11-29 13:32:12','2025-11-29 13:32:12',NULL),
(1219,84,4,0.000000000000000000,'2025-11-29 13:32:12','2025-11-29 13:32:12',NULL),
(1220,84,35,537.000000000000000000,'2025-11-29 13:32:12','2025-12-05 10:46:26',NULL),
(1221,85,1,0.000000000000000000,'2025-11-29 16:04:48','2025-11-29 16:04:48',NULL),
(1222,85,2,0.000000000000000000,'2025-11-29 16:04:48','2025-11-29 16:04:48',NULL),
(1223,85,4,0.000000000000000000,'2025-11-29 16:04:48','2025-11-29 16:04:48',NULL),
(1224,85,35,0.000000000000000000,'2025-11-29 16:04:48','2025-11-29 16:04:48',NULL),
(1225,86,1,0.000000000000000000,'2025-11-30 08:38:28','2025-11-30 08:38:28',NULL),
(1226,86,2,0.000000000000000000,'2025-11-30 08:38:28','2025-11-30 08:38:28',NULL),
(1227,86,4,0.000000000000000000,'2025-11-30 08:38:28','2025-11-30 08:38:28',NULL),
(1228,86,35,0.000000000000000000,'2025-11-30 08:38:28','2025-11-30 08:38:28',NULL),
(1229,87,1,9386.328587834000000000,'2025-11-30 10:17:42','2025-11-30 10:27:30',NULL),
(1230,87,2,0.000000000000000000,'2025-11-30 10:17:42','2025-11-30 10:17:42',NULL),
(1231,87,4,0.000000000000000000,'2025-11-30 10:17:42','2025-11-30 10:17:42',NULL),
(1232,87,35,1800.000000000000000000,'2025-11-30 10:17:42','2025-12-07 00:24:13',NULL),
(1233,88,1,0.000000000000000000,'2025-12-01 04:05:07','2025-12-01 04:05:07',NULL),
(1234,88,2,0.000000000000000000,'2025-12-01 04:05:07','2025-12-01 04:05:07',NULL),
(1235,88,4,0.000000000000000000,'2025-12-01 04:05:07','2025-12-01 04:05:07',NULL),
(1236,88,35,0.000000000000000000,'2025-12-01 04:05:07','2025-12-01 04:05:07',NULL),
(1237,89,1,0.000000000000000000,'2025-12-01 12:08:54','2025-12-01 12:08:54',NULL),
(1238,89,2,0.000000000000000000,'2025-12-01 12:08:54','2025-12-01 12:08:54',NULL),
(1239,89,4,0.000000000000000000,'2025-12-01 12:08:54','2025-12-01 12:08:54',NULL),
(1240,89,35,0.000000000000000000,'2025-12-01 12:08:54','2025-12-01 12:08:54',NULL),
(1241,90,1,0.005295575931023230,'2025-12-02 05:01:38','2025-12-08 11:17:42',NULL),
(1242,90,2,0.000000000000000000,'2025-12-02 05:01:38','2025-12-02 05:01:38',NULL),
(1243,90,4,0.000000000000000000,'2025-12-02 05:01:38','2025-12-02 05:01:38',NULL),
(1244,90,35,846.000000000000000000,'2025-12-02 05:01:38','2025-12-03 10:15:19',NULL),
(1245,91,1,0.000000000000000000,'2025-12-02 05:10:15','2025-12-02 05:10:15',NULL),
(1246,91,2,0.000000000000000000,'2025-12-02 05:10:15','2025-12-02 05:10:15',NULL),
(1247,91,4,0.000000000000000000,'2025-12-02 05:10:15','2025-12-02 05:10:15',NULL),
(1248,91,35,0.000000000000000000,'2025-12-02 05:10:15','2025-12-02 05:10:15',NULL),
(1249,92,1,0.000000000000000000,'2025-12-02 06:10:56','2025-12-02 06:10:56',NULL),
(1250,92,2,0.000000000000000000,'2025-12-02 06:10:56','2025-12-02 06:10:56',NULL),
(1251,92,4,0.000000000000000000,'2025-12-02 06:10:56','2025-12-02 06:10:56',NULL),
(1252,92,35,0.000000000000000000,'2025-12-02 06:10:56','2025-12-06 06:15:44',NULL),
(1253,93,1,0.000000000000000000,'2025-12-02 10:50:46','2025-12-02 10:50:46',NULL),
(1254,93,2,0.000000000000000000,'2025-12-02 10:50:46','2025-12-02 10:50:46',NULL),
(1255,93,4,0.000000000000000000,'2025-12-02 10:50:46','2025-12-02 10:50:46',NULL),
(1256,93,35,99.000000000000000000,'2025-12-02 10:50:46','2025-12-06 11:45:51',NULL),
(1257,94,1,0.000000000000000000,'2025-12-02 19:00:47','2025-12-02 19:00:47',NULL),
(1258,94,2,0.000000000000000000,'2025-12-02 19:00:47','2025-12-02 19:00:47',NULL),
(1259,94,4,0.000000000000000000,'2025-12-02 19:00:47','2025-12-02 19:00:47',NULL),
(1260,94,35,0.000000000000000000,'2025-12-02 19:00:47','2025-12-02 19:00:47',NULL),
(1261,95,1,0.000000000000000000,'2025-12-02 20:09:03','2025-12-02 20:09:03',NULL),
(1262,95,2,0.000000000000000000,'2025-12-02 20:09:03','2025-12-02 20:09:03',NULL),
(1263,95,4,0.000000000000000000,'2025-12-02 20:09:03','2025-12-02 20:09:03',NULL),
(1264,95,35,0.000000000000000000,'2025-12-02 20:09:03','2025-12-02 20:09:03',NULL),
(1265,96,1,0.000000000000000000,'2025-12-02 21:09:16','2025-12-02 21:09:16',NULL),
(1266,96,2,0.000000000000000000,'2025-12-02 21:09:16','2025-12-02 21:09:16',NULL),
(1267,96,4,0.000000000000000000,'2025-12-02 21:09:16','2025-12-02 21:09:16',NULL),
(1268,96,35,0.000000000000000000,'2025-12-02 21:09:16','2025-12-02 21:09:16',NULL),
(1269,97,1,0.000000000000000000,'2025-12-02 22:23:51','2025-12-02 22:23:51',NULL),
(1270,97,2,0.000000000000000000,'2025-12-02 22:23:51','2025-12-02 22:23:51',NULL),
(1271,97,4,0.000000000000000000,'2025-12-02 22:23:51','2025-12-02 22:23:51',NULL),
(1272,97,35,0.000000000000000000,'2025-12-02 22:23:51','2025-12-02 22:23:51',NULL),
(1273,98,1,0.000000000000000000,'2025-12-03 03:17:49','2025-12-03 03:17:49',NULL),
(1274,98,2,0.000000000000000000,'2025-12-03 03:17:49','2025-12-03 03:17:49',NULL),
(1275,98,4,0.000000000000000000,'2025-12-03 03:17:49','2025-12-03 03:17:49',NULL),
(1276,98,35,0.000000000000000000,'2025-12-03 03:17:49','2025-12-03 03:17:49',NULL),
(1277,99,1,0.000000000000000000,'2025-12-03 07:16:25','2025-12-03 07:16:25',NULL),
(1278,99,2,0.000000000000000000,'2025-12-03 07:16:25','2025-12-03 07:16:25',NULL),
(1279,99,4,0.000000000000000000,'2025-12-03 07:16:25','2025-12-03 07:16:25',NULL),
(1280,99,35,0.000000000000000000,'2025-12-03 07:16:25','2025-12-03 07:16:25',NULL),
(1281,100,1,0.000000000000000000,'2025-12-03 08:20:43','2025-12-03 08:20:43',NULL),
(1282,100,2,0.000000000000000000,'2025-12-03 08:20:43','2025-12-03 08:20:43',NULL),
(1283,100,4,0.000000000000000000,'2025-12-03 08:20:43','2025-12-03 08:20:43',NULL),
(1284,100,35,0.000000000000000000,'2025-12-03 08:20:43','2025-12-03 08:20:43',NULL),
(1285,101,1,0.000000000000000000,'2025-12-03 09:10:26','2025-12-03 09:10:26',NULL),
(1286,101,2,0.000000000000000000,'2025-12-03 09:10:26','2025-12-03 09:10:26',NULL),
(1287,101,4,0.000000000000000000,'2025-12-03 09:10:26','2025-12-03 09:10:26',NULL),
(1288,101,35,0.000000000000000000,'2025-12-03 09:10:26','2025-12-03 09:10:26',NULL),
(1289,102,1,0.000000000000000000,'2025-12-03 18:38:18','2025-12-03 18:38:18',NULL),
(1290,102,2,0.000000000000000000,'2025-12-03 18:38:18','2025-12-03 18:38:18',NULL),
(1291,102,4,0.000000000000000000,'2025-12-03 18:38:18','2025-12-03 18:38:18',NULL),
(1292,102,35,0.000000000000000000,'2025-12-03 18:38:18','2025-12-03 18:38:18',NULL),
(1293,103,1,0.000000000000000000,'2025-12-03 23:46:18','2025-12-03 23:46:18',NULL),
(1294,103,2,0.000000000000000000,'2025-12-03 23:46:18','2025-12-03 23:46:18',NULL),
(1295,103,4,0.000000000000000000,'2025-12-03 23:46:18','2025-12-03 23:46:18',NULL),
(1296,103,35,0.000000000000000000,'2025-12-03 23:46:18','2025-12-03 23:46:18',NULL),
(1297,104,1,0.000000000000000000,'2025-12-04 00:35:40','2025-12-04 00:35:40',NULL),
(1298,104,2,0.000000000000000000,'2025-12-04 00:35:40','2025-12-04 00:35:40',NULL),
(1299,104,4,0.000000000000000000,'2025-12-04 00:35:40','2025-12-04 00:35:40',NULL),
(1300,104,35,0.000000000000000000,'2025-12-04 00:35:40','2025-12-04 00:35:40',NULL),
(1301,105,1,0.000000000000000000,'2025-12-04 06:18:59','2025-12-04 06:18:59',NULL),
(1302,105,2,0.000000000000000000,'2025-12-04 06:18:59','2025-12-04 06:18:59',NULL),
(1303,105,4,0.000000000000000000,'2025-12-04 06:18:59','2025-12-04 06:18:59',NULL),
(1304,105,35,0.000000000000000000,'2025-12-04 06:18:59','2025-12-04 06:18:59',NULL),
(1305,106,1,0.000000000000000000,'2025-12-04 06:26:26','2025-12-04 06:26:26',NULL),
(1306,106,2,0.000000000000000000,'2025-12-04 06:26:26','2025-12-04 06:26:26',NULL),
(1307,106,4,0.000000000000000000,'2025-12-04 06:26:26','2025-12-04 06:26:26',NULL),
(1308,106,35,0.000000000000000000,'2025-12-04 06:26:26','2025-12-04 06:26:26',NULL),
(1309,107,1,0.000911427477715600,'2025-12-04 19:40:49','2025-12-05 22:58:24',NULL),
(1310,107,2,0.000000000000000000,'2025-12-04 19:40:49','2025-12-04 19:40:49',NULL),
(1311,107,4,0.000000000000000000,'2025-12-04 19:40:49','2025-12-04 19:40:49',NULL),
(1312,107,35,100.000000000000000000,'2025-12-04 19:40:49','2025-12-05 22:59:04',NULL),
(1313,108,1,0.004046738001057300,'2025-12-04 20:42:34','2025-12-04 22:59:36',NULL),
(1314,108,2,0.000000000000000000,'2025-12-04 20:42:34','2025-12-04 20:42:34',NULL),
(1315,108,4,0.000000000000000000,'2025-12-04 20:42:34','2025-12-04 20:42:34',NULL),
(1316,108,35,0.000000000000000000,'2025-12-04 20:42:34','2025-12-04 20:42:34',NULL),
(1317,109,1,0.000000000000000000,'2025-12-04 22:03:23','2025-12-04 22:03:23',NULL),
(1318,109,2,0.000000000000000000,'2025-12-04 22:03:23','2025-12-04 22:03:23',NULL),
(1319,109,4,0.000000000000000000,'2025-12-04 22:03:23','2025-12-04 22:03:23',NULL),
(1320,109,35,0.000000000000000000,'2025-12-04 22:03:23','2025-12-04 22:03:23',NULL),
(1321,110,1,0.000000000000000000,'2025-12-05 02:18:24','2025-12-05 02:18:24',NULL),
(1322,110,2,0.000000000000000000,'2025-12-05 02:18:24','2025-12-05 02:18:24',NULL),
(1323,110,4,0.000000000000000000,'2025-12-05 02:18:24','2025-12-05 02:18:24',NULL),
(1324,110,35,0.000000000000000000,'2025-12-05 02:18:24','2025-12-05 02:18:24',NULL),
(1325,111,1,0.000000000000000000,'2025-12-05 02:33:21','2025-12-05 02:33:21',NULL),
(1326,111,2,0.000000000000000000,'2025-12-05 02:33:21','2025-12-05 02:33:21',NULL),
(1327,111,4,0.000000000000000000,'2025-12-05 02:33:21','2025-12-05 02:33:21',NULL),
(1328,111,35,493.800000000000000000,'2025-12-05 02:33:21','2025-12-05 10:41:19',NULL),
(1329,112,1,0.000000000000000000,'2025-12-05 02:47:37','2025-12-05 02:47:37',NULL),
(1330,112,2,0.000000000000000000,'2025-12-05 02:47:37','2025-12-05 02:47:37',NULL),
(1331,112,4,0.000000000000000000,'2025-12-05 02:47:37','2025-12-05 02:47:37',NULL),
(1332,112,35,151.000000000000000000,'2025-12-05 02:47:37','2025-12-05 03:19:57',NULL),
(1333,113,1,0.000000000000000000,'2025-12-05 08:19:58','2025-12-05 08:19:58',NULL),
(1334,113,2,0.000000000000000000,'2025-12-05 08:19:58','2025-12-05 08:19:58',NULL),
(1335,113,4,0.000000000000000000,'2025-12-05 08:19:58','2025-12-05 08:19:58',NULL),
(1336,113,35,0.000000000000000000,'2025-12-05 08:19:58','2025-12-05 08:19:58',NULL),
(1337,113,37,0.000000000000000000,'2025-12-05 08:19:58','2025-12-05 08:19:58',NULL),
(1338,114,1,0.000000000000000000,'2025-12-05 11:14:04','2025-12-05 11:14:04',NULL),
(1339,114,2,0.000000000000000000,'2025-12-05 11:14:04','2025-12-05 11:14:04',NULL),
(1340,114,4,0.000000000000000000,'2025-12-05 11:14:04','2025-12-05 11:14:04',NULL),
(1341,114,35,0.000000000000000000,'2025-12-05 11:14:04','2025-12-05 11:14:04',NULL),
(1342,114,37,0.000000000000000000,'2025-12-05 11:14:04','2025-12-05 11:14:04',NULL),
(1343,115,1,0.000000000000000000,'2025-12-05 11:16:47','2025-12-05 11:16:47',NULL),
(1344,115,2,0.000000000000000000,'2025-12-05 11:16:47','2025-12-05 11:16:47',NULL),
(1345,115,4,0.000000000000000000,'2025-12-05 11:16:47','2025-12-05 11:16:47',NULL),
(1346,115,35,100.000000000000000000,'2025-12-05 11:16:47','2025-12-05 12:14:19',NULL),
(1347,115,37,0.000000000000000000,'2025-12-05 11:16:47','2025-12-05 11:16:47',NULL),
(1348,116,1,0.000000000000000000,'2025-12-06 07:22:24','2025-12-06 07:22:24',NULL),
(1349,116,2,0.000000000000000000,'2025-12-06 07:22:24','2025-12-06 07:22:24',NULL),
(1350,116,4,0.000000000000000000,'2025-12-06 07:22:24','2025-12-06 07:22:24',NULL),
(1351,116,35,0.000000000000000000,'2025-12-06 07:22:24','2025-12-06 07:22:24',NULL),
(1352,116,37,0.000000000000000000,'2025-12-06 07:22:24','2025-12-06 07:22:24',NULL),
(1353,117,1,0.000000000000000000,'2025-12-06 11:06:23','2025-12-06 11:06:23',NULL),
(1354,117,2,0.000000000000000000,'2025-12-06 11:06:23','2025-12-06 11:06:23',NULL),
(1355,117,4,0.000000000000000000,'2025-12-06 11:06:23','2025-12-06 11:06:23',NULL),
(1356,117,35,0.000000000000000000,'2025-12-06 11:06:23','2025-12-06 11:06:23',NULL),
(1357,117,37,0.000000000000000000,'2025-12-06 11:06:23','2025-12-06 11:06:23',NULL),
(1358,118,1,788.000000000000000000,'2025-12-07 05:36:31','2025-12-08 12:00:30',NULL),
(1359,118,2,0.000000000000000000,'2025-12-07 05:36:31','2025-12-07 05:36:31',NULL),
(1360,118,4,0.000000000000000000,'2025-12-07 05:36:31','2025-12-07 05:36:31',NULL),
(1361,118,35,0.000000000000000000,'2025-12-07 05:36:31','2025-12-07 05:36:31',NULL),
(1362,118,37,0.941574640000000000,'2025-12-07 05:36:31','2025-12-08 12:23:23',NULL),
(1363,119,1,0.000000000000000000,'2025-12-07 06:38:17','2025-12-07 06:38:17',NULL),
(1364,119,2,0.000000000000000000,'2025-12-07 06:38:17','2025-12-07 06:38:17',NULL),
(1365,119,4,0.000000000000000000,'2025-12-07 06:38:17','2025-12-07 06:38:17',NULL),
(1366,119,35,0.000000000000000000,'2025-12-07 06:38:17','2025-12-07 06:38:17',NULL),
(1367,119,37,0.000000000000000000,'2025-12-07 06:38:17','2025-12-07 06:38:17',NULL),
(1368,120,1,0.000000000000000000,'2025-12-08 02:18:43','2025-12-08 02:18:43',NULL),
(1369,120,2,0.000000000000000000,'2025-12-08 02:18:43','2025-12-08 02:18:43',NULL),
(1370,120,4,0.000000000000000000,'2025-12-08 02:18:43','2025-12-08 02:18:43',NULL),
(1371,120,35,0.000000000000000000,'2025-12-08 02:18:43','2025-12-08 02:18:43',NULL),
(1372,120,37,0.000000000000000000,'2025-12-08 02:18:43','2025-12-08 02:18:43',NULL),
(1373,121,1,0.000000000000000000,'2025-12-08 05:19:12','2025-12-08 05:19:12',NULL),
(1374,121,2,0.000000000000000000,'2025-12-08 05:19:12','2025-12-08 05:19:12',NULL),
(1375,121,4,0.000000000000000000,'2025-12-08 05:19:12','2025-12-08 05:19:12',NULL),
(1376,121,35,743992.930000000000000000,'2025-12-08 05:19:12','2025-12-23 11:05:45',NULL),
(1377,121,37,0.000000000000000000,'2025-12-08 05:19:12','2025-12-08 05:19:12',NULL),
(1378,122,1,0.000000000000000000,'2025-12-08 06:28:59','2025-12-08 06:28:59',NULL),
(1379,122,2,0.000000000000000000,'2025-12-08 06:28:59','2025-12-08 06:28:59',NULL),
(1380,122,4,0.000000000000000000,'2025-12-08 06:28:59','2025-12-08 06:28:59',NULL),
(1381,122,35,0.000000000000000000,'2025-12-08 06:28:59','2025-12-08 06:28:59',NULL),
(1382,122,37,0.000000000000000000,'2025-12-08 06:28:59','2025-12-08 06:28:59',NULL),
(1383,123,1,0.000000000000000000,'2025-12-08 15:18:30','2025-12-08 15:18:30',NULL),
(1384,123,2,0.000000000000000000,'2025-12-08 15:18:30','2025-12-08 15:18:30',NULL),
(1385,123,4,0.000000000000000000,'2025-12-08 15:18:30','2025-12-08 15:18:30',NULL),
(1386,123,35,0.000000000000000000,'2025-12-08 15:18:30','2025-12-08 15:18:30',NULL),
(1387,123,37,0.000000000000000000,'2025-12-08 15:18:30','2025-12-08 15:18:30',NULL),
(1388,124,1,0.000000000000000000,'2026-01-15 16:36:26','2026-01-15 16:36:26',NULL),
(1389,124,2,0.000000000000000000,'2026-01-15 16:36:26','2026-01-15 16:36:26',NULL),
(1390,124,4,0.000000000000000000,'2026-01-15 16:36:26','2026-01-15 16:36:26',NULL),
(1391,124,35,0.000000000000000000,'2026-01-15 16:36:26','2026-01-15 16:36:26',NULL),
(1392,124,37,0.000000000000000000,'2026-01-15 16:36:26','2026-01-15 16:36:26',NULL),
(1393,125,1,0.000000000000000000,'2026-01-16 12:02:47','2026-01-16 12:02:47',NULL),
(1394,125,2,0.000000000000000000,'2026-01-16 12:02:47','2026-01-16 12:02:47',NULL),
(1395,125,4,0.000000000000000000,'2026-01-16 12:02:47','2026-01-16 12:02:47',NULL),
(1396,125,35,0.000000000000000000,'2026-01-16 12:02:47','2026-01-16 12:02:47',NULL),
(1397,125,37,0.000000000000000000,'2026-01-16 12:02:47','2026-01-16 12:02:47',NULL);

/*Table structure for table `wallets` */

DROP TABLE IF EXISTS `wallets`;

CREATE TABLE `wallets` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `balance` decimal(20,2) NOT NULL DEFAULT '0.00',
  `bonus` decimal(20,2) NOT NULL DEFAULT '0.00',
  `shares` decimal(10,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `wallets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `wallets` */

insert  into `wallets`(`id`,`user_id`,`balance`,`bonus`,`shares`,`created_at`,`updated_at`,`deleted_at`) values 
(1,2,349500.00,0.00,0.00,'2024-11-12 07:01:47','2024-11-13 03:45:36',NULL),
(2,5,0.00,0.00,0.00,'2024-11-12 13:03:09','2024-11-13 07:03:09',NULL),
(3,6,0.00,0.00,0.00,'2024-11-12 14:31:51','2024-11-13 08:31:51',NULL),
(4,7,0.00,0.00,0.00,'2024-11-12 14:37:04','2024-11-13 08:37:04',NULL),
(5,8,0.00,0.00,0.00,'2024-11-12 14:39:34','2024-11-13 08:39:34',NULL),
(6,9,0.00,0.00,0.00,'2024-11-12 15:32:11','2024-11-13 09:32:11',NULL),
(7,10,0.00,0.00,0.00,'2024-11-12 15:38:31','2024-11-13 09:38:31',NULL),
(8,11,600000.00,0.00,0.00,'2024-11-13 03:48:48','2024-11-13 23:30:51',NULL),
(9,12,5000.00,0.00,0.00,'2024-11-13 05:11:23','2024-11-15 14:26:09',NULL),
(10,13,90737400.00,0.00,0.00,'2024-11-13 08:42:20','2024-11-21 03:44:52',NULL),
(11,14,90000.00,0.00,0.00,'2024-11-13 14:07:12','2024-11-14 08:29:36',NULL),
(12,15,0.00,0.00,0.00,'2024-11-13 14:40:28','2024-11-14 08:40:28',NULL),
(13,16,130000.00,0.00,0.00,'2024-11-14 10:12:10','2024-11-15 11:17:05',NULL),
(14,17,688388.00,0.00,0.00,'2024-11-14 20:23:53','2024-11-15 15:15:44',NULL),
(15,18,0.00,0.00,0.00,'2024-11-15 02:32:35','2024-11-15 20:32:35',NULL),
(16,19,6299.80,13948.45,0.00,'2024-11-20 04:58:16','2024-11-21 10:42:34',NULL),
(17,20,0.00,0.00,0.00,'2024-11-20 10:32:53','2024-11-21 04:32:53',NULL),
(18,21,0.00,0.00,0.00,'2024-11-20 10:35:28','2024-11-21 04:35:28',NULL),
(19,22,0.00,0.00,0.00,'2024-11-20 10:39:01','2024-11-21 04:39:01',NULL),
(20,23,0.00,0.00,0.00,'2024-11-20 10:42:50','2024-11-21 04:42:50',NULL),
(21,24,17998.00,0.00,0.00,'2024-11-20 10:45:15','2024-11-21 06:41:13',NULL),
(22,25,0.00,0.00,0.00,'2024-11-21 13:43:23','2024-11-22 07:43:23',NULL),
(23,26,0.00,0.00,0.00,'2024-11-21 13:45:04','2024-11-22 07:45:04',NULL),
(24,27,4165286.00,0.00,0.00,'2024-11-21 13:45:54','2024-11-26 09:25:15',NULL),
(25,28,19800.00,0.00,5000.00,'2024-11-25 14:15:58','2024-11-26 09:46:46',NULL),
(26,29,0.00,0.00,0.00,'2024-12-10 09:48:16','2024-12-11 03:48:16',NULL),
(27,30,0.00,0.00,0.00,'2024-12-10 09:54:14','2024-12-11 03:54:14',NULL),
(28,31,0.00,0.00,0.00,'2024-12-10 09:59:34','2024-12-11 06:05:08',NULL),
(29,32,0.00,0.00,0.00,'2024-12-13 03:08:42','2024-12-13 21:08:42',NULL),
(30,33,0.00,0.00,0.00,'2025-01-31 12:46:02','2025-02-01 06:46:02',NULL),
(33,40,0.00,0.00,0.00,'2025-02-03 11:19:21','2025-02-04 05:19:21',NULL),
(34,41,16.96,0.00,0.00,'2025-02-04 02:29:26','2025-02-05 03:34:45',NULL),
(35,42,0.00,0.00,0.00,'2025-02-07 09:19:22','2025-02-08 03:19:22',NULL),
(36,43,0.00,0.00,0.00,'2025-02-07 12:43:11','2025-02-08 06:43:11',NULL),
(37,44,0.00,0.00,0.00,'2025-02-07 16:33:50','2025-02-08 10:33:50',NULL),
(38,45,0.00,0.00,0.00,'2025-02-07 16:47:25','2025-02-08 10:47:25',NULL),
(39,46,0.00,0.00,0.00,'2025-02-11 12:12:58','2025-02-12 06:12:58',NULL),
(40,47,0.00,0.00,0.00,'2025-02-13 12:44:37','2025-02-14 06:44:37',NULL),
(41,48,0.00,0.00,0.00,'2025-02-13 13:13:21','2025-02-14 07:13:21',NULL),
(42,49,0.00,0.00,0.00,'2025-02-13 13:24:31','2025-02-14 07:24:31',NULL),
(43,50,0.00,0.00,0.00,'2025-02-17 10:37:04','2025-02-18 04:37:04',NULL),
(44,51,0.00,0.00,0.00,'2025-02-21 10:35:37','2025-02-22 04:35:37',NULL),
(45,52,0.00,0.00,0.00,'2025-02-24 15:37:28','2025-02-25 09:37:28',NULL),
(46,53,-65000.00,0.00,0.00,'2025-02-25 12:11:23','2025-06-18 01:00:00',NULL),
(47,54,0.00,0.00,0.00,'2025-02-25 12:16:38','2025-02-26 06:16:38',NULL),
(48,55,0.00,0.00,0.00,'2025-02-25 12:29:24','2025-02-26 06:29:24',NULL),
(49,56,0.00,0.00,0.00,'2025-02-25 13:17:14','2025-02-26 07:17:14',NULL),
(50,57,0.00,0.00,0.00,'2025-02-26 13:24:02','2025-02-27 07:24:02',NULL),
(51,58,0.00,0.00,0.00,'2025-02-26 14:22:21','2025-02-27 08:22:21',NULL),
(52,59,0.00,0.00,0.00,'2025-02-28 05:30:18','2025-02-28 23:30:18',NULL),
(53,60,0.00,0.00,0.00,'2025-03-01 09:18:55','2025-03-02 03:18:55',NULL),
(54,61,0.00,0.00,0.00,'2025-03-04 14:13:31','2025-03-05 08:13:31',NULL),
(55,62,0.00,0.00,0.00,'2025-03-11 17:55:10','2025-03-12 08:55:10',NULL),
(56,63,0.00,0.00,0.00,'2025-03-17 20:24:44','2025-03-18 11:24:44',NULL),
(57,64,0.00,0.00,0.00,'2025-03-17 20:34:31','2025-03-18 11:34:31',NULL),
(58,65,0.00,0.00,0.00,'2025-03-18 15:29:04','2025-03-19 06:29:04',NULL),
(59,66,0.00,0.00,0.00,'2025-05-22 18:11:56','2025-05-23 09:11:56',NULL),
(60,67,0.00,0.00,0.00,'2025-06-11 11:40:22','2025-06-11 21:40:22',NULL),
(61,68,-630000.00,0.00,0.00,'2025-06-13 12:25:42','2025-06-27 07:03:53',NULL),
(62,69,0.00,0.00,0.00,'2025-06-16 17:23:25','2025-06-17 03:23:25',NULL),
(63,70,0.00,0.00,0.00,'2025-06-20 12:44:40','2025-06-20 22:44:40',NULL),
(64,71,0.00,0.00,0.00,'2025-06-20 14:57:11','2025-06-21 00:57:11',NULL),
(65,72,0.00,0.00,0.00,'2025-06-21 00:39:18','2025-06-21 10:39:18',NULL),
(66,73,0.00,0.00,0.00,'2025-11-24 19:07:53','2025-11-25 01:07:53',NULL),
(67,74,0.00,0.00,0.00,'2025-11-25 00:23:54','2025-11-25 06:23:54',NULL),
(68,75,0.00,0.00,0.00,'2025-11-25 17:17:29','2025-11-25 23:17:29',NULL),
(69,76,0.00,0.00,0.00,'2025-11-25 19:22:02','2025-11-26 01:22:02',NULL),
(70,77,0.00,0.00,0.00,'2025-11-26 00:47:52','2025-11-26 06:47:52',NULL),
(71,78,0.00,0.00,0.00,'2025-11-26 02:43:30','2025-11-26 08:43:30',NULL),
(72,79,0.00,0.00,0.00,'2025-11-26 03:34:55','2025-11-26 09:34:55',NULL),
(73,80,0.00,0.00,0.00,'2025-11-26 04:13:23','2025-11-26 10:13:23',NULL),
(74,81,0.00,0.00,0.00,'2025-11-26 04:16:39','2025-11-26 10:16:39',NULL),
(75,82,0.00,0.00,0.00,'2025-11-27 07:50:46','2025-11-27 13:50:46',NULL),
(76,83,0.00,0.00,0.00,'2025-11-27 08:56:49','2025-11-27 14:56:49',NULL),
(77,84,0.00,0.00,0.00,'2025-11-27 21:31:08','2025-11-28 03:31:08',NULL),
(78,85,0.00,0.00,0.00,'2025-11-28 01:46:03','2025-11-28 07:46:03',NULL),
(79,86,0.00,0.00,0.00,'2025-11-28 03:48:38','2025-11-28 09:48:38',NULL),
(80,87,0.00,0.00,0.00,'2025-11-29 00:43:41','2025-11-29 06:43:41',NULL),
(81,88,0.00,0.00,0.00,'2025-11-29 01:41:30','2025-11-29 07:41:30',NULL),
(82,89,0.00,0.00,0.00,'2025-11-29 02:28:15','2025-11-29 08:28:15',NULL),
(83,90,0.00,0.00,0.00,'2025-11-29 02:40:44','2025-11-29 08:40:44',NULL),
(84,91,0.00,0.00,0.00,'2025-11-29 07:32:12','2025-11-29 13:32:12',NULL),
(85,92,0.00,0.00,0.00,'2025-11-29 10:04:48','2025-11-29 16:04:48',NULL),
(86,93,0.00,0.00,0.00,'2025-11-30 02:38:28','2025-11-30 08:38:28',NULL),
(87,94,0.00,0.00,0.00,'2025-11-30 04:17:42','2025-11-30 10:17:42',NULL),
(88,95,0.00,0.00,0.00,'2025-11-30 22:05:07','2025-12-01 04:05:07',NULL),
(89,96,0.00,0.00,0.00,'2025-12-01 06:08:54','2025-12-01 12:08:54',NULL),
(90,97,0.00,0.00,0.00,'2025-12-01 23:01:38','2025-12-02 05:01:38',NULL),
(91,98,0.00,0.00,0.00,'2025-12-01 23:10:15','2025-12-02 05:10:15',NULL),
(92,99,0.00,0.00,0.00,'2025-12-02 00:10:56','2025-12-02 06:10:56',NULL),
(93,100,0.00,0.00,0.00,'2025-12-02 04:50:46','2025-12-02 10:50:46',NULL),
(94,101,0.00,0.00,0.00,'2025-12-02 13:00:47','2025-12-02 19:00:47',NULL),
(95,102,0.00,0.00,0.00,'2025-12-02 14:09:03','2025-12-02 20:09:03',NULL),
(96,103,0.00,0.00,0.00,'2025-12-02 15:09:16','2025-12-02 21:09:16',NULL),
(97,104,0.00,0.00,0.00,'2025-12-02 16:23:51','2025-12-02 22:23:51',NULL),
(98,105,0.00,0.00,0.00,'2025-12-02 21:17:49','2025-12-03 03:17:49',NULL),
(99,106,0.00,0.00,0.00,'2025-12-03 01:16:25','2025-12-03 07:16:25',NULL),
(100,107,0.00,0.00,0.00,'2025-12-03 02:20:43','2025-12-03 08:20:43',NULL),
(101,108,0.00,0.00,0.00,'2025-12-03 03:10:26','2025-12-03 09:10:26',NULL),
(102,109,0.00,0.00,0.00,'2025-12-03 12:38:18','2025-12-03 18:38:18',NULL),
(103,110,0.00,0.00,0.00,'2025-12-03 17:46:18','2025-12-03 23:46:18',NULL),
(104,111,0.00,0.00,0.00,'2025-12-03 18:35:40','2025-12-04 00:35:40',NULL),
(105,112,0.00,0.00,0.00,'2025-12-04 00:18:59','2025-12-04 06:18:59',NULL),
(106,113,0.00,0.00,0.00,'2025-12-04 00:26:26','2025-12-04 06:26:26',NULL),
(107,114,0.00,0.00,0.00,'2025-12-04 13:40:49','2025-12-04 19:40:49',NULL),
(108,115,0.00,0.00,0.00,'2025-12-04 14:42:34','2025-12-04 20:42:34',NULL),
(109,116,0.00,0.00,0.00,'2025-12-04 16:03:23','2025-12-04 22:03:23',NULL),
(110,117,0.00,0.00,0.00,'2025-12-04 20:18:24','2025-12-05 02:18:24',NULL),
(111,118,0.00,0.00,0.00,'2025-12-04 20:33:21','2025-12-05 02:33:21',NULL),
(112,119,0.00,0.00,0.00,'2025-12-04 20:47:37','2025-12-05 02:47:37',NULL),
(113,120,0.00,0.00,0.00,'2025-12-05 02:19:58','2025-12-05 08:19:58',NULL),
(114,121,0.00,0.00,0.00,'2025-12-05 05:14:04','2025-12-05 11:14:04',NULL),
(115,122,0.00,0.00,0.00,'2025-12-05 05:16:47','2025-12-05 11:16:47',NULL),
(116,123,0.00,0.00,0.00,'2025-12-06 01:22:24','2025-12-06 07:22:24',NULL),
(117,124,0.00,0.00,0.00,'2025-12-06 05:06:23','2025-12-06 11:06:23',NULL),
(118,125,0.00,0.00,0.00,'2025-12-06 23:36:31','2025-12-07 05:36:31',NULL),
(119,126,0.00,0.00,0.00,'2025-12-07 00:38:17','2025-12-07 06:38:17',NULL),
(120,127,0.00,0.00,0.00,'2025-12-07 20:18:43','2025-12-08 02:18:43',NULL),
(121,128,-7.97,0.00,0.00,'2025-12-07 23:19:12','2025-12-12 08:32:09',NULL),
(122,129,0.00,0.00,0.00,'2025-12-08 00:28:59','2025-12-08 06:28:59',NULL),
(123,130,0.00,0.00,0.00,'2025-12-08 09:18:30','2025-12-08 15:18:30',NULL),
(124,131,0.00,0.00,0.00,'2026-01-15 16:36:26','2026-01-15 16:36:26',NULL),
(125,132,0.00,0.00,0.00,'2026-01-16 12:02:47','2026-01-16 12:02:47',NULL);

/*Table structure for table `withdrawals` */

DROP TABLE IF EXISTS `withdrawals`;

CREATE TABLE `withdrawals` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `amount` decimal(10,0) DEFAULT NULL,
  `option` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `approved_by` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT '0',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `withdrawals_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `withdrawals` */

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
