<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WalletCoin extends Model
{
    use HasFactory;

    protected $fillable = ['wallet_id', 'coin_id', 'balance']; // Important for mass assignment

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function wallet() {
        return $this->belongsTo(Wallet::class); // A WalletCoin belongs to a Wallet
    }

    public function coin() {
        return $this->belongsTo(Coin::class)->withTrashed(); // A WalletCoin belongs to a Coin
    }
}
