<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Signal extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'description',
        'price_per_unit',
        'duration_unit',
        'default_duration_value',
        'roi_percentage',
        'max_subscribers',
        'status',
    ];

    protected $casts = [
        'price_per_unit' => 'float',
        'roi_percentage' => 'float',
        'default_duration_value' => 'integer',
        'max_subscribers' => 'integer',
    ];

    // If you need relationships, add them here.
    // For example, to link to user subscriptions (which we'll create later):
    // public function subscriptions()
    // {
    //     return $this->hasMany(UserSignalSubscription::class);
    // }
}
