<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Refund extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'refund_id',
        'investment_id',
        'amount_refunded',
        'reason',
        'status_id',
        'action_by',
        'action_at'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function investment()
    {
        return $this->belongsTo(Investment::class);
    }

    public function status()
    {
        return $this->belongsTo(PaymentStatus::class);
    }
}
