<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Referral extends Model
{
    use HasFactory;

    protected $fillable = [
        'referer_id',
        'referee_id',
        'initial_deposit',
        'bonus',
        'date_disbursed',
        'status_id',
        'action_by',
        'action_at',
        'transaction_id'
    ];

    public function referer()
    {
        return $this->belongsTo(User::class, 'referer_id');
    }

    public function referee()
    {
        return $this->belongsTo(User::class, 'referee_id');
    }

    public function status()
    {
        return $this->belongsTo(PaymentStatus::class);
    }

    protected static function boot()
    {
        parent::boot();

        static::updating(function ($referral) {
            if ($referral->isDirty('status_id') && in_array($referral->status_id, [1, 3])) {
                $referral->action_at = now();
                $referral->action_by = auth()->id();
            }
        });
    }
}
