<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Persona extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'tagline',
        'primary_color',
        'logo_path',          // Icon
        'logo_full_path',     // Light Mode Full
        'logo_dark_full_path', // Dark Mode Full (NEW)
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // --- ACCESSORS FOR URLS ---

    public function getLogoUrlAttribute()
    {
        return $this->logo_path ? asset('storage/' . $this->logo_path) : null;
    }

    public function getLogoFullUrlAttribute()
    {
        return $this->logo_full_path ? asset('storage/' . $this->logo_full_path) : $this->logo_url;
    }

    public function getLogoDarkFullUrlAttribute()
    {
        // Fallback to Light Mode Full logo if Dark Mode specific isn't uploaded
        return $this->logo_dark_full_path ? asset('storage/' . $this->logo_dark_full_path) : $this->logo_full_url;
    }
}
