<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class ForexPair extends Model
{
    use HasFactory;

    protected $fillable = [
        'symbol',
        'name',
        'base_currency',
        'quote_currency',
        'exchange_rate',
        'leverage', // Max leverage allowed
        'tradingview_code',
        'is_active',
        'year_range_min',
        'year_range_max',
    ];

    /**
     * Helper to get the current user's wallet for this specific pair.
     * Used in the JSON response for the frontend.
     */
    public function wallet()
    {
        return $this->hasOne(ForexWallet::class)->where('user_id', Auth::id());
    }
}
