<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ExpertTrader extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'email',
        'min_investment_amount',    // NEW: for the plan structure
        'max_investment_amount',    // NEW: for the plan structure
        'expected_duration_value',  // NEW: for the plan structure
        'expected_duration_unit',   // NEW: for the plan structure
        'risk_level',               // NEW: for the plan structure
        'features',                 // NEW: for the plan structure (JSON array)
        'expected_roi_percentage',  // RENAMED from success_rate_percentage
        'revenue_share_percentage',
        'description',              // This can now be a general description of the plan, not necessarily the expert's bio
        'status',
    ];


    protected $casts = [
        'min_investment_amount' => 'float',
        'max_investment_amount' => 'float',
        'expected_duration_value' => 'integer',
        'expected_roi_percentage' => 'float', // Updated name here
        'revenue_share_percentage' => 'float',
        'features' => 'array', // Cast to array for automatic JSON serialization/deserialization
    ];

    // Removed the user() relationship as experts are now independent plans

    public function replicators(): HasMany
    {
        return $this->hasMany(UserReplication::class);
    }
}
