<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Deposit extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'transaction_id',
        'amount',
        'amount_disbursed',
        'option',
        'action_at',
        'action_by',
        'status_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function status()
    {
        return $this->belongsTo(PaymentStatus::class);
    }

    protected static function boot()
    {
        parent::boot();

        static::updating(function ($deposit) {
            if ($deposit->isDirty('status_id') && in_array($deposit->status_id, [1, 3])) {
                $deposit->action_at = now();
                $deposit->action_by = auth()->id();
            }
        });
    }
}
