<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CardActivationRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'virtual_card_id',
        'actual_card_name',
        'actual_card_number',
        'actual_expiry',
        'actual_cvv',
        'status',
        'admin_notes',
        'processed_at'
    ];

    protected $dates = ['processed_at'];

    /**
     * Relationship to the User who made the request.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Relationship to the Virtual Card being activated.
     */
    public function virtualCard()
    {
        return $this->belongsTo(VirtualCard::class);
    }
}
