<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class TransactionApprovedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $transaction;
    public $type;

    public function __construct($transaction, $type)
    {
        $this->transaction = $transaction;
        $this->type = $type;
    }

    public function build()
    {
        if ($this->type =="deposit") {
            return $this->subject('Deposit Approved')
                        ->view('emails.transaction_approved');
        }else{
            return $this->subject('Withdrawal Approved and Sent')
                        ->view('emails.transaction_approved');

        }
    }
}
