<?php

namespace App\Mail;

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class GenericMail extends Mailable
{
    use Queueable, SerializesModels;

    public $subject;
    public $bodyContent;

    /**
     * Create a new message instance.
     */
    public function __construct($subject, $bodyContent)
    {
        $this->subject = $subject;
        $this->bodyContent = $bodyContent;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject($this->subject)
                    ->view('emails.generic') // The Blade file we created
                    ->with([
                        'bodyContent' => $this->bodyContent,
                    ]);
    }
}

