<?php

namespace App\Http\Controllers;

use App\Models\Deposit;
use App\Models\Transaction;
use App\Models\Wallet;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class WalletController extends Controller
{
    public function viewWallet()
    {
        $user = auth()->user();
        $investments = $user->investments;
        $claims = $user->claimedShares;

        $total_staked = 0;

        foreach ($investments as $investment) {
            if (in_array($investment->status_id, [2, 3])) {
                // Eager load the coin relationship to avoid N+1 queries
                $investment->load('coin');

                if ($investment->coin) { // Check if the coin relationship exists
                    $total_staked += $investment->amount * $investment->coin->value; // Multiply amount by coin value
                } else {
                    // Handle the case where the coin relationship is missing.
                    Log::warning("Investment {$investment->id} has no associated coin.");
                }
            }
        }
        $transactions = Transaction::where('user_id', $user->id)->get();

        return view('wallet', compact('transactions','total_staked'));
    }
}
