<?php

namespace App\Http\Controllers;

use App\Models\Deposit;
use App\Models\Wallet;
use App\Models\ClaimedShares;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Validator;
use App\Mail\WelcomeEmail;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;



class SharesController extends Controller
{
    public function claimShares(Request $request)
    {
        // Validate the request data
        // $request->validate([
        //     'letter_explanation' => 'required|file|mimes:pdf,doc,docx',
        //     'signed_contract' => 'required|file|mimes:pdf,doc,docx',
        //     'breach_proof' => 'required|file|mimes:pdf,doc,docx,jpg,png',
        // ]);
        $requestData = $request->all();

        $validator = Validator::make($requestData, [
            'letter_explanation' => 'required|file|mimes:pdf,doc,docx',
            'signed_contract' => 'required|file|mimes:pdf,doc,docx',
            'breach_proof' => 'required|file|mimes:pdf,doc,docx,jpg,png',
        ]);

        if ($validator->fails()) {
            // Dump all validation error messages
            dd($validator->messages()->toArray());
        }

        $letterExplanationPath = time() . '_' . $request->file('letter_explanation')->getClientOriginalName();
        $letterExplanationFilePath = $request->file('letter_explanation')->storeAs('uploads/letter_explanations', $letterExplanationPath);

        $signedContractPath = time() . '_' . $request->file('signed_contract')->getClientOriginalName();
        $signedContractFilePath = $request->file('signed_contract')->storeAs('uploads/signed_contracts', $signedContractPath);

        $breachProofPath = time() . '_' . $request->file('breach_proof')->getClientOriginalName();
        $breachProofFilePath = $request->file('breach_proof')->storeAs('uploads/breach_proofs', $breachProofPath);

        // Create a new ClaimedShares record
        $claimedShares = new ClaimedShares;
        $claimedShares->user_id = auth()->id();
        $claimedShares->letter_explanation = $letterExplanationFilePath;
        $claimedShares->signed_contract = $signedContractFilePath;
        $claimedShares->breach_proof = $breachProofFilePath;

        // ! change to dynamic
        // $wallet = Auth::user()->wallet->decrement('balance', 2228);

        // ... other fields as needed
        $claimedShares->save();

        return redirect()->route('dashboard')->with('success_claim', 'claim logged successfully! You will be informed once the admin approves your claim')->with('claim_id', $claimedShares->id);
    }

    public function admin_view_claimed_shares()
    {
        $claimedShares = ClaimedShares::with('user')->orderByDesc('created_at')->get();
        return view('admin-dash.claimed-shares', compact('claimedShares'));
    }



    public function approveClaim($id)
    {
        $claim = ClaimedShares::findOrFail($id);
        $claim->status = 'approved'; // Or any relevant status
        $claim->user->wallet->increment('shares', 5000);
        $claim->save();
        // \Mail::to($claim->user->email)->send(new \App\Mail\ClaimApprovedMail($claim));
        try {
            \Mail::to($claim->user->email)->send(new \App\Mail\ClaimApprovedMail($claim));
        } catch (\Exception $e) {
            Log::error('Error sending registration email: ' . $e->getMessage());
        }


        return redirect()->route('admin.claimed_shares.view')->with('success', 'Claim approved successfully!');
    }


    public function declineClaim(ClaimedShares $claim)
    {
        $claim->status = 'rejected';
        $claim->save();
        // ! change to dynamic
        // $claim->user->wallet->increment('balance', 2228);
        // \Mail::to($claim->user->email)->send(new \App\Mail\ClaimDeclinedMail($claim));
        try {
            \Mail::to($claim->user->email)->send(new \App\Mail\ClaimDeclinedMail($claim));
        } catch (\Exception $e) {
            Log::error('Error sending registration email: ' . $e->getMessage());
        }

        return redirect()->back()->with('success_decline', 'Claim declined successfully.');
    }













    public function dummyTestMail(Request $request){
        try {
            // Retrieve currently authenticated user
            $user = Auth::user();
            Mail::to('jideonwofoc@gmail.com')->send(new \App\Mail\RegistrationSuccessMail($user));

            // return dd('success');

        } catch (\Exception $e) {
            // Handle potential exceptions (e.g., failed email delivery, missing configuration)
            return dd($e->getMessage());
            // return back()->withErrors(['error' => 'An error occurred while sending the test email: ' . $e->getMessage()]);
        }
    }
}
