<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Review;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class ReviewController extends Controller
{
    /**
     * Handles POST requests to save user ratings and comments.
     *
     * @param Request $request
     * @return \Illuminate\Http\Response
     */
    public function postRating(Request $request)
    {
        $validatedData = $request->validate([
            'rating' => 'required|integer|min:1|max:5', // Validate rating (1-5)
            'comment' => 'nullable|string', // Optional comment
        ]);

        // Authenticate and retrieve the logged-in user
        $user = Auth::user();

        if (!$user) {
            // Handle unauthenticated users (e.g., redirect to login)
            return redirect()->route('login');
        }

        $review = new Review; // Create a new Review instance
        $review->user_id = $user->id; // Set the user ID
        $review->rating = $request->rating;
        $review->comment = $request->comment;

        // Save the review to the database
        $review->save();

        // Success message and redirect (optional)
        return redirect()->back()->with('success_review', 'Review submitted successfully!');
        // $request->session()->flash('success', 'Your review has been submitted successfully!');
        // return redirect()->back(); // Redirect to the previous page
    }
}
