<?php

namespace App\Http\Controllers;

use App\Models\PaymentOption;
use App\Models\InvestmentPlan;
use App\Models\Investment;
use App\Models\Refund;
use App\Models\Wallet;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Support\Str;

class RefundController extends Controller
{
    public function generateUniqueId()
    {
        do {
            $uniqueID = strtoupper('RFD' . Str::random(8));
        } while (Refund::where('refund_id', $uniqueID)->exists());

        return $uniqueID;
    }

    public function index()
    {
        $investments = Investment::where('user_id', auth()->id())->where('status_id', 2)->get();
        return view('refund', compact('investments'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'investment_id' => 'required|max:16',
            'reason' => 'required|string',
        ]);

        // Check if there's an existing pending refund for the same investment ID
        $existingRefund = Refund::where('investment_id', $request->investment_id)
            ->where('status_id', 2)
            ->first();

        if ($existingRefund) {
        return redirect()->back()->with('error', 'A pending refund request already exists for this investment.');
        }


        $refund_id = $this->generateUniqueId();
        $refund = new Refund([
            'refund_id' => $refund_id,
            'user_id' => Auth::id(),
            'investment_id' => $request['investment_id'],
            'reason' => $request['reason']
        ]);
        $refund->save();
        return redirect()->back()->with('success', 'Refund request logged successfully.')->with('refund_id', $refund_id);
    }

    public function admin_view_refunds()
    {
        $refunds = Refund::orderByDesc('created_at')->get();
        return view('admin-dash.refunds', compact('refunds'));
    }

    // this works for both approval and rejection
    public function admin_update_refund(Request $request)
    {
        $request->validate([
            'id' => 'required',
            'type' => 'required|string|in:approve,decline',
        ]);
        $id = $request['id'];
        $refund = Refund::findOrFail($id);

        if($request['type'] === 'approve'){
            $request->validate([
                'id' => 'required',
                'type' => 'required|string|in:approve,decline',
                'amount' => 'required|string',
            ]);
            $investment = Investment::findOrFail($refund->investment_id);

            $investment->status_id = 5;
            $investment->ended_at = Carbon::now('Africa/Lagos');

            $refund->action_at = Carbon::now('Africa/Lagos');
            $refund->action_by = auth()->id();
            $refund->status_id = 1;
            $refund->amount_refunded = $request->amount;

            // Update the wallet balance
            $approved_amount = $request['amount'];
            $wallet = Wallet::where('user_id', $refund->user->id)->first();
            $wallet->increment('balance', $approved_amount);

            $investment->save();
            $refund->save();
            $wallet->save();
            return redirect()->back()->with('success', 'Trade updated successfully.');

        }else{
            $refund->action_at = Carbon::now('Africa/Lagos');
            $refund->action_by = auth()->id();
            $refund->status_id = 3;
            $refund->save();

            return redirect()->back()->with('success_decline', 'Trade updated successfully.');
        }

    }


    public function destroy(PaymentOption $paymentOption)
    {

        $paymentOption->delete();

        return redirect()->back()->with('delete_success', 'Payment option deleted successfully.');
    }
}
