<?php

namespace App\Http\Controllers;

use App\Models\PaymentOption; // Assuming this is used elsewhere, keep it
use App\Models\InvestmentPlan; // Assuming this is used elsewhere, keep it
use App\Models\Investment; // This is for Staking Investments
use App\Models\UserFixedInvestment; // NEW: For Fixed Investment Plans
use App\Models\Wallet; // Assuming this is used elsewhere, keep it
use Illuminate\Http\Request; // Assuming this is used elsewhere, keep it
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log; // Ensure Log is imported if used in previous versions of the controller

class PortfolioController extends Controller
{
    public function index()
    {
        $user = Auth::user();

        // Fetch Staking Investments
        // Eager load coin and statusRel relationships
        $investments = $user->investments;

        // Fetch Fixed Investments
        // Eager load investmentPlan relationship
        $userFixedInvestments = $user->userFixedInvestments()->with('investmentPlan')->latest()->get();

        // Calculate total staked value (sum of amounts in active staking and fixed investments)
        $total_staked = 0;

        // Sum active staking investments
        foreach ($investments as $investment) {
            // Check status (e.g., active, matured)
            if (in_array($investment->status_id, [\App\Models\Investment::STATUS_ACTIVE, \App\Models\Investment::STATUS_MATURED])) {
                if ($investment->coin) {
                    $total_staked += $investment->amount * $investment->coin->value; // Multiply amount by coin value
                } else {
                    Log::warning("Staking Investment {$investment->id} has no associated coin for value calculation.");
                }
            }
        }
        // Sum active fixed investments
        foreach ($userFixedInvestments as $fixedInvestment) {
            //calculate pnl baised on daily roi
            $fixedInvestment->current_pnl = $fixedInvestment->invested_amount * ($fixedInvestment->investmentPlan->daily_roi_percentage / 100) * $fixedInvestment->days_gone;
            if ($fixedInvestment->days_left == 0 && $fixedInvestment->status == 'active') {
                $fixedInvestment->status = 'matured';
            }
            $fixedInvestment->save();
            // Check status (e.g., active, matured)
            if (in_array($fixedInvestment->status, ['active', 'matured'])) { // Assuming 'active' and 'matured' are statuses that contribute to total
                 $total_staked += $fixedInvestment->invested_amount; // Just the invested amount, P&L is separate
            }
        }

        $stockWallets = Auth::user()
            ->stockWallets()
            ->where('claimed', '>', 0)
            ->with('stock') // Eager load the stock relationship
            ->get();


        // Passed $investments (for staking) and $userFixedInvestments (for fixed plans)
        return view('portfolio', compact('investments', 'userFixedInvestments', 'total_staked', 'stockWallets'));
    }
}
