<?php

namespace App\Http\Controllers;

use App\Models\PaymentOption;
use Illuminate\Http\Request;

class PaymentOptionController extends Controller
{
    public function index()
    {
        // $options = PaymentOption::where()->get();
        $options = PaymentOption::where('name', '!=', 'bank transfer')->get();

        return view('admin-dash.payment-options', compact('options'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:16',
            'account_details' => 'required|string',
        ]);

        PaymentOption::create($request->all());

        return redirect()->back()->with('success', 'Payment option added successfully.');
    }

    public function destroy(PaymentOption $paymentOption)
    {

        $paymentOption->delete();

        return redirect()->back()->with('delete_success', 'Payment option deleted successfully.');
    }
}