<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\InvestmentPlan;
use Illuminate\Http\Request;

class InvestmentPlanController extends Controller
{
    public function index()
    {
        $investmentPlans = InvestmentPlan::all();
        return view('admin-dash.investment-plans', compact('investmentPlans'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'required|string',
            'price' => 'required|numeric',
            'roi' => 'required|numeric',
            'duration' => 'required|numeric',
        ]);

        InvestmentPlan::create($request->all());

        return redirect()->back()->with('success', 'Investment plan added successfully.');
    }

    public function update(Request $request, InvestmentPlan $investmentPlan)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'required|string',
            'price' => 'required|numeric',
            'roi' => 'required|numeric',
            'duration' => 'required|numeric',
        ]);

        $investmentPlan->update($request->all());

        return redirect()->back()->with('success', 'Investment plan updated successfully.');
    }


    public function destroy(InvestmentPlan $investmentPlan)
    {
        $investmentPlan->delete();

        return redirect()->back()->with('delete_success', 'Investment plan deleted successfully.');
    }
}
