<?php

namespace App\Http\Controllers;

use App\Models\Deposit;
use App\Models\Transaction;
use App\Models\Wallet;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class DepositController extends Controller
{
    public function create()
    {
        $transactionId = strtoupper('TRD' . Str::random(8));

        // Check if the transaction ID already exists in the database
        $depositExists = Transaction::where('transaction_id', $transactionId)->exists();

        while ($depositExists) {
            $transactionId = strtoupper('TRD' . Str::random(8));
            $depositExists = Deposit::where('transaction_id', $transactionId)->exists();
        }

        return view('deposit.create', compact('transactionId'));
    }

    public function store(Request $request)
    {

        $validatedData = $request->validate([
            'amount' => 'required|numeric|min:1',
            'option' => 'required|string',
        ]);
        // dd($request['amount']);
        $paid_transactionId = $request['transaction_id'];

        $deposit = Deposit::create([
            'user_id' => auth()->id(),
            'amount' => $validatedData['amount'],
            'option' => $validatedData['option'],
            'transaction_id' => $request['transaction_id'],
        ]);
        // dd($request['amount']);


        return redirect()->route('deposit.create')->with('success', 'Deposit created successfully!')->with('transaction_id', $paid_transactionId);
    }

    public function admin_view()
    {
        // $deposits = Deposit::orderByDesc('created_at')->get(); // Fetch all deposits

        return view('admin-dash.deposits', compact('deposits'));
    }

    public function admin_update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'status' => 'required|string',
            'amount_disbursed' => 'nullable|numeric',
            // ... other validation rules as needed
        ]);

        $deposit = Deposit::findOrFail($id);
        $deposit->update($validatedData);

        return redirect()->route('admin-dash.deposits')->with('success', 'Deposit updated successfully!');
    }


    public function approve(Request $request)
    {
        $depositId = $request->input('id');
        $deposit = Deposit::findOrFail($depositId);

        $validatedData = $request->validate([
            'amount' => 'required|numeric|min:1',
        ]);

        $deposit->update([
            'amount_disbursed' => $validatedData['amount'],
            'status_id' => 1, // Assuming 1 is the approved status
        ]);

        // Find or create the user's wallet
        $wallet = Wallet::firstOrCreate(
            ['user_id' => $deposit->user_id],
            ['balance' => 0]
        );

        // Add the approved amount to the wallet balance
        $wallet->increment('balance', $validatedData['amount']);

        return redirect()->back()->with('success', 'Deposit approved successfully!');
    }

    public function decline(Request $request)
    {
        $depositId = $request->input('id');
        $deposit = Deposit::findOrFail($depositId);
        $deposit->update([
            'status_id' => 3, // Assuming 1 is the approved status
        ]);
        return redirect()->back()->with('success_decline', 'Deposit declined successfully!');
    }
}
