<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\InvestmentPlan;
use App\Models\Coin;
use Illuminate\Http\Request;

class CoinController extends Controller
{
    public function index()
    {
        $coins = Coin::all();
        return view('admin-dash.coins', compact('coins'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'code' => 'required|string',
            'value' => 'required|numeric',
            'stake_apr' => 'required|numeric',
            'api_name' => 'nullable|string',
        ]);

        // dd($request->api_name);
        Coin::create($request->all());
        $coin_name = $request->name;

        return redirect()->back()->with('success', $coin_name . ' added successfully.');
    }

    public function update(Request $request, Coin $coin)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'code' => 'required|string',
            'value' => 'required|numeric',
            'stake_apr' => 'required|numeric',
            'api_name' => 'nullable|string',
        ]);

        $coin->update($request->all());

        $coin_name = $request->name;
        return redirect()->back()->with('success', $coin_name . ' updated successfully.');
    }


    public function destroy(Coin $coin)
    {
        $coin->delete();

        $coin_name = $coin->name;
        return redirect()->back()->with('success', $coin_name . ' deleted successfully.');
    }
}
