<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\VirtualCard;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class CardController extends Controller
{
    public function index()
    {
        $user = Auth::user();

        // Fetch or Generate Card (Same logic as Dashboard to ensure consistency)
        $card = VirtualCard::where('user_id', $user->id)->first();

        if (!$card) {
            do {
                $cardNumber = '4' . str_pad(mt_rand(1, 999999999999999), 15, '0', STR_PAD_LEFT);
            } while (VirtualCard::where('card_number', $cardNumber)->exists());

            $expiryDate = Carbon::now()->addYears(3);

            $card = VirtualCard::create([
                'user_id'      => $user->id,
                'card_number'  => $cardNumber,
                'cvv'          => str_pad(mt_rand(1, 999), 3, '0', STR_PAD_LEFT),
                'expiry_month' => $expiryDate->format('m'),
                'expiry_year'  => $expiryDate->format('Y'),
                'status'       => 'inactive',
                'balance'      => 0,
            ]);
        }

        return view('user.card.index', compact('card'));
    }
}
