<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Persona;

class PersonaApiController extends Controller
{
public function getActivePersona()
{
    $persona = Persona::where('is_active', true)->first();

    if (!$persona) {
        // Return default fallback
        return response()->json([
            'name' => config('app.name'),
            'logo_url' => asset('images/favicon.png'),
            'logo_full_url' => asset('images/logo.png'),
            'logo_dark_full_url' => asset('images/logo-dark.png'), // Default dark
            'colors' => ['primary' => '#4f46e5']
        ]);
    }

    return response()->json([
        'name' => $persona->name,
        'tagline' => $persona->tagline,
        'logo_url' => $persona->logo_url,
        'logo_full_url' => $persona->logo_full_url, // Light mode
        'logo_dark_full_url' => $persona->logo_dark_full_url, // Dark mode (NEW)
        'colors' => [
            'primary' => $persona->primary_color
        ]
    ]);
}
}
