<?php


namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Coin;
use Carbon\Carbon;

class UpdateCoinValues extends Command
{
    protected $signature = 'coins:update';
    protected $description = 'Update coin values from CoinGecko API';

    public function handle()
    {
        $now = Carbon::now();
        $this->info('Cron started at: ' . $now->toDateTimeString().'----------------------------------------------------------------'); // Single timestamp output

        $coins = Coin::where('name', '!=', 'Dollars')->get();

        foreach ($coins as $coin) {
            $coin->updateCoinValuesFromApi();
            // $this->info($coin->name.'values updated successfully');
        }

        \Log::info('✅ Coin values updated successfully by Job. Timestamp:' . $now->toDateTimeString());
        $this->info('Coin values updated successfully');
    }
}
