<?php include 'includes/header.php'; ?>
    <main class="w-full flex flex-col items-center ">
        <div class="absolute inset-0 z-0">
            <img src="images/hero-background.webp" 
                alt="Background Gradient" 
                class="w-full h-full object-cover opacity-80">
            <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-[#0b0b15]"></div>
        </div>
        <div class="relative z-10 flex flex-col items-center mt-12 md:mt-20 px-4 text-center">
            
            <div class="mb-6 mt-20">
                <span class="bg-[#0F0C1A1f] border border-white/5 text-gray-300 text-[10px] md:text-xs font-semibold px-3 py-1.5 rounded uppercase tracking-wider">
                    <?php echo $appName; ?> Mobile
                </span>
            </div>
    
            <h1 class="text-4xl md:text-6xl lg:text-7xl font-bold mb-4 tracking-tight">
                Simple, secure, smart
            </h1>
    
            <p class="text-gray-400 text-base md:text-lg mb-10 max-w-lg mx-auto leading-relaxed">
                Access millions of tokens, swap instantly, and stay in control.
            </p>
    
            <a href="<?php echo $appLink; ?>" class="bg-white text-black px-8 py-3.5 rounded-full font-bold flex items-center gap-3 hover:scale-105 transition transform duration-200 shadow-[0_0_20px_rgba(255,255,255,0.3)]">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 20 20"><title>Icon exodus</title><path d="M18.877 6.026 11.21 1v2.81l4.918 3.195-.579 1.83h-4.339v2.33h4.34l.578 1.83-4.918 3.195V19l7.666-5.01-1.254-3.982zM4.543 11.164h4.322V8.836H4.526l-.562-1.83L8.865 3.81V1L1.2 6.026l1.253 3.982L1.2 13.99 8.881 19v-2.81l-4.917-3.195z"></path></svg>
                Get Started with <?php echo $appName; ?> Wallet
            </a>
        </div>
    
        <div class="relative z-20 mt-2 w-full max-w-[1200px] h-[400px] md:h-[600px] flex gap-20 justify-center items-end overflow-hidden">
            <div class="hidden md:block absolute left-[5%] lg:left-[15%] bottom-[-10px] z-10 transform scale-90 translate-y-32 opacity-80 hover:opacity-100 transition duration-500">
                <img src="images/hero-preview-left.webp" 
                     alt="Left Phone Screen" 
                     class="w-[240px] lg:w-[280px] rounded-[3rem] shadow-2xl bg-gray-900">
            </div>
    
            <div class="relative z-10 bottom-[-20px] transform xhover:-translate-y-2 transition duration-500 translate-y-32">                
                <img src="images/hero-preview-center.webp" 
                     alt="Main Phone Screen" 
                     class="w-[260px] md:w-[280px] lg:w-[320px] rounded-[3.5rem] shadow-[0_20px_50px_rgba(0,0,0,0.5)] bg-gray-900">
            </div>
    
            <div class="hidden md:block absolute right-[5%] lg:right-[15%] bottom-[-10px] z-10 transform scale-90 translate-y-32 opacity-80 hover:opacity-100 transition duration-500">
                <img src="images/hero-preview-right.webp" 
                     alt="Right Phone Screen" 
                     class="w-[240px] lg:w-[280px] rounded-[3rem] shadow-2xl bg-gray-900">
            </div>
    
        </div>
        
        <div class="relative z-30 w-full max-w-5xl mx-auto px-6 pb-8 flex flex-wrap justify-center gap-4 md:justify-between items-end mt-10 pointer-events-none">
            <div class="flex gap-5">
                <div class="pointer-events-auto flex items-center gap-2 bg-black/40 backdrop-blur-md border border-white/10 px-4 py-2 rounded-full cursor-pointer hover:bg-white/10 transition">
                    <div class="w-6 h-6 bg-white text-black rounded-full flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="currentColor"><polygon points="5 3 19 12 5 21 5 3"></polygon></svg>
                    </div>
                    <span class="text-xs font-bold uppercase tracking-wide">Watch Video</span>
                </div>
    
                <div class="pointer-events-auto bg-black/40 backdrop-blur-md border border-white/10 px-4 py-2 rounded-full">
                    <span class="font-bold text-sm">11+</span> <span class="text-xs text-gray-400 uppercase ml-1">Years in crypto</span>
                </div>
            </div>
    
            <div class="pointer-events-auto flex items-center gap-2 bg-black/40 backdrop-blur-md border border-white/10 px-4 py-2 rounded-full">
                <span class="text-xs text-gray-400">Advanced Security</span>
                <svg xmlns="http://www.w3.org/2000/svg" width="50" height="20" fill="currentColor" viewBox="0 0 50 20"><title>Ledger logo</title><path d="M41.908 16.992V18h6.913v-4.543h-1.007v3.535zm0-14.992v1.007h5.906v3.536h1.007V2zm-3.565 7.793V7.452h1.58c.77 0 1.047.257 1.047.958v.415c0 .72-.267.968-1.047.968zm2.508.414c.721-.187 1.225-.859 1.225-1.659a1.8 1.8 0 0 0-.573-1.323c-.474-.455-1.106-.682-1.926-.682h-2.222v6.914h.988V10.7h1.481c.76 0 1.067.316 1.067 1.106v1.65h1.007v-1.492c0-1.086-.257-1.5-1.047-1.62zm-8.316.227h3.042v-.908h-3.042V7.452h3.339v-.909h-4.346v6.914h4.494v-.909h-3.487zm-3.308.366v.474c0 .997-.366 1.324-1.284 1.324h-.218c-.918 0-1.363-.297-1.363-1.67V9.071c0-1.382.465-1.669 1.383-1.669h.197c.9 0 1.186.336 1.195 1.265h1.087c-.099-1.363-1.007-2.223-2.37-2.223-.662 0-1.215.208-1.63.603-.622.583-.968 1.57-.968 2.953 0 1.333.297 2.32.909 2.933a2.24 2.24 0 0 0 1.55.622c.593 0 1.136-.237 1.413-.75h.138v.652h.908V9.89h-2.676v.909zm-8.711-3.348h1.076c1.018 0 1.571.256 1.571 1.64v1.816c0 1.383-.553 1.64-1.57 1.64h-1.077zm1.165 6.005c1.887 0 2.588-1.432 2.588-3.457 0-2.054-.75-3.457-2.608-3.457h-2.133v6.914zm-6.923-3.023H17.8v-.908h-3.042V7.452h3.338v-.909H13.75v6.914h4.494v-.909h-3.486zM8.93 6.544H7.924v6.913h4.543v-.909H8.93zM1 13.456V18h6.913v-1.008H2.007v-3.535zM1 2v4.543h1.006V3.007h5.907V2z"></path></svg>
            </div>
        </div>
    
        <section class="bg-[#0b0b15] text-white py-20 overflow-hidden">
            
            <style>
                @keyframes infinite-scroll {
                    from { transform: translateX(0); }
                    to { transform: translateX(-50%); }
                }
                .animate-infinite-scroll {
                    animation: infinite-scroll 40s linear infinite;
                }
                /* Pause animation on hover if desired */
                .group:hover .animate-infinite-scroll {
                    animation-play-state: paused;
                }
            </style>
    
            <div class="max-w-4xl mx-auto text-center px-6 mb-24 md:mb-32">
                <h2 class="text-3xl md:text-5xl font-bold leading-tight mb-8">
                    Portfolio management that moves with you for iOS and Android: swap, buy and sell, stake and earn.
                </h2>
                
                <div class="flex flex-wrap justify-center gap-4">
                    <button class="flex items-center gap-3 bg-[#1a1a2e] border border-white/10 hover:bg-[#252540] transition rounded-xl px-4 py-2 group">
                        <svg class="w-8 h-8 fill-white group-hover:scale-110 transition-transform" viewBox="0 0 24 24"><path d="M18.71 19.5c-.83 1.24-1.71 2.45-3.05 2.47-1.34.03-1.77-.79-3.29-.79-1.53 0-2 .77-3.27.82-1.31.05-2.3-1.32-3.14-2.53C4.25 17 2.94 12.45 4.7 9.39c.87-1.52 2.43-2.48 4.12-2.51 1.28-.02 2.5.87 3.29.87.78 0 2.26-1.07 3.81-.91.65.03 2.47.26 3.64 1.98-.09.06-2.17 1.28-2.15 3.81.03 3.02 2.65 4.03 2.68 4.04-.03.07-.42 1.44-1.38 2.83M13 3.5c.68-.83 1.14-1.99.94-3.15-1.03.04-2.28.69-3.02 1.55-.66.75-1.24 1.95-1.01 3.11 1.15.09 2.32-.59 3.09-1.51z"/></svg>
                        <div class="text-left">
                            <div class="text-[10px] text-gray-400">Download on the</div>
                            <div class="text-sm font-bold">App Store</div>
                        </div>
                    </button>
                    
                    <button class="flex items-center gap-3 bg-[#1a1a2e] border border-white/10 hover:bg-[#252540] transition rounded-xl px-4 py-2 group">
                        <svg class="w-7 h-7 fill-white group-hover:scale-110 transition-transform" viewBox="0 0 24 24"><path d="M3,20.5V3.5C3,2.91 3.34,2.39 3.84,2.15L13.69,12L3.84,21.85C3.34,21.6 3,21.09 3,20.5M16.81,15.12L6.05,21.34L14.54,12.85L16.81,15.12M20.3,12.5L17.38,15.42L15.12,13.16L17.38,10.9L20.3,13.82C20.91,14.43 20.91,15.43 20.3,16.04V16.04M16.81,8.88L14.54,11.15L6.05,2.66L16.81,8.88Z"/></svg>
                        <div class="text-left">
                            <div class="text-[10px] text-gray-400">GET IT ON</div>
                            <div class="text-sm font-bold">Google Play</div>
                        </div>
                    </button>
                </div>
            </div>
    
            <div class="max-w-7xl mx-auto px-6 space-y-24 md:space-y-32">
    
                <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
                    <div class="order-2 md:order-1">
                        <div class="flex items-center gap-2 mb-4 text-[#8b5cf6]">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"></path></svg>
                            <span class="font-medium text-sm md:text-base">Swap</span>
                        </div>
                        <h3 class="text-3xl md:text-5xl font-bold mb-4">Swap directly<br>from your wallet</h3>
                        <p class="text-gray-400 text-lg mb-8 max-w-md">Access thousands of trading pairs in your pocket with swap fees as low as 0.5%.</p>
                        <a href="<?php echo $appLink; ?>" class="bg-[#584cea] hover:bg-[#483dd6] text-white px-8 py-3 rounded-full font-bold transition shadow-[0_0_20px_rgba(88,76,234,0.4)]">
                            Start Swapping
                        </a>
                    </div>
                    <div class="order-1 md:order-2 relative flex justify-center">
                        <div class="absolute inset-0 bg-[#3b2f80] blur-[80px] opacity-40 rounded-full translate-y-10 scale-75"></div>
                        <img src="images/showcase-buy-back.webp" alt="Swap Interface" class="relative z-10 w-[280px] md:w-[320px] rounded-[3rem] border-8 border-[#0b0b15] shadow-2xl">
                    </div>
                </div>
    
                <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
                    <div class="relative flex justify-center">
                        <div class="absolute inset-0 bg-[#3b2f80] blur-[80px] opacity-40 rounded-full translate-y-10 scale-75"></div>
                        <img src="images/showcase-buy-back.webp" alt="Buy Interface" class="relative z-10 w-[280px] md:w-[320px] rounded-[3rem] border-8 border-[#0b0b15] shadow-2xl">
                    </div>
                    <div>
                        <div class="flex items-center gap-2 mb-4 text-[#60a5fa]">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3"></path></svg>
                            <span class="font-medium text-sm md:text-base">Buy</span>
                        </div>
                        <h3 class="text-3xl md:text-5xl font-bold mb-4">Buy effortlessly</h3>
                        <p class="text-gray-400 text-lg mb-8 max-w-md">Pay for your favorite tokens by card, bank transfer, Venmo, PayPal, Apple Pay or Google Pay.</p>
                        <button class="bg-[#584cea] hover:bg-[#483dd6] text-white px-8 py-3 rounded-full font-bold transition shadow-[0_0_20px_rgba(88,76,234,0.4)]">
                            Start Swapping
                        </button>
                    </div>
                </div>
    
                <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
                    <div class="order-2 md:order-1">
                        <div class="flex items-center gap-2 mb-4 text-[#8b5cf6]">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path></svg>
                            <span class="font-medium text-sm md:text-base">Secure</span>
                        </div>
                        <h3 class="text-3xl md:text-5xl font-bold mb-4">Ledger hardware<br>wallet support</h3>
                        <p class="text-gray-400 text-lg mb-8 max-w-md">Connect your Ledger device to <?php echo $appName; ?> and boost your wallet security with enhanced protection made easy.</p>
                        <button class="bg-[#584cea] hover:bg-[#483dd6] text-white px-8 py-3 rounded-full font-bold transition shadow-[0_0_20px_rgba(88,76,234,0.4)]">
                            Learn More
                        </button>
                    </div>
                    <div class="order-1 md:order-2 relative flex justify-center">
                        <div class="absolute inset-0 bg-[#3b2f80] blur-[80px] opacity-40 rounded-full translate-y-10 scale-75"></div>
                        <img src="images/showcase-secure.webp" alt="Ledger Interface" class="relative z-10 w-[280px] md:w-[320px] rounded-[3rem] border-8 border-[#0b0b15] shadow-2xl">
                    </div>
                </div>
    
            </div>
    
            <div class="mt-32 relative">
                <div class="absolute inset-0 bg-[radial-gradient(ellipse_at_top,_var(--tw-gradient-stops))] from-blue-900/20 via-[#0b0b15] to-[#0b0b15] z-0"></div>
                <div class="absolute inset-0 z-0 opacity-10" style="background-image: radial-gradient(#4f46e5 1px, transparent 1px); background-size: 30px 30px;"></div>
    
                <div class="max-w-7xl mx-auto px-6 relative z-10 border-t border-white/10 pt-16 pb-8">
                    <div class="flex flex-col md:flex-row justify-between items-center gap-6 mb-12">
                        <div class="max-w-2xl">
                            <h2 class="text-3xl md:text-4xl font-bold mb-3">1,000,000+ assets supported</h2>
                            <p class="text-gray-400">Securely send and receive assets across 50+ networks. Manage a diverse crypto portfolio, monitor prices, and track performance from anywhere - all in one place.</p>
                        </div>
                        <button class="bg-[#584cea] hover:bg-[#483dd6] text-white px-6 py-2.5 rounded-full font-bold flex items-center gap-2 transition whitespace-nowrap">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path></svg>
                            Browse Assets
                        </button>
                    </div>
    
                    <div class="relative w-full overflow-hidden mask-gradient group">
                        <div class="absolute inset-y-0 left-0 w-16 bg-gradient-to-r from-[#0b0b15] to-transparent z-20"></div>
                        <div class="absolute inset-y-0 right-0 w-16 bg-gradient-to-l from-[#0b0b15] to-transparent z-20"></div>
    
                        <div class="flex animate-infinite-scroll w-max gap-8 lg:gap-12">
                            
                            <div class="flex gap-8 lg:gap-12">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/tronmainnet.svg" alt="Tron">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/ripple.svg" alt="Ripple">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/bitcoin.svg" alt="Bitcoin">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/ethereum.svg" alt="Ethereum">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/bnbmainnet.svg" alt="BNB">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/token/PEPEethereum22ED551C.svg" alt="Pepe">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/avalanchec.svg" alt="Avax">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/cosmos.svg" alt="Cosmos">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/token/USDC.svg" alt="USDC">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/token/SHIB.svg" alt="Shib">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/polkadot.svg" alt="Polkadot">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/token/USDT.svg" alt="USDT">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/solana.svg" alt="Solana">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/aptos.svg" alt="Aptos">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/token/OPoptimism4A7EE59D.svg" alt="Optimism">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/token/JUPYsolanaED7EBE51.svg" alt="Jupiter">
                            </div>
    
                            <div class="flex gap-8 lg:gap-12" aria-hidden="true">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/tronmainnet.svg" alt="Tron">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/ripple.svg" alt="Ripple">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/bitcoin.svg" alt="Bitcoin">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/ethereum.svg" alt="Ethereum">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/bnbmainnet.svg" alt="BNB">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/token/PEPEethereum22ED551C.svg" alt="Pepe">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/avalanchec.svg" alt="Avax">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/cosmos.svg" alt="Cosmos">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/token/USDC.svg" alt="USDC">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/token/SHIB.svg" alt="Shib">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/polkadot.svg" alt="Polkadot">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/token/USDT.svg" alt="USDT">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/solana.svg" alt="Solana">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/asset/aptos.svg" alt="Aptos">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/token/OPoptimism4A7EE59D.svg" alt="Optimism">
                                <img class="h-12 w-12 lg:h-16 lg:w-16 object-contain" src="https://ct-cdn.a.exodus.io/icons/token/JUPYsolanaED7EBE51.svg" alt="Jupiter">
                            </div>
                        </div>
                    </div>
    
                </div>
            </div>
    
        </section>
    </main>
    

<?php include 'includes/footer.php'; ?>