    <footer class="bg-black text-white pt-16 pb-8 border-t border-gray-900">
        <div class="max-w-[1200px] mx-auto px-6 md:px-8">
            
            <div class="flex flex-col md:flex-row justify-between items-center gap-6 mb-12">
                <h2 class="text-2xl md:text-3xl font-medium tracking-tight text-center md:text-left">
                    Control your wealth with <?php echo $appName; ?> today
                </h2>
                <a href="<?php echo $appLink; ?>" class="rounded-full bg-[#4f46e5] px-8 py-3 text-sm font-bold text-white transition-transform hover:scale-105 hover:bg-[#4338ca] shadow-[0_0_15px_rgba(79,70,229,0.4)]">
                    Start Using <?php echo $appName; ?> Wallet
                </a>
            </div>

            <hr class="border-gray-800 mb-16" />

            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-x-8 gap-y-12 mb-20">
                
                <div class="flex flex-col gap-4">
                    <h3 class="font-bold text-white mb-2">Products</h3>
                    <ul class="space-y-3 text-sm text-gray-400">
                        <li><a href="#" class="hover:text-white transition-colors"><?php echo $appName; ?> Pay</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Mobile Wallet</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Desktop Wallet</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Web3 Wallet</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Ledger Hardware Wallet</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Trezor Hardware Wallet</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Staking Rewards</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">XO Pay</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">XO Swap</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Passkeys Wallet & SDK</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Wallet-as-a-Service (WaaS)</a></li>
                    </ul>
                </div>

                <div class="flex flex-col gap-4">
                    <h3 class="font-bold text-white mb-2">Support</h3>
                    <ul class="space-y-3 text-sm text-gray-400">
                        <li><a href="#" class="hover:text-white transition-colors">24/7 Customer Support</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Crypto Assets</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Legal Inquiries</a></li>
                    </ul>
                </div>

                <div class="flex flex-col gap-4">
                    <h3 class="font-bold text-white mb-2">Learn</h3>
                    <ul class="space-y-3 text-sm text-gray-400">
                        <li><a href="#" class="hover:text-white transition-colors">Knowledge Base</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">YouTube</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Newsletter</a></li>
                    </ul>
                </div>

                <div class="flex flex-col gap-4">
                    <h3 class="font-bold text-white mb-2">Company</h3>
                    <ul class="space-y-3 text-sm text-gray-400">
                        <li><a href="#" class="hover:text-white transition-colors">About Us</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Investors</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Careers</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Contact Us</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Brand Guidelines</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Security</a></li>
                        <li><a href="#" class="hover:text-white transition-colors">Intellectual Property</a></li>
                    </ul>
                </div>

                <div class="flex flex-col gap-4 col-span-2 lg:col-span-1">
                    <h3 class="font-bold text-white mb-2">Subscribe to the Newsletter!</h3>
                    <p class="text-sm text-gray-400 leading-relaxed mb-4">
                        Get the latest <?php echo $appName; ?> news and product updates delivered straight to your inbox.
                    </p>
                    <button class="w-full rounded-full bg-white py-3 text-sm font-bold text-black hover:bg-gray-200 transition-colors">
                        Subscribe
                    </button>
                    <p class="text-[10px] text-gray-600 mt-2 leading-tight">
                        We'll only use your email to send information about <?php echo $appName; ?>. You can unsubscribe at any time.
                    </p>
                </div>
            </div>

            <div class="flex flex-col md:flex-row justify-between items-center gap-6 mb-12">
                <div class="flex flex-col md:flex-row items-center gap-4 text-center md:text-left">
                    <div class="flex items-center gap-2">
                        <img src="<?= $appLogoUrl ?>" alt="<?= $appName ?> Logo" class="hidden h-8 w-auto lg:block object-contain">
                    </div>
                    <span class="text-xs text-gray-500">Copyright © 2026 <?php echo $appName; ?> Movement, Inc.</span>
                </div>

                <div class="flex items-center gap-4 text-gray-500">
                    <a href="#" class="hover:text-white transition"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M19 0h-14c-2.761 0-5 2.239-5 5v14c0 2.761 2.239 5 5 5h14c2.762 0 5-2.239 5-5v-14c0-2.761-2.238-5-5-5zm-11 19h-3v-11h3v11zm-1.5-12.268c-.966 0-1.75-.79-1.75-1.764s.784-1.764 1.75-1.764 1.75.79 1.75 1.764-.783 1.764-1.75 1.764zm13.5 12.268h-3v-5.604c0-3.368-4-3.113-4 0v5.604h-3v-11h3v1.765c1.396-2.586 7-2.777 7 2.476v6.759z"/></svg></a>
                    <a href="#" class="hover:text-white transition"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M20.317 4.37a19.791 19.791 0 0 0-4.885-1.515.074.074 0 0 0-.079.037c-.21.375-.444.864-.608 1.25a18.27 18.27 0 0 0-5.487 0 12.64 12.64 0 0 0-.617-1.25.077.077 0 0 0-.079-.037A19.736 19.736 0 0 0 3.677 4.37a.07.07 0 0 0-.032.027C.533 9.046-.32 13.58.099 18.057a.082.082 0 0 0 .031.057 19.9 19.9 0 0 0 5.993 3.03.078.078 0 0 0 .084-.028 14.09 14.09 0 0 0 1.226-1.994.076.076 0 0 0-.041-.106 13.107 13.107 0 0 1-1.872-.892.077.077 0 0 1-.008-.128 10.2 10.2 0 0 0 .372-.292.074.074 0 0 1 .077-.01c3.928 1.793 8.18 1.793 12.062 0a.074.074 0 0 1 .078.01c.12.098.246.198.373.292a.077.077 0 0 1-.006.127 12.299 12.299 0 0 1-1.873.892.077.077 0 0 0-.041.107c.36.698.772 1.362 1.225 1.993a.076.076 0 0 0 .084.028 19.839 19.839 0 0 0 6.002-3.03.077.077 0 0 0 .032-.054c.5-5.177-.838-9.674-3.549-13.66a.061.061 0 0 0-.031-.03z"/></svg></a>
                    <a href="#" class="hover:text-white transition"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M12 0c-6.626 0-12 5.373-12 12 0 5.302 3.438 9.8 8.207 11.387.599.111.793-.261.793-.577v-2.234c-3.338.726-4.033-1.416-4.033-1.416-.546-1.387-1.333-1.756-1.333-1.756-1.089-.745.083-.729.083-.729 1.205.084 1.839 1.237 1.839 1.237 1.07 1.834 2.807 1.304 3.492.997.107-.775.418-1.305.762-1.604-2.665-.305-5.467-1.334-5.467-5.931 0-1.311.469-2.381 1.236-3.221-.124-.303-.535-1.524.117-3.176 0 0 1.008-.322 3.301 1.23.957-.266 1.983-.399 3.003-.404 1.02.005 2.047.138 3.006.404 2.291-1.552 3.297-1.23 3.297-1.23.653 1.653.242 2.874.118 3.176.77.84 1.235 1.911 1.235 3.221 0 4.609-2.807 5.624-5.479 5.921.43.372.823 1.102.823 2.222v3.293c0 .319.192.694.801.576 4.765-1.589 8.199-6.086 8.199-11.386 0-6.627-5.373-12-12-12z"/></svg></a>
                    <a href="#" class="hover:text-white transition"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M19.615 3.184c-3.604-.246-11.631-.245-15.23 0-3.897.266-4.356 2.62-4.385 8.816.029 6.185.484 8.549 4.385 8.816 3.6.245 11.626.246 15.23 0 3.897-.266 4.356-2.62 4.385-8.816-.029-6.185-.484-8.549-4.385-8.816zm-10.615 12.816v-8l8 3.993-8 4.007z"/></svg></a>
                    <a href="#" class="hover:text-white transition"><svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" stroke="currentColor" stroke-width="0.312"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M9 13C8.44772 13 8 13.4477 8 14C8 14.5523 8.44772 15 9 15C9.55229 15 10 14.5523 10 14C10 13.4477 9.55229 13 9 13Z" fill="currentColor"></path> <path d="M14 14C14 13.4477 14.4477 13 15 13C15.5523 13 16 13.4477 16 14C16 14.5523 15.5523 15 15 15C14.4477 15 14 14.5523 14 14Z" fill="currentColor"></path> <path d="M8.29289 16.7929C8.97405 16.1117 9.57505 16.7945 10.1972 17.1056C10.5749 17.2944 11.1728 17.5 12 17.5C12.8272 17.5 13.4251 17.2944 13.8028 17.1056C14.4249 16.7945 15.0259 16.1117 15.7071 16.7929C16.5738 17.6596 15.4209 18.5326 14.6972 18.8944C14.0749 19.2056 13.1728 19.5 12 19.5C10.8272 19.5 9.92507 19.2056 9.30279 18.8944C8.57552 18.5308 7.44766 17.6381 8.29289 16.7929Z" fill="currentColor"></path> <path fill-rule="evenodd" clip-rule="evenodd" d="M12.4703 1.15182C12.7232 0.993884 13.0334 0.957034 13.3162 1.05132L16.6328 2.15685C17.1818 1.45278 18.038 1 19 1C20.6569 1 22 2.34315 22 4C22 5.65686 20.6569 7 19 7C17.3613 7 16.0294 5.68608 16.0005 4.05426L13.8314 3.33121L13.0711 9.03277C14.2994 9.1083 15.4685 9.31237 16.545 9.62357C17.166 8.64754 18.2574 8 19.5 8C21.433 8 23 9.56701 23 11.5C23 12.2757 22.7477 12.9924 22.3206 13.5726C22.76 14.3288 23 15.1466 23 16C23 19.866 18.0751 23 12 23C5.92487 23 1 19.866 1 16C1 15.1466 1.23999 14.3288 1.67937 13.5726C1.25233 12.9924 1 12.2757 1 11.5C1 9.56701 2.567 8 4.5 8C5.74259 8 6.83394 8.64754 7.45501 9.62358C8.56809 9.30178 9.78028 9.09454 11.0544 9.02551L12.0088 1.86784C12.0482 1.5723 12.2174 1.30975 12.4703 1.15182ZM20 4C20 4.55229 19.5523 5 19 5C18.4477 5 18 4.55229 18 4C18 3.44772 18.4477 3 19 3C19.5523 3 20 3.44772 20 4ZM18.7044 12.7376C20.3517 13.7858 21 14.988 21 16C21 17.012 20.3517 18.2142 18.7044 19.2624C17.0809 20.2956 14.7159 21 12 21C9.28405 21 6.91908 20.2956 5.29558 19.2624C3.64835 18.2142 3 17.012 3 16C3 14.988 3.64835 13.7858 5.29558 12.7376C6.91908 11.7044 9.28405 11 12 11C14.7159 11 17.0809 11.7044 18.7044 12.7376ZM18.5221 10.3626C19.5949 9.4393 21.352 10.5086 20.9402 11.9207C20.2671 11.3244 19.4503 10.7982 18.5221 10.3626ZM3.05982 11.9207C3.73291 11.3244 4.5497 10.7982 5.47793 10.3626C4.40504 9.43929 2.64794 10.5086 3.05982 11.9207Z" fill="currentColor"></path> </g></svg></a>
                    <a href="#" class="hover:text-white transition"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="currentColor"><path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/></svg></a>
                    <a href="#" class="hover:text-white transition"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg></a>
                    <a href="#" class="hover:text-white transition"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M22.675 0h-21.35c-.732 0-1.325.593-1.325 1.325v21.351c0 .731.593 1.324 1.325 1.324h11.495v-9.294h-3.128v-3.622h3.128v-2.671c0-3.1 1.893-4.788 4.659-4.788 1.325 0 2.463.099 2.795.143v3.24l-1.918.001c-1.504 0-1.795.715-1.795 1.763v2.313h3.587l-.467 3.622h-3.12v9.293h6.116c.73 0 1.323-.593 1.323-1.325v-21.351c0-.732-.593-1.325-1.325-1.325z"/></svg></a>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 text-[11px] text-gray-500 leading-relaxed mb-8">
                <div>
                    <?php echo $appName; ?> is a software platform ONLY and does not conduct any independent diligence on or substantive review of any blockchain asset, digital currency, cryptocurrency or associated funds. You are fully and solely responsible for evaluating your investments, for determining whether you will swap blockchain assets based on your own, and for all your decisions as to whether to swap blockchain assets with the <?php echo $appName; ?> in app swap feature. In many cases, blockchain assets you swap on the basis of your research may not increase in value, and may decrease in value. Similarly, blockchain assets you swap on the basis of your research may increase in value after your swap.
                </div>
                <div class="flex flex-col gap-6">
                    <p>
                        Past performance is not indicative of future results. Any investment in blockchain assets involves the risk of loss of part or all of your investment. The value of the blockchain assets you swap is subject to market and other investment risks.
                    </p>
                    <p>
                        <?php echo $appName; ?> users are responsible for storing their own recovery phrase. If the recovery phrase is lost, the user might not be able to retrieve their private keys.
                    </p>
                </div>
            </div>

            <div class="flex gap-4 text-xs text-gray-500 underline decoration-transparent hover:decoration-gray-500 transition">
                <a href="#" class="hover:text-gray-300">Privacy Policy</a>
                <a href="#" class="hover:text-gray-300">Terms of Service</a>
                <a href="#" class="hover:text-gray-300">Trademarks</a>
            </div>

        </div>
    </footer>
</body>
</html>