<?php include 'includes/header.php'; ?>

<main class="w-full bg-white text-gray-900 font-sans">

    <section class="relative h-[500px] md:h-[600px] flex items-center justify-center overflow-hidden bg-gray-900 text-white">
        <div class="absolute inset-0 z-0">
            <img src="images/desk-bg.jpg" alt="<?php echo $appName; ?> Desktop" class="w-full h-full object-cover opacity-40">
            <div class="absolute inset-0 bg-gray-900/60 mix-blend-multiply"></div>
        </div>
        
        <div class="relative z-10 text-center max-w-4xl px-6">
            <h1 class="text-4xl md:text-6xl font-light leading-tight tracking-tight mb-6">
                <?php echo $appName; ?> empowers people to control their wealth.
            </h1>
            <div class="h-1 w-24 md:w-32 bg-purple-600 mx-auto rounded-full"></div>
        </div>
    </section>

    <section class="py-24 px-6 max-w-5xl mx-auto text-center">
        <div class="mb-8 flex justify-center opacity-30">
            <svg width="40" height="40" viewBox="0 0 40 40" fill="currentColor" class="text-gray-400">
                <path d="M20 0L40 10V30L20 40L0 30V10L20 0ZM20 22.5L35 15L20 7.5L5 15L20 22.5Z"/>
            </svg>
        </div>
        
        <div class="uppercase text-xs tracking-[0.2em] text-gray-400 mb-6 font-semibold">
            <?php echo $appName; ?> gives you the power to
        </div>
        
        <h2 class="text-3xl md:text-4xl font-light text-gray-700 leading-snug mb-16 max-w-4xl mx-auto">
            Secure, Manage, and Swap cryptocurrency on desktop, mobile and hardware wallets.
        </h2>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-12 text-left text-gray-500 font-light leading-relaxed max-w-4xl mx-auto">
            <p>
                At <?php echo $appName; ?> we pour our hearts into every detail, from pixel-perfect icons to subtle sounds, creating a cryptocurrency experience that works for everyone.
            </p>
            <p>
                Our goal is to remove the geek requirement and make it fun and easy to learn and use cryptocurrency. No technical talk. No confusing steps - we think it shows.
            </p>
        </div>
        
        <div class="mt-16">
            <a href="#" class="inline-block bg-gradient-to-r from-purple-500 to-indigo-600 text-white text-xs font-bold uppercase tracking-wider py-4 px-10 rounded-full shadow-lg hover:shadow-xl hover:scale-105 transition transform duration-300">
                Download Media Kit
            </a>
        </div>
    </section>

    <section class="relative h-[400px] flex flex-col justify-start items-center bg-cover bg-center bg-fixed" style="background-image: url('images/mountain-bg.jpg');">
        <div class="absolute inset-0 bg-white/70"></div>
        
        <div class="relative z-10 w-full max-w-6xl mx-auto px-6 pt-16">
            <div class="flex justify-between w-full text-center text-gray-600 font-light text-2xl md:text-3xl">
                <div class="flex flex-col items-center">
                    <span class="text-xs font-bold uppercase tracking-widest text-gray-400 mb-2">01</span>
                    Safe
                </div>
                <div class="flex flex-col items-center">
                    <span class="text-xs font-bold uppercase tracking-widest text-gray-400 mb-2">02</span>
                    Reliable
                </div>
                <div class="flex flex-col items-center">
                    <span class="text-xs font-bold uppercase tracking-widest text-gray-400 mb-2">03</span>
                    Trusted
                </div>
            </div>
            
            <!-- <div class="absolute left-1/2 top-1/2 -translate-x-1/2 translate-y-12">
                <svg width="100" height="100" viewBox="0 0 100 100" fill="white" class="drop-shadow-lg">
                    <path d="M50 0L100 25V75L50 100L0 75V25L50 0ZM50 55L85 37.5L50 20L15 37.5L50 55Z"/>
                </svg>
            </div> -->
        </div>
    </section>

    <section class="bg-[#6b46c1] text-white py-20 px-6">
        <div class="max-w-6xl mx-auto grid grid-cols-1 md:grid-cols-4 gap-12 text-center md:text-left">
            
            <div>
                <div class="text-[10px] font-bold uppercase tracking-widest opacity-60 mb-2">Founded In</div>
                <div class="text-5xl font-light mb-4">2015</div>
                <div class="text-xs opacity-70 leading-relaxed">
                    By JP Richardson and<br>Daniel Castagnoli
                </div>
            </div>
            
            <div>
                <div class="text-[10px] font-bold uppercase tracking-widest opacity-60 mb-2">Product Updates</div>
                <div class="text-5xl font-light mb-4">200+</div>
                <div class="text-xs opacity-70 leading-relaxed">
                    New releases across desktop,<br>mobile and hardware
                </div>
            </div>
            
            <div>
                <div class="text-[10px] font-bold uppercase tracking-widest opacity-60 mb-2">New Release Every</div>
                <div class="text-5xl font-light mb-4">2 Weeks</div>
                <div class="text-xs opacity-70 leading-relaxed">
                    Released software every two<br>weeks since 2015
                </div>
            </div>
            
            <div>
                <div class="text-[10px] font-bold uppercase tracking-widest opacity-60 mb-2">Digital Assets</div>
                <div class="text-5xl font-light mb-4">100,000+</div>
                <div class="text-xs opacity-70 leading-relaxed">
                    Supported cryptocurrencies<br>inside <?php echo $appName; ?> products
                </div>
            </div>

        </div>
    </section>

    <section class="py-24 px-6 bg-white text-center">
        <h2 class="text-4xl font-light text-gray-800 mb-12">Built for Trust</h2>
        
        <p class="max-w-4xl mx-auto text-gray-500 font-light leading-relaxed mb-16 text-sm md:text-base">
            <?php echo $appName; ?> was founded in 2015 by JP Richardson and Daniel Castagnoli. JP brings the technical magic behind the scenes to <?php echo $appName; ?>. JP has published <a href="#" class="text-blue-400 hover:underline">over 200 open source libraries</a> and has written code in use by most Bitcoin and cryptocurrency software on the web today. On the creative side, from subtle sounds to smooth animations, Daniel oversees each detail of the <?php echo $appName; ?> creative process. Daniel is a master of emotional design and has designed experiences for Apple, BMW, Disney, Louis Vuitton and Nike.
        </p>
        
        <div class="flex flex-col md:flex-row justify-center gap-0 md:gap-0 max-w-4xl mx-auto mb-8">
            <div class="flex-1">
                <img src="images/JP-Richardson.jpg" alt="JP Richardson" class="w-full h-auto object-cover grayscale hover:grayscale-0 transition duration-500">
                <div class="mt-6">
                    <h3 class="text-lg font-normal text-gray-800">JP Richardson</h3>
                    <div class="flex justify-center gap-3 mt-2 text-gray-300">
                        <i class="fab fa-github hover:text-gray-500 cursor-pointer"></i>
                        <i class="fab fa-twitter hover:text-gray-500 cursor-pointer"></i>
                        <i class="fab fa-instagram hover:text-gray-500 cursor-pointer"></i>
                    </div>
                </div>
            </div>
            <div class="flex-1">
                <img src="images/Daniel-Castagnoli.jpg" alt="Daniel Castagnoli" class="w-full h-auto object-cover grayscale hover:grayscale-0 transition duration-500">
                <div class="mt-6">
                    <h3 class="text-lg font-normal text-gray-800">Daniel Castagnoli</h3>
                    <div class="flex justify-center gap-3 mt-2 text-gray-300">
                        <i class="fab fa-github hover:text-gray-500 cursor-pointer"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-24 max-w-3xl mx-auto">
            <div class="text-[10px] font-bold uppercase tracking-widest text-gray-300 mb-6">The Goal at <?php echo $appName; ?></div>
            <h3 class="text-2xl md:text-3xl font-light text-gray-600 leading-normal">
                Remove the geek requirement, and keep design a priority, to make cryptocurrency easy for everyone.
            </h3>
        </div>
    </section>

    <section class="flex flex-col md:flex-row bg-gray-50">
        <div class="md:w-1/2 h-[400px] md:h-auto bg-cover bg-center" style="background-image: url('images/office-desk.jpg');"></div>
        
        <div class="md:w-1/2 p-12 md:p-24 flex flex-col justify-center items-start text-left">
            <div class="text-[10px] font-bold uppercase tracking-widest text-gray-400 mb-4">Careers</div>
            <h2 class="text-4xl font-light text-gray-800 mb-6">Working at <?php echo $appName; ?></h2>
            <p class="text-gray-500 font-light mb-10 text-sm md:text-base leading-relaxed max-w-md">
                Is cryptocurrency your passion? Join <?php echo $appName; ?> and work from anywhere - all positions are 100% remote.
            </p>
            <a href="#" class="bg-gradient-to-r from-purple-500 to-indigo-600 text-white text-xs font-bold uppercase tracking-wider py-4 px-10 rounded-full shadow-lg hover:shadow-xl hover:scale-105 transition transform duration-300">
                View Open Positions
            </a>
        </div>
    </section>

</main>
    

<?php include 'includes/footer.php'; ?>